package gov.va.caret.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgMem;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Facil;
import gov.va.caret.model.Note;
import gov.va.caret.model.Persn;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.NoteImpl;
import gov.va.caret.model.impl.WorImImpl;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;

import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.beanutils.Converter;



public class Toolbox {

	private static Map<String,Map<String,Map<String,Long>>> districtMap = null;
	
	static final String CARET_DATE_FORMAT = "MM/dd/yy";
	static final String CARET_DATE_ORIENT = "yyyyMMdd";
	static final String CARET_DATE_FORMAT_PDF = "MM-dd-yyyy";
	static final String CARET_DATE_FORMAT_CPRS = "MM/dd/yyyy";
	static final String CARET_DATETIME_FORMAT = "MM/dd/yy hh:mm a";
	static final String CARET_DATETIME_METADATA_FORMAT = "MM/dd/yyyy hh:mm:ss a z";

	private static Format currencyInstance = null;
	private static Format dateFormat = null;
	private static Format dateFormatPdf = null;
	private static Format dateFormatCprs = null;
	private static Format dateTimeFormat = null;
	private static Format dateMetadata = null;
	private static Format dateFormatOrient = null;
	
	private static final String FOUR = "0000";
	private static final String THREE = "000";
	private static final String TWO = "00";
	private static final String ONE = "0";
	private static final int DEFAULT_MAX = 75;
	
	private static List<String> relationshipFamily = 
			ListUtil.toList( PortletProps.get(CaretStrPool.RELATIONSHIP_FAMILY).split(StringPool.COMMA));
	
	public static boolean isFamily(String individual) {
		return relationshipFamily.contains(individual);
	}

	public static class DateConverter implements Converter {
		@SuppressWarnings("rawtypes")
		public Object convert(Class type, Object value ){
			if ( value == null ){
				return null;
			}
			if ( value instanceof Date ){
				return value;
			} else {
				try {
					return parseDate( value.toString() );
				} catch ( Exception e ){
					_log.error("converter failed..." , e);
				}
			}
			return null;
		}
	}
	
	public static Format getDateFormat(){
		if ( dateFormat == null ){
			dateFormat = new DateFormatThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormat;
	}
	
	public static Format getDateFormatPdf(){
		if ( dateFormatPdf == null ){
			dateFormatPdf = new DateFormatPdfThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormatPdf;
	}
	
	public static Format getDateFormatOrient(){
		if ( dateFormatOrient == null ){
			dateFormatOrient = new DateFormatOrientThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormatOrient;
	}
	
	public static Format getDateFormatCprs(){
		if ( dateFormatCprs == null ){
			dateFormatCprs = new DateFormatCprsThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormatCprs;
	}
	
	public static Format getDateTimeFormat() {
		if ( dateTimeFormat == null ){
			dateTimeFormat  = new DateTimeFormatThreadLocal<SimpleDateFormat>().get();
		}
		return dateTimeFormat;
	}
	
	public static Format getDateMetadataFormat() {
		if ( dateMetadata == null ){
			dateMetadata  = new DateFormatMetadataThreadLocal<SimpleDateFormat>().get();
		}
		return dateMetadata;
	}

	public static String currencyFormat ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		if ( currencyInstance == null ){
			currencyInstance = new ThreadLocal<NumberFormat>().get();
		}
		return currencyInstance.format( value );
	}
	
	public static String formatDate ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormat().format( value );
	}
	
	public static String formatDatePdf ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormatPdf().format( value );
	}
	
	public static String formatDateOrient ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormatOrient().format( value );
	}
	
	public static String formatDateCprs ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormatCprs().format( value );
	}
	
	public static String formatDateTimeMetadata ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateMetadataFormat().format( value );
	}
	
	public static String formatDateTime ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateTimeFormat().format( value );
	}
	
	public static String formatZip ( Object value ){
		if ( value != null ) {
			int length = value.toString().length();
			if ( length > 4 ) return value.toString();
			
			switch(length){
				case 4: return ONE + value; 
				case 3: return TWO + value; 
				case 2: return THREE + value; 
				case 1: return FOUR + value; 
			}
		}
		return StringPool.BLANK;
	}
	
	public static String formatSsn ( String value ){
		if ( value != null && !value.isEmpty()) {
			if ( value.length() == 9 ) {
				return new StringBuilder(value).insert(6, '-').insert(3, '-').toString();
			}
			ApplicationWorkFlowException.handleException("Invalid PII data provided " + value.length() );
		}
		return StringPool.BLANK;
	}
	
	public static Date parseDate ( String dateStr ){
		if ( dateStr == null ) return null;
		try {
			return (Date) getDateFormat().parseObject( dateStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided " + dateStr);
		}
		return null;
	}
		
	public static Date parseMetadataTime ( String dateTimeStr ){
		if ( dateTimeStr == null ) return null;
		try {
			return (Date) getDateMetadataFormat().parseObject( dateTimeStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided " + dateTimeStr);
		}
		return null;
	}
	
	public static Date parseDateTime ( String dateTimeStr ){
		if ( dateTimeStr == null ) return null;
		try {
			return (Date) getDateTimeFormat().parseObject( dateTimeStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided " + dateTimeStr);
			return parseDate( dateTimeStr );
		}
//		return null;
	}
	
	public static String getExpandoValue( ExpandoBridge expandoBridge,	String attributeName ) {
		return getExpandoValue(expandoBridge, attributeName, false);
	}
	
	public static String getExpandoValue( ExpandoBridge expandoBridge,
			String attributeName,
			Boolean isSecure ) {
		if ( Validator.isNotNull( attributeName ) && expandoBridge.hasAttribute( attributeName ) ) {
			return (String) expandoBridge.getAttribute( attributeName, isSecure );
		}
		return StringPool.BLANK;
	}
	
	public static boolean setExpandoValue( BaseModel<?> baseModel, String attributeName, String value ) {
		try {
			if ( Validator.isNotNull( attributeName ) ){
				if ( baseModel.getExpandoBridge().hasAttribute( attributeName ) ) {
					baseModel.getExpandoBridge().setAttribute( attributeName, value, false );
				} else {
					throw new ApplicationWorkFlowException(CaretStrPool.METADATA + " not initialized" );
				}
			}
			return true;
		}catch (PortalException e) {
			e.printStackTrace();
		}
		return false;
	}
			
	public static Note createNote(Date now, long chainId, long groupId, long userId,
			String messageString) {
		Note note = new NoteImpl();
		note.setCreationDate(now);
		note.setValue(messageString);
		note.setChainId(chainId);
		note.setGroupId(groupId);
		note.setUserId(userId);
		return note;
	}
	
	public static WorIm createWorkItem ( ServiceContext sc, long groupId, BaseModel<?> src, WorkType type, long veteranPersnId, long caregiverPersnId ){
		WorIm workItem = new WorImImpl();
		workItem.setStatus( CaretStrPool.NEW );
		workItem.setCreationDate( sc.getCreateDate() );
		workItem.setGroupId( groupId );
		workItem.setType( type.name() );
		workItem.setClassPk( (Long)src.getPrimaryKeyObj() );
		workItem.setPersnId(veteranPersnId);
		workItem.setCaregiverId(caregiverPersnId);
		_log.info("using DueDate=" + type.getDueDate( sc.getCreateDate() ) );
		workItem.setDueDate( type.getDueDate( sc.getCreateDate() ) );
		_log.info("using src.getModelClass()=" + src.getModelClass());
		workItem.setClassId( PortalUtil.getClassNameId( src.getModelClass() ) );
		return workItem;
	}

	public static WorIm createHomeVisitWorkItem ( ServiceContext sc, long groupId, BaseModel<?> src, WorkType type, long veteranPersnId, long caregiverPersnId, long vcgId, Date completionDate){
		WorIm workItem = new WorImImpl();
		workItem.setStatus( CaretStrPool.NEW );
		workItem.setCreationDate( sc.getCreateDate() );
		workItem.setGroupId( groupId );
		workItem.setType( type.name() );
		workItem.setClassPk( (Long)src.getPrimaryKeyObj() );
		workItem.setPersnId(veteranPersnId);
		workItem.setCaregiverId(caregiverPersnId);
		_log.info("using DueDate=" + type.getDueDate( completionDate ) );
		workItem.setDueDate( type.getDueDate( completionDate ) );
		_log.info("using src.getModelClass()=" + src.getModelClass());
		workItem.setClassId( PortalUtil.getClassNameId( src.getModelClass() ) );
		workItem.setVcgId(vcgId);
		return workItem;
	}

	
	public static Map<String,Map<String,Map<String,Long>>> getVhaOrgTree( long companyId, boolean includeNumber ) throws ApplicationWorkFlowException {
		
		if ( districtMap == null ){
			try {
				Organization head = OrganizationLocalServiceUtil.getOrganization( companyId, PortletProps.get(CaretStrPool.HEAD_ORG_NAME) );
				districtMap = new HashMap<String,Map<String,Map<String,Long>>>();
				for ( Organization district: OrganizationLocalServiceUtil.getOrganizations( companyId, head.getOrganizationId() ) ){
					Map<String,Map<String,Long>> visnMap = new TreeMap<String,Map<String,Long>>();
					districtMap.put(district.getName(), visnMap );
					for ( Organization visn: OrganizationLocalServiceUtil.getOrganizations( companyId, district.getOrganizationId() ) ){
						Map<String,Long> facilityMap = new TreeMap<String,Long>();
						visnMap.put(visn.getName(), facilityMap );
						for ( Organization facility : OrganizationLocalServiceUtil.getOrganizations( companyId, visn.getOrganizationId() ) ){
							Facil facil = FacilLocalServiceUtil.getByOrgId( facility.getPrimaryKey() );
							
							facilityMap.put( includeNumber? facil.getFacilityNumber() + StringPool.COMMA_AND_SPACE + facility.getName() + StringPool.COMMA_AND_SPACE + facil.getLocation() :
								facility.getName(),
									facility.getOrganizationId() );
						}
					}
				}
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
			
		}
		return districtMap;
	}
	
	public static int getInteger ( Map<String,Object> map, String key ){
		return ( (java.math.BigDecimal) map.get(key) ).intValue();
	}
	
	public static long getLong ( Map<String,Object> map, String key ){
		return ( (java.math.BigDecimal) map.get(key) ).longValue();
	}
	
//	@SuppressWarnings({ "rawtypes" })
//	public static boolean isBoolean(BaseModel bean, String name) {
//		try {
//			return bean.getClass().getMethod( CaretStrPool.GET + StringUtil.upperCaseFirstLetter(name)).getReturnType() == boolean.class;
//		} catch (NoSuchMethodException e) {
//			e.printStackTrace();
//		} catch (SecurityException e) {
//			e.printStackTrace();
//		}
//		return false;
//	}

	public static Map<String, Object> getMap(Object... appId){
		Map<String, Object> map = new HashMap<String, Object>();
		for ( int i = 0; i < appId.length; i++ ){
			map.put( CaretStrPool.NDX +i, appId[i]);
		}
		return map;
	}
	
	public static Collection<String> getCollection(Object... appId){
		Collection<String> collection = new ArrayList<String>();
		for ( int i = 0; i < appId.length; i++ ){
			collection.add( appId[i].toString() );
		}
		return collection;
	}
	
	
	public static boolean isEmpty( String entry ) {
		return entry == null || entry.trim().length() == 0;
	}
	
	public static String nullSafe( Object entry ) {
		return entry == null? StringPool.BLANK : entry.toString();
	}
	
	@SuppressWarnings({ "rawtypes" })
	public static String chomp(Class c, BaseModel baseModel, String attribute,
			String value) {
		if ( modelConfig == null ){
			setModelConfig();
		}
		
		Class[] interfaces = c.getInterfaces();
		Class use = interfaces.length > 0? interfaces[0] : c;
		
		if ( value != null && modelConfig.containsKey( use ) ){
			Map<String,Integer> rules = modelConfig.get( use ) ;
			int rule = rules.get( attribute );
			return value.substring(0, Math.min( value.length(), rule ) );
		}
		
		return value.substring(0, Math.min( value.length(), DEFAULT_MAX ) );
	}

	@SuppressWarnings("rawtypes")
	private static void setModelConfig() {
		modelConfig = new HashMap<Class,Map<String,Integer>>();
		
		Map<String,Integer> configMap = new CaretMap<String,Integer>(75);
		configMap.put("comment", 400); 
		modelConfig.put( VcgAn.class, configMap );
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("value", 400); 
		modelConfig.put( Note.class, configMap );
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("cbopcNotes", 400);
		configMap.put("cscNotes", 400);
		modelConfig.put( Vcg.class, configMap );
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("label", 255);
		modelConfig.put( BoxGp.class, configMap );

		configMap = new CaretMap<String,Integer>(75);
		configMap.put("message", 400);
		modelConfig.put( BgMem.class, configMap );
		
	}
	
	public static List<BoxGp> initBoxGroup( String name, String subName ) throws ApplicationWorkFlowException { 
		String boxGroupValues = PortletProps.get(subName);
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(name, subName);
		String[] labels =  boxGroupValues.split( StringPool.SEMICOLON );
		groups = new ArrayList<BoxGp>();
		int i = 0;
		for ( String label: labels ){
			BoxGp grp = new BoxGpImpl();
			grp.setBoxGroup(name);
			grp.setBoxSubGroup(subName);
			grp.setLabel(label);
			grp.setViewSequence(i++);
			try {
				groups.add( BoxGpLocalServiceUtil.addBoxGp(grp) );
			} catch (SystemException e) {
				e.printStackTrace();
				throw new ApplicationWorkFlowException(e);
			}
		}
		return groups; 
	}

	public static void initYesNoBoxGp ( String subgroup, String yesNoGroup, List<BoxGp> list, int sequence ) throws ApplicationWorkFlowException{
		BoxGp yesAnswer = new BoxGpImpl();
		yesAnswer.setBoxGroup(yesNoGroup);
		yesAnswer.setBoxSubGroup(subgroup);
		yesAnswer.setLabel(CaretStrPool.YES);
		yesAnswer.setViewSequence(sequence);
		
		BoxGp noAnswer = new BoxGpImpl();
		noAnswer.setBoxGroup(yesNoGroup);
		noAnswer.setBoxSubGroup(subgroup);
		noAnswer.setLabel(CaretStrPool.NO);
		noAnswer.setViewSequence(sequence+1);
		try {
			list.add( BoxGpLocalServiceUtil.addBoxGp(yesAnswer) );
			list.add( BoxGpLocalServiceUtil.addBoxGp(noAnswer) );
		} catch (SystemException e) {
			e.printStackTrace();
			throw new ApplicationWorkFlowException(e);
		}
	}

	public static Date subtractFromNow ( double doubleValue ) {
		double flooredValue = Math.floor( doubleValue );
		double percentDay = doubleValue - flooredValue;
		
		Calendar calendar = Calendar.getInstance();
		if ( percentDay > 0 ){
			int minutesInt = Double.valueOf(percentDay * 24 * 60).intValue();
			_log.info("subtracting minutes " + minutesInt );
			calendar.add(Calendar.MINUTE, -minutesInt);
		}
		if ( percentDay >= 1){
			_log.info("subtracting days for date..." + Double.valueOf(doubleValue).intValue() );
			calendar.add(Calendar.DAY_OF_YEAR, -Double.valueOf(doubleValue).intValue() );
		}
		return calendar.getTime();
//		return adjustDate(doubleValue, new Date(), false);
	}
	
	public static Date adjustDate ( double doubleValue, Date date, boolean up ) {
		double days = Math.floor( doubleValue );
		double remainderPercentDay = doubleValue - days;
		
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		if ( remainderPercentDay > 0 ){
			int minutesInt = Double.valueOf(remainderPercentDay * 24 * 60).intValue();
			_log.info( (up? " increasing ": "subtracting ") + "minutes by " + minutesInt );
			calendar.add(Calendar.MINUTE, up? minutesInt : -minutesInt);
		}
		if ( days >= 1){
			_log.info( (up?"increasing ": "subtracting ") + "days by " + days );
			calendar.add(Calendar.DAY_OF_YEAR, up? (int)days: (int)-days );
		}
		_log.debug( "now.compareTo(rollDate): " + new Date().compareTo( calendar.getTime() ) );
		return calendar.getTime();
	}
	
	@SuppressWarnings("rawtypes")
	private static Map<Class,Map<String,Integer>> modelConfig = null;
	private static Log _log = LogFactoryUtil.getLog( Toolbox.class );
	
	public static boolean toBoolYesNo(String label) {
		return CaretStrPool.YES.equals(label);
	}

	public static Collection<String> getAddressCollection() {
		return Toolbox.getCollection("city","state","zip");
	}
	
	public static String getPersnFullName(long persnId) {
		try { 
			Persn persn = PersnLocalServiceUtil.getPersn( persnId );
			return persn.getLastName() + StringPool.COMMA_AND_SPACE + persn.getFirstName();
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return StringPool.BLANK;
	}
	
	public static String getUserFullName(long userId) {
		try { 
			User user = UserLocalServiceUtil.getUser( userId );
			return user.getLastName() + StringPool.COMMA_AND_SPACE + user.getFirstName();
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return StringPool.BLANK;
	}
}
