 package gov.va.caret.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.OnlineViewController;
import gov.va.caret.model.VcgAn;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.view.CaretParam;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.portlet.PortletRequest;

public class OnlineUtil {

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static List myCaregivers ( List<Map<String, Object>> applications, PortletRequest request ) {
		
		if ( applications.isEmpty() ){
			return Collections.EMPTY_LIST;
		}
		List returnList = new ArrayList<Map>();
		Set<Long> caregiverIds = new HashSet<Long>();
		for ( Map<String, Object> appFields : applications ){
			BigDecimal vcgAnId = (BigDecimal) appFields.get( CaretStrPool.NDX0 );
			
			long primaryId = Toolbox.getLong(appFields,CaretStrPool.NDX11);
			if ( primaryId > 0 ){
				Object primarySignDate = appFields.get(CaretStrPool.NDX8);
				String primarySigned = (primarySignDate != null && !primarySignDate.toString().isEmpty())?
						CaretStrPool.SIGNED : CaretStrPool.NEED_SIGNATURE;
				returnList.add( Toolbox.getMap( CaretStrPool.PRIMARY, appFields.get(CaretStrPool.NDX1),
						primarySigned, primarySignDate, vcgAnId ) );
				caregiverIds.add(primaryId);
			}
			
			long secondaryId = Toolbox.getLong(appFields,CaretStrPool.NDX12);
			if ( secondaryId > 0 ){
				Object secondarySignDate = appFields.get(CaretStrPool.NDX9);
				String secondarySigned = (secondarySignDate != null && !secondarySignDate.toString().isEmpty())?
						CaretStrPool.SIGNED : CaretStrPool.NEED_SIGNATURE;
				returnList.add( Toolbox.getMap( CaretStrPool.SECONDARY, appFields.get(CaretStrPool.NDX2),
						secondarySigned, secondarySignDate, vcgAnId ) );
				caregiverIds.add(secondaryId);
			}
			
			long secondaryTwoId = Toolbox.getLong(appFields,CaretStrPool.NDX13);
			if ( secondaryTwoId > 0 ){ 
				Object secondaryTwoSignDate = appFields.get(CaretStrPool.NDX10);
				String secondaryTwoSigned = (secondaryTwoSignDate != null && !secondaryTwoSignDate.toString().isEmpty())?
						CaretStrPool.SIGNED : CaretStrPool.NEED_SIGNATURE;
				returnList.add( Toolbox.getMap( CaretStrPool.SECONDARYTWO, appFields.get(CaretStrPool.NDX3),
						secondaryTwoSigned, secondaryTwoSignDate, vcgAnId ) );
				caregiverIds.add(secondaryTwoId);
			}
			
//			checkConfirmation( request, vcgAnId.longValue() );
		}
		OnlineViewController.get().getForm(request).put(CaretStrPool.CAREGIVER_IDS, caregiverIds.size());
		request.getPortletSession().setAttribute(CaretStrPool.CAREGIVER_IDS, caregiverIds);
		return returnList;
	}
	
//	public static void checkConfirmation( PortletRequest request, long vcgAnId ) {
//		try {
//			VcgAn v = VcgAnLocalServiceUtil.getVcgAn( vcgAnId );
//			if ( v.getSubmitDate() != null && CaretStrPool.READ_CONFIRMATION.equals( v.getStatus() ) ){
//				OnlineViewController.get().getForm(request).put(CaretStrPool.CONFIRMATION_ARGS, new String[]{ String.valueOf(vcgAnId) } );
////				v.setStatus("READY");
//				v.setStatus("SUBMITTED");
//				CaretParam.setOnlineServiceContext(request);
//				CaretLocalServiceUtil.save(v);
//			}
//		} catch (PortalException e) {
//			e.printStackTrace();
//		} catch (SystemException e) {
//			e.printStackTrace();
//		}
//	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static List myVeterans(List<Map<String, Object>> list, PortletRequest request ) throws ApplicationWorkFlowException {
		
		long caretPersonId = CaretParam.getPersnId(request);
		
		if ( list.isEmpty() ){
			return Collections.EMPTY_LIST;
		}
		List returnList = new ArrayList<Map>();
		for ( Map<String, Object> map : list ){
			String status;
			Object signDate;
			// Primary Cg
			if ( map.get(CaretStrPool.NDX11) != StringPool.BLANK  && caretPersonId == Toolbox.getLong(map,CaretStrPool.NDX11) ){
				if ( map.get(CaretStrPool.NDX8) == StringPool.BLANK ){
					status = CaretStrPool.NOT_SIGNED;
					signDate = StringPool.BLANK;
				} else {
					status = CaretStrPool.SIGNED;
					signDate = map.get(CaretStrPool.NDX8);
				}
				returnList.add( Toolbox.getMap( CaretStrPool.PRIMARY,
											map.get(CaretStrPool.NDX14),
											status, signDate,
											map.get(CaretStrPool.NDX0) ) );
			
			//Secondary Cg
			} else if ( map.get(CaretStrPool.NDX12) != StringPool.BLANK && caretPersonId == Toolbox.getLong(map,CaretStrPool.NDX12) ){
				if ( map.get(CaretStrPool.NDX9) == StringPool.BLANK ){
					status = CaretStrPool.NOT_SIGNED;
					signDate = StringPool.BLANK;
				} else {
					status = CaretStrPool.SIGNED;
					signDate = map.get(CaretStrPool.NDX9);
				}
				returnList.add( 
						Toolbox.getMap( CaretStrPool.SECONDARY,
											map.get(CaretStrPool.NDX14),
											status, signDate,
											map.get(CaretStrPool.NDX0) ) );
			
				//Secondary II
			} else if ( map.get(CaretStrPool.NDX13) != StringPool.BLANK && caretPersonId == Toolbox.getLong(map,CaretStrPool.NDX13) ){
				if ( map.get(CaretStrPool.NDX10) == StringPool.BLANK ){
					status = CaretStrPool.NOT_SIGNED;
					signDate = StringPool.BLANK;
				} else {
					status = CaretStrPool.SIGNED;
					signDate = map.get(CaretStrPool.NDX10);
				}
				returnList.add( Toolbox.getMap( 
											CaretStrPool.SECONDARYTWO,
											map.get(CaretStrPool.NDX14),
											status, signDate,
											map.get(CaretStrPool.NDX0) ) );
			}
		}
		return returnList;
	}
	
	public static Map<Long,String> getCaregivers ( long siteId, long caregiverRoleId ) throws SystemException, PortalException {
		List<UserGroupRole> caregivers = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroupAndRole( siteId, caregiverRoleId );
		Map<Long,String> caregiverNames = new HashMap<Long,String>();
		for ( UserGroupRole userGroupRole: caregivers ){
			User u = UserLocalServiceUtil.getUser( userGroupRole.getUserId() );
			caregiverNames.put( userGroupRole.getUserId(), u.getFullName() + StringPool.COMMA_AND_SPACE + u.getEmailAddress() );
		}
		return caregiverNames;
	}
	
}
