package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchFacilException;
import gov.va.caret.model.Facil;
import gov.va.caret.model.impl.FacilImpl;
import gov.va.caret.model.impl.FacilModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the facil service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see FacilPersistence
 * @see FacilUtil
 * @generated
 */
public class FacilPersistenceImpl extends BasePersistenceImpl<Facil>
    implements FacilPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link FacilUtil} to access the facil persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = FacilImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(FacilModelImpl.ENTITY_CACHE_ENABLED,
            FacilModelImpl.FINDER_CACHE_ENABLED, FacilImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(FacilModelImpl.ENTITY_CACHE_ENABLED,
            FacilModelImpl.FINDER_CACHE_ENABLED, FacilImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(FacilModelImpl.ENTITY_CACHE_ENABLED,
            FacilModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_GROUPID = new FinderPath(FacilModelImpl.ENTITY_CACHE_ENABLED,
            FacilModelImpl.FINDER_CACHE_ENABLED, FacilImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByGroupId",
            new String[] { Long.class.getName() },
            FacilModelImpl.GROUPID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(FacilModelImpl.ENTITY_CACHE_ENABLED,
            FacilModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "facil.groupId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_FACILITYNUMBER = new FinderPath(FacilModelImpl.ENTITY_CACHE_ENABLED,
            FacilModelImpl.FINDER_CACHE_ENABLED, FacilImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByFacilityNumber",
            new String[] { String.class.getName() },
            FacilModelImpl.FACILITYNUMBER_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_FACILITYNUMBER = new FinderPath(FacilModelImpl.ENTITY_CACHE_ENABLED,
            FacilModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByFacilityNumber",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_FACILITYNUMBER_FACILITYNUMBER_1 = "facil.facilityNumber IS NULL";
    private static final String _FINDER_COLUMN_FACILITYNUMBER_FACILITYNUMBER_2 = "facil.facilityNumber = ?";
    private static final String _FINDER_COLUMN_FACILITYNUMBER_FACILITYNUMBER_3 = "(facil.facilityNumber IS NULL OR facil.facilityNumber = '')";
    private static final String _SQL_SELECT_FACIL = "SELECT facil FROM Facil facil";
    private static final String _SQL_SELECT_FACIL_WHERE = "SELECT facil FROM Facil facil WHERE ";
    private static final String _SQL_COUNT_FACIL = "SELECT COUNT(facil) FROM Facil facil";
    private static final String _SQL_COUNT_FACIL_WHERE = "SELECT COUNT(facil) FROM Facil facil WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "facil.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Facil exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Facil exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(FacilPersistenceImpl.class);
    private static Facil _nullFacil = new FacilImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<Facil> toCacheModel() {
                return _nullFacilCacheModel;
            }
        };

    private static CacheModel<Facil> _nullFacilCacheModel = new CacheModel<Facil>() {
            @Override
            public Facil toEntityModel() {
                return _nullFacil;
            }
        };

    public FacilPersistenceImpl() {
        setModelClass(Facil.class);
    }

    /**
     * Returns the facil where groupId = &#63; or throws a {@link gov.va.caret.NoSuchFacilException} if it could not be found.
     *
     * @param groupId the group ID
     * @return the matching facil
     * @throws gov.va.caret.NoSuchFacilException if a matching facil could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil findByGroupId(long groupId)
        throws NoSuchFacilException, SystemException {
        Facil facil = fetchByGroupId(groupId);

        if (facil == null) {
            StringBundler msg = new StringBundler(4);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("groupId=");
            msg.append(groupId);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchFacilException(msg.toString());
        }

        return facil;
    }

    /**
     * Returns the facil where groupId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param groupId the group ID
     * @return the matching facil, or <code>null</code> if a matching facil could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil fetchByGroupId(long groupId) throws SystemException {
        return fetchByGroupId(groupId, true);
    }

    /**
     * Returns the facil where groupId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param groupId the group ID
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching facil, or <code>null</code> if a matching facil could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil fetchByGroupId(long groupId, boolean retrieveFromCache)
        throws SystemException {
        Object[] finderArgs = new Object[] { groupId };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_GROUPID,
                    finderArgs, this);
        }

        if (result instanceof Facil) {
            Facil facil = (Facil) result;

            if ((groupId != facil.getGroupId())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_SELECT_FACIL_WHERE);

            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(groupId);

                List<Facil> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_GROUPID,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "FacilPersistenceImpl.fetchByGroupId(long, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    Facil facil = list.get(0);

                    result = facil;

                    cacheResult(facil);

                    if ((facil.getGroupId() != groupId)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_GROUPID,
                            finderArgs, facil);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_GROUPID,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (Facil) result;
        }
    }

    /**
     * Removes the facil where groupId = &#63; from the database.
     *
     * @param groupId the group ID
     * @return the facil that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil removeByGroupId(long groupId)
        throws NoSuchFacilException, SystemException {
        Facil facil = findByGroupId(groupId);

        return remove(facil);
    }

    /**
     * Returns the number of facils where groupId = &#63;.
     *
     * @param groupId the group ID
     * @return the number of matching facils
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByGroupId(long groupId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_GROUPID;

        Object[] finderArgs = new Object[] { groupId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_FACIL_WHERE);

            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(groupId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns the facil where facilityNumber = &#63; or throws a {@link gov.va.caret.NoSuchFacilException} if it could not be found.
     *
     * @param facilityNumber the facility number
     * @return the matching facil
     * @throws gov.va.caret.NoSuchFacilException if a matching facil could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil findByFacilityNumber(String facilityNumber)
        throws NoSuchFacilException, SystemException {
        Facil facil = fetchByFacilityNumber(facilityNumber);

        if (facil == null) {
            StringBundler msg = new StringBundler(4);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("facilityNumber=");
            msg.append(facilityNumber);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchFacilException(msg.toString());
        }

        return facil;
    }

    /**
     * Returns the facil where facilityNumber = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param facilityNumber the facility number
     * @return the matching facil, or <code>null</code> if a matching facil could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil fetchByFacilityNumber(String facilityNumber)
        throws SystemException {
        return fetchByFacilityNumber(facilityNumber, true);
    }

    /**
     * Returns the facil where facilityNumber = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param facilityNumber the facility number
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching facil, or <code>null</code> if a matching facil could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil fetchByFacilityNumber(String facilityNumber,
        boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[] { facilityNumber };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_FACILITYNUMBER,
                    finderArgs, this);
        }

        if (result instanceof Facil) {
            Facil facil = (Facil) result;

            if (!Validator.equals(facilityNumber, facil.getFacilityNumber())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_SELECT_FACIL_WHERE);

            boolean bindFacilityNumber = false;

            if (facilityNumber == null) {
                query.append(_FINDER_COLUMN_FACILITYNUMBER_FACILITYNUMBER_1);
            } else if (facilityNumber.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_FACILITYNUMBER_FACILITYNUMBER_3);
            } else {
                bindFacilityNumber = true;

                query.append(_FINDER_COLUMN_FACILITYNUMBER_FACILITYNUMBER_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindFacilityNumber) {
                    qPos.add(facilityNumber);
                }

                List<Facil> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_FACILITYNUMBER,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "FacilPersistenceImpl.fetchByFacilityNumber(String, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    Facil facil = list.get(0);

                    result = facil;

                    cacheResult(facil);

                    if ((facil.getFacilityNumber() == null) ||
                            !facil.getFacilityNumber().equals(facilityNumber)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_FACILITYNUMBER,
                            finderArgs, facil);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_FACILITYNUMBER,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (Facil) result;
        }
    }

    /**
     * Removes the facil where facilityNumber = &#63; from the database.
     *
     * @param facilityNumber the facility number
     * @return the facil that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil removeByFacilityNumber(String facilityNumber)
        throws NoSuchFacilException, SystemException {
        Facil facil = findByFacilityNumber(facilityNumber);

        return remove(facil);
    }

    /**
     * Returns the number of facils where facilityNumber = &#63;.
     *
     * @param facilityNumber the facility number
     * @return the number of matching facils
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByFacilityNumber(String facilityNumber)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_FACILITYNUMBER;

        Object[] finderArgs = new Object[] { facilityNumber };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_FACIL_WHERE);

            boolean bindFacilityNumber = false;

            if (facilityNumber == null) {
                query.append(_FINDER_COLUMN_FACILITYNUMBER_FACILITYNUMBER_1);
            } else if (facilityNumber.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_FACILITYNUMBER_FACILITYNUMBER_3);
            } else {
                bindFacilityNumber = true;

                query.append(_FINDER_COLUMN_FACILITYNUMBER_FACILITYNUMBER_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindFacilityNumber) {
                    qPos.add(facilityNumber);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the facil in the entity cache if it is enabled.
     *
     * @param facil the facil
     */
    @Override
    public void cacheResult(Facil facil) {
        EntityCacheUtil.putResult(FacilModelImpl.ENTITY_CACHE_ENABLED,
            FacilImpl.class, facil.getPrimaryKey(), facil);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_GROUPID,
            new Object[] { facil.getGroupId() }, facil);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_FACILITYNUMBER,
            new Object[] { facil.getFacilityNumber() }, facil);

        facil.resetOriginalValues();
    }

    /**
     * Caches the facils in the entity cache if it is enabled.
     *
     * @param facils the facils
     */
    @Override
    public void cacheResult(List<Facil> facils) {
        for (Facil facil : facils) {
            if (EntityCacheUtil.getResult(FacilModelImpl.ENTITY_CACHE_ENABLED,
                        FacilImpl.class, facil.getPrimaryKey()) == null) {
                cacheResult(facil);
            } else {
                facil.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all facils.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(FacilImpl.class.getName());
        }

        EntityCacheUtil.clearCache(FacilImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the facil.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(Facil facil) {
        EntityCacheUtil.removeResult(FacilModelImpl.ENTITY_CACHE_ENABLED,
            FacilImpl.class, facil.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        clearUniqueFindersCache(facil);
    }

    @Override
    public void clearCache(List<Facil> facils) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (Facil facil : facils) {
            EntityCacheUtil.removeResult(FacilModelImpl.ENTITY_CACHE_ENABLED,
                FacilImpl.class, facil.getPrimaryKey());

            clearUniqueFindersCache(facil);
        }
    }

    protected void cacheUniqueFindersCache(Facil facil) {
        if (facil.isNew()) {
            Object[] args = new Object[] { facil.getGroupId() };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_GROUPID, args,
                Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_GROUPID, args, facil);

            args = new Object[] { facil.getFacilityNumber() };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_FACILITYNUMBER,
                args, Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_FACILITYNUMBER,
                args, facil);
        } else {
            FacilModelImpl facilModelImpl = (FacilModelImpl) facil;

            if ((facilModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_GROUPID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { facil.getGroupId() };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_GROUPID, args,
                    Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_GROUPID, args,
                    facil);
            }

            if ((facilModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_FACILITYNUMBER.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { facil.getFacilityNumber() };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_FACILITYNUMBER,
                    args, Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_FACILITYNUMBER,
                    args, facil);
            }
        }
    }

    protected void clearUniqueFindersCache(Facil facil) {
        FacilModelImpl facilModelImpl = (FacilModelImpl) facil;

        Object[] args = new Object[] { facil.getGroupId() };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_GROUPID, args);

        if ((facilModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_GROUPID.getColumnBitmask()) != 0) {
            args = new Object[] { facilModelImpl.getOriginalGroupId() };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_GROUPID, args);
        }

        args = new Object[] { facil.getFacilityNumber() };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_FACILITYNUMBER, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_FACILITYNUMBER, args);

        if ((facilModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_FACILITYNUMBER.getColumnBitmask()) != 0) {
            args = new Object[] { facilModelImpl.getOriginalFacilityNumber() };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_FACILITYNUMBER,
                args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_FACILITYNUMBER,
                args);
        }
    }

    /**
     * Creates a new facil with the primary key. Does not add the facil to the database.
     *
     * @param facilId the primary key for the new facil
     * @return the new facil
     */
    @Override
    public Facil create(long facilId) {
        Facil facil = new FacilImpl();

        facil.setNew(true);
        facil.setPrimaryKey(facilId);

        return facil;
    }

    /**
     * Removes the facil with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param facilId the primary key of the facil
     * @return the facil that was removed
     * @throws gov.va.caret.NoSuchFacilException if a facil with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil remove(long facilId)
        throws NoSuchFacilException, SystemException {
        return remove((Serializable) facilId);
    }

    /**
     * Removes the facil with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the facil
     * @return the facil that was removed
     * @throws gov.va.caret.NoSuchFacilException if a facil with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil remove(Serializable primaryKey)
        throws NoSuchFacilException, SystemException {
        Session session = null;

        try {
            session = openSession();

            Facil facil = (Facil) session.get(FacilImpl.class, primaryKey);

            if (facil == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchFacilException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(facil);
        } catch (NoSuchFacilException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected Facil removeImpl(Facil facil) throws SystemException {
        facil = toUnwrappedModel(facil);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(facil)) {
                facil = (Facil) session.get(FacilImpl.class,
                        facil.getPrimaryKeyObj());
            }

            if (facil != null) {
                session.delete(facil);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (facil != null) {
            clearCache(facil);
        }

        return facil;
    }

    @Override
    public Facil updateImpl(gov.va.caret.model.Facil facil)
        throws SystemException {
        facil = toUnwrappedModel(facil);

        boolean isNew = facil.isNew();

        Session session = null;

        try {
            session = openSession();

            if (facil.isNew()) {
                session.save(facil);

                facil.setNew(false);
            } else {
                session.merge(facil);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !FacilModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }

        EntityCacheUtil.putResult(FacilModelImpl.ENTITY_CACHE_ENABLED,
            FacilImpl.class, facil.getPrimaryKey(), facil);

        clearUniqueFindersCache(facil);
        cacheUniqueFindersCache(facil);

        return facil;
    }

    protected Facil toUnwrappedModel(Facil facil) {
        if (facil instanceof FacilImpl) {
            return facil;
        }

        FacilImpl facilImpl = new FacilImpl();

        facilImpl.setNew(facil.isNew());
        facilImpl.setPrimaryKey(facil.getPrimaryKey());

        facilImpl.setFacilId(facil.getFacilId());
        facilImpl.setFacilityNumber(facil.getFacilityNumber());
        facilImpl.setLocation(facil.getLocation());
        facilImpl.setGroupId(facil.getGroupId());

        return facilImpl;
    }

    /**
     * Returns the facil with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the facil
     * @return the facil
     * @throws gov.va.caret.NoSuchFacilException if a facil with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil findByPrimaryKey(Serializable primaryKey)
        throws NoSuchFacilException, SystemException {
        Facil facil = fetchByPrimaryKey(primaryKey);

        if (facil == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchFacilException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return facil;
    }

    /**
     * Returns the facil with the primary key or throws a {@link gov.va.caret.NoSuchFacilException} if it could not be found.
     *
     * @param facilId the primary key of the facil
     * @return the facil
     * @throws gov.va.caret.NoSuchFacilException if a facil with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil findByPrimaryKey(long facilId)
        throws NoSuchFacilException, SystemException {
        return findByPrimaryKey((Serializable) facilId);
    }

    /**
     * Returns the facil with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the facil
     * @return the facil, or <code>null</code> if a facil with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        Facil facil = (Facil) EntityCacheUtil.getResult(FacilModelImpl.ENTITY_CACHE_ENABLED,
                FacilImpl.class, primaryKey);

        if (facil == _nullFacil) {
            return null;
        }

        if (facil == null) {
            Session session = null;

            try {
                session = openSession();

                facil = (Facil) session.get(FacilImpl.class, primaryKey);

                if (facil != null) {
                    cacheResult(facil);
                } else {
                    EntityCacheUtil.putResult(FacilModelImpl.ENTITY_CACHE_ENABLED,
                        FacilImpl.class, primaryKey, _nullFacil);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(FacilModelImpl.ENTITY_CACHE_ENABLED,
                    FacilImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return facil;
    }

    /**
     * Returns the facil with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param facilId the primary key of the facil
     * @return the facil, or <code>null</code> if a facil with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Facil fetchByPrimaryKey(long facilId) throws SystemException {
        return fetchByPrimaryKey((Serializable) facilId);
    }

    /**
     * Returns all the facils.
     *
     * @return the facils
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Facil> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the facils.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.FacilModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of facils
     * @param end the upper bound of the range of facils (not inclusive)
     * @return the range of facils
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Facil> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the facils.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.FacilModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of facils
     * @param end the upper bound of the range of facils (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of facils
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Facil> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<Facil> list = (List<Facil>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_FACIL);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_FACIL;

                if (pagination) {
                    sql = sql.concat(FacilModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<Facil>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Facil>(list);
                } else {
                    list = (List<Facil>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the facils from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (Facil facil : findAll()) {
            remove(facil);
        }
    }

    /**
     * Returns the number of facils.
     *
     * @return the number of facils
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_FACIL);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the facil persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.Facil")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<Facil>> listenersList = new ArrayList<ModelListener<Facil>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<Facil>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(FacilImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
