package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchCespException;
import gov.va.caret.model.Cesp;
import gov.va.caret.model.impl.CespImpl;
import gov.va.caret.model.impl.CespModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the cesp service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see CespPersistence
 * @see CespUtil
 * @generated
 */
public class CespPersistenceImpl extends BasePersistenceImpl<Cesp>
    implements CespPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link CespUtil} to access the cesp persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = CespImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(CespModelImpl.ENTITY_CACHE_ENABLED,
            CespModelImpl.FINDER_CACHE_ENABLED, CespImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(CespModelImpl.ENTITY_CACHE_ENABLED,
            CespModelImpl.FINDER_CACHE_ENABLED, CespImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CespModelImpl.ENTITY_CACHE_ENABLED,
            CespModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_CALLID = new FinderPath(CespModelImpl.ENTITY_CACHE_ENABLED,
            CespModelImpl.FINDER_CACHE_ENABLED, CespImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCallId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID =
        new FinderPath(CespModelImpl.ENTITY_CACHE_ENABLED,
            CespModelImpl.FINDER_CACHE_ENABLED, CespImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCallId",
            new String[] { Long.class.getName() },
            CespModelImpl.CALLID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_CALLID = new FinderPath(CespModelImpl.ENTITY_CACHE_ENABLED,
            CespModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCallId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_CALLID_CALLID_2 = "cesp.callId = ?";
    private static final String _SQL_SELECT_CESP = "SELECT cesp FROM Cesp cesp";
    private static final String _SQL_SELECT_CESP_WHERE = "SELECT cesp FROM Cesp cesp WHERE ";
    private static final String _SQL_COUNT_CESP = "SELECT COUNT(cesp) FROM Cesp cesp";
    private static final String _SQL_COUNT_CESP_WHERE = "SELECT COUNT(cesp) FROM Cesp cesp WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "cesp.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Cesp exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Cesp exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(CespPersistenceImpl.class);
    private static Cesp _nullCesp = new CespImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<Cesp> toCacheModel() {
                return _nullCespCacheModel;
            }
        };

    private static CacheModel<Cesp> _nullCespCacheModel = new CacheModel<Cesp>() {
            @Override
            public Cesp toEntityModel() {
                return _nullCesp;
            }
        };

    public CespPersistenceImpl() {
        setModelClass(Cesp.class);
    }

    /**
     * Returns all the cesps where callId = &#63;.
     *
     * @param callId the call ID
     * @return the matching cesps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Cesp> findByCallId(long callId) throws SystemException {
        return findByCallId(callId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the cesps where callId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param callId the call ID
     * @param start the lower bound of the range of cesps
     * @param end the upper bound of the range of cesps (not inclusive)
     * @return the range of matching cesps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Cesp> findByCallId(long callId, int start, int end)
        throws SystemException {
        return findByCallId(callId, start, end, null);
    }

    /**
     * Returns an ordered range of all the cesps where callId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param callId the call ID
     * @param start the lower bound of the range of cesps
     * @param end the upper bound of the range of cesps (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching cesps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Cesp> findByCallId(long callId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID;
            finderArgs = new Object[] { callId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_CALLID;
            finderArgs = new Object[] { callId, start, end, orderByComparator };
        }

        List<Cesp> list = (List<Cesp>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Cesp cesp : list) {
                if ((callId != cesp.getCallId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_CESP_WHERE);

            query.append(_FINDER_COLUMN_CALLID_CALLID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(CespModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(callId);

                if (!pagination) {
                    list = (List<Cesp>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Cesp>(list);
                } else {
                    list = (List<Cesp>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first cesp in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching cesp
     * @throws gov.va.caret.NoSuchCespException if a matching cesp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Cesp findByCallId_First(long callId,
        OrderByComparator orderByComparator)
        throws NoSuchCespException, SystemException {
        Cesp cesp = fetchByCallId_First(callId, orderByComparator);

        if (cesp != null) {
            return cesp;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("callId=");
        msg.append(callId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCespException(msg.toString());
    }

    /**
     * Returns the first cesp in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching cesp, or <code>null</code> if a matching cesp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Cesp fetchByCallId_First(long callId,
        OrderByComparator orderByComparator) throws SystemException {
        List<Cesp> list = findByCallId(callId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last cesp in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching cesp
     * @throws gov.va.caret.NoSuchCespException if a matching cesp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Cesp findByCallId_Last(long callId,
        OrderByComparator orderByComparator)
        throws NoSuchCespException, SystemException {
        Cesp cesp = fetchByCallId_Last(callId, orderByComparator);

        if (cesp != null) {
            return cesp;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("callId=");
        msg.append(callId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCespException(msg.toString());
    }

    /**
     * Returns the last cesp in the ordered set where callId = &#63;.
     *
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching cesp, or <code>null</code> if a matching cesp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Cesp fetchByCallId_Last(long callId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByCallId(callId);

        if (count == 0) {
            return null;
        }

        List<Cesp> list = findByCallId(callId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the cesps before and after the current cesp in the ordered set where callId = &#63;.
     *
     * @param cespId the primary key of the current cesp
     * @param callId the call ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next cesp
     * @throws gov.va.caret.NoSuchCespException if a cesp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Cesp[] findByCallId_PrevAndNext(long cespId, long callId,
        OrderByComparator orderByComparator)
        throws NoSuchCespException, SystemException {
        Cesp cesp = findByPrimaryKey(cespId);

        Session session = null;

        try {
            session = openSession();

            Cesp[] array = new CespImpl[3];

            array[0] = getByCallId_PrevAndNext(session, cesp, callId,
                    orderByComparator, true);

            array[1] = cesp;

            array[2] = getByCallId_PrevAndNext(session, cesp, callId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Cesp getByCallId_PrevAndNext(Session session, Cesp cesp,
        long callId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_CESP_WHERE);

        query.append(_FINDER_COLUMN_CALLID_CALLID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(CespModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(callId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(cesp);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Cesp> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the cesps where callId = &#63; from the database.
     *
     * @param callId the call ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByCallId(long callId) throws SystemException {
        for (Cesp cesp : findByCallId(callId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(cesp);
        }
    }

    /**
     * Returns the number of cesps where callId = &#63;.
     *
     * @param callId the call ID
     * @return the number of matching cesps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByCallId(long callId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_CALLID;

        Object[] finderArgs = new Object[] { callId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_CESP_WHERE);

            query.append(_FINDER_COLUMN_CALLID_CALLID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(callId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the cesp in the entity cache if it is enabled.
     *
     * @param cesp the cesp
     */
    @Override
    public void cacheResult(Cesp cesp) {
        EntityCacheUtil.putResult(CespModelImpl.ENTITY_CACHE_ENABLED,
            CespImpl.class, cesp.getPrimaryKey(), cesp);

        cesp.resetOriginalValues();
    }

    /**
     * Caches the cesps in the entity cache if it is enabled.
     *
     * @param cesps the cesps
     */
    @Override
    public void cacheResult(List<Cesp> cesps) {
        for (Cesp cesp : cesps) {
            if (EntityCacheUtil.getResult(CespModelImpl.ENTITY_CACHE_ENABLED,
                        CespImpl.class, cesp.getPrimaryKey()) == null) {
                cacheResult(cesp);
            } else {
                cesp.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all cesps.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(CespImpl.class.getName());
        }

        EntityCacheUtil.clearCache(CespImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the cesp.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(Cesp cesp) {
        EntityCacheUtil.removeResult(CespModelImpl.ENTITY_CACHE_ENABLED,
            CespImpl.class, cesp.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<Cesp> cesps) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (Cesp cesp : cesps) {
            EntityCacheUtil.removeResult(CespModelImpl.ENTITY_CACHE_ENABLED,
                CespImpl.class, cesp.getPrimaryKey());
        }
    }

    /**
     * Creates a new cesp with the primary key. Does not add the cesp to the database.
     *
     * @param cespId the primary key for the new cesp
     * @return the new cesp
     */
    @Override
    public Cesp create(long cespId) {
        Cesp cesp = new CespImpl();

        cesp.setNew(true);
        cesp.setPrimaryKey(cespId);

        return cesp;
    }

    /**
     * Removes the cesp with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param cespId the primary key of the cesp
     * @return the cesp that was removed
     * @throws gov.va.caret.NoSuchCespException if a cesp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Cesp remove(long cespId) throws NoSuchCespException, SystemException {
        return remove((Serializable) cespId);
    }

    /**
     * Removes the cesp with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the cesp
     * @return the cesp that was removed
     * @throws gov.va.caret.NoSuchCespException if a cesp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Cesp remove(Serializable primaryKey)
        throws NoSuchCespException, SystemException {
        Session session = null;

        try {
            session = openSession();

            Cesp cesp = (Cesp) session.get(CespImpl.class, primaryKey);

            if (cesp == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchCespException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(cesp);
        } catch (NoSuchCespException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected Cesp removeImpl(Cesp cesp) throws SystemException {
        cesp = toUnwrappedModel(cesp);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(cesp)) {
                cesp = (Cesp) session.get(CespImpl.class,
                        cesp.getPrimaryKeyObj());
            }

            if (cesp != null) {
                session.delete(cesp);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (cesp != null) {
            clearCache(cesp);
        }

        return cesp;
    }

    @Override
    public Cesp updateImpl(gov.va.caret.model.Cesp cesp)
        throws SystemException {
        cesp = toUnwrappedModel(cesp);

        boolean isNew = cesp.isNew();

        CespModelImpl cespModelImpl = (CespModelImpl) cesp;

        Session session = null;

        try {
            session = openSession();

            if (cesp.isNew()) {
                session.save(cesp);

                cesp.setNew(false);
            } else {
                session.merge(cesp);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !CespModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((cespModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { cespModelImpl.getOriginalCallId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CALLID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID,
                    args);

                args = new Object[] { cespModelImpl.getCallId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CALLID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLID,
                    args);
            }
        }

        EntityCacheUtil.putResult(CespModelImpl.ENTITY_CACHE_ENABLED,
            CespImpl.class, cesp.getPrimaryKey(), cesp);

        return cesp;
    }

    protected Cesp toUnwrappedModel(Cesp cesp) {
        if (cesp instanceof CespImpl) {
            return cesp;
        }

        CespImpl cespImpl = new CespImpl();

        cespImpl.setNew(cesp.isNew());
        cespImpl.setPrimaryKey(cesp.getPrimaryKey());

        cespImpl.setCespId(cesp.getCespId());
        cespImpl.setCallId(cesp.getCallId());
        cespImpl.setCreatedByPersnId(cesp.getCreatedByPersnId());
        cespImpl.setCreationDate(cesp.getCreationDate());
        cespImpl.setStep(cesp.getStep());
        cespImpl.setStatus(cesp.getStatus());
        cespImpl.setReferredBy(cesp.getReferredBy());
        cespImpl.setAssignedCslPersnId(cesp.getAssignedCslPersnId());
        cespImpl.setGoals(cesp.getGoals());
        cespImpl.setPlanProgressBarrier(cesp.getPlanProgressBarrier());
        cespImpl.setCespClosed(cesp.getCespClosed());
        cespImpl.setCespClosedReason(cesp.getCespClosedReason());
        cespImpl.setGoalsReached(cesp.getGoalsReached());

        return cespImpl;
    }

    /**
     * Returns the cesp with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the cesp
     * @return the cesp
     * @throws gov.va.caret.NoSuchCespException if a cesp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Cesp findByPrimaryKey(Serializable primaryKey)
        throws NoSuchCespException, SystemException {
        Cesp cesp = fetchByPrimaryKey(primaryKey);

        if (cesp == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchCespException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return cesp;
    }

    /**
     * Returns the cesp with the primary key or throws a {@link gov.va.caret.NoSuchCespException} if it could not be found.
     *
     * @param cespId the primary key of the cesp
     * @return the cesp
     * @throws gov.va.caret.NoSuchCespException if a cesp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Cesp findByPrimaryKey(long cespId)
        throws NoSuchCespException, SystemException {
        return findByPrimaryKey((Serializable) cespId);
    }

    /**
     * Returns the cesp with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the cesp
     * @return the cesp, or <code>null</code> if a cesp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Cesp fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        Cesp cesp = (Cesp) EntityCacheUtil.getResult(CespModelImpl.ENTITY_CACHE_ENABLED,
                CespImpl.class, primaryKey);

        if (cesp == _nullCesp) {
            return null;
        }

        if (cesp == null) {
            Session session = null;

            try {
                session = openSession();

                cesp = (Cesp) session.get(CespImpl.class, primaryKey);

                if (cesp != null) {
                    cacheResult(cesp);
                } else {
                    EntityCacheUtil.putResult(CespModelImpl.ENTITY_CACHE_ENABLED,
                        CespImpl.class, primaryKey, _nullCesp);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(CespModelImpl.ENTITY_CACHE_ENABLED,
                    CespImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return cesp;
    }

    /**
     * Returns the cesp with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param cespId the primary key of the cesp
     * @return the cesp, or <code>null</code> if a cesp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Cesp fetchByPrimaryKey(long cespId) throws SystemException {
        return fetchByPrimaryKey((Serializable) cespId);
    }

    /**
     * Returns all the cesps.
     *
     * @return the cesps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Cesp> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the cesps.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of cesps
     * @param end the upper bound of the range of cesps (not inclusive)
     * @return the range of cesps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Cesp> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the cesps.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of cesps
     * @param end the upper bound of the range of cesps (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of cesps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Cesp> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<Cesp> list = (List<Cesp>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_CESP);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_CESP;

                if (pagination) {
                    sql = sql.concat(CespModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<Cesp>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Cesp>(list);
                } else {
                    list = (List<Cesp>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the cesps from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (Cesp cesp : findAll()) {
            remove(cesp);
        }
    }

    /**
     * Returns the number of cesps.
     *
     * @return the number of cesps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_CESP);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the cesp persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.Cesp")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<Cesp>> listenersList = new ArrayList<ModelListener<Cesp>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<Cesp>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(CespImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
