package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Dummy;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
//import gov.va.caret.view.ReportParameter;

import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
* @author Payam Shabaneh
*/
public class CaretFinderImpl extends BasePersistenceImpl<Dummy> implements CaretFinder {
	
	
	@SuppressWarnings("unchecked")
	public List<Map<String,Object>> getReport ( String sqlName, Object entries, String orderColumn, boolean desc, int start, int end ) throws ApplicationWorkFlowException {
		return getReport(sqlName, entries, orderColumn, desc, start, end, StringPool.BLANK );
	}
	
	@SuppressWarnings("unchecked")
	public List<Map<String,Object>> getReport ( String sqlName, Object entries, String orderColumn, boolean desc, int start, int end, String filtered ) throws ApplicationWorkFlowException {
		
		if ( _log.isDebugEnabled() ){
			_log.debug("report name is..." + sqlName);
		}
		
		Session session = null;
		try {
			session = openSession();
			String sql = CustomSQLUtil.get( sqlName );
			if ( start >= 0 && end >= 0 ){
				sql = SELECT_WITH_ROWNUM + sql + WHERE_ROWNUM_LT  + end + WHERE_ROWNUM_GT + start;
			}
			
			SQLQuery sqlQuery = setup ( session, entries, sql, orderColumn, desc, filtered );
			
			return translate( sqlQuery.list() );
		} catch ( Exception e ){
			e.printStackTrace();
			throw new ApplicationWorkFlowException ( SERVICE_EXCEPTION + sqlName );
		} finally {
			if ( session != null ){
				closeSession( session );
			}
		}
		
	}
	
	@SuppressWarnings("unchecked")
	public List<Map<String,Object>> getReport ( String sqlName, Object entries, int start, int end ) throws ApplicationWorkFlowException {
		
		if ( _log.isDebugEnabled() ){
			_log.debug("report name is..." + sqlName);
		}
		
		Session session = null;
		try {
			session = openSession();
			String sql = CustomSQLUtil.get( sqlName );
			if ( start >= 0 && end >= 0 ){
				sql = SELECT_WITH_ROWNUM + sql + WHERE_ROWNUM_LT  + end + WHERE_ROWNUM_GT + start;
			}
			
			SQLQuery sqlQuery = setup ( session, entries, sql );
			
			
			
			return translate( sqlQuery.list() );
		} catch ( Exception e ){
			e.printStackTrace();
			throw new ApplicationWorkFlowException ( SERVICE_EXCEPTION );
		} finally {
			if ( session != null ){
				closeSession( session );
			}
		}
	}
	
	private SQLQuery setup ( Session session, Object entries, String sql ){
		return setup(session, entries, sql, StringPool.BLANK);
	}
	
	@SuppressWarnings("unchecked")
	private SQLQuery setup ( Session session, Object entries, String sql, String filtered ){
		SQLQuery sqlQuery = null;
		if ( entries != null ){
			if ( entries instanceof Map ){
				Map<String,Object> map = ( Map<String,Object> )entries;
				for ( String key: map.keySet() ){
					sql = StringUtil.replace( sql, OPEN + key + CLOSE, convert( map.get(key) ) );
				}
			} else {
				sqlQuery = session.createSQLQuery( sql );
				QueryPos.getInstance( sqlQuery ).add( entries );
			}
		}
		
		if ( _log.isDebugEnabled() ){
			_log.debug("SQL" + sql);
		}
		
		sql = StringUtil.replace( sql, _FILTERED, filtered );
		
		if ( sqlQuery == null ){
			sqlQuery = session.createSQLQuery( sql );
		}
		return sqlQuery;
	}
		
	//orderBy$] [$desc
	@SuppressWarnings("unchecked")
	private SQLQuery setup ( Session session, Object entries, String sql, String column, boolean desc, String filtered ){
		SQLQuery sqlQuery = null;
		boolean addEntries = false;
		if ( entries != null ){
			if ( entries instanceof Map ){
				Map<String,Object> map = ( Map<String,Object> )entries;
				for ( String key: map.keySet() ){
					sql = StringUtil.replace( sql, OPEN + key + CLOSE, convert( map.get(key) ) );
				}
			} else {
				addEntries = true;
			}
		}
		
		sql = StringUtil.replace( sql, _COLUMN, column );
		sql = StringUtil.replace( sql, _FILTERED, filtered );
		sql = StringUtil.replace( sql, _DESC, desc? DESC : StringPool.BLANK );

		if ( _log.isDebugEnabled() ){
			_log.debug("SQL" + sql);
		}

		if ( sqlQuery == null ){
			sqlQuery = session.createSQLQuery( sql );
		}
		
		if ( addEntries ){
			QueryPos.getInstance( sqlQuery ).add( entries );
		}
		
		
		return sqlQuery;
	}

	public int getReportCount ( String sqlName, Object entries ) throws ApplicationWorkFlowException {
		
		if ( _log.isDebugEnabled() ){
			_log.debug("count name is..." + sqlName);
		}
		
		Session session = null;
		try {
			session = openSession();
			String sql = removeOrderBy( CustomSQLUtil.get( sqlName ) );
			sql = COUNT_PRE + sql + StringPool.CLOSE_PARENTHESIS;
			
			SQLQuery sqlQuery = setup ( session, entries, sql ); 

			sqlQuery.addScalar(COUNT,Type.INTEGER);
			
			return (Integer) sqlQuery.list().get(0);
		} catch ( Exception e ){
			e.printStackTrace();
			throw new ApplicationWorkFlowException ( SERVICE_EXCEPTION );
		} finally {
			if ( session != null ){
				closeSession( session );
			}
		}
	}
	
	private String convert(Object object) {
		if ( object instanceof java.util.Date ){
			return StringPool.APOSTROPHE + Toolbox.formatDateTime(object) + StringPool.APOSTROPHE;
		} 
		return object.toString();
	}
	
	private String removeOrderBy ( String sql ){
		if ( sql == null ){
			return "SELECT 1 from DUAL where 1 = ?";
		}
		int i = sql.indexOf( ORDER );
		if ( i > 0 ){
			sql = sql.substring( 0, i );
		}
		return sql;
	}
	
	private List<Map<String,Object>> translate (List<Object[]> list){
		if ( list.isEmpty() ) 
			return Collections.emptyList();
		return translate( list, Toolbox.getDateTimeFormat() );
	}
	
	private List<Map<String,Object>> translate ( List<Object[]> list, Format dateFormat ){
		List<Map<String,Object>> translate = new ArrayList<Map<String,Object>>();
		Map<String,Object> map;
		for ( Object[] o: list){
			map = new HashMap<String,Object>();
			for ( int i = 0; i < o.length; i++ ){
				if ( o[i] == null ){
					o[i] = StringPool.BLANK;
				} else if ( o[i] instanceof java.util.Date ){
					o[i] = dateFormat.format(o[i]);
				} 
				map.put(CaretStrPool.NDX + i, o[i]);
			}
			translate.add(map);
		}
		return translate;
	}
	
	private static Log _log = LogFactoryUtil.getLog( CaretFinderImpl.class );

	private static final String SELECT_WITH_ROWNUM = "select * from (select ROWNUM rnum, a.* from (";
	private static final String WHERE_ROWNUM_LT = ") a where ROWNUM <=";
	private static final String WHERE_ROWNUM_GT = ") where rnum >=";

	private static final String SERVICE_EXCEPTION = "SERVICE EXCEPTION : SEE STACK TRACE";
	private static final String ORDER = " ORDER ";
	private static final String COUNT_PRE = "select count(*) COUNT from (";
	private static final String COUNT = "COUNT"; 
	private static final String OPEN = "[$";
	private static final String CLOSE = "$]";
	private static final String DESC = "DESC";
	private static final String _COLUMN = "[$COLUMN$]";
	private static final String _DESC = "[$DESC$]";
	private static final String _FILTERED = "[$FILTERED$]";
}
