/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchBgMemException;
import gov.va.caret.model.BgMem;
import gov.va.caret.model.impl.BgMemImpl;
import gov.va.caret.model.impl.BgMemModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the bg mem service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgMemPersistence
 * @see BgMemUtil
 * @generated
 */
public class BgMemPersistenceImpl extends BasePersistenceImpl<BgMem>
	implements BgMemPersistence {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Always use {@link BgMemUtil} to access the bg mem persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
	 */
	public static final String FINDER_CLASS_NAME_ENTITY = BgMemImpl.class.getName();
	public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
		".List1";
	public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
		".List2";
	public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(BgMemModelImpl.ENTITY_CACHE_ENABLED,
			BgMemModelImpl.FINDER_CACHE_ENABLED, BgMemImpl.class,
			FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
	public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(BgMemModelImpl.ENTITY_CACHE_ENABLED,
			BgMemModelImpl.FINDER_CACHE_ENABLED, BgMemImpl.class,
			FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
	public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(BgMemModelImpl.ENTITY_CACHE_ENABLED,
			BgMemModelImpl.FINDER_CACHE_ENABLED, Long.class,
			FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
	public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXGROUPMEDIUMASSOCIATIONS =
		new FinderPath(BgMemModelImpl.ENTITY_CACHE_ENABLED,
			BgMemModelImpl.FINDER_CACHE_ENABLED, BgMemImpl.class,
			FINDER_CLASS_NAME_LIST_WITH_PAGINATION,
			"findByBoxGroupMediumAssociations",
			new String[] {
				Long.class.getName(),
				
			Integer.class.getName(), Integer.class.getName(),
				OrderByComparator.class.getName()
			});
	public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPMEDIUMASSOCIATIONS =
		new FinderPath(BgMemModelImpl.ENTITY_CACHE_ENABLED,
			BgMemModelImpl.FINDER_CACHE_ENABLED, BgMemImpl.class,
			FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION,
			"findByBoxGroupMediumAssociations",
			new String[] { Long.class.getName() },
			BgMemModelImpl.OWNERID_COLUMN_BITMASK);
	public static final FinderPath FINDER_PATH_COUNT_BY_BOXGROUPMEDIUMASSOCIATIONS =
		new FinderPath(BgMemModelImpl.ENTITY_CACHE_ENABLED,
			BgMemModelImpl.FINDER_CACHE_ENABLED, Long.class,
			FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION,
			"countByBoxGroupMediumAssociations",
			new String[] { Long.class.getName() });

	/**
	 * Returns all the bg mems where ownerId = &#63;.
	 *
	 * @param ownerId the owner ID
	 * @return the matching bg mems
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public List<BgMem> findByBoxGroupMediumAssociations(long ownerId)
		throws SystemException {
		return findByBoxGroupMediumAssociations(ownerId, QueryUtil.ALL_POS,
			QueryUtil.ALL_POS, null);
	}

	/**
	 * Returns a range of all the bg mems where ownerId = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	 * </p>
	 *
	 * @param ownerId the owner ID
	 * @param start the lower bound of the range of bg mems
	 * @param end the upper bound of the range of bg mems (not inclusive)
	 * @return the range of matching bg mems
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public List<BgMem> findByBoxGroupMediumAssociations(long ownerId,
		int start, int end) throws SystemException {
		return findByBoxGroupMediumAssociations(ownerId, start, end, null);
	}

	/**
	 * Returns an ordered range of all the bg mems where ownerId = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	 * </p>
	 *
	 * @param ownerId the owner ID
	 * @param start the lower bound of the range of bg mems
	 * @param end the upper bound of the range of bg mems (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching bg mems
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public List<BgMem> findByBoxGroupMediumAssociations(long ownerId,
		int start, int end, OrderByComparator orderByComparator)
		throws SystemException {
		boolean pagination = true;
		FinderPath finderPath = null;
		Object[] finderArgs = null;

		if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
				(orderByComparator == null)) {
			pagination = false;
			finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPMEDIUMASSOCIATIONS;
			finderArgs = new Object[] { ownerId };
		}
		else {
			finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXGROUPMEDIUMASSOCIATIONS;
			finderArgs = new Object[] { ownerId, start, end, orderByComparator };
		}

		List<BgMem> list = (List<BgMem>)FinderCacheUtil.getResult(finderPath,
				finderArgs, this);

		if ((list != null) && !list.isEmpty()) {
			for (BgMem bgMem : list) {
				if ((ownerId != bgMem.getOwnerId())) {
					list = null;

					break;
				}
			}
		}

		if (list == null) {
			StringBundler query = null;

			if (orderByComparator != null) {
				query = new StringBundler(3 +
						(orderByComparator.getOrderByFields().length * 3));
			}
			else {
				query = new StringBundler(3);
			}

			query.append(_SQL_SELECT_BGMEM_WHERE);

			query.append(_FINDER_COLUMN_BOXGROUPMEDIUMASSOCIATIONS_OWNERID_2);

			if (orderByComparator != null) {
				appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
					orderByComparator);
			}
			else
			 if (pagination) {
				query.append(BgMemModelImpl.ORDER_BY_JPQL);
			}

			String sql = query.toString();

			Session session = null;

			try {
				session = openSession();

				Query q = session.createQuery(sql);

				QueryPos qPos = QueryPos.getInstance(q);

				qPos.add(ownerId);

				if (!pagination) {
					list = (List<BgMem>)QueryUtil.list(q, getDialect(), start,
							end, false);

					Collections.sort(list);

					list = new UnmodifiableList<BgMem>(list);
				}
				else {
					list = (List<BgMem>)QueryUtil.list(q, getDialect(), start,
							end);
				}

				cacheResult(list);

				FinderCacheUtil.putResult(finderPath, finderArgs, list);
			}
			catch (Exception e) {
				FinderCacheUtil.removeResult(finderPath, finderArgs);

				throw processException(e);
			}
			finally {
				closeSession(session);
			}
		}

		return list;
	}

	/**
	 * Returns the first bg mem in the ordered set where ownerId = &#63;.
	 *
	 * @param ownerId the owner ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching bg mem
	 * @throws gov.va.caret.NoSuchBgMemException if a matching bg mem could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem findByBoxGroupMediumAssociations_First(long ownerId,
		OrderByComparator orderByComparator)
		throws NoSuchBgMemException, SystemException {
		BgMem bgMem = fetchByBoxGroupMediumAssociations_First(ownerId,
				orderByComparator);

		if (bgMem != null) {
			return bgMem;
		}

		StringBundler msg = new StringBundler(4);

		msg.append(_NO_SUCH_ENTITY_WITH_KEY);

		msg.append("ownerId=");
		msg.append(ownerId);

		msg.append(StringPool.CLOSE_CURLY_BRACE);

		throw new NoSuchBgMemException(msg.toString());
	}

	/**
	 * Returns the first bg mem in the ordered set where ownerId = &#63;.
	 *
	 * @param ownerId the owner ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching bg mem, or <code>null</code> if a matching bg mem could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem fetchByBoxGroupMediumAssociations_First(long ownerId,
		OrderByComparator orderByComparator) throws SystemException {
		List<BgMem> list = findByBoxGroupMediumAssociations(ownerId, 0, 1,
				orderByComparator);

		if (!list.isEmpty()) {
			return list.get(0);
		}

		return null;
	}

	/**
	 * Returns the last bg mem in the ordered set where ownerId = &#63;.
	 *
	 * @param ownerId the owner ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching bg mem
	 * @throws gov.va.caret.NoSuchBgMemException if a matching bg mem could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem findByBoxGroupMediumAssociations_Last(long ownerId,
		OrderByComparator orderByComparator)
		throws NoSuchBgMemException, SystemException {
		BgMem bgMem = fetchByBoxGroupMediumAssociations_Last(ownerId,
				orderByComparator);

		if (bgMem != null) {
			return bgMem;
		}

		StringBundler msg = new StringBundler(4);

		msg.append(_NO_SUCH_ENTITY_WITH_KEY);

		msg.append("ownerId=");
		msg.append(ownerId);

		msg.append(StringPool.CLOSE_CURLY_BRACE);

		throw new NoSuchBgMemException(msg.toString());
	}

	/**
	 * Returns the last bg mem in the ordered set where ownerId = &#63;.
	 *
	 * @param ownerId the owner ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching bg mem, or <code>null</code> if a matching bg mem could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem fetchByBoxGroupMediumAssociations_Last(long ownerId,
		OrderByComparator orderByComparator) throws SystemException {
		int count = countByBoxGroupMediumAssociations(ownerId);

		if (count == 0) {
			return null;
		}

		List<BgMem> list = findByBoxGroupMediumAssociations(ownerId, count - 1,
				count, orderByComparator);

		if (!list.isEmpty()) {
			return list.get(0);
		}

		return null;
	}

	/**
	 * Returns the bg mems before and after the current bg mem in the ordered set where ownerId = &#63;.
	 *
	 * @param bgMemId the primary key of the current bg mem
	 * @param ownerId the owner ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the previous, current, and next bg mem
	 * @throws gov.va.caret.NoSuchBgMemException if a bg mem with the primary key could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem[] findByBoxGroupMediumAssociations_PrevAndNext(long bgMemId,
		long ownerId, OrderByComparator orderByComparator)
		throws NoSuchBgMemException, SystemException {
		BgMem bgMem = findByPrimaryKey(bgMemId);

		Session session = null;

		try {
			session = openSession();

			BgMem[] array = new BgMemImpl[3];

			array[0] = getByBoxGroupMediumAssociations_PrevAndNext(session,
					bgMem, ownerId, orderByComparator, true);

			array[1] = bgMem;

			array[2] = getByBoxGroupMediumAssociations_PrevAndNext(session,
					bgMem, ownerId, orderByComparator, false);

			return array;
		}
		catch (Exception e) {
			throw processException(e);
		}
		finally {
			closeSession(session);
		}
	}

	protected BgMem getByBoxGroupMediumAssociations_PrevAndNext(
		Session session, BgMem bgMem, long ownerId,
		OrderByComparator orderByComparator, boolean previous) {
		StringBundler query = null;

		if (orderByComparator != null) {
			query = new StringBundler(6 +
					(orderByComparator.getOrderByFields().length * 6));
		}
		else {
			query = new StringBundler(3);
		}

		query.append(_SQL_SELECT_BGMEM_WHERE);

		query.append(_FINDER_COLUMN_BOXGROUPMEDIUMASSOCIATIONS_OWNERID_2);

		if (orderByComparator != null) {
			String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

			if (orderByConditionFields.length > 0) {
				query.append(WHERE_AND);
			}

			for (int i = 0; i < orderByConditionFields.length; i++) {
				query.append(_ORDER_BY_ENTITY_ALIAS);
				query.append(orderByConditionFields[i]);

				if ((i + 1) < orderByConditionFields.length) {
					if (orderByComparator.isAscending() ^ previous) {
						query.append(WHERE_GREATER_THAN_HAS_NEXT);
					}
					else {
						query.append(WHERE_LESSER_THAN_HAS_NEXT);
					}
				}
				else {
					if (orderByComparator.isAscending() ^ previous) {
						query.append(WHERE_GREATER_THAN);
					}
					else {
						query.append(WHERE_LESSER_THAN);
					}
				}
			}

			query.append(ORDER_BY_CLAUSE);

			String[] orderByFields = orderByComparator.getOrderByFields();

			for (int i = 0; i < orderByFields.length; i++) {
				query.append(_ORDER_BY_ENTITY_ALIAS);
				query.append(orderByFields[i]);

				if ((i + 1) < orderByFields.length) {
					if (orderByComparator.isAscending() ^ previous) {
						query.append(ORDER_BY_ASC_HAS_NEXT);
					}
					else {
						query.append(ORDER_BY_DESC_HAS_NEXT);
					}
				}
				else {
					if (orderByComparator.isAscending() ^ previous) {
						query.append(ORDER_BY_ASC);
					}
					else {
						query.append(ORDER_BY_DESC);
					}
				}
			}
		}
		else {
			query.append(BgMemModelImpl.ORDER_BY_JPQL);
		}

		String sql = query.toString();

		Query q = session.createQuery(sql);

		q.setFirstResult(0);
		q.setMaxResults(2);

		QueryPos qPos = QueryPos.getInstance(q);

		qPos.add(ownerId);

		if (orderByComparator != null) {
			Object[] values = orderByComparator.getOrderByConditionValues(bgMem);

			for (Object value : values) {
				qPos.add(value);
			}
		}

		List<BgMem> list = q.list();

		if (list.size() == 2) {
			return list.get(1);
		}
		else {
			return null;
		}
	}

	/**
	 * Removes all the bg mems where ownerId = &#63; from the database.
	 *
	 * @param ownerId the owner ID
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public void removeByBoxGroupMediumAssociations(long ownerId)
		throws SystemException {
		for (BgMem bgMem : findByBoxGroupMediumAssociations(ownerId,
				QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
			remove(bgMem);
		}
	}

	/**
	 * Returns the number of bg mems where ownerId = &#63;.
	 *
	 * @param ownerId the owner ID
	 * @return the number of matching bg mems
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public int countByBoxGroupMediumAssociations(long ownerId)
		throws SystemException {
		FinderPath finderPath = FINDER_PATH_COUNT_BY_BOXGROUPMEDIUMASSOCIATIONS;

		Object[] finderArgs = new Object[] { ownerId };

		Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs,
				this);

		if (count == null) {
			StringBundler query = new StringBundler(2);

			query.append(_SQL_COUNT_BGMEM_WHERE);

			query.append(_FINDER_COLUMN_BOXGROUPMEDIUMASSOCIATIONS_OWNERID_2);

			String sql = query.toString();

			Session session = null;

			try {
				session = openSession();

				Query q = session.createQuery(sql);

				QueryPos qPos = QueryPos.getInstance(q);

				qPos.add(ownerId);

				count = (Long)q.uniqueResult();

				FinderCacheUtil.putResult(finderPath, finderArgs, count);
			}
			catch (Exception e) {
				FinderCacheUtil.removeResult(finderPath, finderArgs);

				throw processException(e);
			}
			finally {
				closeSession(session);
			}
		}

		return count.intValue();
	}

	private static final String _FINDER_COLUMN_BOXGROUPMEDIUMASSOCIATIONS_OWNERID_2 =
		"bgMem.ownerId = ?";
	public static final FinderPath FINDER_PATH_FETCH_BY_BGMEMASNINST = new FinderPath(BgMemModelImpl.ENTITY_CACHE_ENABLED,
			BgMemModelImpl.FINDER_CACHE_ENABLED, BgMemImpl.class,
			FINDER_CLASS_NAME_ENTITY, "fetchByBgMemAsnInst",
			new String[] { Long.class.getName(), Long.class.getName() },
			BgMemModelImpl.OWNERID_COLUMN_BITMASK |
			BgMemModelImpl.BOXGPID_COLUMN_BITMASK);
	public static final FinderPath FINDER_PATH_COUNT_BY_BGMEMASNINST = new FinderPath(BgMemModelImpl.ENTITY_CACHE_ENABLED,
			BgMemModelImpl.FINDER_CACHE_ENABLED, Long.class,
			FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByBgMemAsnInst",
			new String[] { Long.class.getName(), Long.class.getName() });

	/**
	 * Returns the bg mem where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgMemException} if it could not be found.
	 *
	 * @param ownerId the owner ID
	 * @param boxGpId the box gp ID
	 * @return the matching bg mem
	 * @throws gov.va.caret.NoSuchBgMemException if a matching bg mem could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem findByBgMemAsnInst(long ownerId, long boxGpId)
		throws NoSuchBgMemException, SystemException {
		BgMem bgMem = fetchByBgMemAsnInst(ownerId, boxGpId);

		if (bgMem == null) {
			StringBundler msg = new StringBundler(6);

			msg.append(_NO_SUCH_ENTITY_WITH_KEY);

			msg.append("ownerId=");
			msg.append(ownerId);

			msg.append(", boxGpId=");
			msg.append(boxGpId);

			msg.append(StringPool.CLOSE_CURLY_BRACE);

			if (_log.isWarnEnabled()) {
				_log.warn(msg.toString());
			}

			throw new NoSuchBgMemException(msg.toString());
		}

		return bgMem;
	}

	/**
	 * Returns the bg mem where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
	 *
	 * @param ownerId the owner ID
	 * @param boxGpId the box gp ID
	 * @return the matching bg mem, or <code>null</code> if a matching bg mem could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem fetchByBgMemAsnInst(long ownerId, long boxGpId)
		throws SystemException {
		return fetchByBgMemAsnInst(ownerId, boxGpId, true);
	}

	/**
	 * Returns the bg mem where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
	 *
	 * @param ownerId the owner ID
	 * @param boxGpId the box gp ID
	 * @param retrieveFromCache whether to use the finder cache
	 * @return the matching bg mem, or <code>null</code> if a matching bg mem could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem fetchByBgMemAsnInst(long ownerId, long boxGpId,
		boolean retrieveFromCache) throws SystemException {
		Object[] finderArgs = new Object[] { ownerId, boxGpId };

		Object result = null;

		if (retrieveFromCache) {
			result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_BGMEMASNINST,
					finderArgs, this);
		}

		if (result instanceof BgMem) {
			BgMem bgMem = (BgMem)result;

			if ((ownerId != bgMem.getOwnerId()) ||
					(boxGpId != bgMem.getBoxGpId())) {
				result = null;
			}
		}

		if (result == null) {
			StringBundler query = new StringBundler(4);

			query.append(_SQL_SELECT_BGMEM_WHERE);

			query.append(_FINDER_COLUMN_BGMEMASNINST_OWNERID_2);

			query.append(_FINDER_COLUMN_BGMEMASNINST_BOXGPID_2);

			String sql = query.toString();

			Session session = null;

			try {
				session = openSession();

				Query q = session.createQuery(sql);

				QueryPos qPos = QueryPos.getInstance(q);

				qPos.add(ownerId);

				qPos.add(boxGpId);

				List<BgMem> list = q.list();

				if (list.isEmpty()) {
					FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGMEMASNINST,
						finderArgs, list);
				}
				else {
					if ((list.size() > 1) && _log.isWarnEnabled()) {
						_log.warn(
							"BgMemPersistenceImpl.fetchByBgMemAsnInst(long, long, boolean) with parameters (" +
							StringUtil.merge(finderArgs) +
							") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
					}

					BgMem bgMem = list.get(0);

					result = bgMem;

					cacheResult(bgMem);

					if ((bgMem.getOwnerId() != ownerId) ||
							(bgMem.getBoxGpId() != boxGpId)) {
						FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGMEMASNINST,
							finderArgs, bgMem);
					}
				}
			}
			catch (Exception e) {
				FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGMEMASNINST,
					finderArgs);

				throw processException(e);
			}
			finally {
				closeSession(session);
			}
		}

		if (result instanceof List<?>) {
			return null;
		}
		else {
			return (BgMem)result;
		}
	}

	/**
	 * Removes the bg mem where ownerId = &#63; and boxGpId = &#63; from the database.
	 *
	 * @param ownerId the owner ID
	 * @param boxGpId the box gp ID
	 * @return the bg mem that was removed
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem removeByBgMemAsnInst(long ownerId, long boxGpId)
		throws NoSuchBgMemException, SystemException {
		BgMem bgMem = findByBgMemAsnInst(ownerId, boxGpId);

		return remove(bgMem);
	}

	/**
	 * Returns the number of bg mems where ownerId = &#63; and boxGpId = &#63;.
	 *
	 * @param ownerId the owner ID
	 * @param boxGpId the box gp ID
	 * @return the number of matching bg mems
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public int countByBgMemAsnInst(long ownerId, long boxGpId)
		throws SystemException {
		FinderPath finderPath = FINDER_PATH_COUNT_BY_BGMEMASNINST;

		Object[] finderArgs = new Object[] { ownerId, boxGpId };

		Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs,
				this);

		if (count == null) {
			StringBundler query = new StringBundler(3);

			query.append(_SQL_COUNT_BGMEM_WHERE);

			query.append(_FINDER_COLUMN_BGMEMASNINST_OWNERID_2);

			query.append(_FINDER_COLUMN_BGMEMASNINST_BOXGPID_2);

			String sql = query.toString();

			Session session = null;

			try {
				session = openSession();

				Query q = session.createQuery(sql);

				QueryPos qPos = QueryPos.getInstance(q);

				qPos.add(ownerId);

				qPos.add(boxGpId);

				count = (Long)q.uniqueResult();

				FinderCacheUtil.putResult(finderPath, finderArgs, count);
			}
			catch (Exception e) {
				FinderCacheUtil.removeResult(finderPath, finderArgs);

				throw processException(e);
			}
			finally {
				closeSession(session);
			}
		}

		return count.intValue();
	}

	private static final String _FINDER_COLUMN_BGMEMASNINST_OWNERID_2 = "bgMem.ownerId = ? AND ";
	private static final String _FINDER_COLUMN_BGMEMASNINST_BOXGPID_2 = "bgMem.boxGpId = ?";

	public BgMemPersistenceImpl() {
		setModelClass(BgMem.class);
	}

	/**
	 * Caches the bg mem in the entity cache if it is enabled.
	 *
	 * @param bgMem the bg mem
	 */
	@Override
	public void cacheResult(BgMem bgMem) {
		EntityCacheUtil.putResult(BgMemModelImpl.ENTITY_CACHE_ENABLED,
			BgMemImpl.class, bgMem.getPrimaryKey(), bgMem);

		FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGMEMASNINST,
			new Object[] { bgMem.getOwnerId(), bgMem.getBoxGpId() }, bgMem);

		bgMem.resetOriginalValues();
	}

	/**
	 * Caches the bg mems in the entity cache if it is enabled.
	 *
	 * @param bgMems the bg mems
	 */
	@Override
	public void cacheResult(List<BgMem> bgMems) {
		for (BgMem bgMem : bgMems) {
			if (EntityCacheUtil.getResult(BgMemModelImpl.ENTITY_CACHE_ENABLED,
						BgMemImpl.class, bgMem.getPrimaryKey()) == null) {
				cacheResult(bgMem);
			}
			else {
				bgMem.resetOriginalValues();
			}
		}
	}

	/**
	 * Clears the cache for all bg mems.
	 *
	 * <p>
	 * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
	 * </p>
	 */
	@Override
	public void clearCache() {
		if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
			CacheRegistryUtil.clear(BgMemImpl.class.getName());
		}

		EntityCacheUtil.clearCache(BgMemImpl.class.getName());

		FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
		FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
		FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
	}

	/**
	 * Clears the cache for the bg mem.
	 *
	 * <p>
	 * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
	 * </p>
	 */
	@Override
	public void clearCache(BgMem bgMem) {
		EntityCacheUtil.removeResult(BgMemModelImpl.ENTITY_CACHE_ENABLED,
			BgMemImpl.class, bgMem.getPrimaryKey());

		FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
		FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

		clearUniqueFindersCache(bgMem);
	}

	@Override
	public void clearCache(List<BgMem> bgMems) {
		FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
		FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

		for (BgMem bgMem : bgMems) {
			EntityCacheUtil.removeResult(BgMemModelImpl.ENTITY_CACHE_ENABLED,
				BgMemImpl.class, bgMem.getPrimaryKey());

			clearUniqueFindersCache(bgMem);
		}
	}

	protected void cacheUniqueFindersCache(BgMem bgMem) {
		if (bgMem.isNew()) {
			Object[] args = new Object[] { bgMem.getOwnerId(), bgMem.getBoxGpId() };

			FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_BGMEMASNINST, args,
				Long.valueOf(1));
			FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGMEMASNINST, args,
				bgMem);
		}
		else {
			BgMemModelImpl bgMemModelImpl = (BgMemModelImpl)bgMem;

			if ((bgMemModelImpl.getColumnBitmask() &
					FINDER_PATH_FETCH_BY_BGMEMASNINST.getColumnBitmask()) != 0) {
				Object[] args = new Object[] {
						bgMem.getOwnerId(), bgMem.getBoxGpId()
					};

				FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_BGMEMASNINST,
					args, Long.valueOf(1));
				FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGMEMASNINST,
					args, bgMem);
			}
		}
	}

	protected void clearUniqueFindersCache(BgMem bgMem) {
		BgMemModelImpl bgMemModelImpl = (BgMemModelImpl)bgMem;

		Object[] args = new Object[] { bgMem.getOwnerId(), bgMem.getBoxGpId() };

		FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BGMEMASNINST, args);
		FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGMEMASNINST, args);

		if ((bgMemModelImpl.getColumnBitmask() &
				FINDER_PATH_FETCH_BY_BGMEMASNINST.getColumnBitmask()) != 0) {
			args = new Object[] {
					bgMemModelImpl.getOriginalOwnerId(),
					bgMemModelImpl.getOriginalBoxGpId()
				};

			FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BGMEMASNINST, args);
			FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGMEMASNINST, args);
		}
	}

	/**
	 * Creates a new bg mem with the primary key. Does not add the bg mem to the database.
	 *
	 * @param bgMemId the primary key for the new bg mem
	 * @return the new bg mem
	 */
	@Override
	public BgMem create(long bgMemId) {
		BgMem bgMem = new BgMemImpl();

		bgMem.setNew(true);
		bgMem.setPrimaryKey(bgMemId);

		return bgMem;
	}

	/**
	 * Removes the bg mem with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * @param bgMemId the primary key of the bg mem
	 * @return the bg mem that was removed
	 * @throws gov.va.caret.NoSuchBgMemException if a bg mem with the primary key could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem remove(long bgMemId)
		throws NoSuchBgMemException, SystemException {
		return remove((Serializable)bgMemId);
	}

	/**
	 * Removes the bg mem with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * @param primaryKey the primary key of the bg mem
	 * @return the bg mem that was removed
	 * @throws gov.va.caret.NoSuchBgMemException if a bg mem with the primary key could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem remove(Serializable primaryKey)
		throws NoSuchBgMemException, SystemException {
		Session session = null;

		try {
			session = openSession();

			BgMem bgMem = (BgMem)session.get(BgMemImpl.class, primaryKey);

			if (bgMem == null) {
				if (_log.isWarnEnabled()) {
					_log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
				}

				throw new NoSuchBgMemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
					primaryKey);
			}

			return remove(bgMem);
		}
		catch (NoSuchBgMemException nsee) {
			throw nsee;
		}
		catch (Exception e) {
			throw processException(e);
		}
		finally {
			closeSession(session);
		}
	}

	@Override
	protected BgMem removeImpl(BgMem bgMem) throws SystemException {
		bgMem = toUnwrappedModel(bgMem);

		Session session = null;

		try {
			session = openSession();

			if (!session.contains(bgMem)) {
				bgMem = (BgMem)session.get(BgMemImpl.class,
						bgMem.getPrimaryKeyObj());
			}

			if (bgMem != null) {
				session.delete(bgMem);
			}
		}
		catch (Exception e) {
			throw processException(e);
		}
		finally {
			closeSession(session);
		}

		if (bgMem != null) {
			clearCache(bgMem);
		}

		return bgMem;
	}

	@Override
	public BgMem updateImpl(gov.va.caret.model.BgMem bgMem)
		throws SystemException {
		bgMem = toUnwrappedModel(bgMem);

		boolean isNew = bgMem.isNew();

		BgMemModelImpl bgMemModelImpl = (BgMemModelImpl)bgMem;

		Session session = null;

		try {
			session = openSession();

			if (bgMem.isNew()) {
				session.save(bgMem);

				bgMem.setNew(false);
			}
			else {
				session.merge(bgMem);
			}
		}
		catch (Exception e) {
			throw processException(e);
		}
		finally {
			closeSession(session);
		}

		FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

		if (isNew || !BgMemModelImpl.COLUMN_BITMASK_ENABLED) {
			FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
		}

		else {
			if ((bgMemModelImpl.getColumnBitmask() &
					FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPMEDIUMASSOCIATIONS.getColumnBitmask()) != 0) {
				Object[] args = new Object[] { bgMemModelImpl.getOriginalOwnerId() };

				FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXGROUPMEDIUMASSOCIATIONS,
					args);
				FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPMEDIUMASSOCIATIONS,
					args);

				args = new Object[] { bgMemModelImpl.getOwnerId() };

				FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXGROUPMEDIUMASSOCIATIONS,
					args);
				FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPMEDIUMASSOCIATIONS,
					args);
			}
		}

		EntityCacheUtil.putResult(BgMemModelImpl.ENTITY_CACHE_ENABLED,
			BgMemImpl.class, bgMem.getPrimaryKey(), bgMem);

		clearUniqueFindersCache(bgMem);
		cacheUniqueFindersCache(bgMem);

		return bgMem;
	}

	protected BgMem toUnwrappedModel(BgMem bgMem) {
		if (bgMem instanceof BgMemImpl) {
			return bgMem;
		}

		BgMemImpl bgMemImpl = new BgMemImpl();

		bgMemImpl.setNew(bgMem.isNew());
		bgMemImpl.setPrimaryKey(bgMem.getPrimaryKey());

		bgMemImpl.setBgMemId(bgMem.getBgMemId());
		bgMemImpl.setOwnerId(bgMem.getOwnerId());
		bgMemImpl.setBoxGpId(bgMem.getBoxGpId());
		bgMemImpl.setMediumText(bgMem.getMediumText());

		return bgMemImpl;
	}

	/**
	 * Returns the bg mem with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
	 *
	 * @param primaryKey the primary key of the bg mem
	 * @return the bg mem
	 * @throws gov.va.caret.NoSuchBgMemException if a bg mem with the primary key could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem findByPrimaryKey(Serializable primaryKey)
		throws NoSuchBgMemException, SystemException {
		BgMem bgMem = fetchByPrimaryKey(primaryKey);

		if (bgMem == null) {
			if (_log.isWarnEnabled()) {
				_log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
			}

			throw new NoSuchBgMemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
				primaryKey);
		}

		return bgMem;
	}

	/**
	 * Returns the bg mem with the primary key or throws a {@link gov.va.caret.NoSuchBgMemException} if it could not be found.
	 *
	 * @param bgMemId the primary key of the bg mem
	 * @return the bg mem
	 * @throws gov.va.caret.NoSuchBgMemException if a bg mem with the primary key could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem findByPrimaryKey(long bgMemId)
		throws NoSuchBgMemException, SystemException {
		return findByPrimaryKey((Serializable)bgMemId);
	}

	/**
	 * Returns the bg mem with the primary key or returns <code>null</code> if it could not be found.
	 *
	 * @param primaryKey the primary key of the bg mem
	 * @return the bg mem, or <code>null</code> if a bg mem with the primary key could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem fetchByPrimaryKey(Serializable primaryKey)
		throws SystemException {
		BgMem bgMem = (BgMem)EntityCacheUtil.getResult(BgMemModelImpl.ENTITY_CACHE_ENABLED,
				BgMemImpl.class, primaryKey);

		if (bgMem == _nullBgMem) {
			return null;
		}

		if (bgMem == null) {
			Session session = null;

			try {
				session = openSession();

				bgMem = (BgMem)session.get(BgMemImpl.class, primaryKey);

				if (bgMem != null) {
					cacheResult(bgMem);
				}
				else {
					EntityCacheUtil.putResult(BgMemModelImpl.ENTITY_CACHE_ENABLED,
						BgMemImpl.class, primaryKey, _nullBgMem);
				}
			}
			catch (Exception e) {
				EntityCacheUtil.removeResult(BgMemModelImpl.ENTITY_CACHE_ENABLED,
					BgMemImpl.class, primaryKey);

				throw processException(e);
			}
			finally {
				closeSession(session);
			}
		}

		return bgMem;
	}

	/**
	 * Returns the bg mem with the primary key or returns <code>null</code> if it could not be found.
	 *
	 * @param bgMemId the primary key of the bg mem
	 * @return the bg mem, or <code>null</code> if a bg mem with the primary key could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public BgMem fetchByPrimaryKey(long bgMemId) throws SystemException {
		return fetchByPrimaryKey((Serializable)bgMemId);
	}

	/**
	 * Returns all the bg mems.
	 *
	 * @return the bg mems
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public List<BgMem> findAll() throws SystemException {
		return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
	}

	/**
	 * Returns a range of all the bg mems.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	 * </p>
	 *
	 * @param start the lower bound of the range of bg mems
	 * @param end the upper bound of the range of bg mems (not inclusive)
	 * @return the range of bg mems
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public List<BgMem> findAll(int start, int end) throws SystemException {
		return findAll(start, end, null);
	}

	/**
	 * Returns an ordered range of all the bg mems.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	 * </p>
	 *
	 * @param start the lower bound of the range of bg mems
	 * @param end the upper bound of the range of bg mems (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of bg mems
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public List<BgMem> findAll(int start, int end,
		OrderByComparator orderByComparator) throws SystemException {
		boolean pagination = true;
		FinderPath finderPath = null;
		Object[] finderArgs = null;

		if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
				(orderByComparator == null)) {
			pagination = false;
			finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
			finderArgs = FINDER_ARGS_EMPTY;
		}
		else {
			finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
			finderArgs = new Object[] { start, end, orderByComparator };
		}

		List<BgMem> list = (List<BgMem>)FinderCacheUtil.getResult(finderPath,
				finderArgs, this);

		if (list == null) {
			StringBundler query = null;
			String sql = null;

			if (orderByComparator != null) {
				query = new StringBundler(2 +
						(orderByComparator.getOrderByFields().length * 3));

				query.append(_SQL_SELECT_BGMEM);

				appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
					orderByComparator);

				sql = query.toString();
			}
			else {
				sql = _SQL_SELECT_BGMEM;

				if (pagination) {
					sql = sql.concat(BgMemModelImpl.ORDER_BY_JPQL);
				}
			}

			Session session = null;

			try {
				session = openSession();

				Query q = session.createQuery(sql);

				if (!pagination) {
					list = (List<BgMem>)QueryUtil.list(q, getDialect(), start,
							end, false);

					Collections.sort(list);

					list = new UnmodifiableList<BgMem>(list);
				}
				else {
					list = (List<BgMem>)QueryUtil.list(q, getDialect(), start,
							end);
				}

				cacheResult(list);

				FinderCacheUtil.putResult(finderPath, finderArgs, list);
			}
			catch (Exception e) {
				FinderCacheUtil.removeResult(finderPath, finderArgs);

				throw processException(e);
			}
			finally {
				closeSession(session);
			}
		}

		return list;
	}

	/**
	 * Removes all the bg mems from the database.
	 *
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public void removeAll() throws SystemException {
		for (BgMem bgMem : findAll()) {
			remove(bgMem);
		}
	}

	/**
	 * Returns the number of bg mems.
	 *
	 * @return the number of bg mems
	 * @throws SystemException if a system exception occurred
	 */
	@Override
	public int countAll() throws SystemException {
		Long count = (Long)FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
				FINDER_ARGS_EMPTY, this);

		if (count == null) {
			Session session = null;

			try {
				session = openSession();

				Query q = session.createQuery(_SQL_COUNT_BGMEM);

				count = (Long)q.uniqueResult();

				FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
					FINDER_ARGS_EMPTY, count);
			}
			catch (Exception e) {
				FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
					FINDER_ARGS_EMPTY);

				throw processException(e);
			}
			finally {
				closeSession(session);
			}
		}

		return count.intValue();
	}

	/**
	 * Initializes the bg mem persistence.
	 */
	public void afterPropertiesSet() {
		String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
					com.liferay.util.service.ServiceProps.get(
						"value.object.listener.gov.va.caret.model.BgMem")));

		if (listenerClassNames.length > 0) {
			try {
				List<ModelListener<BgMem>> listenersList = new ArrayList<ModelListener<BgMem>>();

				for (String listenerClassName : listenerClassNames) {
					listenersList.add((ModelListener<BgMem>)InstanceFactory.newInstance(
							getClassLoader(), listenerClassName));
				}

				listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
			}
			catch (Exception e) {
				_log.error(e);
			}
		}
	}

	public void destroy() {
		EntityCacheUtil.removeCache(BgMemImpl.class.getName());
		FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
		FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
		FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
	}

	private static final String _SQL_SELECT_BGMEM = "SELECT bgMem FROM BgMem bgMem";
	private static final String _SQL_SELECT_BGMEM_WHERE = "SELECT bgMem FROM BgMem bgMem WHERE ";
	private static final String _SQL_COUNT_BGMEM = "SELECT COUNT(bgMem) FROM BgMem bgMem";
	private static final String _SQL_COUNT_BGMEM_WHERE = "SELECT COUNT(bgMem) FROM BgMem bgMem WHERE ";
	private static final String _ORDER_BY_ENTITY_ALIAS = "bgMem.";
	private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No BgMem exists with the primary key ";
	private static final String _NO_SUCH_ENTITY_WITH_KEY = "No BgMem exists with the key {";
	private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
				PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
	private static Log _log = LogFactoryUtil.getLog(BgMemPersistenceImpl.class);
	private static BgMem _nullBgMem = new BgMemImpl() {
			@Override
			public Object clone() {
				return this;
			}

			@Override
			public CacheModel<BgMem> toCacheModel() {
				return _nullBgMemCacheModel;
			}
		};

	private static CacheModel<BgMem> _nullBgMemCacheModel = new CacheModel<BgMem>() {
			@Override
			public BgMem toEntityModel() {
				return _nullBgMem;
			}
		};
}