/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.User;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.NoSuchPersnException;
import gov.va.caret.model.Persn;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.base.PersnLocalServiceBaseImpl;
import gov.va.caret.util.CaretStrPool;

/**
 * The implementation of the persn local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.PersnLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.PersnLocalServiceBaseImpl
 * @see gov.va.caret.service.PersnLocalServiceUtil
 */
public class PersnLocalServiceImpl extends PersnLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.PersnLocalServiceUtil} to access the persn local service.
	 */
	
	public Persn getByUser ( long userId ) throws ApplicationWorkFlowException {
		try {
			return persnPersistence.findByUser(userId);
		} catch (NoSuchPersnException e) {
			return null;
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException (e);
		}
		
	}
	
	public Persn getByExternalId ( String externalId ) throws ApplicationWorkFlowException {
		try {
			return persnPersistence.findByExternalId ( externalId );
		} catch (NoSuchPersnException e) {
			return null;
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException (e);
		}
		
	}
	
	public Persn addPersn ( User user, boolean overWrite ) throws ApplicationWorkFlowException {
		
		Persn persn = PersnLocalServiceUtil.getByUser( user.getPrimaryKey() );
		if ( persn == null ){
			persn = new PersnImpl();
			persn.setUserId(0);
			persn.setPersnUserId( user.getPrimaryKey() );
		}
		if ( persn.getPersnId() == 0 || overWrite ){
			persn.setFirstName( user.getFirstName() );
			persn.setLastName( user.getLastName() );
			persn.setMiddleName( user.getMiddleName() );
			persn.setEmail( user.getEmailAddress() );
			
			try {
				String[] types = PortletProps.get(CaretStrPool.PERSN_GENDER_TYPES).split(StringPool.COMMA);
				boolean male = user.getMale();
				boolean female = user.getFemale();
				for ( String type: types ){
					if ( type.equals("male") && male && !female ){
						persn.setGender(type);
						break;
					}
					if ( type.equals("female") && female && !male ){
						persn.setGender(type);
						break;
					}
				}
			} catch (Exception e1) {}
			try {
				persn.setBirthDate( user.getBirthday() );
			} catch (Exception e1) {}
			CaretLocalServiceUtil.save(persn);
		}
		return persn;
	}
}