/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Docum;
import gov.va.caret.service.base.DocumLocalServiceBaseImpl;

import java.util.List;

/**
 * The implementation of the docum local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.DocumLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.DocumLocalServiceBaseImpl
 * @see gov.va.caret.service.DocumLocalServiceUtil
 */
public class DocumLocalServiceImpl extends DocumLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.DocumLocalServiceUtil} to access the docum local service.
	 */
	
	public List<Docum> getByClass ( long primaryKey, long classId, String type ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.findByType(primaryKey, classId, type);
		} catch (SystemException e) {
			e.printStackTrace();
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<Docum> getByPrimaryKey ( long primaryKey ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.findByClassPk( primaryKey );
		} catch (SystemException e) {
			e.printStackTrace();
			throw new ApplicationWorkFlowException(e);
		}
	}

	public List<Docum> getByClassId ( long primaryKey ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.findByClassId( primaryKey );
		} catch (SystemException e) {
			e.printStackTrace();
			throw new ApplicationWorkFlowException(e);
		}
	}
}