/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.NoSuchBgAsnException;
import gov.va.caret.NoSuchFacilException;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.CalEt;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Facil;
import gov.va.caret.model.Note;
import gov.va.caret.model.Persn;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.support.Person;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.base.CaretLocalServiceBaseImpl;
import gov.va.caret.service.persistence.CaretFinderUtil;
import gov.va.caret.service.persistence.VcgAnPersistence;
import gov.va.caret.util.CaretStrPool;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * The implementation of the caret local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.CaretLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author 
 * @see gov.va.caret.service.base.CaretLocalServiceBaseImpl
 * @see gov.va.caret.service.CaretLocalServiceUtil
 */
public class CaretLocalServiceImpl extends CaretLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.CaretLocalServiceUtil} to access the caret local service.
	 */
		
	public int getReportCount ( String name, Object entries ) throws ApplicationWorkFlowException{
		return CaretFinderUtil.getReportCount(name, entries);
	}
	
	public List<Map<String,Object>> getReport ( String name, Object entries ) throws ApplicationWorkFlowException{
		return CaretFinderUtil.getReport( name, entries, QueryUtil.ALL_POS, QueryUtil.ALL_POS);
	}
	
	public List<Map<String,Object>> getReport ( String name, Object entries, int start, int end ) throws ApplicationWorkFlowException {
		return CaretFinderUtil.getReport( name, entries, start, end );
	}
	
	public List<Map<String,Object>> getReport ( String name, Object entries, String column, boolean desc, int start, int end ) throws ApplicationWorkFlowException {
		return CaretFinderUtil.getReport( name, entries, column, desc, start, end );
	}

	public BaseModel<?> save( BaseModel<?> model ) throws ApplicationWorkFlowException {
		return getAudLgLocalService().save( model );
	}
	
	public Note addNote ( Note note ) throws ApplicationWorkFlowException {
		try {
			if ( note.getValue() == null || note.getValue().isEmpty() ){
				ApplicationWorkFlowException.handleException("Empty Note ignored " + note.getCreationDate() );
				return note;
			} else {
				return getNoteLocalService().addNote(note);
			}
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public Facil getFacilityByNumber ( String facilityNumber ) throws ApplicationWorkFlowException {
		try {
			return getFacilPersistence().findByFacilityNumber(facilityNumber);
		} catch (NoSuchFacilException e) {
			return null;
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException( e );
		}
	}
	
	public List<CalEt> getCallEvents( long callId ) throws ApplicationWorkFlowException {
		try {
			return getCalEtPersistence().findByCallId( callId );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException( e );
		}
	}
	
	public List<Assmt> getAssessments( long vcgId ) throws ApplicationWorkFlowException {
		try {
			return assmtPersistence.findByVcgId( vcgId );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException( e );
		}
	}
	
	public AudLg getAudLg ( long classId, long classPk, String attribute ) throws ApplicationWorkFlowException {
		try {
			return audLgPersistence.fetchByAttribute(classId, classPk, attribute);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException( e );
		}
	}
	
	public List<Docum> getByClass ( long primaryKey, long classId, String type ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.findByType(primaryKey, classId, type);
		} catch (SystemException e) {
			e.printStackTrace();
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<Docum> getByPrimaryKey ( long primaryKey ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.findByClassPk( primaryKey );
		} catch (SystemException e) {
			e.printStackTrace();
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public Persn getPerson ( long persnId ) throws ApplicationWorkFlowException {
		Persn person = null;
		try {
			person = PersnLocalServiceUtil.getPersn( persnId );
		} catch (PortalException e) {
		} catch (SystemException e) {
		}
		if ( person == null ){
			ApplicationWorkFlowException.handleException("No Person exists with id " + persnId );
			return Person.DEFAULT_PERSON;
		}
		return new Person ( person );
	}
	
	
	public VcgAn getPrimaryApp ( long veteranId ) throws ApplicationWorkFlowException {
		try {
			
			List<VcgAn> list = vcgAnPersistence.findByPrimaryApp(0, veteranId);
			if ( !list.isEmpty() ){
				return list.get(0);
			}
		} catch (SystemException e) {
		}
		return null;
	}
	//=========
	
	public List<BoxGp> getBoxGroups ( String name ) throws ApplicationWorkFlowException{
		try {
			return boxGpPersistence.findByBoxGroup( name );
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return Collections.emptyList();
	}
	
	public List<BoxGp> getBoxGroups ( String boxGroup, String boxSubGroup ) throws ApplicationWorkFlowException{
		try {
			return boxGpPersistence.findByBoxSubGroup(boxGroup, boxSubGroup);
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return Collections.emptyList();
	}
	
	public List<BgAsn> getBoxGroupAssociations ( long ownerId ) throws ApplicationWorkFlowException{
		try {
			return bgAsnPersistence.findByBoxGroupAssociations(ownerId);
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return Collections.emptyList();
	}
	
	public List<BgAsn> getBoxGroupAssociations ( long ownerId, boolean enabled ) throws ApplicationWorkFlowException{
		try {
			return bgAsnPersistence.findBySelectedBoxGroupAssociations(ownerId, enabled);
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return Collections.emptyList();
	}
	
	public BgAsn getBoxGroupAssociation ( long ownerId, long boxGpId ) throws ApplicationWorkFlowException{
		try {
			return bgAsnPersistence.findByBgAsnInst(ownerId, boxGpId);
		} catch (NoSuchBgAsnException e) {
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return null;
	}
	
}