/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.kernel.exception.SystemException;

import java.util.List;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BlsRe;
import gov.va.caret.service.base.BlsReLocalServiceBaseImpl;

/**
 * The implementation of the bls re local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.BlsReLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.BlsReLocalServiceBaseImpl
 * @see gov.va.caret.service.BlsReLocalServiceUtil
 */
public class BlsReLocalServiceImpl extends BlsReLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.BlsReLocalServiceUtil} to access the bls re local service.
	 */
	public List<BlsRe> findBlsByZip( String zip ) throws ApplicationWorkFlowException {
		try {
			return blsRePersistence.findByZip(zip);
		} catch (SystemException e) {
			e.printStackTrace();
			throw new ApplicationWorkFlowException(e);
		}
	}
}