/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.NoSuchClassNameException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelWrapper;
import com.liferay.portal.model.PersistedModel;
import com.liferay.portal.service.InvokableLocalService;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.persistence.BasePersistence;
import com.liferay.portal.service.persistence.ClassNameUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.impl.AudLgImpl;
import gov.va.caret.model.support.AuditLogSupport;
import gov.va.caret.service.base.AudLgLocalServiceBaseImpl;
import gov.va.caret.util.CaretStrPool;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

/**
 * Care-T implementation of the Audit-log local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.AudLgLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author Payam Shabaneh
 * @see gov.va.caret.service.base.AudLgLocalServiceBaseImpl
 * @see gov.va.caret.service.AudLgLocalServiceUtil
 */
public class AudLgLocalServiceImpl extends AudLgLocalServiceBaseImpl {
	
	private static final String GET = "get";
	private static final String ADD = "add";

	private static final String LOCAL_SERVICE = "LocalService";
	private static final String PERSISTENCE = "Persistence";
	
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.AudLgLocalServiceUtil} to access the aud lg local service.
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public BaseModel<?> save( BaseModel<?> model ) throws ApplicationWorkFlowException {
		
		try { 
			ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
			if ( sc == null ){
				sc = new ServiceContext();
			}

			long modelPk = (Long)model.getPrimaryKeyObj();
			boolean isNew = modelPk == 0;
			
			Object userIdObj = sc.getAttribute( CaretStrPool.USER_ID );
			long userId = userIdObj == null? sc.getUserId(): (Long) userIdObj;
			
			Object coverUserIdObj = sc.getAttribute( CaretStrPool.REAL_USER_ID );
			long coverUserId = coverUserIdObj == null? userId : (Long)coverUserIdObj;
			
			String roleName = String.valueOf( sc.getAttribute( CaretStrPool.DASHBOARD_ROLE_NAME ) );
			long classId = ClassNameUtil.findByValue( model.getModelClass().getName() ).getPrimaryKey();
			String modelClassSimpleName = model.getModelClass().getSimpleName();
			
			BasePersistence basePers = (BasePersistence) getClass().getMethod( GET + modelClassSimpleName + PERSISTENCE ).invoke( this );
			
			Date defaultDate = sc.getCreateDate() == null? new Date(): sc.getCreateDate();
			long groupId = 0;
			Map<String,Object> newModelAttributes = model.getModelAttributes();
			if ( isNew ){
				if ( newModelAttributes.containsKey(CaretStrPool.CREATE_DATE) ){
					model.setModelAttributes( Collections.singletonMap( CaretStrPool.CREATE_DATE, (Object) defaultDate ) );
				}
				
				try {
					( (InvokableLocalService) getClass().
							getMethod( GET +  modelClassSimpleName + LOCAL_SERVICE ).
							invoke( this ) ).
							invokeMethod( ADD + modelClassSimpleName, new String[]{ model.getModelClass().getName() }, new Object[]{ model } );
					if ( _log.isInfoEnabled() ){
						_log.info("Added " + model.getModelClassName() + model.getPrimaryKeyObj() );
					}
				} catch (Throwable e) {
					throw new ApplicationWorkFlowException(e);
				}
				
			} else {
				BaseModel oldModel;

				if ( model instanceof ModelWrapper ){
					oldModel = AuditLogSupport.getWrappedModel( basePers.fetchByPrimaryKey( modelPk ) );
				} else {
					oldModel = basePers.fetchByPrimaryKey( modelPk );
				}
				Map<String,Object> oldModelAttributes = oldModel.getModelAttributes();
				
				if ( oldModelAttributes.containsKey(CaretStrPool.GROUP_ID ) ){
					groupId = (Long) oldModelAttributes.get(CaretStrPool.GROUP_ID );
				}
								
				for ( String attribute : newModelAttributes.keySet() ){
					
					Object prevValue = oldModelAttributes.get(attribute);
					Object newValue = newModelAttributes.get(attribute);
					
					if ( ( prevValue == null && newValue != null ) || ( prevValue!=null && !prevValue.equals( newValue ) ) ){						
						createAuditLg( classId, modelPk, attribute, sc.getUserId(), coverUserId, defaultDate,
								prevValue, newValue, groupId, roleName );
					}
				}
				try {
					basePers.update( model );
					if ( _log.isInfoEnabled() ){
						_log.info("updated " + model.getModelClassName() + model.getPrimaryKeyObj() );
					}
				} catch (Throwable e) {
					throw new ApplicationWorkFlowException(e);
				}
			}
			(( PersistedModel ) model).persist();
			
			if ( isNew ){
				if ( newModelAttributes.containsKey(CaretStrPool.GROUP_ID )){
					groupId = (Long) newModelAttributes.get(CaretStrPool.GROUP_ID );
				}
				createAuditLg( classId, (Long) model.getPrimaryKeyObj(), modelClassSimpleName, sc.getUserId(), coverUserId, defaultDate,
						CaretStrPool.EMPTY_ASSET, CaretStrPool.CREATE_ASSET, groupId, roleName );
			}
			return model; 

		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (NoSuchMethodException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (SecurityException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (IllegalAccessException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (IllegalArgumentException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (InvocationTargetException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (NoSuchClassNameException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	
	private void createAuditLg( long classId, long modelPk, String attribute, long savedById,
										long coverUserId, Date modifiedDate, Object prevValueObj, Object newValueObj,
															long groupId, String roleName ) throws SystemException{
		AudLg audit = new AudLgImpl();
		
		audit.setClassId( classId );
		audit.setClassPk( modelPk );
		audit.setAttribute( attribute );
		audit.setModifiedById( savedById );
		audit.setCoverUserId ( coverUserId );
		audit.setModifiedDate( modifiedDate );
		audit.setSysDateTime( modifiedDate.getTime() );
		audit.setOldValue( String.valueOf(prevValueObj) );
		audit.setNewValue( String.valueOf(newValueObj) );
		audit.setGroupId ( groupId );
		audit.setRoleName ( roleName );
		audit = audLgPersistence.update( audit );
	}
	
	public java.lang.Object invokeMethod ( String methodName, String[] parameterTypes, Object[] parameters ) throws ApplicationWorkFlowException {
		throw new ApplicationWorkFlowException("Unsupported Operation");
	}
	
	private static Log _log = LogFactoryUtil.getLog( AudLgLocalServiceImpl.class );
}