package gov.va.caret.service.ctssh;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map.Entry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.util.Properties;
import java.util.Set;

public class CTSSHResponse {
	
	
	public int HTTP_RESP_CODE = 0;
	public int HTTP_CONTENT_LENGTH = 0;	
	public String HTTP_CONTENT_TYPE = "";
	public String HTTP_RESPONSE_MESSAGE = "";
	protected String run_key;
	protected Date run_date_time;	
	protected String soap_request;
	protected String http_response_body;
	protected String raw_template;	
	protected StringBuilder sbLog;
	protected HashMap<String,Long>bench_marks;
	protected Properties response_properties;
	protected ArrayList<String> column_names;
	protected ArrayList<HashMap<String,Object>> result_set;
	protected DocumentBuilderFactory doc_builder_factory;
	protected DocumentBuilder doc_builder; 	
	public ArrayList<CTSSHResponse> responseChain;
	private int row_idx = -1;
	private int row_count = -1;
	private Exception execution_exception;
	public boolean isResponseChain = false;
	
	
	
	protected Exception getException() {
		return execution_exception;
	}
	
	protected void setException(Exception ex) {
		execution_exception = ex;
	}
	
	protected CTSSHResponse(String run_key) throws ParserConfigurationException
	{
		this.run_key = run_key;
		this.sbLog = new StringBuilder();
		this.bench_marks = new HashMap<String,Long>();
		this.response_properties = new Properties();
		this.column_names = new ArrayList<String>();
		this.result_set = new ArrayList<HashMap<String,Object>>();
		this.doc_builder_factory = DocumentBuilderFactory.newInstance();
		this.doc_builder = this.doc_builder_factory.newDocumentBuilder();  	
		this.run_date_time = new Date();
		
	}
	
	
	public String getLog()
	{
		return sbLog.toString();
	}
	
	protected void log(String message)
	{
	    	sbLog.append(System.currentTimeMillis());
			sbLog.append(" :");
			sbLog.append(this.run_key);
			sbLog.append(":\t");
			sbLog.append(message);
			sbLog.append("\n");
	
	}

	protected void log(Exception e)
	{
		 Writer sw = new StringWriter();
		 PrintWriter pw = new PrintWriter(sw);
		 //e.printStackTrace(pw);
		sbLog.append(System.currentTimeMillis());
		sbLog.append(" :");
		sbLog.append(this.run_key);
		sbLog.append(":\t");
		sbLog.append(e.toString());
		sbLog.append("\n");
	}

	
	public String getResponseData()
	{
		return CTSSHUtil.getPrettyPrintXML(http_response_body);
	}

	public String getRequestData()
	{
		return CTSSHUtil.getPrettyPrintXML(soap_request);
	}
	public String getTemplateData()
	{
		return raw_template;
	}
	
	
	
	
	public void listColumns() {
		
		for(String s: this.column_names)
		{
			System.out.println(s);
		}
		
	}
 
	public int getRowCount()
	{
		return row_count;
	}
	
	protected void set()
	{
		row_count = result_set.size();
	}
	
	public void setStartTime(String key)
	{
		long start = System.currentTimeMillis();//do this before using the map to account for latency
		bench_marks.put(key + ".START", start);
	}

	public void setEndTime(String key)
	{
		long stop = System.currentTimeMillis();//do this before using the map to account for latency
		bench_marks.put(key + ".END", stop);
		long start = bench_marks.get(key + ".START");
		bench_marks.put(key + ".ELAPSED", stop - start);
		
	}
	
	@SuppressWarnings("unchecked")
	public String getRecordReport()
	{

		StringBuilder sb = new StringBuilder();
		
		StringBuilder column_row = new StringBuilder();
		StringBuilder delim_row = new StringBuilder();
		StringBuilder data_row = new StringBuilder();
		
		
		
		try{		
				
			for(String cn: this.column_names)
			{
				if(cn.endsWith("_COUNT") == false)
				{				
					try{
						String value = getString(cn);
						int column_size = 0;
						if(value == null)
							column_size =  cn.length();
						else
						if(value.length() > cn.length())
							column_size = value.length();
						else
							column_size =  cn.length();
						
						column_row.append(CTSSHUtil.make_string_size(cn,column_size ) + "  ");
						delim_row.append(CTSSHUtil.make_string("-",column_size) + "  ");
						data_row.append(CTSSHUtil.make_string_size(value,column_size) + "  ");
						
					}catch(Exception erw)
					{
					
						String count = getString(cn + "_COUNT");
						String value = "entity[" + count  + "]";
						int column_size = 0;
						if(value.length() > cn.length())
							column_size = value.length();
						else
							column_size =  cn.length();
						
						column_row.append(CTSSHUtil.make_string_size(cn,column_size ) + "  ");
						delim_row.append(CTSSHUtil.make_string("-",column_size) + "  ");
						data_row.append(CTSSHUtil.make_string_size(value,column_size) + "  ");
						
						
						
					}
				}
			}				
			
			sb.append(column_row.toString() + "\n");
			sb.append(delim_row.toString() + "\n");
			sb.append(data_row.toString() + "\n");
			
		
			
			
			for(String cn: this.column_names)
			{
				if(cn.endsWith("_COUNT") == false)
				{				
					try{
						String value = getString(cn);//this will trigger an error
					}catch(Exception erw)
					{
						//this is an entity
						//now do the entities
						int count = Integer.parseInt(getString(cn + "_COUNT"));
						sb.append("\n");
						sb.append("\t..........................................................................................................\n");
						sb.append("\tENTITY : " + cn + "\n");
						sb.append("\tCOUNT  : " + count + "\n");						
						
						column_row = new StringBuilder();
						delim_row = new StringBuilder();
						data_row = new StringBuilder();			
						
						int[] column_sizes = new int[20];
						HashMap<String,Object> column_data = (HashMap<String, Object>) get(cn);

						if(column_data.size() == 0)
						{
							sb.append("\t*** NO DATA ***\n");
						}else
						{
							int key_size = 0;
							String lkch = "[LIST_KEY]";
							ArrayList<String> columnnames = new ArrayList<String>(); 
							//now time for my OCD.  Measure the columns
							for(Entry<String, Object> rows: column_data.entrySet())
							{
								String key = rows.getKey();
								key_size = key.length();
								if(key_size < lkch.length())
									key_size = lkch.length();
								
							
								HashMap<String,String> row = (HashMap<String, String>) rows.getValue();
								int ccount = 0;
								for(Entry<String,String> column: row.entrySet())
								{
									if(columnnames.contains(column.getKey()) == false)
										columnnames.add(column.getKey());
									
									
									if(column.getKey().length() > column_sizes[ccount])
										column_sizes[ccount] = column.getKey().length();
									
									if(column.getValue().length() > column_sizes[ccount])
										column_sizes[ccount] = column.getValue().length();
									
									ccount++;
										
								}
								ccount = 0;
							}
							column_row.append("\t");
							delim_row.append("\t");
							data_row.append("\t");

							//build out the header and the delim
							column_row.append(CTSSHUtil.make_string_size(lkch,key_size) + "  ");
							delim_row.append(CTSSHUtil.make_string("-",key_size) + "  ");
							
							int ccount = 0;
							for(String cnames: columnnames)
							{
								column_row.append(CTSSHUtil.make_string_size(cnames,column_sizes[ccount]) + "  ");
								delim_row.append(CTSSHUtil.make_string("-",column_sizes[ccount]) + "  ");
								ccount++;
							}
							ccount = 0;
							
							for(Entry<String, Object> rows: column_data.entrySet())
							{
								
								data_row.append(CTSSHUtil.make_string_size(rows.getKey(),key_size) + "  ");
								HashMap<String,String> row = (HashMap<String, String>) rows.getValue();
								ccount = 0;
								for(String cnames: columnnames)
								{
									data_row.append(CTSSHUtil.make_string_size(row.get(cnames),column_sizes[ccount]) + "  ");
									ccount++;	
								}								
								ccount = 0;
								data_row.append("\n\t");
								
							}
							
							sb.append(column_row.toString() + "\n");
							sb.append(delim_row.toString() + "\n");
							sb.append(data_row.toString() + "\n");
													
						}
						sb.append("\t..........................................................................................................\n");
						
					}
				}
			}				
			
			
			
			
			
			
		}catch(Exception wer)
		{
			//wer.printStackTrace();
		}
		
		return sb.toString();
		
	
		
		
	}
	
	public String getRunReport()
	{
		int string_size = 35;
		
		StringBuilder sb = new StringBuilder();
		sb.append("\n");
		sb.append("================================================================\n");
		sb.append("CARE-T SOAP SERVICE HANDLER RUN REPORT\n");
		sb.append("RUN ID   : " + this.run_key + "\n");
		sb.append("RUN TIME : " + run_date_time.toString() + "\n");
		sb.append("================================================================\n");
		sb.append("RUN STATISTICS\n");
		sb.append("------------------------------------------------------\n");
		
		for(Entry<String, Long> s :bench_marks.entrySet())
		{
			if(s.getKey().endsWith(".ELAPSED"))
			{
				sb.append(CTSSHUtil.make_string_size(s.getKey(),string_size) + " : " + CTSSHUtil.make_string_size(s.getValue(),4) + " ms\n");
			}
		}
						
		
		sb.append("\n");
		sb.append("HTTP RESPONSE ATTRIBUTES AND CODES\n");
		sb.append("------------------------------------------------------\n");
		sb.append(CTSSHUtil.make_string_size("HTTP_RESP_CODE",string_size) + " : " + HTTP_RESP_CODE + "\n");
		sb.append(CTSSHUtil.make_string_size("HTTP_CONTENT_LENGTH",string_size) + " : " + HTTP_CONTENT_LENGTH + "\n");
		sb.append(CTSSHUtil.make_string_size("HTTP_CONTENT_TYPE",string_size) + " : " + HTTP_CONTENT_TYPE + "\n");
		sb.append(CTSSHUtil.make_string_size("HTTP_RESPONSE_MESSAGE",string_size) + " : " + HTTP_RESPONSE_MESSAGE + "\n");
		
		
		sb.append("\n");
		sb.append("NON RECORD ATTRIBUTES RETURNED FROM INTERFACE\n");
		sb.append("------------------------------------------------------\n");
		if(response_properties == null || response_properties.size() == 0)
			sb.append("-->  NO NON RECORD RESPONSE PROPERTIES RETURNED <--\n");
		else
		{
			 Set<Object> keys = this.response_properties.keySet();
   	         for(Object k:keys){
		          String key = (String)k;
		          sb.append(CTSSHUtil.make_string_size(key,string_size) + " : " + response_properties.getProperty(key) + "\n");
	        }
		}
		
		sb.append("\n");
		sb.append("COLUMNS PROCESSED FROM RESULTS\n");
		sb.append("------------------------------------------------------\n");
		for(String cn: this.column_names)
		{
			sb.append(cn);
			sb.append("     ");
		}
		sb.append("\n");
		sb.append("\n");
		
		sb.append("RECORDS PROCESSED FROM RESULTS (" + getRowCount() + ")\n");

		return sb.toString();
		
	}
	
	public String getReport() throws CTSSHException
	{
		StringBuilder sb = new StringBuilder();
		sb.append("\n");
		sb.append(getRunReport());
		sb.append("\n");
		int counter = 0;
		try{
			while(next())
			{
				counter++;
				sb.append("=============================================================================================================\n");
				sb.append("BEGIN RECORD (" + counter + ")\n");
				sb.append("-------------------\n");
				sb.append(getRecordReport());
				sb.append("\n");
				
			}		
		}catch(Exception e)
		{
			
		}
		return sb.toString();
		
	
	
}

	
	//DATA SET METHODS
	
	@SuppressWarnings("unchecked")
	public String getString(String column, String entry_type, String entry_column) throws CTSSHException
	{
		String rval = null;
		
		if(result_set == null || result_set.size() == 0)
			throw new CTSSHException("No data.");		
		
		if(row_idx == -1)
			throw new CTSSHException("No current row");		
		
		if(!column_names.contains(column))
			throw new CTSSHException("Invalid column name : " + column);
		
		
		if(result_set.get(row_idx).containsKey(column))
		{
			
			if((result_set.get(row_idx).get(column) instanceof String) == true)
					throw new CTSSHException("Column " + column +  " cannot be converted to entry table");	
			
			
			HashMap<String,HashMap<String,Object>> htcolumn = (HashMap<String, HashMap<String,Object>>) result_set.get(row_idx).get(column);
			
			if(htcolumn != null)
			{
				if(htcolumn.containsKey(entry_type))
				{
					HashMap<String, Object>entry = htcolumn.get(entry_type) ;
					if(entry.containsKey(entry_column))
						rval = (String) entry.get(entry_column);	
				}
				
			}
			
			
			
			
			
		}		
		
		return rval;
	}
	
	public Object get(String column) throws CTSSHException
	{
		Object rval = null;
		
		if(result_set == null || result_set.size() == 0)
			throw new CTSSHException("No data.");		
		
		if(row_idx == -1)
			throw new CTSSHException("No current row");		
		
		if(!column_names.contains(column))
			throw new CTSSHException("Invalid column name : " + column);
		
		
		if(result_set.get(row_idx).containsKey(column))
		{
			rval = result_set.get(row_idx).get(column);
		}
		
		return rval;
	}
	
	public String getString(String column) throws CTSSHException
	{
		String rval = null;

		if(response_properties == null || response_properties.size() == 0)
			throw new CTSSHException("No data.");		
		
		if(response_properties.containsKey(column))
			rval =  response_properties.getProperty(column);
		else
		{
			if(result_set == null || result_set.size() == 0)
				throw new CTSSHException("No data.");		
			
			if(row_idx == -1)
				throw new CTSSHException("No current row");		
			
			if(!column_names.contains(column))
				throw new CTSSHException("Invalid column name : " + column);
			
			
			if(result_set.get(row_idx).containsKey(column))
			{
				
				if((result_set.get(row_idx).get(column) instanceof String) == false)
						throw new CTSSHException("Column " + column +  " cannot be converted to String", false);	
				
				
				rval = (String) result_set.get(row_idx).get(column);
				
				
			}
		}
			
			
		return rval;
		
	}
	
	public boolean next() throws CTSSHException 
	{
		if(result_set == null || result_set.size() == 0)
			throw new CTSSHException("No data.");		
			
		
		if((row_idx + 1) == row_count)
		{
			return false;
		}
		else
		{
			row_idx++;
			return true;
		}
	}
	
	public boolean previous() throws CTSSHException 
	{

		if(result_set == null || result_set.size() == 0)
			throw new CTSSHException("No data.");
		
		if((row_idx - 1) < 0)
		{
			return false;
		}
		else
		{
			row_idx--;
			return true;
		}

		
	}
	
	public void absolute(int row) throws CTSSHException {
	
		if(result_set == null || result_set.size() == 0)
			throw new CTSSHException("No data.");		
		
		if(row >=  row_count || row < 0)
			throw new CTSSHException("Invalid row number.");

		row_idx = row;
		
	}
	 
	public void beforeFirst() throws CTSSHException 
	{
		if(result_set == null || result_set.size() == 0)
			throw new CTSSHException("No data.");
		
		row_idx = -1;
	}
	
	public int getRow() throws CTSSHException 
	{
		
		if(result_set == null || result_set.size() == 0)
			throw new CTSSHException("No data.");
		
		return row_idx + 1;
	}

	public void absorb(CTSSHResponse _response) {

		if(responseChain == null)
			responseChain = new ArrayList<CTSSHResponse>();
		
		if(response_properties == null)
			response_properties = new Properties();
		
		
		response_properties.putAll(_response.response_properties);
		
		responseChain.add(_response);
		HTTP_RESP_CODE = _response.HTTP_RESP_CODE;
		isResponseChain  = true;
		
	}



	


	
		
	
	
}
