package gov.va.caret.service.ctssh;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.service.ServiceContext;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Persn;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.support.Person;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;

public class CTSSHFacade {

	public static final String FILE_TEMPLATE_STORE = "templates.location";
	private static final String DOT_ATTR_DOT = ".ATTR." ;
	private static Log _log = LogFactoryUtil.getLog(CTSSHFacade.class);
	
	private static CTSSHFacade instance = null; 
	
	public static CTSSHFacade getInstance(){
		if ( instance == null ){
			instance = new CTSSHFacade();
		}
		return instance;
	}
	
	public static void init( String localpath ) {
		
		boolean local = true;
		try {
			String tempLocation = PortletProps.get( FILE_TEMPLATE_STORE );
			_log.info("Defined property, templates.location =" + tempLocation);
			if ( tempLocation != null && !tempLocation.isEmpty() && FileUtil.exists( tempLocation ) ){
				if ( new File( tempLocation ).canRead() ){
					CTSSHandler.init( tempLocation + File.separatorChar );
					local = false;
				} else {
					_log.error("cannot read folder " + tempLocation );
				}
			} else {
				_log.info("using default template");
			}
			if ( local ){
				_log.info("using local, localpath=" + localpath );
				CTSSHandler.init( localpath + File.separatorChar );
			}
			
		} catch (CTSSHException e) {
			e.printStackTrace();
		}
		
	}
	
	public List<Person> searchAttended (Map<String,String> map, PortletRequest request){
		List<Person> attended = searchMvi ( map, CTSSHConstants.MVI_1305_ATTENDED_SEARCH );
		List<Person> merged = new ArrayList<Person>();
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		for ( Person person: attended ){
			//CTSSHConstants.FLD_EE_KEY
			try {
				_log.info("returned externalId=" + person.getExternalId() );
				if ( person.getExternalId() != null && ! person.getExternalId().isEmpty() ){
					Persn p = PersnLocalServiceUtil.getByExternalId( person.getExternalId() );
					if ( p == null ){
						CaretLocalServiceUtil.save(person);
						merged.add(person);
						_log.info("created new Person with " + person.getExternalId() );
					} else {
						_log.info("found local copy of Person " + p);
					}
				} else {
					_log.error("External Id missing..." + person);
				}
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
		return merged;
	}
	
	public Person searchUnattended (Map<String,String> map){
		List<Person> persns = searchMvi ( map, CTSSHConstants.MVI_1305_UNATTENDED_SEARCH );
		if ( persns == null || persns.isEmpty() ){
			return Person.DEFAULT_PERSON;
		}
		return persns.get(0);
	}
	
	public List<Person> searchMvi (Map<String,String> map, String requestType ) {
		CTSSHRequest ctsshRequest = new CTSSHRequest( requestType );
		if ( ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_FIRSTNAME, map.get(  CTSSHConstants.FLD_MVI_FIRSTNAME) ) |
				ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_LASTNAME, map.get(  CTSSHConstants.FLD_MVI_LASTNAME)) |
        	ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_MIDDLENAME, map.get(  CTSSHConstants.FLD_MVI_MIDDLENAME)) |
        	ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_PREFIX, map.get(  CTSSHConstants.FLD_MVI_PREFIX)) |
			ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_SUFFIX, map.get(  CTSSHConstants.FLD_MVI_SUFFIX)) ) {
				ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_NAMETYPE, getPortletProp( CTSSHConstants.FLD_MVI_NAMETYPE, "L" ) );
        }
		
		ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_DOB, map.get(CTSSHConstants.FLD_MVI_DOB) ); 
		ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_SSN, map.get( CTSSHConstants.FLD_MVI_SSN) );
        ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_GENDER, map.get(  CTSSHConstants.FLD_MVI_GENDER) ) ;    
        
        if ( ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_STREETADDRESS1, map.get(  CTSSHConstants.FLD_MVI_STREETADDRESS1)) |        
	        ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_STREETADDRESS2, map.get(  CTSSHConstants.FLD_MVI_STREETADDRESS2)) |        
	        ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_STREETADDRESS3, map.get(  CTSSHConstants.FLD_MVI_STREETADDRESS3)) |        
	        ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_STREETADDRESS4, map.get(  CTSSHConstants.FLD_MVI_STREETADDRESS4)) |        
	        ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_CITY, map.get(  CTSSHConstants.FLD_MVI_CITY)) |
	        ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_POSTALCODE, map.get(  CTSSHConstants.FLD_MVI_POSTALCODE)) |  
	        ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_STATE, map.get(  CTSSHConstants.FLD_MVI_STATE)) ) {
	        	ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_ADDRESSTYPE, getPortletProp( CTSSHConstants.FLD_MVI_ADDRESSTYPE, "Personal") );        
        }
        
        ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_SENDER_OID, getPortletProp( CTSSHConstants.FLD_MVI_SENDER_OID, "2.16.840.1.113883.4.349") );
        ctsshRequest.safeSetParameter( CTSSHConstants.FLD_MVI_SENDER_ID, getPortletProp( CTSSHConstants.FLD_MVI_SENDER_ID, "bfuser008") );
                
		try {
			CTSSHResponse ctsshResponse = null;
			_log.info(ctsshRequest.getReport());
			try {
				ctsshResponse = CTSSHandler.instance().execute(ctsshRequest);
				int count = ctsshResponse.getRowCount();
				try {
					_log.info("count:" + count);
					_log.info(ctsshResponse.getReport());
				} catch (CTSSHException e) {
					e.printStackTrace();
				}
				if ( count > 0 ){
					return parseResults( ctsshResponse, requestType ) ;
				}
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			}

			
		} catch (XPathExpressionException e) {
			
			e.printStackTrace();
		} catch (IOException e) {
			
			e.printStackTrace();
		} catch (CTSSHException e1) {
			
			// e1.printStackTrace();
		}
		return Collections.emptyList();
	}
	

	public static String getPortletProp ( String property, String defaultValue ){
		String val = PortletProps.get( property );
		if ( val==null || val.isEmpty() ){
			return defaultValue;
		}
		return val;
	}
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	private static List<Person> parseResults(CTSSHResponse response, String keyType) {
		List<Person> persons = new ArrayList<Person>();
		String[] keys = PortletProps.get( "service." + keyType ).split(StringPool.COMMA);
		int ndx0 = 0;
		if ( keys.length > ndx0 )
		try {
			response.absolute(ndx0);
			do {
				Map map = new HashMap(); 
				for( String key : keys ){
					String args = PortletProps.get(keyType + StringPool.PERIOD + key);
					if ( args!=null && !args.isEmpty() ){
						String attr = PortletProps.get(keyType + DOT_ATTR_DOT + key);
						if ( attr == null || attr.isEmpty() ){
							attr = key.toLowerCase();
						}
						String[] params = args.split(StringPool.COMMA);
						switch(params.length){
						case 1:
							if ( CaretStrPool.BIRTHDATE.equals(attr) ){
								try {
									map.put(attr, Toolbox.getDateFormatOrient().parseObject( response.getString(params[0])) ) ;
								} catch (ParseException e) {
									e.printStackTrace();
								}
							} else {
								map.put(attr, response.getString(params[0]));
							}
							break;
						case 3:
							map.put(attr, response.getString(params[0], params[1], params[2]) );
						}
					}
				}

				Person prson = new Person( new PersnImpl() );
				prson.setModelAttributes(map);
				prson.setSource("MVI");
				persons.add(prson);
			       
			} while(response.next());
		} catch (CTSSHException e) {
			
			e.printStackTrace();
		}	
		return persons;
	}
	
	
}
