package gov.va.caret.service.ctssh;

import gov.va.caret.ApplicationWorkFlowException;

public class CTSSHException extends ApplicationWorkFlowException {

	private static final long serialVersionUID = -4985551809979208442L;
	
	public CTSSHException(String message)
	{
		super( message );
		CTSSHUtil.log(message);
	}

	public CTSSHException(String message, boolean log)
	{
		super( message );
		if(log)
			CTSSHUtil.log(message);
	}

	
	public CTSSHException(Exception e)
	{
		super( e );
		CTSSHUtil.log(e);
	}
	

}
