package gov.va.caret.security;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.controller.dashboard.config.OnlineDashboardConfig;
import gov.va.caret.util.CaretStrPool;

import javax.portlet.PortletRequest;

public class CAction {

	public static final String VIEW = "VIEW";
	
	//Role subtypes-----------------------
	public static final String CARET = "CareT";
	public static final String ACTION = "action.";
	public static final String CARET_ONLINE = "Caret-Online";
	

	public enum CaretCan {

		VIEW_VETERANS,
		
		CBOPC_FUNCTION,
		CBOPCFM_FUNCTION,
		CSC_FUNCTION,
		CSL_FUNCTION,
		HEC_FUNCTION,
		HRC_FUNCTION,
		TECH_FUNCTION,
		VACO_FUNCTION,
		
		IMPERSONATE_ROLE,
		IDENTITY_MATCHING,
		CSL_FAMILY_RELATIONSHIPS,
		CREATE_CSC_WAIVER,
		CREATE_VACO_WAIVER,
		TRACK_ASSESSMENT,
		STIPEND_CALCULATOR,
		VIEW_BLS_RATES,

		LOD_QA,
		CREATE_APPLICATIONS,
		ASSOCIATE_APPLICATIONS,
		DISPOSITION_APPLICATIONS,
		MANAGE_VCG,
		UPDATE_ACTIVE_VCG_ICN,
		UPDATE_ACTIVE_VCG_NAME,
		UPDATE_ACTIVE_VCG_ADDRESS,
		UPDATE_ACTIVE_VCG_INSURANCE,
		
		VIEW_VENDORS, 
		CREATE_VENDORS, 
		
		VIEW_PAYMENTS,
		CREATE_AD_HOC_PAYMENTS,
		STOP_PAYMENTS,
		UPDATE_TIER_LEVEL,
		FINANCE_PAYMENTS, //payment bucket
		
		VIEW_CALLS,
		CREATE_CALLS,
		ASSOCIATE_CALLS,
		CREATE_CALL_TYPE,
		CREATE_CESP,
		CREATE_SOC,
		
		VIEW_REFERRAL,
		CREATE_REFERRAL,
		ASSOCIATE_REFERRAL,
		
		READ_MESSAGES,
		CREATE_MESSAGES,
		REPLY_MESSAGES, UPDATE_ACTIVE_VCG_FNAME, UPDATE_ACTIVE_VCG_MNAME, UPDATE_ACTIVE_VCG_GENDER, UPDATE_ACTIVE_VCG_BDAY, UPDATE_ACTIVE_VCG_SSN; 
		
		public String toString(){
			return ACTION + this.name();
		}
	}
	
	public enum OnlineCan {
		VETERAN_FUNCTION,
		CAREGIVER_FUNCTION,

		CREATE_APPLICATIONS,
		DOWNLOAD_APPLICATION_PDF,
		
		VIEW_STIPEND,
		UPLOAD_POA,
		
		SEARCH_MVI,
		CREATE_MESSAGES,
		REPLY_MESSAGES
	}
	
	public static boolean canDoOnline ( PortletRequest request, String canDo ) {
		boolean ret = false;
		try {
			ThemeDisplay themeDisplay = ( (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY) );
			ret = PortletPermissionUtil.contains(  themeDisplay.getPermissionChecker(), themeDisplay.getLayout(), 
					PortalUtil.getPortletId( request ), 
					canDo );
			
		} catch (PortalException e) {
		} catch (SystemException e) {
		}
//		_log.info( canDo.name() + StringPool.COLON + ret );
		return ret;
	}
	

	public static boolean canDoCaret ( PortletRequest request, String canDo ) {
		boolean ret = false;
		try {
			ret = PortletPermissionUtil.contains( 
					( (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY) ).getPermissionChecker(),
					PortalUtil.getPortletId( request ), 
					canDo );
			
		} catch (PortalException e) {
		} catch (SystemException e) {
		}
//		_log.info( canDo.name() + StringPool.COLON + ret );
		return ret;
	}
//	
//	public static Map<String, Boolean> getMap ( PortletRequest request ) {
//		Map<String, Boolean> map = new CaretMap<String, Boolean>(false);
//		for ( CAction.CaretCan canDo : CAction.CaretCan.values() ){
//			try {
//				boolean ret = PortletPermissionUtil.contains( 
//						( (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY) ).getPermissionChecker(),
//						PortalUtil.getPortletId( request ),
//						canDo.name() );
////				_log.info( canDo.name() + StringPool.COLON + ret );
//				map.put(canDo.name(), ret);
//			} catch (PortalException e) {
//			} catch (SystemException e) {
//			}
//		}
//		return map;
//	}


	public static boolean isOmniAdmin(PortletRequest request) {
		return ( (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY) ).getPermissionChecker().isOmniadmin();
	}
	
	public static boolean canImpersonate(PortletRequest request) {
		return canDoCaret(request, CaretCan.IMPERSONATE_ROLE.name() );
	}

	public static OnlineDashboardConfig loadOnlineRoleId ( PortletRequest request ){
		return setOnlineRoleContext( request, null );
	}
	
	public static OnlineDashboardConfig setOnlineRoleContext ( PortletRequest request, OnlineDashboardConfig useRole ){
		if ( useRole == null ){
			OnlineDashboardConfig onlineDashboardConfig = 
					( OnlineDashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.ONLINE_DASHBOARD_CONFIG );
			if ( onlineDashboardConfig == null ){
				for ( OnlineDashboardConfig onlineDashConfig : OnlineDashboardConfig.values() ){
					if ( canDoOnline( request, onlineDashConfig.name() ) ){
						request.getPortletSession().setAttribute( CaretStrPool.ONLINE_DASHBOARD_CONFIG, onlineDashConfig);
						return onlineDashConfig;
					}
				}
				return null;
			}
			return onlineDashboardConfig;
		} else {
			if (  canDoOnline( request, useRole.name() ) ){
				request.getPortletSession().setAttribute( CaretStrPool.ONLINE_DASHBOARD_CONFIG, useRole);
				return useRole;
			}
			return null;
		}
	}
	
}
