package gov.va.caret.portlet.resource;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.CaretBaseViewController;
import gov.va.caret.controller.OnlineViewController;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Facil;
import gov.va.caret.model.Persn;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.model.support.Person;
import gov.va.caret.pdf.PopulatePDFImpl;
import gov.va.caret.pdf.VaForm1010cgFields;
import gov.va.caret.service.BgAsnLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

import org.apache.pdfbox.pdmodel.PDDocument;

public class OnlineResourceCommand extends ResourceCommand {
	
	public String load1010cg ( ResourceRequest request, ResourceResponse response ){
		OnlineViewController.get().loadApplication( request );
		return "edit1010cg";
	}
	
	public String getCities ( ResourceRequest request, ResourceResponse response ){
		 _log.info("inside getCities... ");
		return super.getCities(request, response);
	}
	
	public void getUSPSZips ( ResourceRequest request, ResourceResponse response ){
		super.getUSPSZips(request, response);
	}
	public void validateUSPSAddress ( ResourceRequest request, ResourceResponse response ){
	    super.validateUSPSAddress(request, response);
	}

	
	public String getZips ( ResourceRequest request, ResourceResponse response ){
		 _log.info("inside getZips... ");
		return super.getZips(request, response);
	}
	
	public String getFacils ( ResourceRequest request, ResourceResponse response ){
		 return super.getFacils(request, response);
	}
	
	@SuppressWarnings("rawtypes")
	protected String getApplicationReview ( ResourceRequest request, ResourceResponse response ){
		
		try {
            _log.info("inside getPdf form... ");

    		boolean veteranPreview = false, primaryPreview = false;
			PDDocument pdfDoc = null;
        	try{
            	pdfDoc = initDocument( request );
    			
    			long vcgAnId = ParamUtil.getLong(request, "vcgAnId", 0);
    			BaseModel vcgApplication = vcgAnId > 0 ? VcgAnLocalServiceUtil.getVcgAn(vcgAnId) : new VcgAnImpl();
    			
    			//TODO: pass list of parameter names 
    			VcgAn vcgAn = (VcgAn) CaretParam.loadModel(request, vcgApplication, vcgApplication.getModelAttributes().keySet(), "vcgAn_");
    			
    			long persnId = CaretParam.getPersnId(request);

    			Person veteran = null;
    			Person primary = null;
    			Person secondary = null;
    			Person secondaryTwo = null;
    			boolean vaHealthEnrolled = false;
    			String preferredFacility = StringPool.BLANK;
				String lastTreatmentPlace = StringPool.BLANK;
				boolean hospital = false;
				boolean clinic = false;
				boolean mediEnrolled = false;
				String otherHealthInsurance = StringPool.BLANK;
				String primaryRelationship = StringPool.BLANK;
				String secondaryRelationship = StringPool.BLANK;
				String secondaryTwoRelationship = StringPool.BLANK;
				String personCategory = CaretStrPool.PERSON_CATEGORY_VETERAN;
				OnlineViewController controller = OnlineViewController.get();
    			if ( vcgAn.getVcgAnId() == 0 ){
    				veteranPreview = true;
    				veteran = new Person( PersnLocalServiceUtil.getPersn( CaretParam.getPersnId(request) ) );
    				veteran = (Person) CaretParam.loadModel(request, veteran, veteran.getModelAttributes().keySet(),  CaretStrPool.VETERAN_PERSN  + StringPool.UNDERLINE);
    				controller.loadPersnAddress( request, veteran, CaretStrPool.VETERAN_PERSN );
    				vaHealthEnrolled = vcgAn.getVaHealthEnrolled();
    				Organization org =  OrganizationLocalServiceUtil.getOrganization( veteran.getGroupId() );
    				Facil facil = FacilLocalServiceUtil.getByOrgId( org.getPrimaryKey() );
    				preferredFacility = org.getName() + StringPool.COMMA_AND_SPACE + facil.getLocation();
    				
    				lastTreatmentPlace = vcgAn.getLastTreatmentPlace();
    				hospital = vcgAn.isHospital();
    				clinic = vcgAn.isClinic();
//    				if ( vcgAn.getPrimaryId() > 0 ){
//    					primary = PersnLocalServiceUtil.getPersn( vcgAn.getPrimaryId() );
//    					primary.setSsn(StringPool.BLANK);
//    					primary.setBirthDate(null);
//    				}
//    				if ( vcgAn.getSecondaryId() > 0 ){
//    					secondary = PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryId() );
//    					secondary.setSsn(StringPool.BLANK);
//    					secondary.setBirthDate(null);
//    				}
//    				if ( vcgAn.getSecondaryTwoId() > 0 ){
//    					secondaryTwo = PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryTwoId() );
//    					secondaryTwo.setSsn(StringPool.BLANK);
//    					secondaryTwo.setBirthDate(null);
//    				}
    			} else if ( persnId == vcgAn.getPrimaryId() ){
    				primaryPreview = true;
//    				veteran = loadName( vcgAn.getVeteranId() );
    				personCategory = CaretStrPool.PERSON_CATEGORY_PRIMARY;
    				primary = new Person ( PersnLocalServiceUtil.getPersn( persnId ) );
    				primary = (Person) CaretParam.loadModel(request, primary, primary.getModelAttributes().keySet(), CaretStrPool.PRIMARY_PERSN  + StringPool.UNDERLINE);
    				controller.loadPersnAddress( request, primary, CaretStrPool.PRIMARY_PERSN );
    				primaryRelationship = vcgAn.getPrimaryRelationship(); 
    				mediEnrolled = vcgAn.getMediEnrolled();
					if ( !ParamUtil.getBoolean(request, CaretStrPool.OTHER_HEALTH_INSURANCE, false) ){
						primary.setOtherHealthInsurance(StringPool.BLANK);
					}
    				otherHealthInsurance = primary.getOtherHealthInsurance();
    			} else if ( persnId == vcgAn.getSecondaryId() ){
//    				veteran = loadName( vcgAn.getVeteranId() );
    				personCategory = CaretStrPool.PERSON_CATEGORY_SECONDARY;
    				secondary = new Person( PersnLocalServiceUtil.getPersn( persnId ) );
    				secondary = (Person) CaretParam.loadModel(request, secondary, secondary.getModelAttributes().keySet(),  CaretStrPool.SECONDARY_PERSN  + StringPool.UNDERLINE);
    				controller.loadPersnAddress( request, secondary, CaretStrPool.SECONDARY_PERSN );
    				secondaryRelationship = vcgAn.getSecondaryRelationship(); 
    			} else if ( persnId == vcgAn.getSecondaryTwoId() ){
//    				veteran = loadName( vcgAn.getVeteranId() );
    				personCategory = CaretStrPool.PERSON_CATEGORY_SECONDARYTWO;
    				secondaryTwo = new Person( PersnLocalServiceUtil.getPersn( persnId ) );
    				secondaryTwo = (Person) CaretParam.loadModel(request, secondaryTwo, secondaryTwo.getModelAttributes().keySet(), CaretStrPool.SECONDARY_TWO_PERSN  + StringPool.UNDERLINE);
    				controller.loadPersnAddress( request, secondaryTwo, CaretStrPool.SECONDARY_TWO_PERSN );
    				secondaryTwoRelationship = vcgAn.getSecondaryTwoRelationship();
    			} 
    			
    			VaForm1010cgFields pdfFields = new VaForm1010cgFields(veteran, primary, secondary, secondaryTwo,
    					vaHealthEnrolled, preferredFacility, lastTreatmentPlace, hospital, clinic, mediEnrolled,
    					otherHealthInsurance, primaryRelationship, secondaryRelationship, secondaryTwoRelationship,
    					pdfDoc, personCategory );
    			
				if ( veteranPreview  ){
    				pdfFields.setVeteranPreview(true);
    			} else if ( primaryPreview ){
    				pdfFields.setPrimaryPreview(true);
    			} else {
    				pdfFields.setSecondaryPreview(true);
    			}
    			
    			ByteArrayOutputStream output = new ByteArrayOutputStream();
    			new PopulatePDFImpl().getPDF( request, pdfFields, output );

    			response.setContentType( "application/pdf");
    			response.setProperty("Cache-Control", "no-cache");
    			writeStream( response, output.toByteArray(), "Review_10-10CG.pdf" );
        	} catch (IOException e) {
    			e.printStackTrace();
    		} catch (URISyntaxException e) {
    			e.printStackTrace();
    		} finally {
    			if ( pdfDoc != null ){
    				pdfDoc.close();
    			}
    		}
        } catch(Exception e) {
        	e.printStackTrace();
        } 
		return StringPool.BLANK;
	}
	
//	private Persn loadName(long persnId) throws PortalException, SystemException {
//		Persn minimalVeteranInfo = new PersnImpl();
//		Persn veteran = PersnLocalServiceUtil.getPersn(persnId);
//		minimalVeteranInfo.setLastName(veteran.getLastName());
//		minimalVeteranInfo.setFirstName(veteran.getFirstName());
//		minimalVeteranInfo.setMiddleName(veteran.getMiddleName());
//		minimalVeteranInfo.setSuffix(veteran.getSuffix());
//		return minimalVeteranInfo;
//	}

	private PDDocument initDocument( ResourceRequest request ) throws URISyntaxException, MalformedURLException, IOException {
		//pass a blank pdf
    	URI uri = new URI( request.getScheme(),
	    					null,
	    					request.getServerName(),
	    					request.getServerPort(),
	    					request.getContextPath() + PopulatePDFImpl.FORM,
	    					null, null);
		
		return PDDocument.load( new URL( uri.toString() ) );
	}

	public String getDocum ( ResourceRequest request, ResourceResponse response ){
		return super.getDocum (request, response);
	}
	
	public String searchVcg ( ResourceRequest request, ResourceResponse response ){
		 String fname = ParamUtil.get(request, "fname", StringPool.BLANK);
		 String lname = getValue(request, "lname");
		 String male = getValue(request, "male");
		 String female = getValue(request, "female");
		 String address = getValue(request, "address" );
		 String birthdate = getValue(request, "birthdate" );
		 Long cg1 = ParamUtil.getLong(request, "cg1");
		 Long cg2 = ParamUtil.getLong(request, "cg2");
		 Long cg3 = ParamUtil.getLong(request, "cg3");
		 long[] selects = ParamUtil.getLongValues(request, "selects");
		 _log.info( "male="+ male + ", fname=" + fname + ", lname=" + lname+ ", address=" + address );
		 
		 DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PersnImpl.class, PortletClassLoaderUtil.getClassLoader() );
		 if ( ! fname.isEmpty() ){
			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.FIRSTNAME).like(fname) );
		 }
		 
		 if ( ! lname.isEmpty() ){
			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).like(lname) );
		 }
		 
		try {
			JSONObject vcg, json = JSONFactoryUtil.createJSONObject();
			JSONArray vcgs = JSONFactoryUtil.createJSONArray();

			boolean skipSearch = fname.isEmpty() && lname.isEmpty();
			List<Persn> list = null;
			int size = 0;
			if ( skipSearch ){
				list = Collections.emptyList();
			} else {
				dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.PERSN_USER_ID).gt( Long.valueOf(0) ) );
				if ( cg1 > 0 ){
					dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.PERSN_ID).ne( cg1 ) );
				}
				if ( cg2 > 0 ){
					dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.PERSN_ID).ne( cg2 ) );
				}
				if ( cg3 > 0 ){
					dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.PERSN_ID).ne( cg3 ) );
				}
				
				
				list = PersnLocalServiceUtil.dynamicQuery( dynamicQuery );
				int listSize = list.size();
				Set<Long> caregiverIds = (Set<Long>) request.getPortletSession().getAttribute(CaretStrPool.CAREGIVER_IDS);
				
				if ( listSize > 0 ){
					if ( caregiverIds != null && !caregiverIds.isEmpty() ){
						if ( caregiverIds.contains( list.get(0).getPrimaryKey() ) ){
							size = 0;	
						} else {
							size = listSize;
						}
					} else {
						size = listSize;
					}
				}
			}
			json.put("size", size );
			_log.info("user size vcgs.. " + size );
			
			if ( size == 0 ){
				vcg = JSONFactoryUtil.createJSONObject();
				vcg.put(CaretStrPool.PRIMARY_KEY, 0 );
				ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
				String noPersonsFound = LanguageUtil.get(themeDisplay.getLocale(), "no-caregiver-found", "No Caregiver found"  );
				vcg.put("fullName", noPersonsFound );
				vcgs.put(vcg);
			} else {
				for ( Persn p : list ){
					vcg = JSONFactoryUtil.createJSONObject();
					
					vcg.put("fullName", p.getFirstName() + " " + p.getMiddleName() + " " +  p.getLastName() );
					vcg.put(CaretStrPool.PRIMARY_KEY, p.getPrimaryKey() );
					// vcg.put("ssn", p.getSsn() );
					// vcg.put("birthDate", Toolbox.formatDate( p.getBirthDate() ) );
//					vcg.put("lastName", p.getLastName() );
//					vcg.put("firstName", p.getFirstName() );
//					vcg.put("middleName", p.getMiddleName() );
//					vcg.put("suffix", p.getSuffix() );
					vcg.put("phone", p.getPhone() );
					vcg.put("phone2", p.getPhone2() );
					vcg.put("email", p.getEmail() );
					vcg.put("address", p.getAddress() );
					vcg.put("city", p.getCity() );
					vcg.put("state", p.getState() );
					vcg.put("zip", p.getZip() );
					vcg.put("groupId", p.getGroupId() );
					vcg.put("gender", p.getGender() );
					vcgs.put(vcg);
				}
			}
			json.put("vcgs", vcgs);
			return writeJson ( response, json );
			
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return StringPool.BLANK;
	}
	
	
	
	public String saveAnswer ( ResourceRequest request, ResourceResponse response ){
		 
		 String subgroup = request.getParameter(CaretStrPool.SUBGROUP);
		 long boxGpId = ParamUtil.getLong(request, CaretStrPool.BOX_GROUP_ID);
		
		 JSONObject json = JSONFactoryUtil.createJSONObject();
		 try{
			 for ( BoxGp boxGp: BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.ONLINE_QUESTIONAIRE_YN, subgroup) ) {
				 BgAsn bgAsn = BoxGpLocalServiceUtil.getBoxGroupAssociation( CaretParam.getPersnId(request), boxGp.getBoxGpId() ) ;
				 if ( bgAsn != null ){
					 bgAsn.setSelected(boxGp.getBoxGpId() == boxGpId);
				 } else if ( boxGp.getBoxGpId() == boxGpId ){
					 bgAsn = new BgAsnImpl();
					 bgAsn.setSelected(true);
					 bgAsn.setBoxGpId(boxGpId);
					 bgAsn.setOwnerId( CaretParam.getPersnId(request) );
				 } else {
					 continue;
				 }
				 BgAsnLocalServiceUtil.updateBgAsn(bgAsn);
				 if ( CaretStrPool.ENROLLED_BG.equals( subgroup ) && boxGp.getBoxGpId() == boxGpId ){
					 request.getPortletSession().setAttribute( CaretStrPool.ENROLLED_BG, Toolbox.toBoolYesNo( boxGp.getLabel() ) );
				 }
			}
			json.put(CaretStrPool.FORM, StringPool.TRUE);
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
		 
		 
		 json.put(CaretStrPool.FORM, StringPool.TRUE);
		return writeJson ( response, json );
	}
	
	public String clearAnswer ( ResourceRequest request, ResourceResponse response ){
		JSONObject json = JSONFactoryUtil.createJSONObject();
		try {
			for ( BgAsn bgAsn: BoxGpLocalServiceUtil.getBoxGroupAssociations( CaretParam.getPersnId(request) ) ) {
				bgAsn.setSelected(false);
				BgAsnLocalServiceUtil.updateBgAsn(bgAsn);
			}
			json.put(CaretStrPool.FORM, StringPool.TRUE);
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
		if ( request.getPortletSession().getAttribute(CaretStrPool.ENROLLED_BG) != null ){
			request.getPortletSession().removeAttribute(CaretStrPool.ENROLLED_BG);
		}
		return writeJson(response, json);
	}
	
	private static Log _log = LogFactoryUtil.getLog( OnlineResourceCommand.class );

	@Override
	public String getJspDir() {
		return CaretBaseViewController.ONLINE_VIEW;
	}
	
}
