package gov.va.caret.portlet.action;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.OnlineViewController;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Docum;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.model.support.ApplicationStatus;
import gov.va.caret.model.support.BoxedGroupAssociation;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.pdf.FileType;
import gov.va.caret.pdf.PopulatePDFImpl;
import gov.va.caret.pdf.VaForm1010cgFields;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Blob;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ProcessAction;

import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;

public class OnlineActionCommand extends ActionCommand {
	

	

	@ProcessAction (name="saveApplicationVcg")
	public void saveApplicationVcg( ActionRequest request, ActionResponse actionResponse ) throws ApplicationWorkFlowException, PortalException, SystemException {
		
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
		_log.info("reached save application.....");
		if ( ! CaretParam.isTracked( request, tracker, true ) ){
			_log.warn("TRACKER BLOCKING action... ");
			request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
			return;
		}
		
		String personCategory = CaretStrPool.PERSON_CATEGORY_VETERAN;
		for ( Enumeration<String> enume = request.getParameterNames(); enume.hasMoreElements() ; ){
			String name = enume.nextElement();
			_log.info(name + ":" + ParamUtil.getString(request, name));
		}
		
		try {
			long vcgAnId = ParamUtil.getLong(request, "vcgAnId", 0); 
			long persnId = CaretParam.getPersnId(request);
			Person veteran = null;
			Person primary = null;
			Person secondary = null;
			Person secondaryTwo = null;
			boolean primaryPiiChanged = false;
			boolean primaryInsuranceChanged = false;
			
			VcgAn vcgApplication;
			StringBuilder message = new StringBuilder();
			ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
			String signed1010Form = LanguageUtil.get(themeDisplay.getLocale(), "signed-1010cg-form", " signed VA Form 10-10CG" );
			ServiceContext sc = CaretParam.setOnlineServiceContext(request);
			
			if ( vcgAnId > 0 ){  //Update to application by caregiver
				try {
					vcgApplication = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
					veteran = new Person ( PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
					if ( vcgApplication.getPrimaryId() > 0 && vcgApplication.getPrimaryId() == persnId ){
						if ( vcgApplication.getPrimarySignDate() != null ){
							throw new ApplicationWorkFlowException( "Application was signed in another session." );
						}
						vcgApplication.setMediEnrolled(ParamUtil.getBoolean(request, "vcgAn_mediEnrolled"));
						vcgApplication.setPrimaryRelationship(ParamUtil.getString(request, "vcgAn_primaryRelationship"));
						
						Person pers = new Person ( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) );
						String oldSsn = pers.getSsn();
						String oldFirst = pers.getFirstName();
						String oldLast = pers.getLastName();
						String oldInsurance = pers.getOtherHealthInsurance();
						vcgApplication.setPrimarySignDate( sc.getCreateDate() );
						
						primary = (Person) CaretParam.loadModel(request, pers, Toolbox.getCollection("lastName","firstName","middleName",
																		"birthDate","gender","ssn","phone","phone2","email", "otherHealthInsurance"), 
																			CaretStrPool.PRIMARY_PERSN  + StringPool.UNDERLINE);
						boolean otherHealthInsurance = ParamUtil.getBoolean(request, "otherHealthInsurance", false);
						if ( !otherHealthInsurance ){
							primary.setOtherHealthInsurance(StringPool.BLANK);
						}
						
						loadAddress( request, primary, CaretStrPool.PRIMARY_PERSN );
						CaretLocalServiceUtil.save( primary );
						
						primaryPiiChanged = !primary.getFirstName().equals(oldFirst) || 
											!primary.getSsn().equals(oldSsn) || 
											!primary.getLastName().equals(oldLast);
						primaryInsuranceChanged = !primary.getOtherHealthInsurance().equals(oldInsurance);	
						
						message.append(pers.getLastName()).append(StringPool.COMMA_AND_SPACE).append(pers.getFirstName());
						personCategory = CaretStrPool.PERSON_CATEGORY_PRIMARY;
			      		_log.info("person is primary");
					}
					if ( vcgApplication.getSecondaryId() > 0 && vcgApplication.getSecondaryId() == persnId ){
						if ( vcgApplication.getSecondarySignDate() != null ){
							throw new ApplicationWorkFlowException( "Application was signed in another session." );
						}
						vcgApplication.setSecondaryRelationship( request.getParameter("vcgAn_secondaryRelationship") );
						vcgApplication.setSecondarySignDate( sc.getCreateDate() );
						Person pers = new Person ( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) );
						
						secondary = (Person) CaretParam.loadModel(request, pers, Toolbox.getCollection("lastName","firstName","middleName",
								"birthDate","gender","ssn","phone","phone2","email"), CaretStrPool.SECONDARY_PERSN  + StringPool.UNDERLINE);
						
						loadAddress( request, secondary, CaretStrPool.SECONDARY_PERSN );
						CaretLocalServiceUtil.save( secondary );
						message.append(pers.getLastName()).append(StringPool.COMMA_AND_SPACE).append(pers.getFirstName());
						personCategory = CaretStrPool.PERSON_CATEGORY_SECONDARY;
			      		_log.info("person is secondary");
					}
					if ( vcgApplication.getSecondaryTwoId() > 0 && vcgApplication.getSecondaryTwoId() == persnId ){
						if ( vcgApplication.getSecondaryTwoSignDate() != null ){
							throw new ApplicationWorkFlowException( "Application was signed in another session." );
						}
						vcgApplication.setSecondaryRelationship( request.getParameter("vcgAn_secondaryTwoRelationship") );
						vcgApplication.setSecondaryTwoSignDate( sc.getCreateDate() );
						Person pers = new Person( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) );
						secondaryTwo = (Person) CaretParam.loadModel(request, pers, Toolbox.getCollection("lastName","firstName","middleName",
								"birthDate","gender","ssn","phone","phone2","email"), CaretStrPool.SECONDARY_TWO_PERSN  + StringPool.UNDERLINE);
						loadAddress( request, secondaryTwo, CaretStrPool.SECONDARY_TWO_PERSN );
						CaretLocalServiceUtil.save( secondaryTwo );
						message.append(pers.getLastName()).append(StringPool.COMMA_AND_SPACE).append(pers.getFirstName());
						personCategory = CaretStrPool.PERSON_CATEGORY_SECONDARYTWO;
			      		_log.info("person is secondarytwo");
					}
					
					message.append( signed1010Form );
					
					
				} catch (PortalException e) {
					throw new ApplicationWorkFlowException(e);
				} catch (SystemException e) {
					throw new ApplicationWorkFlowException(e);
				}
			} else {  // new Application submitted by Veteran....
				validateAppCount(request);
				VcgAn v = new VcgAnImpl();
				//TODO: tighten loadModel in case previous CG selections were made already
				vcgApplication = (VcgAn) CaretParam.loadModel(request, new VcgAnImpl(), v.getModelAttributes().keySet(), CaretStrPool.VCGAN_UNDERLINE);
				validateCaregivers(request, vcgApplication);
				veteran = (Person) CaretParam.loadModel(request, new Person(PersnLocalServiceUtil.getPersn( persnId )), Toolbox.getCollection("lastName","firstName","middleName",
						"birthDate","gender","ssn","phone","phone2","email","groupId"), CaretStrPool.VETERAN_PERSN_UNDERLINE);
				saveOnlineAnswers(request);
				loadAddress( request, veteran, CaretStrPool.VETERAN_PERSN );
				CaretLocalServiceUtil.save( veteran );
				vcgApplication.setGroupId( veteran.getGroupId() );
				vcgApplication.setStatus( ApplicationStatus.NEW.name() );
				message.append(veteran.getLastName()).append(StringPool.COMMA_AND_SPACE).append(veteran.getFirstName())
				.append(signed1010Form);
				
			}
			
			WorIm workItem = null;
			if ( vcgAnId > 0 ){
				int signCount = 0;
				if ( vcgApplication.getSecondaryTwoSignDate() != null ) signCount++;
				if ( vcgApplication.getPrimarySignDate() != null ) signCount++;
				if ( vcgApplication.getSecondarySignDate() != null ) signCount++;
				
				int idCount = 0;
				if ( vcgApplication.getPrimaryId() > 0 ) idCount++;
				if ( vcgApplication.getSecondaryId() > 0 ) idCount++;
				if ( vcgApplication.getSecondaryTwoId() > 0 ) idCount++;
				
				if ( signCount > 0 && signCount == idCount ){
					vcgApplication.setSubmitDate( sc.getCreateDate() );
					vcgApplication.setReceivedDate( sc.getCreateDate() );
					vcgApplication.setStatus( ApplicationStatus.SUBMITTED.name() );
					long caregiverId = 0;
					if ( vcgApplication.getPrimaryId() > 0 ){
						caregiverId = vcgApplication.getPrimaryId(); 
					} else if ( vcgApplication.getSecondaryId() > 0 ){
						caregiverId = vcgApplication.getSecondaryId(); 
					} else {
						caregiverId = vcgApplication.getSecondaryTwoId();
					}
					
					workItem = Toolbox.createWorkItem( sc, vcgApplication.getGroupId(), vcgApplication, WorkType.ONLINE_APP, veteran.getPersnId(), caregiverId );
				
				}
				
				boolean approvedStateChange = false;
				if ( primaryPiiChanged || primaryInsuranceChanged ) {
					approvedStateChange = 0 < CaretLocalServiceUtil.
							getReportCount( "primaryAppWork", vcgApplication.getPrimaryId() );
				}
				if ( approvedStateChange ){
					if ( primaryPiiChanged ){
						CaretLocalServiceUtil.save( Toolbox.createWorkItem( sc, 0, primary, WorkType.VENDOR_PII_UPDATE, veteran.getPersnId(), vcgApplication.getPrimaryId() ) );
					}
					if ( primaryInsuranceChanged ){
						CaretLocalServiceUtil.save( Toolbox.createWorkItem( sc, 0, primary, WorkType.VENDOR_INSURANCE_UPDATE, veteran.getPersnId(), vcgApplication.getPrimaryId() ) );
					}
				}
			}
			String workAddedToQue = LanguageUtil.get(themeDisplay.getLocale(), "online-1010-work-added-to-q", "Online 10-10CG work item added to Facility que." );
			CaretLocalServiceUtil.save( vcgApplication );
			if ( workItem != null ){
				CaretLocalServiceUtil.save( workItem );
				CaretLocalServiceUtil.addNote( Toolbox.createNote(
						sc.getCreateDate(), workItem.getWorImId(), vcgApplication.getGroupId(), sc.getUserId(), workAddedToQue) );
			}

//			update the session tracker...
			request.getPortletSession().setAttribute( CaretStrPool.APP_NDX, VcgAnLocalServiceUtil.getByPersnCount( CaretParam.getPersnId(request) ) );
			
			handleApplicationPdfDocument( request, vcgApplication, personCategory, veteran, primary, secondary, secondaryTwo );
			handleApplicationPoaDocument( request, vcgApplication );
			
			CaretLocalServiceUtil.addNote( Toolbox.createNote(
						sc.getCreateDate(), vcgApplication.getVcgAnId(), vcgApplication.getGroupId(), sc.getUserId(), message.toString() ) );
			_log.info( "finished Application creation...");
			
		} catch (IOException e1) {
			e1.printStackTrace();
		}
	}

	
	private Set<Long> validateCaregivers(ActionRequest request, VcgAn vcgApplication) throws ApplicationWorkFlowException {

		VcgAn vcgAn = (VcgAn)CaretParam.loadModel(request, new VcgAnImpl(), new HashSet<String>(Arrays.asList("primaryId","secondaryId","secondaryTwoId")), "vcgAn_");
		
		Set<Long> caregiverIds = new HashSet<Long>(); 
		
		@SuppressWarnings("unchecked")
		Set<Long> sessionStore = (Set<Long>) request.getPortletSession().getAttribute(CaretStrPool.CAREGIVER_IDS);
		if ( sessionStore != null ){
			caregiverIds.addAll(sessionStore);
		}
		
		if ( vcgApplication.getPrimaryId() == 0 && vcgAn.getPrimaryId() > 0 ){
			if ( caregiverIds.contains( vcgAn.getPrimaryId() ) ) {
				throw new ApplicationWorkFlowException( "Caregiver already assigned." );
			} else {
				caregiverIds.add( vcgAn.getPrimaryId() );
			}
		}
		
		if ( vcgApplication.getSecondaryId() == 0 && vcgAn.getSecondaryId() > 0 ){
			if ( caregiverIds.contains( vcgAn.getSecondaryId() ) ) {
				throw new ApplicationWorkFlowException( "Caregiver already assigned." );
			} else {
				caregiverIds.add( vcgAn.getSecondaryId() );
			}
		}
		
		if ( vcgApplication.getSecondaryTwoId() == 0 && vcgAn.getSecondaryTwoId() > 0 ){
			if ( caregiverIds.contains( vcgAn.getSecondaryTwoId() ) ) {
				throw new ApplicationWorkFlowException( "Caregiver already assigned." );
			} else {
				caregiverIds.add( vcgAn.getSecondaryTwoId() );
			}
		}
		return caregiverIds;
	}


	private void validateAppCount(ActionRequest request) throws ApplicationWorkFlowException {
		int appNdx = (Integer) request.getPortletSession().getAttribute( CaretStrPool.APP_NDX );
		int targetNdx = VcgAnLocalServiceUtil.getByPersnCount( CaretParam.getPersnId(request) );
		if ( targetNdx > appNdx ){
			throw new ApplicationWorkFlowException( "Application is being created in another session." ); 
		}
	}


	private void handleApplicationPdfDocument( PortletRequest request, VcgAn vcgApplication, String personCategory, Person...persons ) throws PortalException, SystemException, IOException {

		long documId = 0;
		//get existing pdf if one exists for the application.....	
		if ( personCategory != CaretStrPool.PERSON_CATEGORY_VETERAN ){
			List<Docum> vcgAnDoc = DocumLocalServiceUtil.getByClass(vcgApplication.getVcgAnId(), PortalUtil.getClassNameId(VcgAn.class), FileType.TEN_TEN_CG.name() );
			if ( !vcgAnDoc.isEmpty() ){
				documId = vcgAnDoc.get(0).getDocumId();
			}
		}

		PDDocument pdfDoc = null;			
		Docum docum = null;
		if (documId == 0) {
			try{
				//pass a blank pdf
				URI uri = new URI( request.getScheme(),
						null,
						request.getServerName(),
						request.getServerPort(),
						request.getContextPath() + PopulatePDFImpl.FORM,
						null, null);

				pdfDoc = PDDocument.load( new URL( uri.toString() ) );
			} catch (IOException e) {
				e.printStackTrace();
			} catch (URISyntaxException e) {
				e.printStackTrace();
			}
		} else {
			try{
				//pass the pdf from database
				docum = DocumLocalServiceUtil.getDocum(documId);
				if (docum != null) {
					Blob blob = docum.getDocument();
					byte[] binaryData = blob.getBytes(1, (int) blob.length());

					InputStream inputStream = new ByteArrayInputStream(binaryData);
					pdfDoc = PDDocument.load(inputStream);
				}
			}catch (Exception e) {
				e.printStackTrace();
			}
		}

		try {//Exception thrown here...due to health Insurance...
			VaForm1010cgFields vaForm1010cg = new VaForm1010cgFields(persons[0], persons[1], persons[2], persons[3],
					vcgApplication.getVaHealthEnrolled(),
					OrganizationLocalServiceUtil.getOrganization( persons[0].getGroupId() ).getName(),
					vcgApplication.getLastTreatmentPlace(), vcgApplication.getHospital(),  vcgApplication.getClinic(),
					vcgApplication.getMediEnrolled(),  
					persons[1] == null ? StringPool.BLANK : persons[1].getOtherHealthInsurance(),
					vcgApplication.getPrimaryRelationship(),  
					vcgApplication.getSecondaryRelationship(),
					vcgApplication.getSecondaryTwoRelationship(),
					pdfDoc,
					personCategory );
			new PopulatePDFImpl().generateAndPopulatePDF(request, vaForm1010cg);
		} catch (COSVisitorException e1) {
			e1.printStackTrace();
			throw new ApplicationWorkFlowException(e1);
		}
		String name = (String) request.getAttribute(CaretStrPool.TEN_TEN_FILE);

		//update if existing pdf or save if new pdf
		if ( name != null && !name.isEmpty() ){
			File uploadFile = new File( PortletProps.get(CaretStrPool.FILE_TEMP_STORE) + name );
			InputStream inputStream = new FileInputStream( uploadFile );
			OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );

			if(documId == 0) {
				_log.info("==========creating new pdf in db");

				documId = CounterLocalServiceUtil.increment( Docum.class.getName() );
				Docum tenCgDocument = DocumLocalServiceUtil.createDocum(documId);
				tenCgDocument.setDocument( outputBlob );
				tenCgDocument.setClassPk( vcgApplication.getVcgAnId() );
				tenCgDocument.setClassId( PortalUtil.getClassNameId(VcgAn.class) );
				tenCgDocument.setType( FileType.TEN_TEN_CG.name() );
				tenCgDocument.setName(name);
				try {
					DocumLocalServiceUtil.addDocum( tenCgDocument );
					FileUtil.delete(uploadFile);
				} catch (SystemException e) {
					e.printStackTrace();
				}
			}else if (docum != null) {
				_log.info("==========updating existing pdf in db");
				
				docum.setDocument( outputBlob );

				try {
					DocumLocalServiceUtil.updateDocum( docum );
					FileUtil.delete(uploadFile);
				} catch (SystemException e) {
					e.printStackTrace();
				}								
			}
		}
	}

	public void handleApplicationPoaDocument ( PortletRequest request, VcgAn vcgApplication ) throws FileNotFoundException, SystemException {
		if ( request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH) != null ){
			String path = (String) request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH);
			String name = (String) request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_NAME);
			File uploadFile = new File(path);
			InputStream inputStream = new FileInputStream( uploadFile );
			OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );
			
			long documId = CounterLocalServiceUtil.increment( Docum.class.getName() );
			Docum poaDocument = DocumLocalServiceUtil.createDocum(documId);
			poaDocument.setDocument(outputBlob);
			poaDocument.setClassPk( vcgApplication.getVcgAnId() );
			poaDocument.setClassId( PortalUtil.getClassNameId(VcgAn.class) );
			poaDocument.setType( FileType.POA.name() );
			poaDocument.setName(name);
			try {
				//DocumLocalServiceUtil.addDocum( poaDocument );
				request.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_NAME);
				FileUtil.delete(uploadFile);
			}
			catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	

	@ProcessAction (name="uploadFile")
	public void uploadFile ( ActionRequest request, ActionResponse actionResponse ) throws FileNotFoundException{
		UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest(request);
		for ( Enumeration<String> enume = PortalUtil.getUploadPortletRequest(request).getParameterNames(); enume.hasMoreElements() ; ){
			String name = enume.nextElement();
			_log.info(name + ":" + ParamUtil.getString(request, name));
		}
		
		long size = uploadRequest.getSize("file");
		_log.info("size=" + size );
		if ( size == 0 ){
			_log.info("returning since size is 0...");
			return;
		}

		File uploadFile = uploadRequest.getFile("file");
		String tempLocation = PortletProps.get(CaretStrPool.FILE_TEMP_STORE);
		String name = uploadRequest.getFileName("file");
		
		File file = new File(tempLocation + name);
		try {
			FileUtil.copyFile( uploadFile, file );
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		_log.info("path is ... " + uploadFile.getPath() + ", name=" + name );
		request.getPortletSession().setAttribute("poaFile", file.getPath() );
		request.getPortletSession().setAttribute("poaFileName", name);
	}
	
	public void loadApplication( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String context = ParamUtil.getString( actionRequest, "context", StringPool.BLANK );
		if ( "onlineQuestionaire".equals(context) ){
			saveOnlineQuestions(actionRequest, actionResponse);
		}
		
		OnlineViewController.get().loadApplication(actionRequest); 
	}
	
	public void saveOnlineQuestions( ActionRequest actionRequest, ActionResponse actionResponse ){
		try {
			
			boolean enrolled = ParamUtil.getBoolean(actionRequest, "enrolled-in-va-health" );
			actionRequest.setAttribute(CaretStrPool.VETERAN_VA_HEALTH_ENROLLED, enrolled );
			
			boolean dateDischarged = ParamUtil.getBoolean(actionRequest, "military-discharged-date" );
			boolean activeDuty = ParamUtil.getBoolean(actionRequest, "is-veteran-in-military" );
			boolean needCare = ParamUtil.getBoolean(actionRequest, "needs-assistance-basic-functions" );
			
//			long persnId = CaretParam.getPersnId(actionRequest);

			Set<Long> boxGroups = new HashSet<Long>();
			actionRequest.getPortletSession().setAttribute(CaretStrPool.ONLINE_QUESTIONAIRE_YN, boxGroups);

			
			List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.ONLINE_QUESTIONAIRE_YN, CaretStrPool.ONLINE_QUESTIONAIRE_YN);
			for ( BoxGp boxGp: groups ){
				if ( boxGp.getLabel().equals( "enrolled-in-va-health" ) ){
					if ( enrolled ){
						boxGroups.add( boxGp.getBoxGpId() );
					}
					continue;
				}
				if ( boxGp.getLabel().equals( "military-discharged-date" ) ){
					if ( dateDischarged ){
						boxGp.getBoxGpId();
					}
					continue;
				}
				if ( boxGp.getLabel().equals( "is-veteran-in-military" ) ){
					if ( activeDuty ){
						boxGp.getBoxGpId();
					}
					continue;
				}
				if ( boxGp.getLabel().equals( "needs-assistance-basic-functions" ) ){
					if ( needCare ){
						boxGp.getBoxGpId();
					}
					continue;
				}
			}				
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
	}
	
	public void saveOnlineAnswers ( ActionRequest actionRequest ) throws ApplicationWorkFlowException {
		
		@SuppressWarnings("unchecked")
		Set<Long> boxGroups = (Set<Long>) actionRequest.getPortletSession().getAttribute(CaretStrPool.ONLINE_QUESTIONAIRE_YN);
		if ( boxGroups == null ){
			return;
		}
		long persnId = CaretParam.getPersnId( actionRequest );
		for ( Long boxGpId : boxGroups ){
			BgAsn bgAsn = new BgAsnImpl();
			bgAsn.setBoxGpId( boxGpId );
			bgAsn.setOwnerId( persnId );
			bgAsn.setSelected( true );
			CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
		}
	}
	
	public void loadAddress(ActionRequest request, Person persn, String prefix) throws ApplicationWorkFlowException {
		OnlineViewController.get().loadPersnAddress( request, persn, prefix );
	}

	
	
	private static Log _log = LogFactoryUtil.getLog( OnlineActionCommand.class );
	
}
