package gov.va.caret.portlet.action;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.CountryConstants;
import com.liferay.portal.service.RegionServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.bean.AssmtBean;
import gov.va.caret.bean.AttachmentBean;
import gov.va.caret.bean.CespBean;
import gov.va.caret.bean.SocBean;
import gov.va.caret.controller.CaretViewController;
import gov.va.caret.controller.OnlineViewController;
import gov.va.caret.controller.dashboard.config.CslDashboardConfig;
import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.controller.dashboard.config.DashboardConfigFactory;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.CalEt;
import gov.va.caret.model.Call;
import gov.va.caret.model.Cesp;
import gov.va.caret.model.ClSoc;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Persn;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.Waivr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.AssmtImpl;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.model.impl.CalEtImpl;
import gov.va.caret.model.impl.CallImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.model.impl.VcgImpl;
import gov.va.caret.model.impl.WaivrImpl;
import gov.va.caret.model.support.BoxedGroupAssociation;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.model.support.WorkStatus;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.pdf.FileType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.AssmtLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CallLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.CespLocalServiceUtil;
import gov.va.caret.service.ClSocLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.ResultMap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ProcessAction;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;


public class CaretActionCommand extends ActionCommand implements Serializable {
	
private static final long serialVersionUID = 2251500780038409153L;
	


	public void createVcg( ActionRequest request, ActionResponse actionResponse ) throws ApplicationWorkFlowException {
		_log.info("createVcg... " );
		
		boolean veteranStatusPass = ParamUtil.getBoolean(request, "veteranStatus");
		boolean primaryStatusPass = false,
			secondaryStatusPass = false,
			secondaryTwoStatusPass = false;
		
		long vcgAnId = ParamUtil.getLong( request, CaretStrPool.VCGANID );
		long worImId = ParamUtil.getLong( request, CaretStrPool.WORK_ID );

		ServiceContext sc = CaretParam.setCaretServiceContext(request);

		VcgAn vcgAn = null;
		WorIm worIm = null;
		try {
			vcgAn = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
			worIm = WorImLocalServiceUtil.getWorIm(worImId);
		} catch (PortalException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
		
		
		if ( vcgAn.getPrimaryId() > 0 ){
			if ( !request.getParameter("primaryStatus").isEmpty() ){
				primaryStatusPass = ParamUtil.getBoolean(request, "primaryStatus");
			}
		} else {
			primaryStatusPass = true;
		}
		if ( vcgAn.getSecondaryId() > 0 ){
			if ( !request.getParameter("secondaryStatus").isEmpty() ){
				secondaryStatusPass = ParamUtil.getBoolean(request, "secondaryStatus");
			}
		} else {
			secondaryStatusPass = true;
		}
		if ( vcgAn.getSecondaryTwoId() > 0 ){
			if ( !request.getParameter("secondaryTwoStatus").isEmpty() ){
				secondaryTwoStatusPass = ParamUtil.getBoolean(request, "secondaryTwoStatus");
			}
		} else {
			secondaryTwoStatusPass = true;
		}
		
		worIm.setStatus(WorkStatus.COMPLETE.name());
		worIm.setCompletionBy( sc.getUserId() );
		worIm.setCompletionDate( sc.getCreateDate() );
		
		if ( veteranStatusPass && primaryStatusPass && secondaryStatusPass && secondaryTwoStatusPass ){
			Vcg vcg = VcgLocalServiceUtil.getVeteranVcg( vcgAn.getVeteranId() );
			boolean isNewVcg = false;
			List<Assmt> oldAssmts = Collections.emptyList();
			if ( vcgAnId != 0 ){
				try {
//					vcgAn.setStatus( CaretStrPool.APPROVED );
						
					isNewVcg = vcg == null;
					if ( isNewVcg ){
						vcg = new VcgImpl();
						vcg.setModelAttributes( vcgAn.getModelAttributes() );
						try {
							Persn persn = PersnLocalServiceUtil.getPersn( vcgAn.getVeteranId() );
							persn.setStatus(CaretStrPool.ACTIVE_VCG);
							CaretLocalServiceUtil.save(persn);
							vcg.setVeteranDispReason("APPROVED");
						} catch (PortalException e) {
							throw new ApplicationWorkFlowException(e);
						} catch (SystemException e) {
							throw new ApplicationWorkFlowException(e);
						}
					} else {
						oldAssmts = CaretLocalServiceUtil.getAssessments( vcg.getVcgId() );
						for ( Assmt assmt : oldAssmts ){
							CaretParam.loadModel( request, assmt, Collections.singleton("completionDate"), "assmt_" + assmt.getAssmtId() );
							_log.info("assessment is " + assmt);
						}
					}
					if ( vcgAn.getPrimaryId() > 0 ){
						vcg.setPrimaryType( vcgAn.getPrimaryRelationship() );
						vcg.setPrimaryDispositionDate( sc.getCreateDate() );
						try {
							Persn persn = PersnLocalServiceUtil.getPersn( vcgAn.getPrimaryId() );
							persn.setStatus(CaretStrPool.ACTIVE_VCG);
							CaretLocalServiceUtil.save(persn);
							vcg.setPrimaryDispReason("APPROVED");
						} catch (PortalException e) {
							throw new ApplicationWorkFlowException(e);
						} catch (SystemException e) {
							throw new ApplicationWorkFlowException(e);
						}
					}
					if ( vcgAn.getSecondaryId() > 0 ){
						vcg.setSecondaryType( vcgAn.getSecondaryRelationship() );
						vcg.setSecondaryDispositionDate( sc.getCreateDate() );
						try {
							Persn persn = PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryId() );
							persn.setStatus(CaretStrPool.ACTIVE_VCG);
							CaretLocalServiceUtil.save(persn);
							vcg.setSecondaryDispReason("APPROVED");
						} catch (PortalException e) {
							throw new ApplicationWorkFlowException(e);
						} catch (SystemException e) {
							throw new ApplicationWorkFlowException(e);
						}
					}
					if ( vcgAn.getSecondaryTwoId() > 0 ){
						vcg.setSecondaryTwoType( vcgAn.getSecondaryTwoRelationship() );
						vcg.setSecondaryTwoDispositionDate( sc.getCreateDate() );
						try {
							Persn persn = PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryTwoId() );
							persn.setStatus(CaretStrPool.ACTIVE_VCG);
							CaretLocalServiceUtil.save(persn);
							vcg.setSecondaryTwoDispReason("APPROVED");
						} catch (PortalException e) {
							throw new ApplicationWorkFlowException(e);
						} catch (SystemException e) {
							throw new ApplicationWorkFlowException(e);
						}
					}
					CaretLocalServiceUtil.save(vcg);
					
					if ( vcgAn.getVcgId( ) == 0 ){
						vcgAn.setVcgId( vcg.getVcgId() );
					}
					
					
					if ( isNewVcg ){
						worIm.setVcgId( vcg.getVcgId() );
						
					} else if ( ! oldAssmts.isEmpty() ){
						for ( Assmt assmt: oldAssmts ){
							if ( assmt.getCompletionDate() == null ){
								String prefix = "assmt" + assmt.getAssmtId() + "_";
								CaretParam.loadModel( request, assmt, assmt.getModelAttributes().keySet(), prefix );
								assmt.setUserId( sc.getUserId() );
								if ( assmt.getCompletionDate() != null ){
									if ( ! assmt.getCompletionDate().after( sc.getCreateDate() ) ){
										assmt.setCompletionDate(assmt.getCompletionDate());
									} else {
										_log.info("Assessment in future not allowed" );
									}
								}
								CaretLocalServiceUtil.save(assmt);
							}
						}
					}
					
					int newAssessments = ParamUtil.getInteger(request, "newAssessments");
					for ( int i = 1; i <= newAssessments; i++){ 
						Assmt assmt = new AssmtImpl();//vcgId
						try {//[assmt4_type, assmt1_type, ndx0, vcg_primaryId, vcg_veteranId, TRACKER, assmt1_completionDate, assmt2_type, vcg_secondaryTwoId, assmt4_scheduleDate, assmt3_completionDate, javax.portlet.action, assmt4_completionDate, assmt1_scheduleDate, assmt3_type, newAssessments, vcgAnId, action, assmt3_scheduleDate, mvcPath, vcg_secondaryId, assmt2_completionDate, assmt2_scheduleDate]
							String prefix = "assmt" + i + "_";
							CaretParam.loadModel( request, assmt, assmt.getModelAttributes().keySet(), prefix );
							assmt.setVcgId( vcg.getVcgId() );
							//[vcgId, assmtId, userId, scheduleDate, noteId, type, completionDate]
							if ( assmt.getScheduleDate() != null && assmt.getType() != null && !assmt.getType().isEmpty() ){
								assmt.setUserId( sc.getUserId() );
								if ( assmt.getCompletionDate() != null && assmt.getCompletionDate().after( sc.getCreateDate() ) ){
									assmt.setCompletionDate(null);
								}
								CaretLocalServiceUtil.save(assmt);
							}
							_log.info("assessment is " + assmt);
						} catch (ApplicationWorkFlowException e) {
							e.printStackTrace();
						}
					}
				} catch (PortalException e) {
					e.printStackTrace();
				}
			}
			WorIm cbopcWork = Toolbox.createWorkItem(sc, worIm.getGroupId(), worIm, WorkType.CBOPC_WI, worIm.getPersnId(), worIm.getCaregiverId() );
			CaretLocalServiceUtil.addNote( Toolbox.createNote( 
					sc.getCreateDate(),
					cbopcWork.getWorImId(),
					cbopcWork.getGroupId(),
					0,
					ParamUtil.get(request,
							CaretStrPool.WORK_COMMENT, StringPool.BLANK ) ) );
			CaretLocalServiceUtil.save( cbopcWork );
			try{
				throw new ApplicationWorkFlowException("Did not save TIU Note");
				//CTSSH service TIU Note
			} catch ( Exception e ){
				CaretLocalServiceUtil.save( Toolbox.createWorkItem( sc, worIm.getGroupId(), worIm, WorkType.TIU, worIm.getPersnId(), worIm.getCaregiverId() ) );
			}
		} else {
			vcgAn.setStatus(CaretStrPool.UNAPPROVED);
		}
		
		CaretLocalServiceUtil.save(vcgAn);
		CaretLocalServiceUtil.save(worIm);
		CaretLocalServiceUtil.addNote( 
				Toolbox.createNote( 
						sc.getCreateDate(),
						worImId,
						worIm.getGroupId(),
						sc.getUserId(),
						ParamUtil.get(request,
								CaretStrPool.WORK_COMMENT, StringPool.BLANK ) ) );
		
	}

	@ProcessAction (name="loadDispositionWork")
	public void loadDispositionWork( ActionRequest request, ActionResponse response ) {
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		long vcgId = ParamUtil.getLong( request, "vcgId" );
		
		Map<String, Object> form = ResultMap.getForm(request);
		form.put(CaretStrPool.WORK_ID, worImId);
		try {
//			WorkType type = WorkType.valueOf( ParamUtil.getString(request, CaretStrPool.TYPE, StringPool.BLANK) );  
//			switch ( type ){
//			case ONLINE_APP:
//			case CSC_APP:
				Vcg vcg = null;
				VcgAn app = null;
				List<Docum> supportDocs;
				List<Assmt> assessments = Collections.emptyList();
				Person veteran = null;
				if ( vcgId != 0 ){
					vcg = VcgLocalServiceUtil.getVcg(vcgId);
					app =  VcgAnLocalServiceUtil.getRecent(vcgId);
					veteran = new Person( PersnLocalServiceUtil.getPersn( vcg.getVeteranId() ) );
					if ( vcg.getPrimaryId() > 0 ){
						form.put(CaretStrPool.PRIMARY_PERSN, new Person( PersnLocalServiceUtil.getPersn( vcg.getPrimaryId() ) ) );
					}
					if ( vcg.getSecondaryId() > 0 ){
						form.put(CaretStrPool.SECONDARY_PERSN, new Person( PersnLocalServiceUtil.getPersn( vcg.getSecondaryId() ) ) );
					}
					if ( vcg.getSecondaryTwoId() > 0 ){
						form.put(CaretStrPool.SECONDARY_TWO_PERSN, new Person( PersnLocalServiceUtil.getPersn( vcg.getSecondaryTwoId() ) ) );
					}
					assessments = CaretLocalServiceUtil.getAssessments( app.getVcgId() );
					supportDocs = new ArrayList<Docum>();
					for ( VcgAn vcgAn : VcgLocalServiceUtil.getVcgApps( vcgId ) ){
						supportDocs.addAll( DocumLocalServiceUtil.getByClassId( vcgAn.getVcgId() ) );
					}
				} else {
					long primaryKey = ParamUtil.getLong(request, CaretStrPool.PRIMARY_KEY);
					_log.info("primary key is : "+primaryKey);
					app = VcgAnLocalServiceUtil.getVcgAn( primaryKey );
					veteran = new Person( PersnLocalServiceUtil.getPersn( app.getVeteranId() ) );
					if ( app.getPrimaryId() > 0 ){
						form.put(CaretStrPool.PRIMARY_PERSN, new Person (PersnLocalServiceUtil.getPersn( app.getPrimaryId() ) ) );
					}
					if ( app.getSecondaryId() > 0 ){
						form.put(CaretStrPool.SECONDARY_PERSN, new Person (PersnLocalServiceUtil.getPersn( app.getSecondaryId() ) ) );
					}
					if ( app.getSecondaryTwoId() > 0 ){
						form.put(CaretStrPool.SECONDARY_TWO_PERSN, new Person (PersnLocalServiceUtil.getPersn( app.getSecondaryTwoId() ) ) );
					}
					supportDocs = DocumLocalServiceUtil.getByClassId( primaryKey );
					response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_DISPOSITION_PAGE);
				}
				form.put( CaretStrPool.VETERAN_PERSN, veteran );
				
				form.put(CaretStrPool.VCGAN, app);
				form.put("vcg", vcg);
				form.put("assessments", assessments );
				_log.info("Assessments:" + assessments.size() );
				
				form.put("supportDocs", supportDocs );
				_log.info("number of supporting docs is : "+supportDocs.size());
								
				
				
				//***Start of Assessments Code***
				
				form.put("veteranId", app.getVeteranId() );
				
				//get all applications for the vcg record (vcgid) - then check for IN_PROCESS apps
				List<VcgAn> vcgAnList= VcgAnLocalServiceUtil.getByVcg(vcgId);				
				//_log.info("number of applications is : "+vcgAnList.size());
				
				for(VcgAn vcgAn:vcgAnList)
				{
					//Check the status of the application should be in_process 
					if(vcgAn.getStatus().equals(CaretStrPool.IN_PROCESS) && vcg!= null )
					{
						String dateStr = Toolbox.formatDateCprs(vcgAn.getReceivedDate());
						if(vcgAn.getPrimaryId()!=0 && vcgAn.getPrimaryId()==vcg.getPrimaryId() ){
							form.put("primaryValidAppDate", dateStr);
							form.put("primaryApplicationId", vcgAn.getVcgAnId());
						}
						if(vcgAn.getSecondaryId()!=0 && vcgAn.getSecondaryId()==vcg.getSecondaryId()){
							form.put("secondaryValidAppDate", dateStr);
							form.put("secondaryApplicationId", vcgAn.getVcgAnId());
						}	
						if(vcgAn.getSecondaryTwoId()!=0 && vcgAn.getSecondaryTwoId()==vcg.getSecondaryTwoId()){
							form.put("secondaryTwoValidAppDate", dateStr);
							form.put("secondaryTwoApplicationId", vcgAn.getVcgAnId());
						}										
					}
				}
				
				loadAssessments(request, form, vcg);
				
				//***End of Assessments Code***
				

		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
		
	}
	
	
	public void loadAssessments( ActionRequest request, Map<String,Object> form, Vcg vcg) 
	{
		try 
		{			
			AssmtBean primaryClinical = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_CLINICAL); 				
			AssmtBean primaryAssessment = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_ASSESSMENT); 			
			AssmtBean primaryTraining = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_TRAINING); 				
			AssmtBean primaryInHome = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_IN_HOME); 				
			AssmtBean secondaryClinical = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_CLINICAL); 
			AssmtBean secondaryAssessment = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_ASSESSMENT); 
			AssmtBean secondaryTraining = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TRAINING); 
			AssmtBean secondaryTwoClinical = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TWO_CLINICAL); 
			AssmtBean secondaryTwoAssessment = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TWO_ASSESSMENT); 
			AssmtBean secondaryTwoTraining = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TWO_TRAINING); 
			
			List<Assmt> completedAssessmentList = AssmtLocalServiceUtil.findByVcgId(vcg.getVcgId());
			//_log.info("number of completed assessments is : "+completedAssessmentList.size());

			for(Assmt assessment:completedAssessmentList)
			{
				//get active assessments for the caregiver
				if(assessment.isActive())
				{
					String dateStr = Toolbox.formatDateCprs(assessment.getCompletionDate());				
					if(assessment.getType().equals(CaretStrPool.PRIMARY_CLINICAL) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryClinical.setAssessment(assessment);
						primaryClinical.setFormattedcompletionDate(dateStr);					
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_ASSESSMENT) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryAssessment.setAssessment(assessment);
						primaryAssessment.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_TRAINING) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryTraining.setAssessment(assessment);
						primaryTraining.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_IN_HOME) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryInHome.setAssessment(assessment);
						primaryInHome.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_CLINICAL) && assessment.getCaregiverId()==vcg.getSecondaryId()){
						secondaryClinical.setAssessment(assessment);
						secondaryClinical.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_ASSESSMENT) && assessment.getCaregiverId()==vcg.getSecondaryId()){
						secondaryAssessment.setAssessment(assessment);
						secondaryAssessment.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TRAINING) && assessment.getCaregiverId()==vcg.getSecondaryId()){
						secondaryTraining.setAssessment(assessment);
						secondaryTraining.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_CLINICAL) && assessment.getCaregiverId()==vcg.getSecondaryTwoId()){
						secondaryTwoClinical.setAssessment(assessment);
						secondaryTwoClinical.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_ASSESSMENT) && assessment.getCaregiverId()==vcg.getSecondaryTwoId()){
						secondaryTwoAssessment.setAssessment(assessment);
						secondaryTwoAssessment.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_TRAINING) && assessment.getCaregiverId()==vcg.getSecondaryTwoId()){
						secondaryTwoTraining.setAssessment(assessment);
						secondaryTwoTraining.setFormattedcompletionDate(dateStr);
					}
				}
			}
					
			
			List<AssmtBean> primaryAssessmentList = new ArrayList<AssmtBean>();
			primaryAssessmentList.add(primaryClinical);
			primaryAssessmentList.add(primaryAssessment);
			primaryAssessmentList.add(primaryTraining);
			primaryAssessmentList.add(primaryInHome);
			
			List<AssmtBean> secondaryAssessmentList = new ArrayList<AssmtBean>();
			secondaryAssessmentList.add(secondaryClinical);
			secondaryAssessmentList.add(secondaryAssessment);
			secondaryAssessmentList.add(secondaryTraining);

			List<AssmtBean> secondaryTwoAssessmentList = new ArrayList<AssmtBean>();
			secondaryTwoAssessmentList.add(secondaryTwoClinical);
			secondaryTwoAssessmentList.add(secondaryTwoAssessment);
			secondaryTwoAssessmentList.add(secondaryTwoTraining);

			form.put("primaryAssessmentList", primaryAssessmentList);
			form.put("secondaryAssessmentList", secondaryAssessmentList);
			form.put("secondaryTwoAssessmentList", secondaryTwoAssessmentList);
			
		} catch (ApplicationWorkFlowException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	
	
	@ProcessAction (name="workClose")
	public void workClose ( ActionRequest request, ActionResponse response ) {
		_log.info("workClose");
		
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			WorIm workItem = WorImLocalServiceUtil.getWorIm(worImId);
			switch ( WorkType.valueOf( workItem.getType() ) ){
			case CALL_REFERRAL:
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
				
				workItem.setStatus( WorkStatus.COMPLETE.name() );
				workItem.setCompletionBy( sc.getUserId() );
				workItem.setCompletionDate( sc.getCreateDate() );
				
				CaretLocalServiceUtil.save(workItem);
				CaretLocalServiceUtil.addNote(Toolbox.createNote(sc.getCreateDate(),
						worImId,
						workItem.getGroupId(),
						sc.getUserId(),
						ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK)));
			default:
				break;
			}
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
	}

	@ProcessAction (name="openReferral")
	public void openReferral ( ActionRequest request, ActionResponse response ) {
		
		try {
			WorkType type = WorkType.valueOf( ParamUtil.getString(request, "type", StringPool.BLANK) );  
			request.setAttribute(CaretStrPool.WORK_ID, ParamUtil.getLong(request, CaretStrPool.WORK_ID ) );
			switch ( type ){
			case CALL_REFERRAL:
				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
				loadCall(request);
				break;
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_REFERRAL_PAGE);
				loadReferral(request);
				break;
			default:
				break;
			}
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} 
		
	}
	
//	
//	@SuppressWarnings("unchecked")
//	@ProcessAction (name="approvePaymentMonth")
//	public void approvePaymentMonth( ActionRequest actionRequest, ActionResponse actionResponse ) {
//		_log.info("approvePaymentMonth..." );
//		int m = ParamUtil.get(actionRequest, "month", 12);
//		int year = ParamUtil.get(actionRequest, "year", 0);
//		_log.info("month= " + m + ", year=" + year );
//		if ( m < 12 && year > 0 ){
//			Calendar calendar = Calendar.getInstance();
//			calendar.set(Calendar.MONTH, m);
//			calendar.set(Calendar.YEAR, year);
//			calendar.set(Calendar.DAY_OF_MONTH, 0);
//			calendar.set(Calendar.HOUR, 0);
//			Date date = calendar.getTime();
//			_log.info( "date=" + date );
//			
//			DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( StiPtImpl.class, PortalClassLoaderUtil.getClassLoader() )
//			.add ( PropertyFactoryUtil.forName ("StipendStartDate").gt( date ) );
//			calendar.roll(Calendar.MONTH, true);
//			Date date2 = calendar.getTime();
//			dynamicQuery.add ( PropertyFactoryUtil.forName ("StipendStartDate").lt( date2 ) )
//			.add ( PropertyFactoryUtil.forName ("StipendStatus").eq( "PENDING PAYMENT" ) );
//			List<StiPt> list = Collections.emptyList();
//			try {
//				list = StiPtLocalServiceUtil.dynamicQuery(dynamicQuery);
//				Date now = new Date();
//				for ( StiPt payment : list ){
//					PayLg payLog = new PayLgImpl();
//					Double paymentAmt = Double.valueOf( payment.getTierHours() ) * Double.valueOf( payment.getBlsRateHourly() );
//					payLog.setAmount( paymentAmt );
//					payLog.setPaymentDate( payment.getStipendStartDate() );
//					payLog.setStiPtId( payment.getPrimaryKey() );
//					PayLgLocalServiceUtil.addPayLg(payLog);
//					
//					payment.setStipendStatus("PAYMENT_FINANCED");
//					payment.setStipendApprovedDate(now);
//					payment.setMonthlyPayment( paymentAmt.toString() );
//					StiPtLocalServiceUtil.updateStiPt(payment);
//				}
//			} catch (SystemException e) {
//				e.printStackTrace();
//			}
//			actionRequest.setAttribute("monthYear", Months.values()[m] + ", " + year );
//		}
//	}
//	
	@ProcessAction (name="loadTen10App")
	public void loadVcgAnApp ( ActionRequest actionRequest, ActionResponse actionResponse ) {
		_log.info("loadTen10App..." );
		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/internal/createTen10.jsp" );
		loadStatesAndFacilities( actionRequest );
	}
	
	public void loadStatesAndFacilities ( PortletRequest request ) {
		try {
			Map<String,Object> caret = ResultMap.getCaretMap(request);
			caret.put( CaretStrPool.VHA_SYSTEM, Toolbox.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
			try {
				caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
			} catch (SystemException e) {
				e.printStackTrace();
			}
			
			
		} catch (PortalException e) {
			e.printStackTrace();
		}
	}
	
	private void saveBoxGroups ( PortletRequest request, long primaryKey ){
		try {
			List<Long> fmChecks = CaretParam.loadSelectedBoxModel(request, CaretStrPool.BOX_GROUP);

			Long heardFromUs = ParamUtil.getLong(request, "boxRadioGrp_heardFromUs", 0);
			if ( heardFromUs > 0 ){
				fmChecks.add(heardFromUs);
			}
			
			if ( primaryKey > 0 ){
				List<Long> updated = new ArrayList<Long>();
				List<BgAsn> bgAsnList = BoxGpLocalServiceUtil.getBoxGroupAssociations( primaryKey );
				for ( BgAsn bgAsn: bgAsnList ){
					if ( fmChecks.contains( bgAsn.getBoxGpId() ) ){
						if ( !bgAsn.isSelected() ){
							bgAsn.setSelected( true );
							CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
							updated.add( bgAsn.getBoxGpId() );
						}
						fmChecks.remove( bgAsn.getBoxGpId() );
					} else {
						if ( bgAsn.isSelected() ){
							bgAsn.setSelected( false );
							CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
						}
					}
				}
				for ( Long boxGpId: fmChecks){
					if ( ! updated.contains( boxGpId ) ){
						BgAsn bgAsn = new BgAsnImpl();
						bgAsn.setBoxGpId( boxGpId );
						bgAsn.setOwnerId( primaryKey );
						bgAsn.setSelected( true );
						CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
					}
				}
			} else {
				for ( Long boxGpId: fmChecks ){
					BgAsn bgAsn = new BgAsnImpl();
					bgAsn.setBoxGpId(boxGpId);
					bgAsn.setOwnerId( primaryKey );
					bgAsn.setSelected( true );
					CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
				}
			}
			
			_log.info(fmChecks);
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
	}
	
	private void saveCall ( ActionRequest request ) throws ApplicationWorkFlowException{
		_log.info("saveCall..." );
		Call call = null;
		Person caller = null;
		Person veteran = null;
		
		getOutput(request);
		Long callId = ParamUtil.getLong(request, "call_primaryKey");
		Long veteranId = ParamUtil.getLong(request, "veteranPersn_primaryKey");
		
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		if ( callId > 0 ){
			try {
				call = CallLocalServiceUtil.getCall(callId);
			} catch (PortalException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		
		if ( call == null) {
			call = new CallImpl();
		}
			
		Long callerId = ParamUtil.getLong(request, "callerPersn_primaryKey");
		if ( callerId > 0 ){
			try {
				caller = new Person( PersnLocalServiceUtil.getPersn( callerId ) );
			} catch (PortalException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		if ( caller == null ){
			caller = new Person ( new PersnImpl() );
		}
		//TODO: pass list of parameter names 
		CaretParam.loadModel( request, call, call.getModelAttributes().keySet(), "call_");

		//TODO: pass list of parameter names 
		CaretParam.loadModel(request, caller, caller.getModelAttributes().keySet(), "callerPersn_");
		
		if ( call.isSameAddress() ){
			CaretParam.loadModel(request, caller, Toolbox.getCollection("city","state","zip","address"), "veteranPersn_" );
		}
		CaretLocalServiceUtil.save( caller );
		
		if ( veteranId > 0 ){
			try {
				veteran = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		if ( veteran == null ){
			veteran = new Person ( new PersnImpl() );
		}
		//TODO: pass list of parameter names 
		
		veteran = (Person) CaretLocalServiceUtil.save( CaretParam.loadModel(request, veteran, veteran.getModelAttributes().keySet(), "veteranPersn_") );
		_log.info("veteran is " + veteran);
		
		long roleId = (Long)sc.getAttribute( CaretStrPool.ROLE_ID );
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );

		String message = null;
		if ( call.getPrimaryKey() == 0 ){
			call.setCreateGroupId( roleId );
			call.setUserId( (Long) sc.getAttribute( CaretStrPool.USER_ID ) );
			try {
				message = PortalUtil.getUser(request).getFullName() + " created " +
							LanguageUtil.get(themeDisplay.getLocale(), call.getCallType()) + " as " +
							LanguageUtil.get(themeDisplay.getLocale(), call.getCallState() ) ; 
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		call.setVeteranPersnId( veteran.getPersnId() );
		call.setCallerPersnId( caller.getPersnId() );
		call = (Call)CaretLocalServiceUtil.save( call );
		if ( CaretStrPool.CALL_STATE_REFERRAL.equals( call.getCallState() ) ){
			WorIm workItem = null;
			
			if ( veteran.getGroupId() > 0  ){//type, persnId
				if ( call.getWorkPrimaryKey() > 0 ){
					try {
						workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
					} catch (PortalException e) {
						e.printStackTrace();
					} catch (SystemException e) {
						e.printStackTrace();
					}
				}
				if ( workItem == null ){
					workItem = Toolbox.createWorkItem(sc, veteran.getGroupId(), call, WorkType.CALL_REFERRAL, veteran.getPersnId(), caller.getPersnId()  );
//					workItem.setQueId(CaretStrPool.REFERRAL_QUE);
					call.setWorkPrimaryKey(workItem.getPrimaryKey());
					CaretLocalServiceUtil.save( call );
				}
				CaretLocalServiceUtil.save( workItem );
			} else {
				throw new ApplicationWorkFlowException( "NEED GROUP ID" );
			}
			
		} else if ( !CaretStrPool.CALL_STATE_COMPLETE.equals(  call.getCallState() ) ){
			CalEt callEvent = new CalEtImpl();
			callEvent.setCallId(call.getCallId());
			StringBuilder sb = new StringBuilder( call.getCallType() );
			sb.append(CaretStrPool.COLON_SPACE);
			if ( call.isHangUp() ){
				sb.append("Hang-up, ");
			}
			if ( call.isWithoutContact() ){
				sb.append("Without-contact, ");
			}
			if ( call.isWrongNumber() ){
				sb.append("Wrong-number, ");
			}
			callEvent.setComment( sb.substring(0,sb.length()-1) );
			callEvent.setEvent( call.getCallState() );
			CaretLocalServiceUtil.save(callEvent);
		}
		
		saveBoxGroups(request, call.getPrimaryKey());
		
		CaretLocalServiceUtil.addNote( Toolbox.createNote(sc.getCreateDate(), call.getCallId(), roleId, sc.getUserId(), message) );
		_log.info("call is " + call);
	}
		
	public void saveSoc ( ActionRequest request ){
		_log.info("saveSoc..." );

		try {			
			getOutput(request);
			ServiceContext sc = CaretParam.setCaretServiceContext(request);

			String thresholdMet = ParamUtil.get(request, "soc_tresholdMet", StringPool.BLANK);						

			long socId = CounterLocalServiceUtil.increment( ClSoc.class.getName() );
			ClSoc soc = ClSocLocalServiceUtil.createClSoc(socId);
			CaretParam.loadModel(request, soc,	soc.getModelAttributes().keySet(), "soc_");
			
			soc.setClSocId(socId);
			soc.setCreationDate(new Date());

			if(thresholdMet.equals("No")){
				String followupCall = ParamUtil.get(request, "soc_followupCall_q14", StringPool.BLANK);
				String followupCallTime = ParamUtil.get(request, "soc_followupCallTime_q14", StringPool.BLANK);
				soc.setFollowupCall(followupCall);
				soc.setFollowupCallTime(followupCallTime);
			}

			ClSocLocalServiceUtil.addClSoc(soc);
			
			//NOTE: TODO use save() to save soc
			//CaretLocalServiceUtil.save( soc );
			
			//create work item for follow up call			
			if(soc.getFollowupCall() != null && soc.getFollowupCall().equals("Yes")){
				Call call = CallLocalServiceUtil.getCall( Long.parseLong(ParamUtil.get(request, "soc_callId", StringPool.BLANK)) );
				long veteranId = call.getVeteranPersnId();
				Person veteran = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
				CaretLocalServiceUtil.save( Toolbox.createWorkItem( sc, veteran.getGroupId(), soc, WorkType.SOC_FOLLOWUP, veteranId, call.getCallerPersnId() ));
			}
			
			CaretLocalServiceUtil.addNote( Toolbox.createNote(sc.getCreateDate(), soc.getCallId(), (Long)sc.getAttribute( CaretStrPool.ROLE_ID ), sc.getUserId(), "Completed SOC Call Attempt - "+soc.getAttemptNum()) );			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	

	public void saveCesp ( ActionRequest request ){
		_log.info("saveCesp..." );

		try {
			getOutput(request);
			
			ServiceContext sc = CaretParam.setCaretServiceContext(request);

			int numOfCesp = ParamUtil.getInteger(request, "cesp_numOfCesp");
			String cespClosed = ParamUtil.get(request, "cesp_cespClosed", StringPool.BLANK);

			long cespId = CounterLocalServiceUtil.increment( Cesp.class.getName() );
			Cesp cesp = CespLocalServiceUtil.createCesp(cespId);
			CaretParam.loadModel(request, cesp, cesp.getModelAttributes().keySet(), "cesp_");
			
			cesp.setCespId(cespId);
			cesp.setCreationDate(new Date());

			String notification = "";
			if(numOfCesp == 0){
				cesp.setStatus(CaretStrPool.CESP_STATUS_INITIAL);//initial	
				notification = "CESP - Initial - Completed";
			}else if(cespClosed.equals("No")){
				cesp.setStatus(CaretStrPool.CESP_STATUS_COMPLETE);//complete - in step 2								
				notification = "CESP - Completed";
			}else if(cespClosed.equals("Yes")){
				cesp.setStatus(CaretStrPool.CESP_STATUS_CLOSED);//complete - cesp closed										
				notification = "CESP - Closed";
			}

			CespLocalServiceUtil.addCesp(cesp);
			//NOTE: TODO use save() to save cesp
			//CaretLocalServiceUtil.save( cesp );

			
			//create work item for CSC			
			if(null!=cesp.getCespClosedReason() 
				&& (cesp.getCespClosedReason().equals("Goals Reached") || cesp.getCespClosedReason().equals("Participation Discontinued - refer to CSC"))){
				Call call = CallLocalServiceUtil.getCall( Long.parseLong(ParamUtil.get(request, "cesp_callId", StringPool.BLANK)) );
				long veteranId = call.getVeteranPersnId();
				Person veteran = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
				CaretLocalServiceUtil.save( Toolbox.createWorkItem( sc, veteran.getGroupId(), cesp, WorkType.CESP_CSC, veteranId, call.getCallerPersnId() ));
			}

			CaretLocalServiceUtil.addNote( Toolbox.createNote(sc.getCreateDate(), cesp.getCallId(), (Long)sc.getAttribute( CaretStrPool.ROLE_ID ), sc.getUserId(), notification) );			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void saveReferral ( ActionRequest request ) throws ApplicationWorkFlowException{
		Call call = null;
		Person caller = null;
		WorIm workItem = null;

		getOutput(request);
		Long callId = ParamUtil.getLong(request, "call_primaryKey");

		Person veteran = null;
		Long veteranId = ParamUtil.getLong(request, "veteranPersn_primaryKey");
		if ( veteranId > 0 ){
			try {
				veteran = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
			} catch (PortalException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		if ( veteran == null ){
			veteran = new Person ( new PersnImpl() );
		}
		
		CaretParam.setCaretServiceContext(request);
		if ( callId > 0 ){
			try {
				call = CallLocalServiceUtil.getCall(callId);
				workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
			if ( workItem.getStatus().equals( StringPool.BLANK ) ){
				workItem.setStatus( WorkStatus.NEW.name() );
			}
			
			if ( !workItem.getStatus().equals( WorkStatus.NEW.name() ) ){
				throw new ApplicationWorkFlowException( "WORK ITEM ALREADY STARTED" );
			}
		}
		
		
			
		Long callerId = ParamUtil.getLong(request, "callerPersn_primaryKey");
		if ( callerId > 0 ){
			try {
				caller = new Person ( PersnLocalServiceUtil.getPersn( callerId ) );
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		if ( caller == null ){
			caller = new Person ( new PersnImpl() );
		}
		
		//TODO: pass list of parameter names 
		CaretLocalServiceUtil.save( CaretParam.loadModel(request, caller, caller.getModelAttributes().keySet(), "callerPersn_") );
		_log.info("caller is " + caller);
		

		//TODO: pass list of parameter names 
		veteran = (Person)CaretLocalServiceUtil.save( CaretParam.loadModel(request, veteran, veteran.getModelAttributes().keySet(), "veteranPersn_") );
		_log.info("veteran is " + veteran);
		

		if ( ! CaretViewController.getViewController().validateRequired(CaretStrPool.CALL, request) ){
			throw new ApplicationWorkFlowException( "VALIDATION" );
		}
		
		if ( call == null) {
			call = new CallImpl();
		}
		CaretParam.loadModel( request, call, call.getModelAttributes().keySet(), "call_");

		ServiceContext sc = CaretParam.setCaretServiceContext( request );
		
		call.setVeteranPersnId( veteran.getPersnId() );
		call.setCallerPersnId( caller.getPersnId() );

		if ( call.getCallId() == 0 ){
			call.setCallState(CaretStrPool.CALL_STATE_COMPLETE);
			DashboardConfig dashConfig = ( DashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
			call.setCreateGroupId( dashConfig.getRoleId() );
			call.setUserId( (Long) sc.getAttribute( CaretStrPool.USER_ID ) );
			CaretLocalServiceUtil.save( call );
			
			WorkType workType;
			if ( dashConfig instanceof CslDashboardConfig ){
				workType = WorkType.CSL_REFERRAL;
			} else {
				try{
					workType = WorkType.valueOf( dashConfig.getRole() + "_REFERRAL");
				} catch(Exception e){
					workType = WorkType.REFERRAL;
				}
			}
			
			workItem = Toolbox.createWorkItem(sc, veteran.getGroupId(), call, workType, veteran.getPersnId(), call.getCallerPersnId() );
			workItem = (WorIm)CaretLocalServiceUtil.save( workItem );
			call.setWorkPrimaryKey( workItem.getPrimaryKey() );
		}
		call = (Call)CaretLocalServiceUtil.save( call );
		_log.info("call is " + call);
		
		saveReferralQuestionaire ( veteran.getPersnId(), request );
		if ( CAction.canDoCaret(request, CaretCan.HEC_FUNCTION.name() ) ){
			saveLodQa(veteran.getPersnId(), request);
		}
			
		
		//Supporting Docs attachment code
		try {		
			if ( request.getPortletSession().getAttribute(CaretStrPool.FILE_PATH) != null ){
				String path = (String) request.getPortletSession().getAttribute(CaretStrPool.FILE_PATH);
				String name = (String) request.getPortletSession().getAttribute(CaretStrPool.FILE_NAME);
				AttachmentBean attachment = new AttachmentBean();
				attachment.setClassId(call.getCallId());
				attachment.setClassPk(PortalUtil.getClassNameId(Call.class));
				attachment.setPath(path);
				attachment.setName(name);
				attachment.setType(FileType.REFERRAL_1010.name());
				handleApplicationDocument( request, attachment);
				request.getPortletSession().removeAttribute(CaretStrPool.FILE_PATH);
				request.getPortletSession().removeAttribute(CaretStrPool.FILE_NAME);
			}
			if ( request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH) != null ){
				String path = (String) request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH);
				String name = (String) request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_NAME);
				AttachmentBean attachment = new AttachmentBean();
				attachment.setClassId(call.getCallId());
				attachment.setClassPk(PortalUtil.getClassNameId(Call.class));
				attachment.setPath(path);
				attachment.setName(name);
				attachment.setType(FileType.REFERRAL_POA.name());
				handleApplicationDocument( request, attachment);
				request.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_PATH);
				request.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_NAME);
			}
		} catch (FileNotFoundException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		
		_log.info("saveReferral..." );
	}
	
	private void saveReferralQuestionaire(long persnId, PortletRequest request) throws ApplicationWorkFlowException {
		
		
		Map<Long,String> boxGpIdMap = new HashMap<Long,String>();
		for ( String subgroup: PortletProps.get( CaretStrPool.REFERRAL_QUESTIONAIRE_YN ).split( StringPool.SEMICOLON ) ){
			boxGpIdMap.put( ParamUtil.getLong(request, subgroup), subgroup );
		}
		for ( long boxGpId : boxGpIdMap.keySet() ){
			for ( BoxGp boxGp: BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.REFERRAL_QUESTIONAIRE_YN, boxGpIdMap.get(boxGpId) ) ) {
				 BgAsn bgAsn = BoxGpLocalServiceUtil.getBoxGroupAssociation( persnId, boxGp.getBoxGpId() ) ;
				 if ( bgAsn != null ){
					 bgAsn.setSelected(boxGp.getBoxGpId() == boxGpId);
				 } else if ( boxGp.getBoxGpId() == boxGpId ){
					 bgAsn = new BgAsnImpl();
					 bgAsn.setSelected(true);
					 bgAsn.setBoxGpId(boxGpId);
					 bgAsn.setOwnerId( CaretParam.getPersnId(request) );
				 } else {
					 continue;
				 }
				 CaretLocalServiceUtil.save(bgAsn);
//					BgAsnLocalServiceUtil.updateBgAsn(bgAsn);
			}
		}
	}

	public void saveLodQa( long persnId, PortletRequest request ) throws ApplicationWorkFlowException{
		saveBoxGroups(request, persnId);
	}
	
	public void getOutput( PortletRequest request ){
		if ( _log.isDebugEnabled() ){
			List<String> list = new ArrayList<String>();
			for ( Enumeration<String> enume = request.getParameterNames(); enume.hasMoreElements(); ){
				list.add(enume.nextElement());
			}
			Collections.sort(list);
			for ( String name: list ){
				_log.debug( name + ":" + request.getParameter(name) );
			}
		}
	}
	
	public void saveCbopcWork ( ActionRequest actionRequest ){
		_log.info("saveCbopcWork..." );
	}
	public void saveVcgEntry ( ActionRequest request, ActionResponse response ) throws ApplicationWorkFlowException{
		
		_log.info("saveVcg..." );
		
		long persnId = ParamUtil.getLong(request, "_primaryKey");
		long vcgId = ParamUtil.getLong(request, "vcgId");
		
		String ndx = request.getParameter("ndx") + StringPool.UNDERLINE;
		
		if ( vcgId > 0 ){
			Vcg vcg = null;
			try {
				vcg = VcgLocalServiceUtil.getVcg( vcgId );
			} catch (PortalException e1) {
				throw new ApplicationWorkFlowException( e1 );
			} catch (SystemException e1) {
				throw new ApplicationWorkFlowException( e1 );
			}
			
			if ( CAction.canDoCaret( request, CAction.CaretCan.MANAGE_VCG.name() ) ){
				
				try {
					boolean piiChange = false;
					boolean nameChange = false;
					boolean insuranceChange = false;
					boolean addressChange = false;
					
					boolean isVeteran = persnId == vcg.getVeteranId(), 
							isPrimary = persnId == vcg.getPrimaryId(), 
							isSecondary = persnId == vcg.getSecondaryId(), 
							isSecondaryTwo = persnId == vcg.getSecondaryTwoId();
					
					ServiceContext sc = CaretParam.setCaretServiceContext( request );
					
					Person person = new Person( PersnLocalServiceUtil.getPersn(persnId) );
					Person persn = (Person) CaretParam.loadModel( request, new Person( new PersnImpl() ), 
							Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "address", "ssn", "country", "externalId", "otherHealthInsurance", "mediEnrolled" ),
							ndx );
					if ( persn.getCountry().isEmpty() || "false".equals(persn.getCountry() ) ){
						CaretParam.loadModel( request, persn, Toolbox.getAddressCollection(), CaretStrPool.U_UNDERLINE );
					} else {
						CaretParam.loadModel( request, persn, Toolbox.getAddressCollection(), CaretStrPool.G_UNDERLINE );
					}
					
					
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_NAME.name() ) ){
						if ( nameChange = !persn.getLastName().equalsIgnoreCase( person.getLastName() ) ){
							person.setLastName( persn.getLastName() );
						}
					}
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_MNAME.name() ) ){
						if ( !persn.getMiddleName().equalsIgnoreCase( person.getMiddleName() ) ){
							person.setMiddleName( persn.getMiddleName() );
							nameChange = true;
						}
					}
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_FNAME.name() ) ){
						if ( !persn.getFirstName().equalsIgnoreCase( person.getFirstName() ) ){
							person.setFirstName( persn.getFirstName() );
							nameChange = true;
						}
					}
					
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_SSN.name() ) ){
						if ( piiChange = !person.getSsn().equals( persn.getSsn() ) ){
							person.setSsn( persn.getSsn() );
						}
					}
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_BDAY.name() ) ){
						if ( piiChange = ( piiChange || !person.getBirthDateStr().equals( persn.getBirthDateStr() ) ) ){
							person.setBirthDate( persn.getBirthDate() );
						}
					}
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_NAME.name() ) ){
						if ( piiChange = ( piiChange || !person.getExternalId().equals( persn.getExternalId() ) ) ){
							person.setExternalId( persn.getExternalId() );
						}
					}
					
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_ADDRESS.name() ) ){
						if ( addressChange = !persn.getAddress().equalsIgnoreCase( person.getAddress() ) ){
							person.setAddress( persn.getAddress() );
						}
						if ( !persn.getCity().equals( person.getCity() ) ){
							person.setCity( persn.getCity() );
							addressChange = true;
						}
						if ( !persn.getState().equals( person.getState() ) ){
							person.setState( persn.getState() );
							addressChange = true;
						}
						if ( !persn.getZip().equals( person.getZip() ) ){
							person.setZip( persn.getZip() );
							addressChange = true;
						}
					}
					
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_INSURANCE.name() ) ){
						if ( insuranceChange =  !persn.getOtherHealthInsurance().equalsIgnoreCase( person.getOtherHealthInsurance() ) ){
							person.setOtherHealthInsurance( persn.getOtherHealthInsurance() );
						}
//						if ( insuranceChange =  ( insuranceChange || persn.isMedicareEnrolled() != person.isMedicareEnrolled() ) ){
//							person.setMedicareEnrolled( persn.isMedicareEnrolled() );
//						}
					}

					if ( CAction.canDoCaret( request, CAction.CaretCan.DISPOSITION_APPLICATIONS.name() ) ){
						String disposition = request.getParameter(ndx + "DispReason");
						if ( isVeteran && !vcg.getVeteranDispReason().equals( disposition ) ){
							vcg.setVeteranDispReason(disposition);
						} else if ( isPrimary && !vcg.getPrimaryDispReason().equals( disposition )){
							vcg.setPrimaryDispReason( disposition );
						} else if ( isSecondary && !vcg.getSecondaryDispReason().equals( disposition ) ){
							vcg.setSecondaryDispReason( disposition );
						} else if ( isSecondaryTwo && !vcg.getSecondaryTwoDispReason().equals( disposition )  ){
							vcg.setSecondaryTwoDispReason( disposition );
						}
						WorIm workItem = Toolbox.createWorkItem(sc, vcg.getGroupId(), vcg, WorkType.DISPOSITION_UPDATE, 
									vcg.getVeteranId(), person.getPersnId() == vcg.getVeteranId()? vcg.getPrimaryId(): person.getPersnId() );
						CaretLocalServiceUtil.save(workItem);
					}
					
					if ( isPrimary && CAction.canDoCaret( request, CAction.CaretCan.UPDATE_TIER_LEVEL.name() ) ){
						String tierEffectiveDate = request.getParameter(ndx + "tierEffectiveDate");
						int tierLevel = ParamUtil.getInteger(request, ndx + "tierLevel");
						VcgSupport vcgSupport = new VcgSupport(vcg);
						if ( tierEffectiveDate != null && !vcgSupport.getTierEffectiveDateStr().equals( tierEffectiveDate ) ||
								vcgSupport.getTierLevel() != tierLevel ){
							vcgSupport.setTierEffectiveDateStr( tierEffectiveDate );
							vcgSupport.setTierLevel( tierLevel  );

							WorIm workItem = Toolbox.createWorkItem(sc, vcg.getGroupId(), vcg, WorkType.TIER_UPDATE, 
									vcg.getVeteranId(), person.getPersnId() == vcg.getVeteranId()? vcg.getPrimaryId(): person.getPersnId() );
							CaretLocalServiceUtil.save( workItem );
						} 
					}
					if ( piiChange || nameChange || insuranceChange || addressChange ){
						
						if ( piiChange ){
							WorIm workItem =  Toolbox.createWorkItem(sc, vcg.getGroupId(), person, WorkType.PII_CHANGE, 
									vcg.getVeteranId(), person.getPersnId() == vcg.getVeteranId()? vcg.getPrimaryId(): person.getPersnId() ) ;
							CaretLocalServiceUtil.save(workItem);
							
							CaretLocalServiceUtil.addNote( Toolbox.createNote( 
									sc.getCreateDate(),
									person.getPersnId(),
									workItem.getWorImId(),
									sc.getUserId(),
									ParamUtil.get(request,
											CaretStrPool.WORK_COMMENT, StringPool.BLANK ) ) );
						}
						if ( addressChange ){
							WorIm workItem =  Toolbox.createWorkItem(sc, vcg.getGroupId(), person, WorkType.ADDRESS_CHANGE, 
									vcg.getVeteranId(), person.getPersnId() == vcg.getVeteranId()? vcg.getPrimaryId(): person.getPersnId() ) ;
							CaretLocalServiceUtil.save(workItem);
							
							CaretLocalServiceUtil.addNote( Toolbox.createNote( 
									sc.getCreateDate(),
									person.getPersnId(),
									workItem.getWorImId(),
									sc.getUserId(),
									ParamUtil.get(request,
											CaretStrPool.WORK_COMMENT, StringPool.BLANK ) ) );
						}
						if ( nameChange ){
							WorIm workItem =  Toolbox.createWorkItem(sc, vcg.getGroupId(), person, WorkType.NAME_CHANGE, 
									vcg.getVeteranId(), person.getPersnId() == vcg.getVeteranId()? vcg.getPrimaryId(): person.getPersnId() ) ;
							CaretLocalServiceUtil.save(workItem);
							
							CaretLocalServiceUtil.addNote( Toolbox.createNote( 
									sc.getCreateDate(),
									person.getPersnId(),
									workItem.getWorImId(),
									sc.getUserId(),
									ParamUtil.get(request,
											CaretStrPool.WORK_COMMENT, StringPool.BLANK ) ) );
						}
						if ( insuranceChange ){
							WorIm workItem = Toolbox.createWorkItem(sc, vcg.getGroupId(), person, WorkType.INSURANCE_UPDATE, 
									vcg.getVeteranId(), person.getPersnId() == vcg.getVeteranId()? vcg.getPrimaryId(): person.getPersnId() );
							CaretLocalServiceUtil.save(workItem);
							
							CaretLocalServiceUtil.addNote( Toolbox.createNote( 
									sc.getCreateDate(),
									person.getPersnId(),
									workItem.getWorImId(),
									sc.getUserId(),
									ParamUtil.get(request,
											CaretStrPool.WORK_COMMENT, StringPool.BLANK ) ) );
						}
						
						CaretLocalServiceUtil.save(person);
					}
					
					Boolean generalCaregiverUpdatedFlag = ParamUtil.getBoolean(request, "_generalCaregiver");
					if(vcg.getGeneralCaregiver()!=generalCaregiverUpdatedFlag){
						vcg.setGeneralCaregiver(generalCaregiverUpdatedFlag);
						CaretLocalServiceUtil.save( vcg );	
					}
					String generalCaregiverComment = ParamUtil.getString(request, "_generalCaregiverComment");
					if(generalCaregiverComment != null && !("".equals(generalCaregiverComment.trim()))){
						CaretLocalServiceUtil.addNote( Toolbox.createNote(sc.getCreateDate(), vcg.getVcgId(), 0, sc.getUserId(), generalCaregiverComment));						
					}

				} catch (PortalException e) {
					e.printStackTrace();
				} catch (SystemException e) {
					e.printStackTrace();
				}

				
				
				loadDispositionWork (request, response);
				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
				
				
				
			}
		} else {
			_log.info("vcgId == 0");
		}
		
		request.setAttribute( CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE );
	}
	
	public void saveVcgAn ( ActionRequest actionRequest ){
		_log.info("saveVcgAn..." );
		getOutput(actionRequest);
		
		try {
			
			VcgAn v = new VcgAnImpl();
			VcgAn vcgApplication = (VcgAn) CaretParam.loadModel(actionRequest, new VcgAnImpl(), v.getModelAttributes().keySet(), CaretStrPool.VCGAN_UNDERLINE);
			vcgApplication.setCreationDate(new Date());
						
			//create new person records in db for veteran and caregivers
			ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
			
			long caregiverId = 0;
			
			String veteranFirstName = ParamUtil.get(actionRequest, "veteranPerson_firstName", "");
			if(!veteranFirstName.equals("")){			
				Person veteran = new Person ( new PersnImpl() );
				CaretParam.loadModel(actionRequest, veteran, veteran.getModelAttributes().keySet(), CaretStrPool.VETERAN_PERSON  + StringPool.UNDERLINE);
				if( "false".equals(veteran.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSON + "u_" );					
				}else if(!"false".equals(veteran.getCountry())){//foreign address
					CaretParam.loadModel(actionRequest, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSON + "g_" );										
				}				
				CaretLocalServiceUtil.save( veteran );
				vcgApplication.setVeteranId(veteran.getPersnId());
			}

			String primaryFirstName = ParamUtil.get(actionRequest, "primaryPerson_firstName", "");
			if(!primaryFirstName.equals("")){			
				Person primary = new Person ( new PersnImpl() );
				CaretParam.loadModel(actionRequest, primary, primary.getModelAttributes().keySet(), CaretStrPool.PRIMARY_PERSON  + StringPool.UNDERLINE);
				if( "false".equals(primary.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, primary, Toolbox.getAddressCollection(), CaretStrPool.PRIMARY_PERSON + "u_" );
				} else if (!"false".equals(primary.getCountry())){
					CaretParam.loadModel(actionRequest, primary, Toolbox.getAddressCollection(), CaretStrPool.PRIMARY_PERSON + "g_" );					
				}
				CaretLocalServiceUtil.save( primary );
				vcgApplication.setPrimaryId(primary.getPersnId());
				caregiverId = primary.getPersnId();
			}

			String secondaryFirstName = ParamUtil.get(actionRequest, "secondaryPerson_firstName", "");
			if(!secondaryFirstName.equals("")){			
				Person secondary = new Person ( new PersnImpl() );
				CaretParam.loadModel(actionRequest, secondary, secondary.getModelAttributes().keySet(), CaretStrPool.SECONDARY_PERSON  + StringPool.UNDERLINE);
				if( "false".equals(secondary.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, secondary, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_PERSON + "u_" );
				}else if(!"false".equals(secondary.getCountry()) ){
					CaretParam.loadModel(actionRequest, secondary, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_PERSON + "g_" );					
				}
				CaretLocalServiceUtil.save( secondary );
				vcgApplication.setSecondaryId(secondary.getPersnId());
				if ( caregiverId == 0 ){
					caregiverId = secondary.getPersnId();
				}
			}

			String secondaryTwoFirstName = ParamUtil.get(actionRequest, "secondaryTwoPerson_firstName", "");
			if(!secondaryTwoFirstName.equals("")){			
				Person secondaryTwo = new Person ( new PersnImpl() );
				CaretParam.loadModel(actionRequest, secondaryTwo, secondaryTwo.getModelAttributes().keySet(), CaretStrPool.SECONDARY_TWO_PERSON  + StringPool.UNDERLINE);
				if( "false".equals(secondaryTwo.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, secondaryTwo, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_TWO_PERSON + "u_" );
				}else if(!"false".equals(secondaryTwo.getCountry()) ){
					CaretParam.loadModel(actionRequest, secondaryTwo, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_TWO_PERSON + "g_" );
				}
				CaretLocalServiceUtil.save( secondaryTwo );
				vcgApplication.setSecondaryTwoId(secondaryTwo.getPersnId());
				if ( caregiverId == 0 ){
					caregiverId = secondaryTwo.getPersnId();
				}
			}

			boolean foreignCountry = ParamUtil.getBoolean(actionRequest, "veteranPerson_country");
			String groupId = "";
			if(foreignCountry){
				groupId = ParamUtil.get(actionRequest, "veteranPersong_groupId", "");
			}else{
				groupId = ParamUtil.get(actionRequest, "veteranPerson_groupId", "");
			}
			if(!groupId.equals("")){vcgApplication.setGroupId(Long.parseLong(groupId));}

			CaretLocalServiceUtil.save( vcgApplication );
			
			/*
			if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_PATH) != null ){
				String path = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_PATH);
				String name = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_NAME);
				String type = FileType.CSC_1010.name();
				handleApplicationDocument( actionRequest, vcgApplication, path, name, type );				
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.FILE_PATH);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.FILE_NAME);
			}
			if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH) != null ){
				String path = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH);
				String name = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_NAME);
				String type = FileType.CSC_POA.name();
				handleApplicationDocument( actionRequest, vcgApplication, path, name, type );				
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_PATH);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_NAME);
			}
			*/
			
			if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_PATH) != null ){
				String path = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_PATH);
				String name = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_NAME);
				//String type = FileType.CSC_1010.name();
				AttachmentBean attachment = new AttachmentBean();
				attachment.setClassId(vcgApplication.getVcgAnId());
				attachment.setClassPk(PortalUtil.getClassNameId(VcgAn.class));
				attachment.setPath(path);
				attachment.setName(name);
				attachment.setType(FileType.CSC_1010.name());
				//handleApplicationDocument( actionRequest, vcgApplication, path, name, type );
				handleApplicationDocument( actionRequest, attachment);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.FILE_PATH);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.FILE_NAME);
			}
			if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH) != null ){
				String path = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH);
				String name = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_NAME);
				//String type = FileType.CSC_POA.name();
				AttachmentBean attachment = new AttachmentBean();
				attachment.setClassId(vcgApplication.getVcgAnId());
				attachment.setClassPk(PortalUtil.getClassNameId(VcgAn.class));
				attachment.setPath(path);
				attachment.setName(name);
				attachment.setType(FileType.CSC_POA.name());
				//handleApplicationDocument( actionRequest, vcgApplication, path, name, type );
				handleApplicationDocument( actionRequest, attachment);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_PATH);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_NAME);
			}

			CaretLocalServiceUtil.save( Toolbox.createWorkItem( sc, vcgApplication.getGroupId(), vcgApplication, WorkType.CSC_APP, vcgApplication.getVeteranId(), caregiverId ));
						
		} catch (SystemException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (ApplicationWorkFlowException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
	}
	
//	public void handleApplicationDocument ( PortletRequest request, VcgAn vcgApplication, String path, String name, String type) throws FileNotFoundException, SystemException {
	public void handleApplicationDocument ( PortletRequest request, AttachmentBean attachment) throws FileNotFoundException, SystemException {
		_log.info("reached handleApplicationDocument()");
		
		//File uploadFile = new File(path);
		File uploadFile = new File(attachment.getPath());
		InputStream inputStream = new FileInputStream( uploadFile );
		OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );
		
		long documId = CounterLocalServiceUtil.increment( Docum.class.getName() );
		Docum document = DocumLocalServiceUtil.createDocum(documId);
		document.setDocument(outputBlob);
		//document.setClassPk( vcgApplication.getVcgAnId() );
		//document.setClassId( PortalUtil.getClassNameId(VcgAn.class) );
		document.setClassPk( attachment.getClassPk() );
		document.setClassId( attachment.getClassId() );
		document.setType(attachment.getType());
		document.setName(attachment.getName());
		try {
			DocumLocalServiceUtil.addDocum( document );
			request.getPortletSession().removeAttribute(CaretStrPool.FILE_NAME);
			FileUtil.delete(uploadFile);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	
	public void loadAddress(ActionRequest request, Person persn, String prefix) throws ApplicationWorkFlowException {
		OnlineViewController.get().loadPersnAddress( request, persn, prefix );
	}

	
	@ProcessAction (name="searchEntry")
	public void searchEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		searchEntry(actionRequest);
	}

	public void loadCallType(PortletRequest request) throws ApplicationWorkFlowException {
		
		Map<String,Object> form = ResultMap.getForm (request);
		
		String callType = PortletProps.get("call.type");
		if ( !callType.isEmpty() ){
			String[] array = (callType + StringPool.COMMA + "soc-call").split(StringPool.COMMA) ;
			List<String> c = ListUtil.fromArray(array);
			Collections.sort(c);
			form.put( "standard-call-types", c );
		}
		form.put( CaretStrPool.CUSTOM_CALL_TYPES, BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.CUSTOM_CALL_TYPES) );
		DashboardConfigFactory.loadInstance( request, null );
	}
	
	public void loadCall(PortletRequest request) throws ApplicationWorkFlowException {
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
		
		String serviceStatus = PortletProps.get("veteran.supplemental.serviceStatuses");
		if ( !serviceStatus.isEmpty() ){
			request.setAttribute("serviceStatus", serviceStatus.split(StringPool.COMMA) );
		}
		
		Map<String,Object> form = ResultMap.getForm (request);
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		
		Map<String,Integer> total = ResultMap.getResultTotalMap( request );
		Map<String,List<?>> results = ResultMap.getResultListMap( request );
		
		
		
		try {
			long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID, 0 );
			CaretViewController controller = CaretViewController.getViewController();
			if ( callId > 0 ){
				Call call = CallLocalServiceUtil.getCall( callId );
				form.put( "call", call );
				
				Person caller = new Person(PersnLocalServiceUtil.getPersn( call.getCallerPersnId() ));
				form.put(CaretStrPool.CALLER_PERSN, caller );
				controller.loadAddress( caret, caller, CaretStrPool.CALLER_PERSN );
				
				//Start SOC
				String callerName = caller.getFirstName() +" "+caller.getLastName();
				form.put("callerName", callerName);

				loadSocAspects(request, form, call, callId);
				//End SOC
				
				//Start CESP
				loadCespAspects(request, form, call, callId);
				//End CESP
				
				
				Person person = new Person( PersnLocalServiceUtil.getPersn( call.getVeteranPersnId() ) );
				form.put(CaretStrPool.VETERAN_PERSN, person );
				controller.loadAddress( caret, person, CaretStrPool.VETERAN_PERSN );
			
				boolean enableSoc = call.getCreationDate().before( CaretParam.getSocDueDate() );
				request.setAttribute("enableSoc", enableSoc );
				//request.setAttribute("expanded", enableSoc? "collapsed": "expanded" );
				request.setAttribute("expanded", "expanded");

				List<?> l = CaretLocalServiceUtil.getCallEvents( callId );
				results.put("callEvents", l);
				total.put("callEvents", l.size());
				//TODO: come back...
				if ( CAction.canDoCaret(request, CaretCan.LOD_QA.name() ) ){
					loadBoxGroup(CaretStrPool.HEC_QUESTIONAIRE, CaretStrPool.HEC_QUESTIONAIRE);
				}
				
				
				request.setAttribute("isDisabled", CaretStrPool.CALL_STATE_COMPLETE.equals( call.getCallState() ) );
			} else {
				request.setAttribute("expanded", "expanded");
			}
			
			ResultMap.getCaretMap(request).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
			loadCallSelects( request );
			loadMoreCallInfo ( request );
			loadStatesAndFacilities( request );
			controller.loadRequiredInputs( CaretStrPool.CALL, form );
			
			request.setAttribute(CaretStrPool.ROLE, ((DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG)).getRole() );
		} catch (Exception e) {
			e.printStackTrace();
			throw new ApplicationWorkFlowException(e);
		}
		
	}

	private void loadSocAspects(PortletRequest request, Map<String,Object> form, Call call, long callId) throws PortalException, SystemException {
		
		form.put("callDate", Toolbox.formatDateCprs( call.getCreationDate() ) );
		long loggedPersnId = CaretParam.getPersnId(request);
		Person loggedUser = new Person ( PersnLocalServiceUtil.getPersn( loggedPersnId ) );
		form.put("loggedPersnId", loggedPersnId );
		form.put("loggedUserName", loggedUser.getFirstName() +" "+ loggedUser.getLastName() );
				
		List<ClSoc> socList = ClSocLocalServiceUtil.findByCallId(callId);

		int attemptNum = socList.size()+1;
		form.put("attemptNum", attemptNum);
		
		int numOfSoc = socList.size();
		form.put("numOfSoc", numOfSoc);
		
		
		if(numOfSoc > 0){	 
			List<SocBean> socHistory = new ArrayList<SocBean>();
			for(ClSoc oneSoc : socList){
				Person createdByPersn = new Person ( PersnLocalServiceUtil.getPersn( oneSoc.getPersnId() ) );
				String name = createdByPersn.getFirstName()+" "+createdByPersn.getLastName();

				SocBean oneBean = new SocBean();
				oneBean.setSoc(oneSoc);
				oneBean.setFormattedCreatedDate(Toolbox.formatDateTimeMetadata(oneSoc.getCreationDate()));
				oneBean.setCreatedByName(name);
				socHistory.add(oneBean);	
			}
			form.put("soc-history", socHistory);
		}

	}
	
	private void loadCespAspects(PortletRequest request, Map<String,Object> form, Call call, long callId) throws PortalException, SystemException {
		
		long loggedPersnId = CaretParam.getPersnId(request);
		form.put("loggedPersnId", loggedPersnId );

		//check if there are any cesp for the call
		List<Cesp> cespList = CespLocalServiceUtil.findByCallId(callId);	
		int numOfCesp = cespList.size();
		form.put("numOfCesp", numOfCesp);
		
		String cespStatus = StringPool.BLANK;

		if(numOfCesp > 0){
			form.put("step", CaretStrPool.CESP_STEP2);
				 
			List<CespBean> cespHistory = new ArrayList<CespBean>();
			for(Cesp oneCesp : cespList){
				Person createdByPersn = new Person ( PersnLocalServiceUtil.getPersn( oneCesp.getCreatedByPersnId() ) );
				String name = createdByPersn.getFirstName()+" "+createdByPersn.getLastName();

				CespBean oneBean = new CespBean();
				oneBean.setCesp(oneCesp);
				oneBean.setFormattedCreatedDate(Toolbox.formatDateTimeMetadata(oneCesp.getCreationDate()));
				oneBean.setCespCreatedByName(name);
				cespHistory.add(oneBean);	
				
				if(oneCesp.getStatus().equals(CaretStrPool.CESP_STATUS_CLOSED)){
					cespStatus = "closed";
				}
			}
			form.put("cesp-history", cespHistory);
		}else{
			form.put("step", CaretStrPool.CESP_STEP1);
		}

		form.put("cespStatus", cespStatus);
	}
	
	
	@ProcessAction (name="loadEntry")
	public void loadEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String entry = ParamUtil.get(actionRequest, "entry", StringPool.BLANK);
		_log.info("loadEntry..." +  entry );
//		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/internal/"+ action + ".jsp" );
//		_log.info("action..." +  entry );
		try{
			if ( "CREATE_REFERRAL".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_REFERRAL.name() ) ){
					loadReferral(actionRequest);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_REFERRAL_PAGE);
				}
			} else if ( "MANAGE_VCG".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.MANAGE_VCG.name() ) ){
					loadDispositionWork (actionRequest, actionResponse);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
				}
			} else if ( "CREATE_CALLS".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CALLS.name() ) ){
					loadCall (actionRequest);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
				}
			} else if ( "CREATE_CALL_TYPE".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CALL_TYPE.name() ) ){
					loadCallType (actionRequest);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.ADD_CALLTYPE_PAGE);
				}
			} else if ( "soc".equals(entry) ){
				//TODO:  CaretCan.CREATE_SOC
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CALLS.name() ) ){
					loadCall (actionRequest);
					actionRequest.setAttribute("enableSoc", true);
					actionRequest.setAttribute("isDisabled", true);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
					//			loadLetter(actionRequest);
				}
			} else if ( "cesp".equals(entry) ){
				//TODO:   CaretCan.CREATE_CESP
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CALLS.name() ) ){
					loadCall (actionRequest);
					actionRequest.setAttribute("enableCesp", true);
					actionRequest.setAttribute("isDisabled", true);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
					//			loadLetter(actionRequest);
				}
			} else if ( "cbopcWork".equals(entry) ){
	//			loadCbopcWork(actionRequest);
			} else if ( "CREATE_APPLICATIONS".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_APPLICATIONS.name() ) ){
		//			loadStatesAndFacilities( actionRequest );
					createEntry(actionRequest, actionResponse);
					long veteranId = ParamUtil.getLong(actionRequest, CaretStrPool.VETERAN_ID );
					if ( veteranId > 0 ){
						Persn person;
						try {
							person = PersnLocalServiceUtil.getPersn(veteranId);
							ResultMap.getForm(actionRequest).put(CaretStrPool.VETERAN_PERSN, new Person(person));
						} catch (PortalException e) {
							e.printStackTrace();
						} catch (SystemException e) {
							e.printStackTrace();
						}
					}
				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException ( e );
		}
	}
	
	private void searchEntry( PortletRequest request ) {
//		Map<String, Integer> total = ResultMap.getResultTotalMap( request );
//		Map<String, List<?>> results = ResultMap.getResultListMap(request);
		_log.info("searchEntry");
	}
	
	@ProcessAction (name="saveEntry")
	public void saveEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String entry = ParamUtil.get(actionRequest, "entry", StringPool.BLANK);

		_log.info("save entry..." +  entry );
		
///*		
		String tracker = ParamUtil.getString(actionRequest, CaretStrPool.TRACKER, StringPool.BLANK );
		if ( ! CaretParam.isTracked( actionRequest, tracker, true ) ){
			_log.warn("TRACKER BLOCKING action... ");
			actionRequest.setAttribute(CaretStrPool.INVALID_REQUEST, true);
			return;
		}
//*/
		try {
			if ( "vcg".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.MANAGE_VCG.name() ) ){
					saveVcgEntry(actionRequest, actionResponse);
				}
			} else if ( "CREATE_REFERRAL".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_REFERRAL.name() ) ){
					saveReferral(actionRequest);
				}
			} else if ( "CREATE_CALLS".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CALLS.name() ) ){
					saveCall(actionRequest);
				}
			} else if ( "soc".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_SOC.name() ) ){
					saveSoc(actionRequest);
				}
			}else if("cesp".equals(entry)){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CESP.name() ) ){
					saveCesp(actionRequest);
				}
			}else if ( "vcgAn".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_APPLICATIONS.name() ) ){
					saveVcgAn(actionRequest);
				}
			}else if ( "cscWaiver".equals(entry) ){				
				saveCSCWaiver(actionRequest);
			}
									
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException ( e );
		}
	}
	
	
	private void loadCallSelects(PortletRequest request ) throws ApplicationWorkFlowException{
		Map<String,Object> form = ResultMap.getForm (request);
		
		String callType = PortletProps.get("call.type");
		if ( !callType.isEmpty() ){
			form.put( "standard-call-types", callType.split(StringPool.COMMA) );
		}
		form.put( "custom-call-types", BoxGpLocalServiceUtil.getBoxGroups("custom-call-types") );
		
		
		String callerLearnAbout = PortletProps.get("call.callerLearnAbout");
		if ( !callerLearnAbout.isEmpty() ){
			request.setAttribute("callerLearnAbout", callerLearnAbout.split(StringPool.COMMA) );
		}
		String callerCaregiverType = PortletProps.get("call.callerCaregiverType");
		if ( !callerCaregiverType.isEmpty() ){
			request.setAttribute("callerCaregiverType", callerCaregiverType.split(StringPool.COMMA) );
		}
		
		loadRelationshipLists(request);
	}
	
	private void loadMoreReferralInfo ( PortletRequest request, long veteranId ) throws ApplicationWorkFlowException{
		
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.REFERRAL_QUESTIONAIRE_YN);
		
		if ( groups.isEmpty() ){
			groups = new ArrayList<BoxGp>();
			int i = 0;
			for ( String subgroup: PortletProps.get( CaretStrPool.REFERRAL_QUESTIONAIRE_YN ).split( StringPool.SEMICOLON ) ){
				Toolbox.initYesNoBoxGp(subgroup, CaretStrPool.REFERRAL_QUESTIONAIRE_YN, groups, i);
				i = i + 2;
			}
		}

		Map<String,List<BoxGp>> boxGpMap = new HashMap<String,List<BoxGp>>();
		int i = 0;
		List<BoxGp> boxGpList = new ArrayList<BoxGp>(5);
		for ( BoxGp boxGp: groups ){
			boxGpList.add( boxGp );
			if ( i % 2 == 1 ){
				boxGpMap.put( boxGp.getBoxSubGroup(), boxGpList );
				boxGpList = new ArrayList<BoxGp>(5);
			}
			i++;
		}
		ResultMap.getForm(request).put( CaretStrPool.BOX_GROUP, boxGpMap );
		
		if ( veteranId > 0 ){
			Map<Long,Boolean> bgAsn =  new CaretMap<Long,Boolean>( false );
			ResultMap.getForm(request).put("bgAsn_", bgAsn);
			for ( BgAsn bgAsn0: BoxGpLocalServiceUtil.getBoxGroupAssociations( veteranId, true ) ) {
				bgAsn.put( bgAsn0.getBoxGpId(), true );
			}
		}		
		
		if ( CAction.canDoCaret(request, CaretCan.LOD_QA.name() ) ){
			boxGpMap.put(CaretStrPool.HEC_QUESTIONAIRE, loadBoxGroup( CaretStrPool.HEC_QUESTIONAIRE, CaretStrPool.HEC_QUESTIONAIRE) );
		}
	}
	
	private void loadMoreCallInfo ( PortletRequest request ) throws ApplicationWorkFlowException{
		
		String serviceBranches = PortletProps.get("call.serviceBranches");
		if ( !serviceBranches.isEmpty() ){
			request.setAttribute("serviceBranches", serviceBranches.split(StringPool.COMMA) );
		}
		
		String eraServiceTypes = PortletProps.get("call.eraServiceTypes");
		if ( !eraServiceTypes.isEmpty() ){
			request.setAttribute("eraServiceTypes", eraServiceTypes.split(StringPool.COMMA) );
		}
		
		long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID, 0 );
//		Set<Long> bgAsnSet = new HashSet<Long>();
		
		Map<Long,Boolean> boxGrp =  new CaretMap<Long,Boolean>( false );
		
		Map<String, Object> form = ResultMap.getForm(request);
		form.put("boxGrp_", boxGrp);
		
		if ( callId > 0 ){
			for ( BgAsn bgAsn0: BoxGpLocalServiceUtil.getBoxGroupAssociations( callId, true ) ) {
				boxGrp.put( bgAsn0.getBoxGpId(), true );
			}
		}
		ResultMap.getForm(request);
//		form.put( subName, groups );
		form.put( "veteran-primary-diagnosis", loadBoxGroup ( "veteran-primary-diagnosis", "veteran-primary-diagnosis" ) );
		form.put( "other-primary-diagnosis", loadBoxGroup ( "other-primary-diagnosis", "other-primary-diagnosis" ) );
		form.put( "public-law-111-163-reasons", loadBoxGroup ( "public-law-111-163-reasons", "public-law-111-163-reasons") );
		form.put( "heard-from-us", loadBoxGroup ( "heard-from-us", "heard-from-us" ) );
		form.put( "support-lines-transfer", loadBoxGroup ( "support-lines", "support-lines-transfer") );
		form.put( "support-lines-number-provided", loadBoxGroup ( "support-lines", "support-lines-number-provided") );
		form.put( "interventions-applied-family", loadBoxGroup ( "interventions-applied", "interventions-applied-family") );
		form.put( "interventions-applied-care", loadBoxGroup ( "interventions-applied", "interventions-applied-care") );
		form.put( "interventions-applied-respite", loadBoxGroup ( "interventions-applied", "interventions-applied-respite") );
		form.put( "interventions-applied-counseling", loadBoxGroup ( "interventions-applied", "interventions-applied-counseling") );
		form.put( "interventions-applied-directives", loadBoxGroup ( "interventions-applied", "interventions-applied-directives") );
		form.put( "interventions-applied-other", loadBoxGroup ( "interventions-applied", "interventions-applied-other") );
	}
	
	public List<BoxGp> loadBoxGroup ( String name, String subName ) throws ApplicationWorkFlowException {
		
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(name, subName);
		if ( groups.isEmpty() ){
			groups = Toolbox.initBoxGroup(name, subName);
		}
		return groups;
//		ResultMap.getForm(request).put( subName, groups );
	}
	
	public void loadReferral(PortletRequest request) throws ApplicationWorkFlowException {
		
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );

		String serviceStatus = PortletProps.get("veteran.supplemental.serviceStatuses");
		if ( !serviceStatus.isEmpty() ){
			request.setAttribute(CaretStrPool.SERVICE_STATUS, serviceStatus.split(StringPool.COMMA) );
		}
		Map<String,Object> form = ResultMap.getForm( request );
		try {
			CaretViewController controller = CaretViewController.getViewController();
			long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID, 0 );
			long veteranId = 0;
			if ( callId > 0 ){
				Map<String,Object> caret = ResultMap.getCaretMap(request);
				
				Call call = CallLocalServiceUtil.getCall( callId );
				form.put( CaretStrPool.CALL, call );
				
				Person person = new Person( PersnLocalServiceUtil.getPersn( call.getCallerPersnId() ) );
				form.put(CaretStrPool.CALLER_PERSN, person );
				controller.loadAddress( caret, person, CaretStrPool.CALLER_PERSN );
				veteranId = call.getVeteranPersnId();
				person = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
				form.put(CaretStrPool.VETERAN_PERSN, person );
				controller.loadAddress( caret, person, CaretStrPool.VETERAN_PERSN );
			}
			
			loadCallSelects( request );
			loadMoreReferralInfo(request, veteranId );
			
			ResultMap.getCaretMap(request).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
			
			loadStatesAndFacilities( request );

			DashboardConfig config = (DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG);
			if ( config != null ){
				request.setAttribute(CaretStrPool.ROLE, config.getRole() );
			}
			controller.loadRequiredInputs( CaretStrPool.REFFERAL, form );
			
			
			List<Docum> supportDocs = DocumLocalServiceUtil.getByClassId( callId );			
			
			if ( !supportDocs.isEmpty() ){
				form.put("supportDocs", supportDocs );
			} 
			
		} catch (Exception e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	
	public void takeOwnership ( ActionRequest request, ActionResponse actionResponse ){
		_log.info("takeOwnership");
		
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			WorIm workItem = WorImLocalServiceUtil.getWorIm(worImId);
			workItem.setUserId( sc.getUserId() );
			workItem.setStatus(WorkStatus.IN_PROCESS.name());
			CaretLocalServiceUtil.save(workItem);
			
			updateVcgAnStatus(workItem);
			
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
		
	}

	public void assignTo ( ActionRequest request, ActionResponse actionResponse ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		long userId = ParamUtil.getLong(request, "form_userName");
		if ( primKey > 0 && userId > 0 ){
			try {
				WorIm workItem = WorImLocalServiceUtil.getWorIm(primKey);
				workItem.setUserId(userId);
				workItem.setStatus(WorkStatus.IN_PROCESS.name());
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				CaretLocalServiceUtil.save( workItem );
				CaretLocalServiceUtil.addNote( 
						Toolbox.createNote( 
								sc.getCreateDate(),
								workItem.getWorImId(),
								workItem.getGroupId(),
								sc.getUserId(),
								ParamUtil.get(request,
										CaretStrPool.WORK_COMMENT, StringPool.BLANK ) ) );

				updateVcgAnStatus(workItem);
				
			} catch (PortalException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			} 
		}		
	}
	
	
	public void updateVcgAnStatus ( WorIm workItem ){
		
		try{
			String[] types = PortletProps.get(CaretStrPool.APP_TYPES).split(StringPool.COMMA);
			
			boolean updateStatus = false;
			for (String appType: types) { 
				if(workItem.getType().equals(appType))
				{
			         updateStatus = true;
			    }
			}
			
			if(updateStatus)
			{	
				long vcgAnId = workItem.getClassPk();
				VcgAn vcgAn = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
				vcgAn.setStatus("IN_PROCESS");
				VcgAnLocalServiceUtil.updateVcgAn(vcgAn);
			}
			
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}		
	}

	
	public void facilTransfer ( ActionRequest request, ActionResponse actionResponse ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		long groupId = ParamUtil.getLong(request, "transfer_groupId");
		if ( primKey > 0 && groupId > 0 ){
			try {
				WorIm workItem = WorImLocalServiceUtil.getWorIm(primKey);
				workItem.setQueId(groupId);
				workItem.setStatus(WorkStatus.TRANSFER_REQUESTED.name());
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				CaretLocalServiceUtil.save( workItem );
				CaretLocalServiceUtil.addNote( 
						Toolbox.createNote( 
								sc.getCreateDate(),
								workItem.getWorImId(),
								workItem.getGroupId(),
								sc.getUserId(),
								ParamUtil.get(request,
										CaretStrPool.WORK_COMMENT, StringPool.BLANK ) ) );
			} catch (PortalException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			} 
		}
		
	}
	
	public void acceptTransfer ( ActionRequest request, ActionResponse actionResponse ) throws PortalException, SystemException{
		//TODO: 
		boolean accept = ParamUtil.getBoolean(request, "transfer");
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		if ( worImId > 0 ){
			WorIm workItem = WorImLocalServiceUtil.getWorIm(worImId);
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			if ( accept ){
				workItem.setGroupId( workItem.getQueId() );
				workItem.setQueId( 0 );
				workItem.setStatus(WorkStatus.IN_PROCESS.name());
				workItem.setUserId( sc.getUserId() );
			} else {
				workItem.setStatus(WorkStatus.TRANSFER_REJECTED.name());
				workItem.setQueId( 0 );
			}
			CaretLocalServiceUtil.addNote( 
					Toolbox.createNote( 
							sc.getCreateDate(),
							workItem.getWorImId(),
							workItem.getGroupId(),
							sc.getUserId(),
							ParamUtil.get(request,
									CaretStrPool.WORK_COMMENT, StringPool.BLANK ) ) );
			CaretLocalServiceUtil.save( workItem );
		}
		
	}

	
	@ProcessAction (name="createEntry")
	public void createEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String entry = ParamUtil.get(actionRequest, "entry", StringPool.BLANK);
		_log.info("createEntry..." +  entry );
		
		actionRequest.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( actionRequest ) );
		ResultMap.getCaretMap(actionRequest).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
		loadStatesAndFacilities( actionRequest );
		loadRelationshipLists( actionRequest );
		
		actionRequest.setAttribute("isDisabled", true);
		
		Map<String,Object> form = ResultMap.getForm (actionRequest);
		CaretViewController controller = CaretViewController.getViewController();
		controller.loadRequiredInputs( CaretStrPool.VETERAN_PERSN, form );
		controller.loadRequiredInputs( CaretStrPool.PRIMARY_PERSN, form );
		controller.loadRequiredInputs( CaretStrPool.SECONDARY_PERSN, form );
		controller.loadRequiredInputs( CaretStrPool.SECONDARY_TWO_PERSN, form );

		try {
			String  extensions = StringUtil.merge(PrefsPropsUtil.getStringArray(PropsKeys.DL_FILE_EXTENSIONS, StringPool.COMMA));
			long maxSize = Long.parseLong(PrefsPropsUtil.getString(PropsKeys.DL_FILE_MAX_SIZE)) / 1024;
			//_log.info("extensions = " + extensions + ", maxSize=" + maxSize );
			form.put("extensions",  extensions );
			form.put("maxSize",  maxSize );
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.CREATE_APPLICATION_PAGE);
	}
	
	
	public void loadRelationshipLists ( PortletRequest request ) {
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		if ( CAction.canDoCaret( request, CAction.CaretCan.CSL_FAMILY_RELATIONSHIPS.name() ) ){
			caret.put( CaretStrPool.RELATIONSHIP_NOT_FAMILY, PortletProps.get(CaretStrPool.CSL_RELATIONSHIP_NOT_FAMILY).split(StringPool.COMMA) );
			caret.put( CaretStrPool.RELATIONSHIP_FAMILY, PortletProps.get(CaretStrPool.CSL_RELATIONSHIP_FAMILY).split(StringPool.COMMA) );
		} else {
			caret.put( CaretStrPool.RELATIONSHIP_NOT_FAMILY, PortletProps.get(CaretStrPool.RELATIONSHIP_NOT_FAMILY).split(StringPool.COMMA) );
			caret.put( CaretStrPool.RELATIONSHIP_FAMILY, PortletProps.get(CaretStrPool.RELATIONSHIP_FAMILY).split(StringPool.COMMA) );
		}
	}
	
	@ProcessAction (name="uploadFile")
	public void uploadFile ( ActionRequest request, ActionResponse actionResponse ) throws FileNotFoundException{
		UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest(request);
		
		String type = ParamUtil.get(request, "type", StringPool.BLANK);
		//_log.info("file type is : "+type);

		
		long size = uploadRequest.getSize("file");
		//_log.info("size=" + size );
		if ( size == 0 ){
			_log.info("returning since size is 0...");
			return;
		}

		File uploadFile = uploadRequest.getFile("file");
		String tempLocation = PortletProps.get(CaretStrPool.FILE_TEMP_STORE);
		String name = uploadRequest.getFileName("file");
		
		File file = new File(tempLocation + name);
		try {
			FileUtil.copyFile( uploadFile, file );
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		//_log.info("path is ... " + uploadFile.getPath() + ", name=" + name );
		//String filePath = "";
		//String fileName = "";
		if(CaretStrPool.TEN_TEN_CG.equals(type) ){
			//filePath = CaretStrPool.FILE_PATH;
			//fileName = CaretStrPool.FILE_NAME;
			request.getPortletSession().setAttribute(CaretStrPool.FILE_PATH, file.getPath() );
			request.getPortletSession().setAttribute(CaretStrPool.FILE_NAME, name);
		} else if( CaretStrPool.POA.equals(type) ){
			//filePath = CaretStrPool.POA_FILE_PATH;
			//fileName = CaretStrPool.POA_FILE_NAME;			
			request.getPortletSession().setAttribute(CaretStrPool.POA_FILE_PATH, file.getPath() );
			request.getPortletSession().setAttribute(CaretStrPool.POA_FILE_NAME, name);
		} else {
			request.getPortletSession().setAttribute(CaretStrPool.FILE_PATH, file.getPath() );
			request.getPortletSession().setAttribute(CaretStrPool.FILE_NAME, name);
		}
		_log.info("path is ... " + file.getPath() + ", name=" + name );
	}


	
	@ProcessAction (name="cscWaiver")
	public void cscWaiver( ActionRequest actionRequest, ActionResponse actionResponse ) {
		_log.info("cscWaiver....");
		actionRequest.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( actionRequest ));
		
		String workItemId = ParamUtil.get(actionRequest, "workItemId", StringPool.BLANK);
		String vcgAnId = ParamUtil.get(actionRequest, "vcgAnId", StringPool.BLANK);
		String receivedDate = ParamUtil.get(actionRequest, "receivedDate", StringPool.BLANK);
		String daysPassed = ParamUtil.get(actionRequest, "daysPassed", StringPool.BLANK);
				
		Map<String,Object> form = ResultMap.getForm (actionRequest);
		form.put("workItemId", workItemId);
		form.put("vcgAnId", vcgAnId);
		form.put("receivedDate", receivedDate);
		form.put("daysPassed", daysPassed);
		
		try {
			long loggedPersnId = CaretParam.getPersnId(actionRequest);
			form.put("loggedPersnId", loggedPersnId );
		} catch (ApplicationWorkFlowException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.CSC_WAIVER_PAGE);
	}

	
	public void saveCSCWaiver( ActionRequest actionRequest) throws ApplicationWorkFlowException {
		getOutput(actionRequest);
		
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
			Waivr w = new WaivrImpl();
			Waivr waiver = (Waivr) CaretParam.loadModel(actionRequest, new WaivrImpl(), w.getModelAttributes().keySet(), CaretStrPool.WAIVER_UNDERLINE);
			waiver.setCreationDate(new Date());
			
			CaretLocalServiceUtil.save( waiver );
									
		} catch (ApplicationWorkFlowException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
	}

	
	private static Log _log = LogFactoryUtil.getLog( CaretActionCommand.class );
}
