package gov.va.caret.portlet;


import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.CaretViewController;
import gov.va.caret.portlet.action.CaretActionCommand;
import gov.va.caret.portlet.resource.CaretResourceCommand;
import gov.va.caret.security.CAction;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.ZipFyLocalServiceUtil;
import gov.va.caret.service.ctssh.CTSSHFacade;
import gov.va.caret.view.BootStrapUtil;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;

import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;


public class CaretPortlet extends CaretBasePortlet {
	
	public void init() throws PortletException {
		
		super.init();
		
		this.actionCommand = new CaretActionCommand();
		this.resourceCommand = new CaretResourceCommand();
		this.viewController = CaretViewController.getViewController();

		_log.info( "Initializing " + viewController.getVersion() );
		_log.info( "on " + ReleaseInfo.getReleaseInfo() );
			
		if ( StringPool.TRUE.equals(PortletProps.get("init.bootstrap.enabled") ) ){
			try {
				if ( OrganizationLocalServiceUtil.getOrganizationsCount() < 20 ){
					_log.info("begin bootstrap orgs...");
					BootStrapUtil.bootstrapOrgs( getPortletContext() );
				}
				_log.info("begin bootstrap persn...");
				BootStrapUtil.bootstrapPersonTable();
	
				if ( ZipFyLocalServiceUtil.getZipFiesCount() < 5 ){
					_log.info("begin bootstrap facility zip...");
					BootStrapUtil.bootstrapFacZip( getPortletContext() );
				}
	
				int	count = BlsReLocalServiceUtil.getBlsResCount();
				_log.info("bls zip count=" + count );
				if ( count < 50 ){
					_log.info("begin bootstrap bls Rates...");
					BootStrapUtil.loadBlsRate( getPortletContext() );
				}
				_log.info("init completed...");
			} catch (ApplicationWorkFlowException e1) {
				e1.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			} catch (PortalException e) {
				e.printStackTrace();
			}
		}
		if ( StringPool.TRUE.equals( PortletProps.get( "search.mvi.attended.enabled" ) ) ){
			String realPath = getPortletContext().getRealPath("templates") ;
			
			if ( realPath != null ) {
				CTSSHFacade.init( realPath );
		    } else {
		    	boolean ctsshInitd = false;
		    	try {
		    		_log.warn("path was null trying getResource()");
					CTSSHFacade.init( getPortletContext().getResource( "templates" ).toURI().toString() );
					ctsshInitd = true;
				} catch (MalformedURLException e) {
					_log.warn( "Malformed url error:" + e.getMessage() );
				} catch (URISyntaxException e) {
					_log.warn( "URI Syntax error:" + e.getMessage() );
				}
		    	if ( !ctsshInitd ){
		    		_log.warn( "CTSSHFacade:using null default" );
		    		CTSSHFacade.init( null );
		    	}
		    }
		}
		
	}
	
	protected void include( String path, RenderRequest renderRequest, RenderResponse renderResponse)
			throws IOException, PortletException {
		if ( CAction.canDoCaret( renderRequest, CAction.VIEW ) ){
//			CaretParam.loadPermission(renderRequest);
			super.include(path,renderRequest, renderResponse);
		}else {
			_log.info("VIEW needed");
		}
	}
	
	private static Log _log = LogFactoryUtil.getLog(CaretPortlet.class);

}