package gov.va.caret.pdf;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.model.support.Person;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;

import java.util.List;
import java.util.Locale;

import org.apache.pdfbox.pdmodel.PDDocument;

public class VaForm1010cgFields {

	
	private Person veteran;
	private Person primary;
	private Person secondary;
	private Person secondaryTwo;
	private boolean vaHealthEnrolled;
	private String lastTreatmentPlace;
	private String preferredFacility;
	private boolean hospital;
	private boolean clinic;
	private boolean mediEnrolled;
	private String otherHealthInsurance;
	private String primaryRelationship;
	private String secondaryRelationship;
	private String secondaryTwoRelationship;
	private boolean primaryFamily;
	private boolean secondaryFamily;
	private boolean secondaryTwoFamily;
	private boolean otherHealthInsuranceYes;
	private PDDocument pdfDoc = null;
	private String personCategory;
	private boolean veteranPreview = false;
	private boolean primaryPreview = false;
	private boolean secondaryPreview = false;

	
	final static Person nullPerson = Person.DEFAULT_PERSON;
	
	public void setVeteranPreview( boolean isSectionPreview ){
		this.veteranPreview = isSectionPreview; 
	}
	
	public boolean isVeteranPreview(){
		return veteranPreview;
	}
	
	public void setPrimaryPreview( boolean isSectionPreview ){
		this.primaryPreview = isSectionPreview; 
	}

	public void setSecondaryPreview(boolean isSectionPreview) {
		this.secondaryPreview = isSectionPreview;
	}

	public boolean isPrimaryPreview() {
		return false;
	}
	
	public boolean isSecondaryPreview() {
		return false;
	}
	
	private Person nullSafe ( Person persn ){
		return persn == null? nullPerson : persn;
	}

	public VaForm1010cgFields(Person veteran, Person primary, Person secondary,
				Person secondaryTwo, boolean vaHealthEnrolled, String preferredFacility,
				String lastTreatmentPlace, boolean hospital, boolean clinic,
				boolean mediEnrolled, String otherHealthInsurance,
				String primaryRelationship, String secondaryRelationship,
				String secondaryTwoRelationship, PDDocument pdfDoc,
				String personCategory) {

		super();
		this.veteran = veteran;
		this.primary = primary;
		this.secondary = secondary;
		this.secondaryTwo = secondaryTwo;
		this.vaHealthEnrolled = vaHealthEnrolled;
		this.lastTreatmentPlace = lastTreatmentPlace;
		this.preferredFacility = preferredFacility;
		this.hospital = hospital;
		this.clinic = clinic;
		this.mediEnrolled = mediEnrolled;
		this.otherHealthInsurance = otherHealthInsurance;
		this.primaryRelationship = primaryRelationship;
		this.secondaryRelationship = secondaryRelationship;
		this.secondaryTwoRelationship = secondaryTwoRelationship;
		this.pdfDoc = pdfDoc;
		this.personCategory = personCategory;
		
		this.otherHealthInsuranceYes = !Toolbox.isEmpty( otherHealthInsurance );
		this.primaryFamily = Toolbox.isFamily(primaryRelationship);
		this.secondaryFamily = Toolbox.isFamily(secondaryRelationship);
		this.secondaryTwoFamily = Toolbox.isFamily(secondaryTwoRelationship);
	}

	
	public Person getVeteran() {
		return nullSafe(veteran);
	}

	public Person getPrimary() {
		return nullSafe(primary);
	}

	public Person getSecondary() {
		return nullSafe(secondary);
	}

	public Person getSecondaryTwo() {
		return nullSafe(secondaryTwo);
	}

	public boolean isVaHealthEnrolledYes() {
		return primaryPreview || secondaryPreview ? false : vaHealthEnrolled;
	}
	
	public boolean isVaHealthEnrolledNo() {
		return primaryPreview || secondaryPreview ? false : !vaHealthEnrolled;
	}

	public String getLastTreatmentPlace() {
		return lastTreatmentPlace;
	}

	public boolean isHospital() {
		return hospital;
	}

	public boolean isClinic() {
		return clinic;
	}

	public boolean isMediEnrolled() {
		return veteranPreview || secondaryPreview ? false : mediEnrolled;
	}
	
	public boolean isNotMediEnrolled() {
		return veteranPreview || secondaryPreview ? false : !mediEnrolled;
	}

	public String getOtherHealthInsurance() {
		return otherHealthInsurance;
	}

	public String getPrimaryRelationship() {
		return LanguageUtil.get(Locale.getDefault(), primaryRelationship);
	}

	public String getSecondaryRelationship() {
		return LanguageUtil.get(Locale.getDefault(), secondaryRelationship);
	}

	public String getSecondaryTwoRelationship() {
		return LanguageUtil.get(Locale.getDefault(), secondaryTwoRelationship);
	}

	public boolean isPrimaryFamily() {
		return veteranPreview? false : primaryFamily;
	}
	
	public boolean isPrimaryNotFamily() {
		return veteranPreview? false : !primaryFamily;
	}

	public boolean isSecondaryFamily() {
		return veteranPreview? false : secondaryFamily;
	}
	
	public boolean isSecondaryNotFamily() {
		return veteranPreview? false : !secondaryFamily;
	}

	public boolean isSecondaryTwoFamily() {
		return veteranPreview? false : secondaryTwoFamily;
	}
	
	public boolean isSecondaryTwoNotFamily() {
		return veteranPreview? false : !secondaryTwoFamily;
	}
	
	public boolean isOtherHealthInsuranceYes() {
		return veteranPreview || secondaryPreview ? false : otherHealthInsuranceYes;
	}
	
	public boolean isOtherHealthInsuranceNo() {
		return veteranPreview || secondaryPreview ? false : !otherHealthInsuranceYes;
	}
	
	public String getVaMedicalCenter() {
		return preferredFacility;
	}

	public String getPreferredFacility(){
		return preferredFacility;
	}

	public PDDocument getPdfDoc() {
		return pdfDoc;
	}

	public String getPersonCategory() {
		return personCategory;
	}

	public boolean isCaregiverPreview() {
		return primaryPreview || secondaryPreview;
	}
}
