package gov.va.caret.pdf;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.model.support.Person;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import javax.portlet.PortletRequest;

import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;

public class PopulatePDFImpl implements PopulatePDF{
	
	public static final String FORM = "/form/1010CG_08282014.pdf";
	private static Log _log = LogFactoryUtil.getLog(PopulatePDFImpl.class);
	
	public void generateAndPopulatePDF(PortletRequest request, VaForm1010cgFields vaForm1010cg) throws COSVisitorException, IOException{
		
		PDDocument pdfDoc = vaForm1010cg.getPdfDoc();
			
        PDDocumentCatalog docCatalog = pdfDoc.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm(); 
        
        acroForm.setXFA(null);	     	        
        
        printFields(pdfDoc, vaForm1010cg); 
        
        String tempLocation = PortletProps.get(CaretStrPool.FILE_TEMP_STORE);
        String name = "1010CG_" + DateUtil.newTime() + ".pdf";
   
		pdfDoc.save(tempLocation + name); // save changes to another file
		pdfDoc.close();
		
		request.setAttribute(CaretStrPool.TEN_TEN_FILE, name ); // tempLocation + name);
		
		
  }

	public void getPDF(PortletRequest resourceRequest, 
			VaForm1010cgFields vaForm1010cg, 
			ByteArrayOutputStream output) throws COSVisitorException, IOException  {
		
        vaForm1010cg.getPdfDoc().getDocumentCatalog().getAcroForm().setXFA(null);
		
		printFields( vaForm1010cg.getPdfDoc(), vaForm1010cg );
		vaForm1010cg.getPdfDoc().save( output );
		
	}
	
  
  public void printFields( PDDocument pdfDocument, VaForm1010cgFields vaForm1010cg)
  {
  	PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
      PDAcroForm acroForm = docCatalog.getAcroForm();
      List fields;
      try {
    	  fields = acroForm.getFields();
    	  Iterator fieldsIter = fields.iterator();
 
    	  _log.info(new Integer(fields.size()).toString() + " top-level fields were found on the form");
 
	      while( fieldsIter.hasNext())
	      {
	          PDField field = (PDField)fieldsIter.next();
	          processField(field, "|--", field.getPartialName(), vaForm1010cg);
	      }
	  	} catch (IOException e) {
			e.printStackTrace();
		}
  }
  
  private void processField(PDField field, String sLevel, String sParent, VaForm1010cgFields vaForm1010cg)
  {
  	List kids;
	try {
		 kids = field.getKids();
	     if(kids != null)
	     {
	      	Iterator kidsIter = kids.iterator();
	          if(!sParent.equals(field.getPartialName()))
	          {
	              sParent = sParent + "." + field.getPartialName();
	          }
	          //System.out.println(sLevel + sParent);
	          while(kidsIter.hasNext())
	          {
	               Object pdfObj = kidsIter.next();
	               if(pdfObj instanceof PDField)
	               {
	                    PDField kid = (PDField)pdfObj;
	                    processField(kid, "|  " + sLevel, sParent, vaForm1010cg);
	                }
	           }
	       }
	       else
	       {
	      	  //String outputString = sLevel + sParent + "." + field.getPartialName() + " = " + field.getValue() + ", (" + field.getAlternateFieldName() + ") ,  type=" + field.getClass().getName();
	      	  //System.out.println(outputString);
	    	   
	    	  field.setReadonly(true);
	                    	 	      	 
	      	  Person  veteran = vaForm1010cg.getVeteran();
	      	  Person primary = vaForm1010cg.getPrimary();
	      	  Person secondary = vaForm1010cg.getSecondary();
	      	  Person secondaryTwo = vaForm1010cg.getSecondaryTwo();
	      	 
	      	  //all fields
	      	  // ==> Veteran Info ==
		      if(veteran!=null && ( vaForm1010cg.isCaregiverPreview() || CaretStrPool.PERSON_CATEGORY_VETERAN.equals(vaForm1010cg.getPersonCategory()) ) ){
		      	if(field.getPartialName().equals("TextField3[0]") && isNotEmpty(veteran.getLastName())){        		
		      		 field.setValue(veteran.getLastName());
		        }else if(field.getPartialName().equals("TextField3[1]") && isNotEmpty(veteran.getFirstName())){
		         	field.setValue(veteran.getFirstName());
		        }else if(field.getPartialName().equals("TextField3[2]") && isNotEmpty(veteran.getMiddleName())){
		        	field.setValue(veteran.getMiddleName());
		        }else if(field.getPartialName().equals("TextField3[3]") && veteran.getBirthDate()!=null){
		        	field.setValue(Toolbox.formatDatePdf( veteran.getBirthDate() ));
		       	}else if(field.getPartialName().equals("TextField3[4]") && isNotEmpty(veteran.getSsn())){
		       		field.setValue(veteran.getSsn());
		        }else if(field.getPartialName().equals("CheckBox1[0]") && isNotEmpty(veteran.getGender()) && veteran.getGender().equals(CaretStrPool.GENDER_TYPE_MALE)){
		      		((PDCheckbox) field).check();
		        }else if(field.getPartialName().equals("CheckBox2[0]") && isNotEmpty(veteran.getGender()) && veteran.getGender().equals(CaretStrPool.GENDER_TYPE_FEMALE)){
		        	((PDCheckbox) field).check();
		        }else if(field.getPartialName().equals("TextField3[14]") && isNotEmpty(vaForm1010cg.getLastTreatmentPlace())){
		         	field.setValue(vaForm1010cg.getLastTreatmentPlace());
		        }else if(field.getPartialName().equals("CheckBox1[1]") && vaForm1010cg.isHospital()){ //hospital
		         	((PDCheckbox) field).check();
		       	}else if(field.getPartialName().equals("CheckBox2[1]") && vaForm1010cg.isClinic()){ // clinic
		       		((PDCheckbox) field).check();
		        }else if(field.getPartialName().equals("TextField3[6]") && isNotEmpty(veteran.getAddress())){ //address
		       		field.setValue(veteran.getAddress());
		        }else if(field.getPartialName().equals("TextField3[7]") && isNotEmpty(veteran.getCity())){ //city
		        	field.setValue(veteran.getCity());
		       	}else if(field.getPartialName().equals("TextField3[8]") && isNotEmpty(veteran.getState())){ //state
		       		field.setValue(veteran.getState());
		        }else if(field.getPartialName().equals("TextField3[9]") && veteran.getZip()!=null){ //zip
		        	field.setValue(String.valueOf(veteran.getZip()));
		        }else if(field.getPartialName().equals("TextField3[10]") && isNotEmpty(veteran.getPhone())){ // phone
		        	field.setValue(veteran.getPhone());
		        }else if(field.getPartialName().equals("TextField3[11]") && isNotEmpty(veteran.getPhone2())){ //cell phone
		        	field.setValue(veteran.getPhone2());                	
		       	}else if(field.getPartialName().equals("TextField3[12]") && isNotEmpty(vaForm1010cg.getVaMedicalCenter()) ){ //va med center/clinic where you plan to receive treatment - TODO
		       		field.setValue(vaForm1010cg.getVaMedicalCenter());
		        }else if(field.getPartialName().equals("TextField3[13]") && isNotEmpty(veteran.getEmail())){ //email
		        	field.setValue(veteran.getEmail());
		        }else if(field.getPartialName().equals("CheckBox1[2]") && vaForm1010cg.isVaHealthEnrolledYes()){ //enrolled in va healthcare - yes
		        	((PDCheckbox) field).check();
		        }else if(field.getPartialName().equals("CheckBox2[2]") && vaForm1010cg.isVaHealthEnrolledNo()){ // enrolled in va healthcare - no
		        	((PDCheckbox) field).check();
		       	}else if(field.getPartialName().equals("TextField3[20]")){ //veteran esignature TODO	 
		       		//to get x and y coordinates of the signature field
		       		PDRectangle r = field.getWidget().getRectangle();
	                float llx = r.getLowerLeftX();
	                float lly = r.getLowerLeftY();
	                float urx = r.getUpperRightX();
	                float ury = r.getUpperRightY();
	                //System.out.println(field.getPartialName() + "   " + llx + "/" + lly);
	        		//fieldValue = "Veteran Signature";
	                //field.setValue("Veteran Signature");
	         	}else if(field.getPartialName().equals("TextField3[5]")){ //veteran e-signature date TODO
	         		//field.setValue("Veteran sign date");
	         	} 
		      }
	        	 
	      	 
		      // ==> Primary Caregiver ==
		      if(primary!=null && ( vaForm1010cg.isVeteranPreview() || CaretStrPool.PERSON_CATEGORY_PRIMARY.equals(vaForm1010cg.getPersonCategory()) ) )
		      {

		       	 if(field.getPartialName().equals("TextField3[17]") && isNotEmpty(primary.getLastName())){
		        	field.setValue(primary.getLastName());
	        	 }else if(field.getPartialName().equals("TextField3[16]") && isNotEmpty(primary.getFirstName())){
	        		 field.setValue(primary.getFirstName());
	        	 }else if(field.getPartialName().equals("TextField3[15]") && isNotEmpty(primary.getMiddleName())){
	         		 field.setValue(primary.getMiddleName());
	         	 }else if(field.getPartialName().equals("TextField3[18]") && isNotEmpty(primary.getSsn())){
	         		 field.setValue(primary.getSsn());
	         	 }else if(field.getPartialName().equals("TextField3[19]") && primary.getBirthDate()!=null){
	         		 field.setValue(Toolbox.formatDatePdf( primary.getBirthDate()) );
	         	 }else if(field.getPartialName().equals("CheckBox1[3]") && isNotEmpty(primary.getGender()) && primary.getGender().equals(CaretStrPool.GENDER_TYPE_MALE)){
	         		 ((PDCheckbox) field).check();
	        	 }else if(field.getPartialName().equals("CheckBox2[3]") && isNotEmpty(primary.getGender()) && primary.getGender().equals(CaretStrPool.GENDER_TYPE_FEMALE)){
	        		((PDCheckbox) field).check();
	         	 }else if(field.getPartialName().equals("TextField3[21]") && isNotEmpty(primary.getAddress())){
	        		field.setValue(primary.getAddress());
	         	 }else if(field.getPartialName().equals("TextField3[22]") && isNotEmpty(primary.getCity())){//city
	         		field.setValue(primary.getCity());
	        	 }else if(field.getPartialName().equals("TextField3[23]") && isNotEmpty(primary.getState())){//state
	        		field.setValue(primary.getState());
	         	 }else if(field.getPartialName().equals("TextField3[24]") && isNotEmpty(String.valueOf(primary.getZip()))){//zip
	         		field.setValue(String.valueOf(primary.getZip()));
	         	 }else if(field.getPartialName().equals("TextField3[30]") && isNotEmpty(primary.getPhone())){ //phone
	         		field.setValue(primary.getPhone());
	         	 }else if(field.getPartialName().equals("TextField3[31]") && isNotEmpty(primary.getPhone2())){ //cell phone
	         		field.setValue(primary.getPhone2());                	
	        	 }else if(field.getPartialName().equals("TextField3[32]") && isNotEmpty(vaForm1010cg.getPrimaryRelationship())){ 
	        		 field.setValue(vaForm1010cg.getPrimaryRelationship());
	         	 }else if(field.getPartialName().equals("TextField3[33]") && isNotEmpty(primary.getEmail())){
	         		field.setValue(primary.getEmail());
	         	 }else if(field.getPartialName().equals("CheckBox3[0]") && vaForm1010cg.isPrimaryFamily()){ //I certify that I am a family member
	        		((PDCheckbox) field).check();
	         	 }else if(field.getPartialName().equals("CheckBox4[0]") && vaForm1010cg.isPrimaryNotFamily()){ //I certify that I am not a family member
	         		 ((PDCheckbox) field).check();
	         	 }else if(field.getPartialName().equals("CheckBox1[5]") && vaForm1010cg.isMediEnrolled()){ //enrolled in medicade/medicare - yes
	 	       		((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("CheckBox2[5]") && vaForm1010cg.isNotMediEnrolled()){ //enrolled in medicade/medicare - no
		         	((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("CheckBox1[6]") && vaForm1010cg.isOtherHealthInsuranceYes()){ //other health insurance - yes
		       		((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("CheckBox2[6]") && vaForm1010cg.isOtherHealthInsuranceNo()){ //other health insurance - no
		         	((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("TextField4[0]") && isNotEmpty(vaForm1010cg.getOtherHealthInsurance())){ //other health insurance name
		         	field.setValue(vaForm1010cg.getOtherHealthInsurance());
		         }else if(field.getPartialName().equals("TextField3[34]") ){ //primary e-signature date TODO
	         		//field.setValue("Primary sign date");
	         	 } else if(field.getPartialName().equals("TextField3[35]") ){ //primary e-signature TODO
	         		//field.setValue("Primary CG Signature");
	         	 } 
		      }
	      	
	      	
		      // ==> Secondary Caregiver ==
		      if(secondary!=null && ( vaForm1010cg.isVeteranPreview() || CaretStrPool.PERSON_CATEGORY_SECONDARY.equals(vaForm1010cg.getPersonCategory() ) ) )
		      {

	      		if(field.getPartialName().equals("TextField3[25]") && isNotEmpty(secondary.getLastName())){
	      			field.setValue(secondary.getLastName());
		         }else if(field.getPartialName().equals("TextField3[26]") && isNotEmpty(secondary.getFirstName())){
		         	field.setValue(secondary.getFirstName());
		         }else if(field.getPartialName().equals("TextField3[27]") && isNotEmpty(secondary.getMiddleName())){
		        	 field.setValue(secondary.getMiddleName());
		         }else if(field.getPartialName().equals("TextField3[29]") && isNotEmpty(secondary.getSsn())){
		           	field.setValue(secondary.getSsn());
		         }else if(field.getPartialName().equals("TextField3[28]") && secondary.getBirthDate()!=null){
		        	 field.setValue(Toolbox.formatDatePdf( secondary.getBirthDate() ) );
		         }else if(field.getPartialName().equals("CheckBox1[4]") && isNotEmpty(secondary.getGender()) && secondary.getGender().equals(CaretStrPool.GENDER_TYPE_MALE)){
		        	 ((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("CheckBox2[4]") && isNotEmpty(secondary.getGender()) && secondary.getGender().equals(CaretStrPool.GENDER_TYPE_FEMALE)){
		        	 ((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("TextField3[36]") && isNotEmpty(secondary.getAddress())){
		        	 field.setValue(secondary.getAddress());
		         }else if(field.getPartialName().equals("TextField3[37]") && isNotEmpty(secondary.getCity())){ //city
		        	 field.setValue(secondary.getCity());
		         }else if(field.getPartialName().equals("TextField3[38]") && isNotEmpty(secondary.getState())){ //state
		        	 field.setValue(secondary.getState());
		         }else if(field.getPartialName().equals("TextField3[39]") && isNotEmpty(String.valueOf(secondary.getZip()))){ //zip
		        	 field.setValue(String.valueOf(secondary.getZip()));
		         }else if(field.getPartialName().equals("TextField3[41]") && isNotEmpty(secondary.getPhone())){ //phone
		        	 field.setValue(secondary.getPhone());
		         }else if(field.getPartialName().equals("TextField3[40]") && isNotEmpty(secondary.getPhone2())){ //cell phone
		        	 field.setValue(secondary.getPhone2());                	
		         }else if(field.getPartialName().equals("TextField3[42]") && isNotEmpty(vaForm1010cg.getSecondaryRelationship())){
		        	 field.setValue(vaForm1010cg.getSecondaryRelationship());
		         }else if(field.getPartialName().equals("TextField3[43]") && isNotEmpty(secondary.getEmail())){
		        	 field.setValue(secondary.getEmail());
		         }else if(field.getPartialName().equals("CheckBox3[1]") && vaForm1010cg.isSecondaryFamily()){ //I certify that I am a family member
		       		((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("CheckBox4[1]") && vaForm1010cg.isSecondaryNotFamily()){ //I certify that I am not a family member
		         	((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("TextField3[57]") ){ //secondary e-signature date TODO
		      		//field.setValue("Secondary sign date");
		         }else if(field.getPartialName().equals("TextField3[58]") ){ //secondary e-signature TODO
		          	//field.setValue("Secondary CG Signature");
		         }
	      		}
	      	
	      	
	          	// ==> Secondary Caregiver Two ==
		      	if(secondaryTwo!=null && ( vaForm1010cg.isVeteranPreview() || CaretStrPool.PERSON_CATEGORY_SECONDARYTWO.equals(vaForm1010cg.getPersonCategory()) ) )
		      	{	      	 

		          if(field.getPartialName().equals("TextField3[44]") && isNotEmpty(secondaryTwo.getLastName())){
		          	field.setValue(secondaryTwo.getLastName());
		          }else if(field.getPartialName().equals("TextField3[45]") && isNotEmpty(secondaryTwo.getFirstName())){
		          	field.setValue(secondaryTwo.getFirstName());
		          }else if(field.getPartialName().equals("TextField3[46]") && isNotEmpty(secondaryTwo.getMiddleName())){
		           	field.setValue(secondaryTwo.getMiddleName());
		          }else if(field.getPartialName().equals("TextField3[48]") && isNotEmpty(secondaryTwo.getSsn())){
		            field.setValue(secondaryTwo.getSsn());
		          }else if(field.getPartialName().equals("TextField3[47]") && secondaryTwo.getBirthDate()!=null){
		            field.setValue( Toolbox.formatDatePdf(secondaryTwo.getBirthDate()) );
		          }else if(field.getPartialName().equals("CheckBox1[7]") && isNotEmpty(secondaryTwo.getGender()) && secondaryTwo.getGender().equals(CaretStrPool.GENDER_TYPE_MALE)){
		        	((PDCheckbox) field).check();
		          }else if(field.getPartialName().equals("CheckBox2[7]") && isNotEmpty(secondaryTwo.getGender()) && secondaryTwo.getGender().equals(CaretStrPool.GENDER_TYPE_FEMALE)){
		          	((PDCheckbox) field).check();
		          }else if(field.getPartialName().equals("TextField3[49]") && isNotEmpty(secondaryTwo.getAddress())){ //address
		          	field.setValue(secondaryTwo.getAddress());
		          }else if(field.getPartialName().equals("TextField3[50]") && isNotEmpty(secondaryTwo.getCity())){ //city
		           	field.setValue(secondaryTwo.getCity());
		          }else if(field.getPartialName().equals("TextField3[51]") && isNotEmpty(secondaryTwo.getState())){ //state
		          	field.setValue(secondaryTwo.getState());
		          }else if(field.getPartialName().equals("TextField3[52]") && isNotEmpty(String.valueOf(secondaryTwo.getZip()))){ //zip
		           	field.setValue(String.valueOf(secondaryTwo.getZip()));
		          }else if(field.getPartialName().equals("TextField3[53]") && isNotEmpty(secondaryTwo.getPhone())){ //phone
		           	field.setValue(secondaryTwo.getPhone());
		          }else if(field.getPartialName().equals("TextField3[54]") && isNotEmpty(secondaryTwo.getPhone2())){ //cell phone
		           	field.setValue(secondaryTwo.getPhone2());                	
		          }else if(field.getPartialName().equals("TextField3[55]") && isNotEmpty(vaForm1010cg.getSecondaryTwoRelationship())){ //secondaryTwo relationship to veteran
		          	field.setValue(vaForm1010cg.getSecondaryTwoRelationship());
		          }else if(field.getPartialName().equals("TextField3[56]") && isNotEmpty(secondaryTwo.getEmail())){
		           	field.setValue(secondaryTwo.getEmail());
		          }else if(field.getPartialName().equals("CheckBox3[2]") && vaForm1010cg.isSecondaryTwoFamily()){ //I certify that I am a family member
		        	((PDCheckbox) field).check();
		          }else if(field.getPartialName().equals("CheckBox4[2]") && vaForm1010cg.isSecondaryTwoNotFamily()){ //I certify that I am not a family member
		          	((PDCheckbox) field).check();
		          }else if(field.getPartialName().equals("TextField3[59]") ){ //secondary two e-signature date TODO
		           	//field.setValue("Secondary Two sign date");
		          }else if(field.getPartialName().equals("TextField3[60]") ){ //secondary e-signature TODO
		        	//field.setValue("Secondary Two CG Signature");
		          } 
		      	}
		      	
	       }
		} catch (IOException e) {
			e.printStackTrace();
		}
  }
  
  private boolean isNotEmpty(String str){
  	if(str != null && !str.trim().isEmpty()){
  		return true;
  	}else{
  		return false;
  	}  	
  }
  
  
  /*
   * DO NOT DELETE ----- FOR REFERENCE
   */
  /*
  1 top-level fields were found on the form
  |--form1[0]
  |  |--form1[0].#subform[2]

  ----> Veteran Form Info
  |  |  |--form1[0].#subform[2].TextField3[0] = null, (Last Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[1] = null, (First Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[2] = null, (Middle Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[3] = null, (Date of Birth (mm-dd-yyyy)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[4] = null, (Social Security Number) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].CheckBox1[0] = Off, (Male) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[2].CheckBox2[0] = Off, (Female) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[2].CheckBox1[1] = Off, (Hospital) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[2].CheckBox2[1] = Off, (Clinic) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[2].TextField3[5] = null, (Date) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[6] = null, (Current Street Address) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[7] = null, (City) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[8] = null, (State) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[9] = null, (Zip Code) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[10] = null, (Telephone Number (Including Area Code)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[11] = null, (Cell Number (Including Area Code)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[12] = null, (Name of VA medical center or clinic where you receive or plan to receive health care services:) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[13] = null, (Email Address) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].CheckBox1[2] = Off, (Yes) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[2].CheckBox2[2] = Off, (No) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[2].TextField3[14] = null, (Name of facility where you last received medical treatment:) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[20] = null, (Veteran/Servicemember/Representative/POA Signature) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox

  ------> Primary Caregiver Info
	|  |  |--form1[0].#subform[2].TextField3[15] = null, (Middle Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[16] = null, (First Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[17] = null, (Last Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[18] = null, (Social Security Number) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[19] = null, (Date of Birth (mm-dd-yyyy)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].CheckBox1[3] = Off, (Male) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[2].CheckBox2[3] = Off, (Female) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox

	|  |  |--form1[0].#subform[2].TextField3[21] = null, (Current Street Address) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[22] = null, (City) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[23] = null, (State) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[2].TextField3[24] = null, (Zip Code) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox

	|  |  |--form1[0].#subform[3].TextField3[30] = null, (Telephone Number (Including Area Code)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[31] = null, (Cell Number (Including Area Code)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[32] = null, (Relationship to Veteran (e.g., Spouse, Parent, Child, Other)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[33] = null, (E-mail Address) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[34] = null, (Date) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[35] = null, (Primary Family Caregiver Signature) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox

  -------> Secondary Caregiver 1 Info
  |  |--form1[0].#subform[3]
  |  |  |--form1[0].#subform[3].TextField3[25] = null, (Last Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[26] = null, (First Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[27] = null, (Middle Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[28] = null, (Date of Birth (mm-dd-yyyy)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[29] = null, (Social Security Number) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].CheckBox1[4] = Off, (Male) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[3].CheckBox2[4] = Off, (Female) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[3].CheckBox1[5] = Off, (Yes) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[3].CheckBox2[5] = Off, (No) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[3].TextField4[0] = null, (Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].CheckBox1[6] = Off, (Yes) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[3].CheckBox2[6] = Off, (No) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[3].CheckBox3[0] = Off, (I certify that I am a family member of the Veteran or Servicemember named in this application.  ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[3].CheckBox4[0] = Off, (I certify am not a family member and I reside with the Veteran or Servicemember or will do so upon approval.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox

	|  |  |--form1[0].#subform[3].TextField3[36] = null, (Current Street Address) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[37] = null, (City) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[38] = null, (State) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[39] = null, (Zip Code) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[40] = null, (Cell Number (Including Area Code)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[41] = null, (Telephone Number (Including Area Code)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[42] = null, (Relationship to Veteran (e.g., Spouse, Parent, Child, Other)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[3].TextField3[43] = null, (Email Address) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[57] = null, (Date) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[58] = null, (Secondary Caregiver Signature) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox

  ---------> Secondary Caregiver 2 Info
  |  |--form1[0].#subform[4]
	|  |  |--form1[0].#subform[4].TextField3[44] = null, (Last Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[45] = null, (First Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[46] = null, (Middle Name) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[47] = null, (Date of Birth (mm-dd-yyyy)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[48] = null, (Social Security Number) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].CheckBox1[7] = Off, (Male) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[4].CheckBox2[7] = Off, (Female) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[4].TextField3[49] = null, (Current Street Address) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[50] = null, (City) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[51] = null, (State) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[52] = null, (Zip Code) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[53] = null, (Telephone Number (Including Area Code)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[54] = null, (Cell Number (Including Area Code)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[55] = null, (Relationship to Veteran (e.g., Spouse, Parent, Child, Other)) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[56] = null, (Email Address) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].CheckBox3[1] = Off, (I certify that I am a family member of the Veteran or Servicemember named in this application.  ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[4].CheckBox4[1] = Off, (I certify am not a family member and I reside with the Veteran or Servicemember or will do so upon approval.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox

	|  |  |--form1[0].#subform[4].CheckBox3[2] = Off, (I certify that I am a family member of the Veteran or Servicemember named in this application.  ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[4].CheckBox4[2] = Off, (I certify am not a family member and I reside with the Veteran or Servicemember or will do so upon approval.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[4].TextField3[59] = null, (Date) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[4].TextField3[60] = null, (Secondary Caregiver Signature) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
  */
  
}
