package gov.va.caret.model.support;

import com.liferay.util.portlet.PortletProps;

import gov.va.caret.util.Toolbox;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public enum WorkType {
	ONLINE_APP(getDouble(PortletProps.get("onlineApp.due.days"), 1.0 ), true),
	CSC_APP(getDouble(PortletProps.get("cscApp.due.days"), 1.0 ), true),
	HEC_APP(getDouble(PortletProps.get("cscApp.due.days"), 1.0 ), true),
	FACILITY_APP(getDouble(PortletProps.get("facilityApp.due.days"), 1.0 )),
	SOC( getDouble(PortletProps.get("soc.due.days"), 25.0 )),
	SOC_FOLLOWUP( getDouble(PortletProps.get("soc.followup.due.days"), -1.0 )),
	CESP(getDouble(PortletProps.get("cesp.due.days"), -1.0 )),
	CESP_CSC(getDouble(PortletProps.get("cesp.csc.due.days"), -1.0 )),
	REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true),
	HEC_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true),
	HRC_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true),
	CSL_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true),
	CALL_REFERRAL(getDouble(PortletProps.get("callReferral.due.days"), 5.0 ), true),
	HOME_VISIT(getDouble(PortletProps.get("homeVisit.due.days"), 10.0 ), true),	
	VACO_WAIVER(getDouble(PortletProps.get("vaco.waiver.days"), 90.0 )),
	CSC_WAIVER(getDouble(PortletProps.get("csc.waiver.days"), 45.0 )),
	UNPROCESSED_PAYMENT(-1),
	DUPLICATE_PAYMENT(-1),
	TIU(-1),
	CBOPC_WI(-1),   //for New Application approved, write TIU Note
	VENDOR_PII_UPDATE(getDouble(PortletProps.get("pii.update.days"), -1.0 )),
	VENDOR_INSURANCE_UPDATE(getDouble(PortletProps.get("insurance.update.days"), -1.0 )), 
	ADDRESS_CHANGE(-1),
	PII_CHANGE(-1),
	NAME_CHANGE(-1),
	DISPOSITION_UPDATE(-1), 
	INSURANCE_UPDATE(-1), 
	TIER_UPDATE(-1);
	
	double days;
	boolean filterRegistered = false;
	
	WorkType( double days, boolean filterRegistered ){
		this.days = days;
		this.filterRegistered = filterRegistered;
	}
	
	WorkType( double days ){
		this.days = days;
	}

	private static double getDouble(String string, double d) {
		if ( string == null || string.isEmpty() ){
			return d;
		}
		try{
			return Double.valueOf(string);
		} catch ( NumberFormatException nfe ){}
		return d;
	}

	public Date getDueDate(Date createDate) {
		if ( days == -1 ){
			return null;
			//return createDate;
		}
		return Toolbox.adjustDate(days, createDate, true);
	}
	
	public static List<WorkType> getFilterRegistered(){
		List<WorkType> list = new ArrayList<WorkType>();
		for ( WorkType workType: WorkType.values() ){
			if ( workType.filterRegistered ){
				list.add(workType);
			}
		}
		return list;
	}
	
}