package gov.va.caret.model.support;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.model.Vendr;
import gov.va.caret.model.VendrWrapper;
import gov.va.caret.model.impl.VendrImpl;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;


public class Vendor extends VendrWrapper {
	
	private static final long serialVersionUID = -8375561258486068131L;
	public static final Vendor DEFAULT_PERSON = new Vendor( new VendrImpl() );
	
	public Vendor(Vendr user) {
		super(user);
	}

	public String getSsn(){
		String ssn = Toolbox.getExpandoValue(getExpandoBridge(), CaretStrPool.METADATA, false);
		_log.info( "ssn.isEmpty()?" + ssn.isEmpty() );
		return ssn;
	}
	
	public void setSsn ( String ssn ){
		Toolbox.setExpandoValue(this, CaretStrPool.METADATA, ssn );
	}
	
	private static Log _log = LogFactoryUtil.getLog( Vendor.class );
}
