package gov.va.caret.model.support;

import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.model.VcgWrapper;
import gov.va.caret.util.Toolbox;

import java.text.ParseException;
import java.util.Date;

public class VcgSupport extends VcgWrapper {

	String veteranName = null;
	String primaryName = null;
	String secondaryName = null;
	String secondaryTwoName = null;
	
	private static final long serialVersionUID = 1L;

	public VcgSupport(gov.va.caret.model.Vcg vcg) {
		super(vcg);
	}

	public String getVeteranName() {
		if ( veteranName == null ){
			this.veteranName = getFullName( getVeteranId() );
		}
		return veteranName;
	}

	public String getPrimaryName() {
		if ( primaryName == null ){
			this.primaryName = getFullName( getPrimaryId() );
		}
		return primaryName;
	}

	public String getSecondaryName() {
		if ( secondaryName == null ){
			this.secondaryName = getFullName( getSecondaryId() );
		}
		return secondaryName;
	}

	public String getSecondaryTwoName() {
		if ( secondaryTwoName == null ){
			this.secondaryTwoName = getFullName( getSecondaryTwoId() );
		}
		return secondaryTwoName;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	public String getFullName ( long persnId ){
		if ( persnId > 0 ){
			return Toolbox.getPersnFullName ( persnId );
		}
		return StringPool.BLANK;
	}
	
	public String getTierEffectiveDateStr() {
		return Toolbox.formatDateCprs( getTierEffectiveDate() );
	}
	
	public void setTierEffectiveDateStr( String dateStr ) {
		try {
			setTierEffectiveDate( (Date) Toolbox.getDateFormatCprs().parseObject(dateStr) );
		} catch (ParseException e) {
			e.printStackTrace();
		}
	}

}
