package gov.va.caret.model.support;

import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.BaseModel;

import gov.va.caret.model.AudLg;
import gov.va.caret.model.AudLgWrapper;
import gov.va.caret.model.Persn;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.Vendr;
import gov.va.caret.util.Toolbox;

public class AuditLogSupport extends AudLgWrapper {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	String fullName = StringPool.BLANK;

	public AuditLogSupport(AudLg audLg) {
		super(audLg);
	}
	
	public String getModificationDate(){
		return Toolbox.getDateTimeFormat().format( getModifiedDate() );
	}
	
	public String getModifiedBy(){
		if ( getModifiedById() > 0 && fullName == StringPool.BLANK ) {
			fullName = Toolbox.getUserFullName( getModifiedById() ); 
		}
		return fullName;
	}
	
	@SuppressWarnings("rawtypes")
	public static BaseModel getWrappedModel ( BaseModel model ){
		if ( model instanceof Persn ){
			return new Person( (Persn) model );
		}
		if ( model instanceof Vendr ){
			return new Vendor( (Vendr)model );
		}
		if ( model instanceof VcgAn ){
			return new VcgApplication( (VcgAn) model );
		}
		if ( model instanceof Vcg ){
			return new VcgSupport( (Vcg) model );
		}
		return model;
	}

}
