package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.ZipFy;
import gov.va.caret.model.ZipFyModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the ZipFy service. Represents a row in the &quot;CARET_FACILITY_ZIP&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.ZipFyModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ZipFyImpl}.
 * </p>
 *
 * @author caret
 * @see ZipFyImpl
 * @see gov.va.caret.model.ZipFy
 * @see gov.va.caret.model.ZipFyModel
 * @generated
 */
public class ZipFyModelImpl extends BaseModelImpl<ZipFy> implements ZipFyModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a zip fy model instance should use the {@link gov.va.caret.model.ZipFy} interface instead.
     */
    public static final String TABLE_NAME = "CARET_FACILITY_ZIP";
    public static final Object[][] TABLE_COLUMNS = {
            { "zipFyId", Types.BIGINT },
            { "facilId", Types.BIGINT },
            { "facilZip", Types.VARCHAR },
            { "distance", Types.DOUBLE }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_FACILITY_ZIP (zipFyId LONG not null primary key,facilId LONG,facilZip VARCHAR(75) null,distance DOUBLE)";
    public static final String TABLE_SQL_DROP = "drop table CARET_FACILITY_ZIP";
    public static final String ORDER_BY_JPQL = " ORDER BY zipFy.zipFyId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_FACILITY_ZIP.zipFyId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.ZipFy"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.ZipFy"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.ZipFy"),
            true);
    public static long FACILZIP_COLUMN_BITMASK = 1L;
    public static long ZIPFYID_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.ZipFy"));
    private static ClassLoader _classLoader = ZipFy.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { ZipFy.class };
    private long _zipFyId;
    private long _facilId;
    private String _facilZip;
    private String _originalFacilZip;
    private double _distance;
    private long _columnBitmask;
    private ZipFy _escapedModel;

    public ZipFyModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _zipFyId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setZipFyId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _zipFyId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return ZipFy.class;
    }

    @Override
    public String getModelClassName() {
        return ZipFy.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("zipFyId", getZipFyId());
        attributes.put("facilId", getFacilId());
        attributes.put("facilZip", getFacilZip());
        attributes.put("distance", getDistance());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long zipFyId = (Long) attributes.get("zipFyId");

        if (zipFyId != null) {
            setZipFyId(zipFyId);
        }

        Long facilId = (Long) attributes.get("facilId");

        if (facilId != null) {
            setFacilId(facilId);
        }

        String facilZip = (String) attributes.get("facilZip");

        if (facilZip != null) {
            setFacilZip(facilZip);
        }

        Double distance = (Double) attributes.get("distance");

        if (distance != null) {
            setDistance(distance);
        }
    }

    @Override
    public long getZipFyId() {
        return _zipFyId;
    }

    @Override
    public void setZipFyId(long zipFyId) {
        _zipFyId = zipFyId;
    }

    @Override
    public long getFacilId() {
        return _facilId;
    }

    @Override
    public void setFacilId(long facilId) {
        _facilId = facilId;
    }

    @Override
    public String getFacilZip() {
        if (_facilZip == null) {
            return StringPool.BLANK;
        } else {
            return _facilZip;
        }
    }

    @Override
    public void setFacilZip(String facilZip) {
        _columnBitmask |= FACILZIP_COLUMN_BITMASK;

        if (_originalFacilZip == null) {
            _originalFacilZip = _facilZip;
        }

        _facilZip = facilZip;
    }

    public String getOriginalFacilZip() {
        return GetterUtil.getString(_originalFacilZip);
    }

    @Override
    public double getDistance() {
        return _distance;
    }

    @Override
    public void setDistance(double distance) {
        _distance = distance;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            ZipFy.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public ZipFy toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (ZipFy) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        ZipFyImpl zipFyImpl = new ZipFyImpl();

        zipFyImpl.setZipFyId(getZipFyId());
        zipFyImpl.setFacilId(getFacilId());
        zipFyImpl.setFacilZip(getFacilZip());
        zipFyImpl.setDistance(getDistance());

        zipFyImpl.resetOriginalValues();

        return zipFyImpl;
    }

    @Override
    public int compareTo(ZipFy zipFy) {
        long primaryKey = zipFy.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof ZipFy)) {
            return false;
        }

        ZipFy zipFy = (ZipFy) obj;

        long primaryKey = zipFy.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        ZipFyModelImpl zipFyModelImpl = this;

        zipFyModelImpl._originalFacilZip = zipFyModelImpl._facilZip;

        zipFyModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<ZipFy> toCacheModel() {
        ZipFyCacheModel zipFyCacheModel = new ZipFyCacheModel();

        zipFyCacheModel.zipFyId = getZipFyId();

        zipFyCacheModel.facilId = getFacilId();

        zipFyCacheModel.facilZip = getFacilZip();

        String facilZip = zipFyCacheModel.facilZip;

        if ((facilZip != null) && (facilZip.length() == 0)) {
            zipFyCacheModel.facilZip = null;
        }

        zipFyCacheModel.distance = getDistance();

        return zipFyCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{zipFyId=");
        sb.append(getZipFyId());
        sb.append(", facilId=");
        sb.append(getFacilId());
        sb.append(", facilZip=");
        sb.append(getFacilZip());
        sb.append(", distance=");
        sb.append(getDistance());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.ZipFy");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>zipFyId</column-name><column-value><![CDATA[");
        sb.append(getZipFyId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>facilId</column-name><column-value><![CDATA[");
        sb.append(getFacilId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>facilZip</column-name><column-value><![CDATA[");
        sb.append(getFacilZip());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>distance</column-name><column-value><![CDATA[");
        sb.append(getDistance());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
