package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Waivr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing Waivr in entity cache.
 *
 * @author caret
 * @see Waivr
 * @generated
 */
public class WaivrCacheModel implements CacheModel<Waivr>, Externalizable {
    public long waivrId;
    public long classPk;
    public String adjudication;
    public String reason;
    public String note;
    public long creationDate;
    public long completionDate;
    public long userId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(17);

        sb.append("{waivrId=");
        sb.append(waivrId);
        sb.append(", classPk=");
        sb.append(classPk);
        sb.append(", adjudication=");
        sb.append(adjudication);
        sb.append(", reason=");
        sb.append(reason);
        sb.append(", note=");
        sb.append(note);
        sb.append(", creationDate=");
        sb.append(creationDate);
        sb.append(", completionDate=");
        sb.append(completionDate);
        sb.append(", userId=");
        sb.append(userId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Waivr toEntityModel() {
        WaivrImpl waivrImpl = new WaivrImpl();

        waivrImpl.setWaivrId(waivrId);
        waivrImpl.setClassPk(classPk);

        if (adjudication == null) {
            waivrImpl.setAdjudication(StringPool.BLANK);
        } else {
            waivrImpl.setAdjudication(adjudication);
        }

        if (reason == null) {
            waivrImpl.setReason(StringPool.BLANK);
        } else {
            waivrImpl.setReason(reason);
        }

        if (note == null) {
            waivrImpl.setNote(StringPool.BLANK);
        } else {
            waivrImpl.setNote(note);
        }

        if (creationDate == Long.MIN_VALUE) {
            waivrImpl.setCreationDate(null);
        } else {
            waivrImpl.setCreationDate(new Date(creationDate));
        }

        if (completionDate == Long.MIN_VALUE) {
            waivrImpl.setCompletionDate(null);
        } else {
            waivrImpl.setCompletionDate(new Date(completionDate));
        }

        waivrImpl.setUserId(userId);

        waivrImpl.resetOriginalValues();

        return waivrImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        waivrId = objectInput.readLong();
        classPk = objectInput.readLong();
        adjudication = objectInput.readUTF();
        reason = objectInput.readUTF();
        note = objectInput.readUTF();
        creationDate = objectInput.readLong();
        completionDate = objectInput.readLong();
        userId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(waivrId);
        objectOutput.writeLong(classPk);

        if (adjudication == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(adjudication);
        }

        if (reason == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(reason);
        }

        if (note == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(note);
        }

        objectOutput.writeLong(creationDate);
        objectOutput.writeLong(completionDate);
        objectOutput.writeLong(userId);
    }
}
