package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.VetVr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing VetVr in entity cache.
 *
 * @author caret
 * @see VetVr
 * @generated
 */
public class VetVrCacheModel implements CacheModel<VetVr>, Externalizable {
    public long vetVrId;
    public long vendrId;
    public long cgId;
    public long veteranId;
    public long groupId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{vetVrId=");
        sb.append(vetVrId);
        sb.append(", vendrId=");
        sb.append(vendrId);
        sb.append(", cgId=");
        sb.append(cgId);
        sb.append(", veteranId=");
        sb.append(veteranId);
        sb.append(", groupId=");
        sb.append(groupId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public VetVr toEntityModel() {
        VetVrImpl vetVrImpl = new VetVrImpl();

        vetVrImpl.setVetVrId(vetVrId);
        vetVrImpl.setVendrId(vendrId);
        vetVrImpl.setCgId(cgId);
        vetVrImpl.setVeteranId(veteranId);
        vetVrImpl.setGroupId(groupId);

        vetVrImpl.resetOriginalValues();

        return vetVrImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        vetVrId = objectInput.readLong();
        vendrId = objectInput.readLong();
        cgId = objectInput.readLong();
        veteranId = objectInput.readLong();
        groupId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(vetVrId);
        objectOutput.writeLong(vendrId);
        objectOutput.writeLong(cgId);
        objectOutput.writeLong(veteranId);
        objectOutput.writeLong(groupId);
    }
}
