package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.VetVr;
import gov.va.caret.service.VetVrLocalServiceUtil;

/**
 * The extended model base implementation for the VetVr service. Represents a row in the &quot;CARET_VETERAN_VENDOR&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link VetVrImpl}.
 * </p>
 *
 * @author caret
 * @see VetVrImpl
 * @see gov.va.caret.model.VetVr
 * @generated
 */
public abstract class VetVrBaseImpl extends VetVrModelImpl implements VetVr {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a vet vr model instance should use the {@link VetVr} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            VetVrLocalServiceUtil.addVetVr(this);
        } else {
            VetVrLocalServiceUtil.updateVetVr(this);
        }
    }
}
