package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Vendr;
import gov.va.caret.model.VendrModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Vendr service. Represents a row in the &quot;CARET_VENDOR&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.VendrModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link VendrImpl}.
 * </p>
 *
 * @author caret
 * @see VendrImpl
 * @see gov.va.caret.model.Vendr
 * @see gov.va.caret.model.VendrModel
 * @generated
 */
public class VendrModelImpl extends BaseModelImpl<Vendr> implements VendrModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a vendr model instance should use the {@link gov.va.caret.model.Vendr} interface instead.
     */
    public static final String TABLE_NAME = "CARET_VENDOR";
    public static final Object[][] TABLE_COLUMNS = {
            { "vendrId", Types.BIGINT },
            { "lastName", Types.VARCHAR },
            { "firstName", Types.VARCHAR },
            { "middleName", Types.VARCHAR },
            { "fedTaxId", Types.VARCHAR },
            { "address", Types.VARCHAR },
            { "address2", Types.VARCHAR },
            { "city", Types.VARCHAR },
            { "state_", Types.VARCHAR },
            { "zip", Types.VARCHAR },
            { "phone", Types.VARCHAR },
            { "phone2", Types.VARCHAR },
            { "gracePeriod", Types.VARCHAR },
            { "gracePeriodDuration", Types.VARCHAR },
            { "directDepositInfo", Types.VARCHAR },
            { "paymentMethod", Types.VARCHAR },
            { "crypto1", Types.VARCHAR },
            { "groupId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_VENDOR (vendrId LONG not null primary key,lastName VARCHAR(75) null,firstName VARCHAR(75) null,middleName VARCHAR(75) null,fedTaxId VARCHAR(75) null,address VARCHAR(75) null,address2 VARCHAR(75) null,city VARCHAR(75) null,state_ VARCHAR(75) null,zip VARCHAR(75) null,phone VARCHAR(75) null,phone2 VARCHAR(75) null,gracePeriod VARCHAR(75) null,gracePeriodDuration VARCHAR(75) null,directDepositInfo VARCHAR(75) null,paymentMethod VARCHAR(75) null,crypto1 VARCHAR(75) null,groupId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_VENDOR";
    public static final String ORDER_BY_JPQL = " ORDER BY vendr.vendrId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_VENDOR.vendrId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Vendr"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Vendr"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.Vendr"),
            true);
    public static long FEDTAXID_COLUMN_BITMASK = 1L;
    public static long FIRSTNAME_COLUMN_BITMASK = 2L;
    public static long LASTNAME_COLUMN_BITMASK = 4L;
    public static long VENDRID_COLUMN_BITMASK = 8L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Vendr"));
    private static ClassLoader _classLoader = Vendr.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Vendr.class };
    private long _vendrId;
    private String _lastName;
    private String _originalLastName;
    private String _firstName;
    private String _originalFirstName;
    private String _middleName;
    private String _fedTaxId;
    private String _originalFedTaxId;
    private String _address;
    private String _address2;
    private String _city;
    private String _state;
    private String _zip;
    private String _phone;
    private String _phone2;
    private String _gracePeriod;
    private String _gracePeriodDuration;
    private String _directDepositInfo;
    private String _paymentMethod;
    private String _crypto1;
    private long _groupId;
    private long _columnBitmask;
    private Vendr _escapedModel;

    public VendrModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _vendrId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setVendrId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _vendrId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Vendr.class;
    }

    @Override
    public String getModelClassName() {
        return Vendr.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("vendrId", getVendrId());
        attributes.put("lastName", getLastName());
        attributes.put("firstName", getFirstName());
        attributes.put("middleName", getMiddleName());
        attributes.put("fedTaxId", getFedTaxId());
        attributes.put("address", getAddress());
        attributes.put("address2", getAddress2());
        attributes.put("city", getCity());
        attributes.put("state", getState());
        attributes.put("zip", getZip());
        attributes.put("phone", getPhone());
        attributes.put("phone2", getPhone2());
        attributes.put("gracePeriod", getGracePeriod());
        attributes.put("gracePeriodDuration", getGracePeriodDuration());
        attributes.put("directDepositInfo", getDirectDepositInfo());
        attributes.put("paymentMethod", getPaymentMethod());
        attributes.put("crypto1", getCrypto1());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long vendrId = (Long) attributes.get("vendrId");

        if (vendrId != null) {
            setVendrId(vendrId);
        }

        String lastName = (String) attributes.get("lastName");

        if (lastName != null) {
            setLastName(lastName);
        }

        String firstName = (String) attributes.get("firstName");

        if (firstName != null) {
            setFirstName(firstName);
        }

        String middleName = (String) attributes.get("middleName");

        if (middleName != null) {
            setMiddleName(middleName);
        }

        String fedTaxId = (String) attributes.get("fedTaxId");

        if (fedTaxId != null) {
            setFedTaxId(fedTaxId);
        }

        String address = (String) attributes.get("address");

        if (address != null) {
            setAddress(address);
        }

        String address2 = (String) attributes.get("address2");

        if (address2 != null) {
            setAddress2(address2);
        }

        String city = (String) attributes.get("city");

        if (city != null) {
            setCity(city);
        }

        String state = (String) attributes.get("state");

        if (state != null) {
            setState(state);
        }

        String zip = (String) attributes.get("zip");

        if (zip != null) {
            setZip(zip);
        }

        String phone = (String) attributes.get("phone");

        if (phone != null) {
            setPhone(phone);
        }

        String phone2 = (String) attributes.get("phone2");

        if (phone2 != null) {
            setPhone2(phone2);
        }

        String gracePeriod = (String) attributes.get("gracePeriod");

        if (gracePeriod != null) {
            setGracePeriod(gracePeriod);
        }

        String gracePeriodDuration = (String) attributes.get(
                "gracePeriodDuration");

        if (gracePeriodDuration != null) {
            setGracePeriodDuration(gracePeriodDuration);
        }

        String directDepositInfo = (String) attributes.get("directDepositInfo");

        if (directDepositInfo != null) {
            setDirectDepositInfo(directDepositInfo);
        }

        String paymentMethod = (String) attributes.get("paymentMethod");

        if (paymentMethod != null) {
            setPaymentMethod(paymentMethod);
        }

        String crypto1 = (String) attributes.get("crypto1");

        if (crypto1 != null) {
            setCrypto1(crypto1);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getVendrId() {
        return _vendrId;
    }

    @Override
    public void setVendrId(long vendrId) {
        _vendrId = vendrId;
    }

    @Override
    public String getLastName() {
        if (_lastName == null) {
            return StringPool.BLANK;
        } else {
            return _lastName;
        }
    }

    @Override
    public void setLastName(String lastName) {
        _columnBitmask |= LASTNAME_COLUMN_BITMASK;

        if (_originalLastName == null) {
            _originalLastName = _lastName;
        }

        _lastName = lastName;
    }

    public String getOriginalLastName() {
        return GetterUtil.getString(_originalLastName);
    }

    @Override
    public String getFirstName() {
        if (_firstName == null) {
            return StringPool.BLANK;
        } else {
            return _firstName;
        }
    }

    @Override
    public void setFirstName(String firstName) {
        _columnBitmask |= FIRSTNAME_COLUMN_BITMASK;

        if (_originalFirstName == null) {
            _originalFirstName = _firstName;
        }

        _firstName = firstName;
    }

    public String getOriginalFirstName() {
        return GetterUtil.getString(_originalFirstName);
    }

    @Override
    public String getMiddleName() {
        if (_middleName == null) {
            return StringPool.BLANK;
        } else {
            return _middleName;
        }
    }

    @Override
    public void setMiddleName(String middleName) {
        _middleName = middleName;
    }

    @Override
    public String getFedTaxId() {
        if (_fedTaxId == null) {
            return StringPool.BLANK;
        } else {
            return _fedTaxId;
        }
    }

    @Override
    public void setFedTaxId(String fedTaxId) {
        _columnBitmask |= FEDTAXID_COLUMN_BITMASK;

        if (_originalFedTaxId == null) {
            _originalFedTaxId = _fedTaxId;
        }

        _fedTaxId = fedTaxId;
    }

    public String getOriginalFedTaxId() {
        return GetterUtil.getString(_originalFedTaxId);
    }

    @Override
    public String getAddress() {
        if (_address == null) {
            return StringPool.BLANK;
        } else {
            return _address;
        }
    }

    @Override
    public void setAddress(String address) {
        _address = address;
    }

    @Override
    public String getAddress2() {
        if (_address2 == null) {
            return StringPool.BLANK;
        } else {
            return _address2;
        }
    }

    @Override
    public void setAddress2(String address2) {
        _address2 = address2;
    }

    @Override
    public String getCity() {
        if (_city == null) {
            return StringPool.BLANK;
        } else {
            return _city;
        }
    }

    @Override
    public void setCity(String city) {
        _city = city;
    }

    @Override
    public String getState() {
        if (_state == null) {
            return StringPool.BLANK;
        } else {
            return _state;
        }
    }

    @Override
    public void setState(String state) {
        _state = state;
    }

    @Override
    public String getZip() {
        if (_zip == null) {
            return StringPool.BLANK;
        } else {
            return _zip;
        }
    }

    @Override
    public void setZip(String zip) {
        _zip = zip;
    }

    @Override
    public String getPhone() {
        if (_phone == null) {
            return StringPool.BLANK;
        } else {
            return _phone;
        }
    }

    @Override
    public void setPhone(String phone) {
        _phone = phone;
    }

    @Override
    public String getPhone2() {
        if (_phone2 == null) {
            return StringPool.BLANK;
        } else {
            return _phone2;
        }
    }

    @Override
    public void setPhone2(String phone2) {
        _phone2 = phone2;
    }

    @Override
    public String getGracePeriod() {
        if (_gracePeriod == null) {
            return StringPool.BLANK;
        } else {
            return _gracePeriod;
        }
    }

    @Override
    public void setGracePeriod(String gracePeriod) {
        _gracePeriod = gracePeriod;
    }

    @Override
    public String getGracePeriodDuration() {
        if (_gracePeriodDuration == null) {
            return StringPool.BLANK;
        } else {
            return _gracePeriodDuration;
        }
    }

    @Override
    public void setGracePeriodDuration(String gracePeriodDuration) {
        _gracePeriodDuration = gracePeriodDuration;
    }

    @Override
    public String getDirectDepositInfo() {
        if (_directDepositInfo == null) {
            return StringPool.BLANK;
        } else {
            return _directDepositInfo;
        }
    }

    @Override
    public void setDirectDepositInfo(String directDepositInfo) {
        _directDepositInfo = directDepositInfo;
    }

    @Override
    public String getPaymentMethod() {
        if (_paymentMethod == null) {
            return StringPool.BLANK;
        } else {
            return _paymentMethod;
        }
    }

    @Override
    public void setPaymentMethod(String paymentMethod) {
        _paymentMethod = paymentMethod;
    }

    @Override
    public String getCrypto1() {
        if (_crypto1 == null) {
            return StringPool.BLANK;
        } else {
            return _crypto1;
        }
    }

    @Override
    public void setCrypto1(String crypto1) {
        _crypto1 = crypto1;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Vendr.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Vendr toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Vendr) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        VendrImpl vendrImpl = new VendrImpl();

        vendrImpl.setVendrId(getVendrId());
        vendrImpl.setLastName(getLastName());
        vendrImpl.setFirstName(getFirstName());
        vendrImpl.setMiddleName(getMiddleName());
        vendrImpl.setFedTaxId(getFedTaxId());
        vendrImpl.setAddress(getAddress());
        vendrImpl.setAddress2(getAddress2());
        vendrImpl.setCity(getCity());
        vendrImpl.setState(getState());
        vendrImpl.setZip(getZip());
        vendrImpl.setPhone(getPhone());
        vendrImpl.setPhone2(getPhone2());
        vendrImpl.setGracePeriod(getGracePeriod());
        vendrImpl.setGracePeriodDuration(getGracePeriodDuration());
        vendrImpl.setDirectDepositInfo(getDirectDepositInfo());
        vendrImpl.setPaymentMethod(getPaymentMethod());
        vendrImpl.setCrypto1(getCrypto1());
        vendrImpl.setGroupId(getGroupId());

        vendrImpl.resetOriginalValues();

        return vendrImpl;
    }

    @Override
    public int compareTo(Vendr vendr) {
        long primaryKey = vendr.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Vendr)) {
            return false;
        }

        Vendr vendr = (Vendr) obj;

        long primaryKey = vendr.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        VendrModelImpl vendrModelImpl = this;

        vendrModelImpl._originalLastName = vendrModelImpl._lastName;

        vendrModelImpl._originalFirstName = vendrModelImpl._firstName;

        vendrModelImpl._originalFedTaxId = vendrModelImpl._fedTaxId;

        vendrModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<Vendr> toCacheModel() {
        VendrCacheModel vendrCacheModel = new VendrCacheModel();

        vendrCacheModel.vendrId = getVendrId();

        vendrCacheModel.lastName = getLastName();

        String lastName = vendrCacheModel.lastName;

        if ((lastName != null) && (lastName.length() == 0)) {
            vendrCacheModel.lastName = null;
        }

        vendrCacheModel.firstName = getFirstName();

        String firstName = vendrCacheModel.firstName;

        if ((firstName != null) && (firstName.length() == 0)) {
            vendrCacheModel.firstName = null;
        }

        vendrCacheModel.middleName = getMiddleName();

        String middleName = vendrCacheModel.middleName;

        if ((middleName != null) && (middleName.length() == 0)) {
            vendrCacheModel.middleName = null;
        }

        vendrCacheModel.fedTaxId = getFedTaxId();

        String fedTaxId = vendrCacheModel.fedTaxId;

        if ((fedTaxId != null) && (fedTaxId.length() == 0)) {
            vendrCacheModel.fedTaxId = null;
        }

        vendrCacheModel.address = getAddress();

        String address = vendrCacheModel.address;

        if ((address != null) && (address.length() == 0)) {
            vendrCacheModel.address = null;
        }

        vendrCacheModel.address2 = getAddress2();

        String address2 = vendrCacheModel.address2;

        if ((address2 != null) && (address2.length() == 0)) {
            vendrCacheModel.address2 = null;
        }

        vendrCacheModel.city = getCity();

        String city = vendrCacheModel.city;

        if ((city != null) && (city.length() == 0)) {
            vendrCacheModel.city = null;
        }

        vendrCacheModel.state = getState();

        String state = vendrCacheModel.state;

        if ((state != null) && (state.length() == 0)) {
            vendrCacheModel.state = null;
        }

        vendrCacheModel.zip = getZip();

        String zip = vendrCacheModel.zip;

        if ((zip != null) && (zip.length() == 0)) {
            vendrCacheModel.zip = null;
        }

        vendrCacheModel.phone = getPhone();

        String phone = vendrCacheModel.phone;

        if ((phone != null) && (phone.length() == 0)) {
            vendrCacheModel.phone = null;
        }

        vendrCacheModel.phone2 = getPhone2();

        String phone2 = vendrCacheModel.phone2;

        if ((phone2 != null) && (phone2.length() == 0)) {
            vendrCacheModel.phone2 = null;
        }

        vendrCacheModel.gracePeriod = getGracePeriod();

        String gracePeriod = vendrCacheModel.gracePeriod;

        if ((gracePeriod != null) && (gracePeriod.length() == 0)) {
            vendrCacheModel.gracePeriod = null;
        }

        vendrCacheModel.gracePeriodDuration = getGracePeriodDuration();

        String gracePeriodDuration = vendrCacheModel.gracePeriodDuration;

        if ((gracePeriodDuration != null) &&
                (gracePeriodDuration.length() == 0)) {
            vendrCacheModel.gracePeriodDuration = null;
        }

        vendrCacheModel.directDepositInfo = getDirectDepositInfo();

        String directDepositInfo = vendrCacheModel.directDepositInfo;

        if ((directDepositInfo != null) && (directDepositInfo.length() == 0)) {
            vendrCacheModel.directDepositInfo = null;
        }

        vendrCacheModel.paymentMethod = getPaymentMethod();

        String paymentMethod = vendrCacheModel.paymentMethod;

        if ((paymentMethod != null) && (paymentMethod.length() == 0)) {
            vendrCacheModel.paymentMethod = null;
        }

        vendrCacheModel.crypto1 = getCrypto1();

        String crypto1 = vendrCacheModel.crypto1;

        if ((crypto1 != null) && (crypto1.length() == 0)) {
            vendrCacheModel.crypto1 = null;
        }

        vendrCacheModel.groupId = getGroupId();

        return vendrCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(37);

        sb.append("{vendrId=");
        sb.append(getVendrId());
        sb.append(", lastName=");
        sb.append(getLastName());
        sb.append(", firstName=");
        sb.append(getFirstName());
        sb.append(", middleName=");
        sb.append(getMiddleName());
        sb.append(", fedTaxId=");
        sb.append(getFedTaxId());
        sb.append(", address=");
        sb.append(getAddress());
        sb.append(", address2=");
        sb.append(getAddress2());
        sb.append(", city=");
        sb.append(getCity());
        sb.append(", state=");
        sb.append(getState());
        sb.append(", zip=");
        sb.append(getZip());
        sb.append(", phone=");
        sb.append(getPhone());
        sb.append(", phone2=");
        sb.append(getPhone2());
        sb.append(", gracePeriod=");
        sb.append(getGracePeriod());
        sb.append(", gracePeriodDuration=");
        sb.append(getGracePeriodDuration());
        sb.append(", directDepositInfo=");
        sb.append(getDirectDepositInfo());
        sb.append(", paymentMethod=");
        sb.append(getPaymentMethod());
        sb.append(", crypto1=");
        sb.append(getCrypto1());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(58);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Vendr");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>vendrId</column-name><column-value><![CDATA[");
        sb.append(getVendrId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>lastName</column-name><column-value><![CDATA[");
        sb.append(getLastName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>firstName</column-name><column-value><![CDATA[");
        sb.append(getFirstName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>middleName</column-name><column-value><![CDATA[");
        sb.append(getMiddleName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>fedTaxId</column-name><column-value><![CDATA[");
        sb.append(getFedTaxId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>address</column-name><column-value><![CDATA[");
        sb.append(getAddress());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>address2</column-name><column-value><![CDATA[");
        sb.append(getAddress2());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>city</column-name><column-value><![CDATA[");
        sb.append(getCity());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>state</column-name><column-value><![CDATA[");
        sb.append(getState());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>zip</column-name><column-value><![CDATA[");
        sb.append(getZip());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>phone</column-name><column-value><![CDATA[");
        sb.append(getPhone());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>phone2</column-name><column-value><![CDATA[");
        sb.append(getPhone2());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>gracePeriod</column-name><column-value><![CDATA[");
        sb.append(getGracePeriod());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>gracePeriodDuration</column-name><column-value><![CDATA[");
        sb.append(getGracePeriodDuration());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>directDepositInfo</column-name><column-value><![CDATA[");
        sb.append(getDirectDepositInfo());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>paymentMethod</column-name><column-value><![CDATA[");
        sb.append(getPaymentMethod());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>crypto1</column-name><column-value><![CDATA[");
        sb.append(getCrypto1());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
