package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Vcg service. Represents a row in the &quot;CareT_VCG&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.VcgModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link VcgImpl}.
 * </p>
 *
 * @author caret
 * @see VcgImpl
 * @see gov.va.caret.model.Vcg
 * @see gov.va.caret.model.VcgModel
 * @generated
 */
public class VcgModelImpl extends BaseModelImpl<Vcg> implements VcgModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a vcg model instance should use the {@link gov.va.caret.model.Vcg} interface instead.
     */
    public static final String TABLE_NAME = "CareT_VCG";
    public static final Object[][] TABLE_COLUMNS = {
            { "vcgId", Types.BIGINT },
            { "veteranId", Types.BIGINT },
            { "status", Types.VARCHAR },
            { "assessCompletionDate", Types.TIMESTAMP },
            { "primaryTrainedDate", Types.TIMESTAMP },
            { "visitationDate", Types.TIMESTAMP },
            { "primaryId", Types.BIGINT },
            { "secondaryId", Types.BIGINT },
            { "secondaryTwoId", Types.BIGINT },
            { "generalCaregiver", Types.BOOLEAN },
            { "primaryType", Types.VARCHAR },
            { "secondaryType", Types.VARCHAR },
            { "secondaryTwoType", Types.VARCHAR },
            { "primaryDispositionDate", Types.TIMESTAMP },
            { "secondaryDispositionDate", Types.TIMESTAMP },
            { "secondaryTwoDispositionDate", Types.TIMESTAMP },
            { "tierLevel", Types.INTEGER },
            { "tierEffectiveDate", Types.TIMESTAMP },
            { "veteranDispReason", Types.VARCHAR },
            { "primaryDispReason", Types.VARCHAR },
            { "secondaryDispReason", Types.VARCHAR },
            { "secondaryTwoDispReason", Types.VARCHAR },
            { "primaryRevocationDate", Types.TIMESTAMP },
            { "secondaryRevocationDate", Types.TIMESTAMP },
            { "secondaryTwoRevocationDate", Types.TIMESTAMP },
            { "groupId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CareT_VCG (vcgId LONG not null primary key,veteranId LONG,status VARCHAR(75) null,assessCompletionDate DATE null,primaryTrainedDate DATE null,visitationDate DATE null,primaryId LONG,secondaryId LONG,secondaryTwoId LONG,generalCaregiver BOOLEAN,primaryType VARCHAR(75) null,secondaryType VARCHAR(75) null,secondaryTwoType VARCHAR(75) null,primaryDispositionDate DATE null,secondaryDispositionDate DATE null,secondaryTwoDispositionDate DATE null,tierLevel INTEGER,tierEffectiveDate DATE null,veteranDispReason VARCHAR(75) null,primaryDispReason VARCHAR(75) null,secondaryDispReason VARCHAR(75) null,secondaryTwoDispReason VARCHAR(75) null,primaryRevocationDate DATE null,secondaryRevocationDate DATE null,secondaryTwoRevocationDate DATE null,groupId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CareT_VCG";
    public static final String ORDER_BY_JPQL = " ORDER BY vcg.vcgId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CareT_VCG.vcgId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Vcg"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Vcg"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.Vcg"),
            true);
    public static long VETERANID_COLUMN_BITMASK = 1L;
    public static long VCGID_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Vcg"));
    private static ClassLoader _classLoader = Vcg.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Vcg.class };
    private long _vcgId;
    private long _veteranId;
    private long _originalVeteranId;
    private boolean _setOriginalVeteranId;
    private String _status;
    private Date _assessCompletionDate;
    private Date _primaryTrainedDate;
    private Date _visitationDate;
    private long _primaryId;
    private long _secondaryId;
    private long _secondaryTwoId;
    private boolean _generalCaregiver;
    private String _primaryType;
    private String _secondaryType;
    private String _secondaryTwoType;
    private Date _primaryDispositionDate;
    private Date _secondaryDispositionDate;
    private Date _secondaryTwoDispositionDate;
    private int _tierLevel;
    private Date _tierEffectiveDate;
    private String _veteranDispReason;
    private String _primaryDispReason;
    private String _secondaryDispReason;
    private String _secondaryTwoDispReason;
    private Date _primaryRevocationDate;
    private Date _secondaryRevocationDate;
    private Date _secondaryTwoRevocationDate;
    private long _groupId;
    private long _columnBitmask;
    private Vcg _escapedModel;

    public VcgModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _vcgId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setVcgId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _vcgId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Vcg.class;
    }

    @Override
    public String getModelClassName() {
        return Vcg.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("vcgId", getVcgId());
        attributes.put("veteranId", getVeteranId());
        attributes.put("status", getStatus());
        attributes.put("assessCompletionDate", getAssessCompletionDate());
        attributes.put("primaryTrainedDate", getPrimaryTrainedDate());
        attributes.put("visitationDate", getVisitationDate());
        attributes.put("primaryId", getPrimaryId());
        attributes.put("secondaryId", getSecondaryId());
        attributes.put("secondaryTwoId", getSecondaryTwoId());
        attributes.put("generalCaregiver", getGeneralCaregiver());
        attributes.put("primaryType", getPrimaryType());
        attributes.put("secondaryType", getSecondaryType());
        attributes.put("secondaryTwoType", getSecondaryTwoType());
        attributes.put("primaryDispositionDate", getPrimaryDispositionDate());
        attributes.put("secondaryDispositionDate", getSecondaryDispositionDate());
        attributes.put("secondaryTwoDispositionDate",
            getSecondaryTwoDispositionDate());
        attributes.put("tierLevel", getTierLevel());
        attributes.put("tierEffectiveDate", getTierEffectiveDate());
        attributes.put("veteranDispReason", getVeteranDispReason());
        attributes.put("primaryDispReason", getPrimaryDispReason());
        attributes.put("secondaryDispReason", getSecondaryDispReason());
        attributes.put("secondaryTwoDispReason", getSecondaryTwoDispReason());
        attributes.put("primaryRevocationDate", getPrimaryRevocationDate());
        attributes.put("secondaryRevocationDate", getSecondaryRevocationDate());
        attributes.put("secondaryTwoRevocationDate",
            getSecondaryTwoRevocationDate());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long vcgId = (Long) attributes.get("vcgId");

        if (vcgId != null) {
            setVcgId(vcgId);
        }

        Long veteranId = (Long) attributes.get("veteranId");

        if (veteranId != null) {
            setVeteranId(veteranId);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        Date assessCompletionDate = (Date) attributes.get(
                "assessCompletionDate");

        if (assessCompletionDate != null) {
            setAssessCompletionDate(assessCompletionDate);
        }

        Date primaryTrainedDate = (Date) attributes.get("primaryTrainedDate");

        if (primaryTrainedDate != null) {
            setPrimaryTrainedDate(primaryTrainedDate);
        }

        Date visitationDate = (Date) attributes.get("visitationDate");

        if (visitationDate != null) {
            setVisitationDate(visitationDate);
        }

        Long primaryId = (Long) attributes.get("primaryId");

        if (primaryId != null) {
            setPrimaryId(primaryId);
        }

        Long secondaryId = (Long) attributes.get("secondaryId");

        if (secondaryId != null) {
            setSecondaryId(secondaryId);
        }

        Long secondaryTwoId = (Long) attributes.get("secondaryTwoId");

        if (secondaryTwoId != null) {
            setSecondaryTwoId(secondaryTwoId);
        }

        Boolean generalCaregiver = (Boolean) attributes.get("generalCaregiver");

        if (generalCaregiver != null) {
            setGeneralCaregiver(generalCaregiver);
        }

        String primaryType = (String) attributes.get("primaryType");

        if (primaryType != null) {
            setPrimaryType(primaryType);
        }

        String secondaryType = (String) attributes.get("secondaryType");

        if (secondaryType != null) {
            setSecondaryType(secondaryType);
        }

        String secondaryTwoType = (String) attributes.get("secondaryTwoType");

        if (secondaryTwoType != null) {
            setSecondaryTwoType(secondaryTwoType);
        }

        Date primaryDispositionDate = (Date) attributes.get(
                "primaryDispositionDate");

        if (primaryDispositionDate != null) {
            setPrimaryDispositionDate(primaryDispositionDate);
        }

        Date secondaryDispositionDate = (Date) attributes.get(
                "secondaryDispositionDate");

        if (secondaryDispositionDate != null) {
            setSecondaryDispositionDate(secondaryDispositionDate);
        }

        Date secondaryTwoDispositionDate = (Date) attributes.get(
                "secondaryTwoDispositionDate");

        if (secondaryTwoDispositionDate != null) {
            setSecondaryTwoDispositionDate(secondaryTwoDispositionDate);
        }

        Integer tierLevel = (Integer) attributes.get("tierLevel");

        if (tierLevel != null) {
            setTierLevel(tierLevel);
        }

        Date tierEffectiveDate = (Date) attributes.get("tierEffectiveDate");

        if (tierEffectiveDate != null) {
            setTierEffectiveDate(tierEffectiveDate);
        }

        String veteranDispReason = (String) attributes.get("veteranDispReason");

        if (veteranDispReason != null) {
            setVeteranDispReason(veteranDispReason);
        }

        String primaryDispReason = (String) attributes.get("primaryDispReason");

        if (primaryDispReason != null) {
            setPrimaryDispReason(primaryDispReason);
        }

        String secondaryDispReason = (String) attributes.get(
                "secondaryDispReason");

        if (secondaryDispReason != null) {
            setSecondaryDispReason(secondaryDispReason);
        }

        String secondaryTwoDispReason = (String) attributes.get(
                "secondaryTwoDispReason");

        if (secondaryTwoDispReason != null) {
            setSecondaryTwoDispReason(secondaryTwoDispReason);
        }

        Date primaryRevocationDate = (Date) attributes.get(
                "primaryRevocationDate");

        if (primaryRevocationDate != null) {
            setPrimaryRevocationDate(primaryRevocationDate);
        }

        Date secondaryRevocationDate = (Date) attributes.get(
                "secondaryRevocationDate");

        if (secondaryRevocationDate != null) {
            setSecondaryRevocationDate(secondaryRevocationDate);
        }

        Date secondaryTwoRevocationDate = (Date) attributes.get(
                "secondaryTwoRevocationDate");

        if (secondaryTwoRevocationDate != null) {
            setSecondaryTwoRevocationDate(secondaryTwoRevocationDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getVcgId() {
        return _vcgId;
    }

    @Override
    public void setVcgId(long vcgId) {
        _vcgId = vcgId;
    }

    @Override
    public long getVeteranId() {
        return _veteranId;
    }

    @Override
    public void setVeteranId(long veteranId) {
        _columnBitmask |= VETERANID_COLUMN_BITMASK;

        if (!_setOriginalVeteranId) {
            _setOriginalVeteranId = true;

            _originalVeteranId = _veteranId;
        }

        _veteranId = veteranId;
    }

    public long getOriginalVeteranId() {
        return _originalVeteranId;
    }

    @Override
    public String getStatus() {
        if (_status == null) {
            return StringPool.BLANK;
        } else {
            return _status;
        }
    }

    @Override
    public void setStatus(String status) {
        _status = status;
    }

    @Override
    public Date getAssessCompletionDate() {
        return _assessCompletionDate;
    }

    @Override
    public void setAssessCompletionDate(Date assessCompletionDate) {
        _assessCompletionDate = assessCompletionDate;
    }

    @Override
    public Date getPrimaryTrainedDate() {
        return _primaryTrainedDate;
    }

    @Override
    public void setPrimaryTrainedDate(Date primaryTrainedDate) {
        _primaryTrainedDate = primaryTrainedDate;
    }

    @Override
    public Date getVisitationDate() {
        return _visitationDate;
    }

    @Override
    public void setVisitationDate(Date visitationDate) {
        _visitationDate = visitationDate;
    }

    @Override
    public long getPrimaryId() {
        return _primaryId;
    }

    @Override
    public void setPrimaryId(long primaryId) {
        _primaryId = primaryId;
    }

    @Override
    public long getSecondaryId() {
        return _secondaryId;
    }

    @Override
    public void setSecondaryId(long secondaryId) {
        _secondaryId = secondaryId;
    }

    @Override
    public long getSecondaryTwoId() {
        return _secondaryTwoId;
    }

    @Override
    public void setSecondaryTwoId(long secondaryTwoId) {
        _secondaryTwoId = secondaryTwoId;
    }

    @Override
    public boolean getGeneralCaregiver() {
        return _generalCaregiver;
    }

    @Override
    public boolean isGeneralCaregiver() {
        return _generalCaregiver;
    }

    @Override
    public void setGeneralCaregiver(boolean generalCaregiver) {
        _generalCaregiver = generalCaregiver;
    }

    @Override
    public String getPrimaryType() {
        if (_primaryType == null) {
            return StringPool.BLANK;
        } else {
            return _primaryType;
        }
    }

    @Override
    public void setPrimaryType(String primaryType) {
        _primaryType = primaryType;
    }

    @Override
    public String getSecondaryType() {
        if (_secondaryType == null) {
            return StringPool.BLANK;
        } else {
            return _secondaryType;
        }
    }

    @Override
    public void setSecondaryType(String secondaryType) {
        _secondaryType = secondaryType;
    }

    @Override
    public String getSecondaryTwoType() {
        if (_secondaryTwoType == null) {
            return StringPool.BLANK;
        } else {
            return _secondaryTwoType;
        }
    }

    @Override
    public void setSecondaryTwoType(String secondaryTwoType) {
        _secondaryTwoType = secondaryTwoType;
    }

    @Override
    public Date getPrimaryDispositionDate() {
        return _primaryDispositionDate;
    }

    @Override
    public void setPrimaryDispositionDate(Date primaryDispositionDate) {
        _primaryDispositionDate = primaryDispositionDate;
    }

    @Override
    public Date getSecondaryDispositionDate() {
        return _secondaryDispositionDate;
    }

    @Override
    public void setSecondaryDispositionDate(Date secondaryDispositionDate) {
        _secondaryDispositionDate = secondaryDispositionDate;
    }

    @Override
    public Date getSecondaryTwoDispositionDate() {
        return _secondaryTwoDispositionDate;
    }

    @Override
    public void setSecondaryTwoDispositionDate(Date secondaryTwoDispositionDate) {
        _secondaryTwoDispositionDate = secondaryTwoDispositionDate;
    }

    @Override
    public int getTierLevel() {
        return _tierLevel;
    }

    @Override
    public void setTierLevel(int tierLevel) {
        _tierLevel = tierLevel;
    }

    @Override
    public Date getTierEffectiveDate() {
        return _tierEffectiveDate;
    }

    @Override
    public void setTierEffectiveDate(Date tierEffectiveDate) {
        _tierEffectiveDate = tierEffectiveDate;
    }

    @Override
    public String getVeteranDispReason() {
        if (_veteranDispReason == null) {
            return StringPool.BLANK;
        } else {
            return _veteranDispReason;
        }
    }

    @Override
    public void setVeteranDispReason(String veteranDispReason) {
        _veteranDispReason = veteranDispReason;
    }

    @Override
    public String getPrimaryDispReason() {
        if (_primaryDispReason == null) {
            return StringPool.BLANK;
        } else {
            return _primaryDispReason;
        }
    }

    @Override
    public void setPrimaryDispReason(String primaryDispReason) {
        _primaryDispReason = primaryDispReason;
    }

    @Override
    public String getSecondaryDispReason() {
        if (_secondaryDispReason == null) {
            return StringPool.BLANK;
        } else {
            return _secondaryDispReason;
        }
    }

    @Override
    public void setSecondaryDispReason(String secondaryDispReason) {
        _secondaryDispReason = secondaryDispReason;
    }

    @Override
    public String getSecondaryTwoDispReason() {
        if (_secondaryTwoDispReason == null) {
            return StringPool.BLANK;
        } else {
            return _secondaryTwoDispReason;
        }
    }

    @Override
    public void setSecondaryTwoDispReason(String secondaryTwoDispReason) {
        _secondaryTwoDispReason = secondaryTwoDispReason;
    }

    @Override
    public Date getPrimaryRevocationDate() {
        return _primaryRevocationDate;
    }

    @Override
    public void setPrimaryRevocationDate(Date primaryRevocationDate) {
        _primaryRevocationDate = primaryRevocationDate;
    }

    @Override
    public Date getSecondaryRevocationDate() {
        return _secondaryRevocationDate;
    }

    @Override
    public void setSecondaryRevocationDate(Date secondaryRevocationDate) {
        _secondaryRevocationDate = secondaryRevocationDate;
    }

    @Override
    public Date getSecondaryTwoRevocationDate() {
        return _secondaryTwoRevocationDate;
    }

    @Override
    public void setSecondaryTwoRevocationDate(Date secondaryTwoRevocationDate) {
        _secondaryTwoRevocationDate = secondaryTwoRevocationDate;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Vcg.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Vcg toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Vcg) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        VcgImpl vcgImpl = new VcgImpl();

        vcgImpl.setVcgId(getVcgId());
        vcgImpl.setVeteranId(getVeteranId());
        vcgImpl.setStatus(getStatus());
        vcgImpl.setAssessCompletionDate(getAssessCompletionDate());
        vcgImpl.setPrimaryTrainedDate(getPrimaryTrainedDate());
        vcgImpl.setVisitationDate(getVisitationDate());
        vcgImpl.setPrimaryId(getPrimaryId());
        vcgImpl.setSecondaryId(getSecondaryId());
        vcgImpl.setSecondaryTwoId(getSecondaryTwoId());
        vcgImpl.setGeneralCaregiver(getGeneralCaregiver());
        vcgImpl.setPrimaryType(getPrimaryType());
        vcgImpl.setSecondaryType(getSecondaryType());
        vcgImpl.setSecondaryTwoType(getSecondaryTwoType());
        vcgImpl.setPrimaryDispositionDate(getPrimaryDispositionDate());
        vcgImpl.setSecondaryDispositionDate(getSecondaryDispositionDate());
        vcgImpl.setSecondaryTwoDispositionDate(getSecondaryTwoDispositionDate());
        vcgImpl.setTierLevel(getTierLevel());
        vcgImpl.setTierEffectiveDate(getTierEffectiveDate());
        vcgImpl.setVeteranDispReason(getVeteranDispReason());
        vcgImpl.setPrimaryDispReason(getPrimaryDispReason());
        vcgImpl.setSecondaryDispReason(getSecondaryDispReason());
        vcgImpl.setSecondaryTwoDispReason(getSecondaryTwoDispReason());
        vcgImpl.setPrimaryRevocationDate(getPrimaryRevocationDate());
        vcgImpl.setSecondaryRevocationDate(getSecondaryRevocationDate());
        vcgImpl.setSecondaryTwoRevocationDate(getSecondaryTwoRevocationDate());
        vcgImpl.setGroupId(getGroupId());

        vcgImpl.resetOriginalValues();

        return vcgImpl;
    }

    @Override
    public int compareTo(Vcg vcg) {
        long primaryKey = vcg.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Vcg)) {
            return false;
        }

        Vcg vcg = (Vcg) obj;

        long primaryKey = vcg.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        VcgModelImpl vcgModelImpl = this;

        vcgModelImpl._originalVeteranId = vcgModelImpl._veteranId;

        vcgModelImpl._setOriginalVeteranId = false;

        vcgModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<Vcg> toCacheModel() {
        VcgCacheModel vcgCacheModel = new VcgCacheModel();

        vcgCacheModel.vcgId = getVcgId();

        vcgCacheModel.veteranId = getVeteranId();

        vcgCacheModel.status = getStatus();

        String status = vcgCacheModel.status;

        if ((status != null) && (status.length() == 0)) {
            vcgCacheModel.status = null;
        }

        Date assessCompletionDate = getAssessCompletionDate();

        if (assessCompletionDate != null) {
            vcgCacheModel.assessCompletionDate = assessCompletionDate.getTime();
        } else {
            vcgCacheModel.assessCompletionDate = Long.MIN_VALUE;
        }

        Date primaryTrainedDate = getPrimaryTrainedDate();

        if (primaryTrainedDate != null) {
            vcgCacheModel.primaryTrainedDate = primaryTrainedDate.getTime();
        } else {
            vcgCacheModel.primaryTrainedDate = Long.MIN_VALUE;
        }

        Date visitationDate = getVisitationDate();

        if (visitationDate != null) {
            vcgCacheModel.visitationDate = visitationDate.getTime();
        } else {
            vcgCacheModel.visitationDate = Long.MIN_VALUE;
        }

        vcgCacheModel.primaryId = getPrimaryId();

        vcgCacheModel.secondaryId = getSecondaryId();

        vcgCacheModel.secondaryTwoId = getSecondaryTwoId();

        vcgCacheModel.generalCaregiver = getGeneralCaregiver();

        vcgCacheModel.primaryType = getPrimaryType();

        String primaryType = vcgCacheModel.primaryType;

        if ((primaryType != null) && (primaryType.length() == 0)) {
            vcgCacheModel.primaryType = null;
        }

        vcgCacheModel.secondaryType = getSecondaryType();

        String secondaryType = vcgCacheModel.secondaryType;

        if ((secondaryType != null) && (secondaryType.length() == 0)) {
            vcgCacheModel.secondaryType = null;
        }

        vcgCacheModel.secondaryTwoType = getSecondaryTwoType();

        String secondaryTwoType = vcgCacheModel.secondaryTwoType;

        if ((secondaryTwoType != null) && (secondaryTwoType.length() == 0)) {
            vcgCacheModel.secondaryTwoType = null;
        }

        Date primaryDispositionDate = getPrimaryDispositionDate();

        if (primaryDispositionDate != null) {
            vcgCacheModel.primaryDispositionDate = primaryDispositionDate.getTime();
        } else {
            vcgCacheModel.primaryDispositionDate = Long.MIN_VALUE;
        }

        Date secondaryDispositionDate = getSecondaryDispositionDate();

        if (secondaryDispositionDate != null) {
            vcgCacheModel.secondaryDispositionDate = secondaryDispositionDate.getTime();
        } else {
            vcgCacheModel.secondaryDispositionDate = Long.MIN_VALUE;
        }

        Date secondaryTwoDispositionDate = getSecondaryTwoDispositionDate();

        if (secondaryTwoDispositionDate != null) {
            vcgCacheModel.secondaryTwoDispositionDate = secondaryTwoDispositionDate.getTime();
        } else {
            vcgCacheModel.secondaryTwoDispositionDate = Long.MIN_VALUE;
        }

        vcgCacheModel.tierLevel = getTierLevel();

        Date tierEffectiveDate = getTierEffectiveDate();

        if (tierEffectiveDate != null) {
            vcgCacheModel.tierEffectiveDate = tierEffectiveDate.getTime();
        } else {
            vcgCacheModel.tierEffectiveDate = Long.MIN_VALUE;
        }

        vcgCacheModel.veteranDispReason = getVeteranDispReason();

        String veteranDispReason = vcgCacheModel.veteranDispReason;

        if ((veteranDispReason != null) && (veteranDispReason.length() == 0)) {
            vcgCacheModel.veteranDispReason = null;
        }

        vcgCacheModel.primaryDispReason = getPrimaryDispReason();

        String primaryDispReason = vcgCacheModel.primaryDispReason;

        if ((primaryDispReason != null) && (primaryDispReason.length() == 0)) {
            vcgCacheModel.primaryDispReason = null;
        }

        vcgCacheModel.secondaryDispReason = getSecondaryDispReason();

        String secondaryDispReason = vcgCacheModel.secondaryDispReason;

        if ((secondaryDispReason != null) &&
                (secondaryDispReason.length() == 0)) {
            vcgCacheModel.secondaryDispReason = null;
        }

        vcgCacheModel.secondaryTwoDispReason = getSecondaryTwoDispReason();

        String secondaryTwoDispReason = vcgCacheModel.secondaryTwoDispReason;

        if ((secondaryTwoDispReason != null) &&
                (secondaryTwoDispReason.length() == 0)) {
            vcgCacheModel.secondaryTwoDispReason = null;
        }

        Date primaryRevocationDate = getPrimaryRevocationDate();

        if (primaryRevocationDate != null) {
            vcgCacheModel.primaryRevocationDate = primaryRevocationDate.getTime();
        } else {
            vcgCacheModel.primaryRevocationDate = Long.MIN_VALUE;
        }

        Date secondaryRevocationDate = getSecondaryRevocationDate();

        if (secondaryRevocationDate != null) {
            vcgCacheModel.secondaryRevocationDate = secondaryRevocationDate.getTime();
        } else {
            vcgCacheModel.secondaryRevocationDate = Long.MIN_VALUE;
        }

        Date secondaryTwoRevocationDate = getSecondaryTwoRevocationDate();

        if (secondaryTwoRevocationDate != null) {
            vcgCacheModel.secondaryTwoRevocationDate = secondaryTwoRevocationDate.getTime();
        } else {
            vcgCacheModel.secondaryTwoRevocationDate = Long.MIN_VALUE;
        }

        vcgCacheModel.groupId = getGroupId();

        return vcgCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(53);

        sb.append("{vcgId=");
        sb.append(getVcgId());
        sb.append(", veteranId=");
        sb.append(getVeteranId());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", assessCompletionDate=");
        sb.append(getAssessCompletionDate());
        sb.append(", primaryTrainedDate=");
        sb.append(getPrimaryTrainedDate());
        sb.append(", visitationDate=");
        sb.append(getVisitationDate());
        sb.append(", primaryId=");
        sb.append(getPrimaryId());
        sb.append(", secondaryId=");
        sb.append(getSecondaryId());
        sb.append(", secondaryTwoId=");
        sb.append(getSecondaryTwoId());
        sb.append(", generalCaregiver=");
        sb.append(getGeneralCaregiver());
        sb.append(", primaryType=");
        sb.append(getPrimaryType());
        sb.append(", secondaryType=");
        sb.append(getSecondaryType());
        sb.append(", secondaryTwoType=");
        sb.append(getSecondaryTwoType());
        sb.append(", primaryDispositionDate=");
        sb.append(getPrimaryDispositionDate());
        sb.append(", secondaryDispositionDate=");
        sb.append(getSecondaryDispositionDate());
        sb.append(", secondaryTwoDispositionDate=");
        sb.append(getSecondaryTwoDispositionDate());
        sb.append(", tierLevel=");
        sb.append(getTierLevel());
        sb.append(", tierEffectiveDate=");
        sb.append(getTierEffectiveDate());
        sb.append(", veteranDispReason=");
        sb.append(getVeteranDispReason());
        sb.append(", primaryDispReason=");
        sb.append(getPrimaryDispReason());
        sb.append(", secondaryDispReason=");
        sb.append(getSecondaryDispReason());
        sb.append(", secondaryTwoDispReason=");
        sb.append(getSecondaryTwoDispReason());
        sb.append(", primaryRevocationDate=");
        sb.append(getPrimaryRevocationDate());
        sb.append(", secondaryRevocationDate=");
        sb.append(getSecondaryRevocationDate());
        sb.append(", secondaryTwoRevocationDate=");
        sb.append(getSecondaryTwoRevocationDate());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(82);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Vcg");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>vcgId</column-name><column-value><![CDATA[");
        sb.append(getVcgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>veteranId</column-name><column-value><![CDATA[");
        sb.append(getVeteranId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>assessCompletionDate</column-name><column-value><![CDATA[");
        sb.append(getAssessCompletionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryTrainedDate</column-name><column-value><![CDATA[");
        sb.append(getPrimaryTrainedDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>visitationDate</column-name><column-value><![CDATA[");
        sb.append(getVisitationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryId</column-name><column-value><![CDATA[");
        sb.append(getPrimaryId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryId</column-name><column-value><![CDATA[");
        sb.append(getSecondaryId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoId</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>generalCaregiver</column-name><column-value><![CDATA[");
        sb.append(getGeneralCaregiver());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryType</column-name><column-value><![CDATA[");
        sb.append(getPrimaryType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryType</column-name><column-value><![CDATA[");
        sb.append(getSecondaryType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoType</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryDispositionDate</column-name><column-value><![CDATA[");
        sb.append(getPrimaryDispositionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryDispositionDate</column-name><column-value><![CDATA[");
        sb.append(getSecondaryDispositionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoDispositionDate</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoDispositionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>tierLevel</column-name><column-value><![CDATA[");
        sb.append(getTierLevel());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>tierEffectiveDate</column-name><column-value><![CDATA[");
        sb.append(getTierEffectiveDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>veteranDispReason</column-name><column-value><![CDATA[");
        sb.append(getVeteranDispReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryDispReason</column-name><column-value><![CDATA[");
        sb.append(getPrimaryDispReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryDispReason</column-name><column-value><![CDATA[");
        sb.append(getSecondaryDispReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoDispReason</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoDispReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryRevocationDate</column-name><column-value><![CDATA[");
        sb.append(getPrimaryRevocationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryRevocationDate</column-name><column-value><![CDATA[");
        sb.append(getSecondaryRevocationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoRevocationDate</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoRevocationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
