package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.VcgAn;
import gov.va.caret.model.VcgAnModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the VcgAn service. Represents a row in the &quot;CARET_APPLICATION&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.VcgAnModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link VcgAnImpl}.
 * </p>
 *
 * @author caret
 * @see VcgAnImpl
 * @see gov.va.caret.model.VcgAn
 * @see gov.va.caret.model.VcgAnModel
 * @generated
 */
public class VcgAnModelImpl extends BaseModelImpl<VcgAn> implements VcgAnModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a vcg an model instance should use the {@link gov.va.caret.model.VcgAn} interface instead.
     */
    public static final String TABLE_NAME = "CARET_APPLICATION";
    public static final Object[][] TABLE_COLUMNS = {
            { "vcgAnId", Types.BIGINT },
            { "vcgId", Types.BIGINT },
            { "veteranId", Types.BIGINT },
            { "primaryId", Types.BIGINT },
            { "secondaryId", Types.BIGINT },
            { "secondaryTwoId", Types.BIGINT },
            { "status", Types.VARCHAR },
            { "receivedDate", Types.TIMESTAMP },
            { "primaryRelationship", Types.VARCHAR },
            { "secondaryRelationship", Types.VARCHAR },
            { "secondaryTwoRelationship", Types.VARCHAR },
            { "primarySignDate", Types.TIMESTAMP },
            { "secondarySignDate", Types.TIMESTAMP },
            { "secondaryTwoSignDate", Types.TIMESTAMP },
            { "vaHealthEnrolled", Types.BOOLEAN },
            { "mediEnrolled", Types.BOOLEAN },
            { "lastTreatmentPlace", Types.VARCHAR },
            { "hospital", Types.BOOLEAN },
            { "clinic", Types.BOOLEAN },
            { "submitDate", Types.TIMESTAMP },
            { "creationDate", Types.TIMESTAMP },
            { "groupId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_APPLICATION (vcgAnId LONG not null primary key,vcgId LONG,veteranId LONG,primaryId LONG,secondaryId LONG,secondaryTwoId LONG,status VARCHAR(75) null,receivedDate DATE null,primaryRelationship VARCHAR(75) null,secondaryRelationship VARCHAR(75) null,secondaryTwoRelationship VARCHAR(75) null,primarySignDate DATE null,secondarySignDate DATE null,secondaryTwoSignDate DATE null,vaHealthEnrolled BOOLEAN,mediEnrolled BOOLEAN,lastTreatmentPlace VARCHAR(75) null,hospital BOOLEAN,clinic BOOLEAN,submitDate DATE null,creationDate DATE null,groupId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_APPLICATION";
    public static final String ORDER_BY_JPQL = " ORDER BY vcgAn.creationDate DESC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_APPLICATION.creationDate DESC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.VcgAn"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.VcgAn"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.VcgAn"),
            true);
    public static long PRIMARYID_COLUMN_BITMASK = 1L;
    public static long SECONDARYID_COLUMN_BITMASK = 2L;
    public static long SECONDARYTWOID_COLUMN_BITMASK = 4L;
    public static long VCGID_COLUMN_BITMASK = 8L;
    public static long VETERANID_COLUMN_BITMASK = 16L;
    public static long CREATIONDATE_COLUMN_BITMASK = 32L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.VcgAn"));
    private static ClassLoader _classLoader = VcgAn.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { VcgAn.class };
    private long _vcgAnId;
    private long _vcgId;
    private long _originalVcgId;
    private boolean _setOriginalVcgId;
    private long _veteranId;
    private long _originalVeteranId;
    private boolean _setOriginalVeteranId;
    private long _primaryId;
    private long _originalPrimaryId;
    private boolean _setOriginalPrimaryId;
    private long _secondaryId;
    private long _originalSecondaryId;
    private boolean _setOriginalSecondaryId;
    private long _secondaryTwoId;
    private long _originalSecondaryTwoId;
    private boolean _setOriginalSecondaryTwoId;
    private String _status;
    private Date _receivedDate;
    private String _primaryRelationship;
    private String _secondaryRelationship;
    private String _secondaryTwoRelationship;
    private Date _primarySignDate;
    private Date _secondarySignDate;
    private Date _secondaryTwoSignDate;
    private boolean _vaHealthEnrolled;
    private boolean _mediEnrolled;
    private String _lastTreatmentPlace;
    private boolean _hospital;
    private boolean _clinic;
    private Date _submitDate;
    private Date _creationDate;
    private long _groupId;
    private long _columnBitmask;
    private VcgAn _escapedModel;

    public VcgAnModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _vcgAnId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setVcgAnId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _vcgAnId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return VcgAn.class;
    }

    @Override
    public String getModelClassName() {
        return VcgAn.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("vcgAnId", getVcgAnId());
        attributes.put("vcgId", getVcgId());
        attributes.put("veteranId", getVeteranId());
        attributes.put("primaryId", getPrimaryId());
        attributes.put("secondaryId", getSecondaryId());
        attributes.put("secondaryTwoId", getSecondaryTwoId());
        attributes.put("status", getStatus());
        attributes.put("receivedDate", getReceivedDate());
        attributes.put("primaryRelationship", getPrimaryRelationship());
        attributes.put("secondaryRelationship", getSecondaryRelationship());
        attributes.put("secondaryTwoRelationship", getSecondaryTwoRelationship());
        attributes.put("primarySignDate", getPrimarySignDate());
        attributes.put("secondarySignDate", getSecondarySignDate());
        attributes.put("secondaryTwoSignDate", getSecondaryTwoSignDate());
        attributes.put("vaHealthEnrolled", getVaHealthEnrolled());
        attributes.put("mediEnrolled", getMediEnrolled());
        attributes.put("lastTreatmentPlace", getLastTreatmentPlace());
        attributes.put("hospital", getHospital());
        attributes.put("clinic", getClinic());
        attributes.put("submitDate", getSubmitDate());
        attributes.put("creationDate", getCreationDate());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long vcgAnId = (Long) attributes.get("vcgAnId");

        if (vcgAnId != null) {
            setVcgAnId(vcgAnId);
        }

        Long vcgId = (Long) attributes.get("vcgId");

        if (vcgId != null) {
            setVcgId(vcgId);
        }

        Long veteranId = (Long) attributes.get("veteranId");

        if (veteranId != null) {
            setVeteranId(veteranId);
        }

        Long primaryId = (Long) attributes.get("primaryId");

        if (primaryId != null) {
            setPrimaryId(primaryId);
        }

        Long secondaryId = (Long) attributes.get("secondaryId");

        if (secondaryId != null) {
            setSecondaryId(secondaryId);
        }

        Long secondaryTwoId = (Long) attributes.get("secondaryTwoId");

        if (secondaryTwoId != null) {
            setSecondaryTwoId(secondaryTwoId);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        Date receivedDate = (Date) attributes.get("receivedDate");

        if (receivedDate != null) {
            setReceivedDate(receivedDate);
        }

        String primaryRelationship = (String) attributes.get(
                "primaryRelationship");

        if (primaryRelationship != null) {
            setPrimaryRelationship(primaryRelationship);
        }

        String secondaryRelationship = (String) attributes.get(
                "secondaryRelationship");

        if (secondaryRelationship != null) {
            setSecondaryRelationship(secondaryRelationship);
        }

        String secondaryTwoRelationship = (String) attributes.get(
                "secondaryTwoRelationship");

        if (secondaryTwoRelationship != null) {
            setSecondaryTwoRelationship(secondaryTwoRelationship);
        }

        Date primarySignDate = (Date) attributes.get("primarySignDate");

        if (primarySignDate != null) {
            setPrimarySignDate(primarySignDate);
        }

        Date secondarySignDate = (Date) attributes.get("secondarySignDate");

        if (secondarySignDate != null) {
            setSecondarySignDate(secondarySignDate);
        }

        Date secondaryTwoSignDate = (Date) attributes.get(
                "secondaryTwoSignDate");

        if (secondaryTwoSignDate != null) {
            setSecondaryTwoSignDate(secondaryTwoSignDate);
        }

        Boolean vaHealthEnrolled = (Boolean) attributes.get("vaHealthEnrolled");

        if (vaHealthEnrolled != null) {
            setVaHealthEnrolled(vaHealthEnrolled);
        }

        Boolean mediEnrolled = (Boolean) attributes.get("mediEnrolled");

        if (mediEnrolled != null) {
            setMediEnrolled(mediEnrolled);
        }

        String lastTreatmentPlace = (String) attributes.get(
                "lastTreatmentPlace");

        if (lastTreatmentPlace != null) {
            setLastTreatmentPlace(lastTreatmentPlace);
        }

        Boolean hospital = (Boolean) attributes.get("hospital");

        if (hospital != null) {
            setHospital(hospital);
        }

        Boolean clinic = (Boolean) attributes.get("clinic");

        if (clinic != null) {
            setClinic(clinic);
        }

        Date submitDate = (Date) attributes.get("submitDate");

        if (submitDate != null) {
            setSubmitDate(submitDate);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getVcgAnId() {
        return _vcgAnId;
    }

    @Override
    public void setVcgAnId(long vcgAnId) {
        _vcgAnId = vcgAnId;
    }

    @Override
    public long getVcgId() {
        return _vcgId;
    }

    @Override
    public void setVcgId(long vcgId) {
        _columnBitmask |= VCGID_COLUMN_BITMASK;

        if (!_setOriginalVcgId) {
            _setOriginalVcgId = true;

            _originalVcgId = _vcgId;
        }

        _vcgId = vcgId;
    }

    public long getOriginalVcgId() {
        return _originalVcgId;
    }

    @Override
    public long getVeteranId() {
        return _veteranId;
    }

    @Override
    public void setVeteranId(long veteranId) {
        _columnBitmask |= VETERANID_COLUMN_BITMASK;

        if (!_setOriginalVeteranId) {
            _setOriginalVeteranId = true;

            _originalVeteranId = _veteranId;
        }

        _veteranId = veteranId;
    }

    public long getOriginalVeteranId() {
        return _originalVeteranId;
    }

    @Override
    public long getPrimaryId() {
        return _primaryId;
    }

    @Override
    public void setPrimaryId(long primaryId) {
        _columnBitmask |= PRIMARYID_COLUMN_BITMASK;

        if (!_setOriginalPrimaryId) {
            _setOriginalPrimaryId = true;

            _originalPrimaryId = _primaryId;
        }

        _primaryId = primaryId;
    }

    public long getOriginalPrimaryId() {
        return _originalPrimaryId;
    }

    @Override
    public long getSecondaryId() {
        return _secondaryId;
    }

    @Override
    public void setSecondaryId(long secondaryId) {
        _columnBitmask |= SECONDARYID_COLUMN_BITMASK;

        if (!_setOriginalSecondaryId) {
            _setOriginalSecondaryId = true;

            _originalSecondaryId = _secondaryId;
        }

        _secondaryId = secondaryId;
    }

    public long getOriginalSecondaryId() {
        return _originalSecondaryId;
    }

    @Override
    public long getSecondaryTwoId() {
        return _secondaryTwoId;
    }

    @Override
    public void setSecondaryTwoId(long secondaryTwoId) {
        _columnBitmask |= SECONDARYTWOID_COLUMN_BITMASK;

        if (!_setOriginalSecondaryTwoId) {
            _setOriginalSecondaryTwoId = true;

            _originalSecondaryTwoId = _secondaryTwoId;
        }

        _secondaryTwoId = secondaryTwoId;
    }

    public long getOriginalSecondaryTwoId() {
        return _originalSecondaryTwoId;
    }

    @Override
    public String getStatus() {
        if (_status == null) {
            return StringPool.BLANK;
        } else {
            return _status;
        }
    }

    @Override
    public void setStatus(String status) {
        _status = status;
    }

    @Override
    public Date getReceivedDate() {
        return _receivedDate;
    }

    @Override
    public void setReceivedDate(Date receivedDate) {
        _receivedDate = receivedDate;
    }

    @Override
    public String getPrimaryRelationship() {
        if (_primaryRelationship == null) {
            return StringPool.BLANK;
        } else {
            return _primaryRelationship;
        }
    }

    @Override
    public void setPrimaryRelationship(String primaryRelationship) {
        _primaryRelationship = primaryRelationship;
    }

    @Override
    public String getSecondaryRelationship() {
        if (_secondaryRelationship == null) {
            return StringPool.BLANK;
        } else {
            return _secondaryRelationship;
        }
    }

    @Override
    public void setSecondaryRelationship(String secondaryRelationship) {
        _secondaryRelationship = secondaryRelationship;
    }

    @Override
    public String getSecondaryTwoRelationship() {
        if (_secondaryTwoRelationship == null) {
            return StringPool.BLANK;
        } else {
            return _secondaryTwoRelationship;
        }
    }

    @Override
    public void setSecondaryTwoRelationship(String secondaryTwoRelationship) {
        _secondaryTwoRelationship = secondaryTwoRelationship;
    }

    @Override
    public Date getPrimarySignDate() {
        return _primarySignDate;
    }

    @Override
    public void setPrimarySignDate(Date primarySignDate) {
        _primarySignDate = primarySignDate;
    }

    @Override
    public Date getSecondarySignDate() {
        return _secondarySignDate;
    }

    @Override
    public void setSecondarySignDate(Date secondarySignDate) {
        _secondarySignDate = secondarySignDate;
    }

    @Override
    public Date getSecondaryTwoSignDate() {
        return _secondaryTwoSignDate;
    }

    @Override
    public void setSecondaryTwoSignDate(Date secondaryTwoSignDate) {
        _secondaryTwoSignDate = secondaryTwoSignDate;
    }

    @Override
    public boolean getVaHealthEnrolled() {
        return _vaHealthEnrolled;
    }

    @Override
    public boolean isVaHealthEnrolled() {
        return _vaHealthEnrolled;
    }

    @Override
    public void setVaHealthEnrolled(boolean vaHealthEnrolled) {
        _vaHealthEnrolled = vaHealthEnrolled;
    }

    @Override
    public boolean getMediEnrolled() {
        return _mediEnrolled;
    }

    @Override
    public boolean isMediEnrolled() {
        return _mediEnrolled;
    }

    @Override
    public void setMediEnrolled(boolean mediEnrolled) {
        _mediEnrolled = mediEnrolled;
    }

    @Override
    public String getLastTreatmentPlace() {
        if (_lastTreatmentPlace == null) {
            return StringPool.BLANK;
        } else {
            return _lastTreatmentPlace;
        }
    }

    @Override
    public void setLastTreatmentPlace(String lastTreatmentPlace) {
        _lastTreatmentPlace = lastTreatmentPlace;
    }

    @Override
    public boolean getHospital() {
        return _hospital;
    }

    @Override
    public boolean isHospital() {
        return _hospital;
    }

    @Override
    public void setHospital(boolean hospital) {
        _hospital = hospital;
    }

    @Override
    public boolean getClinic() {
        return _clinic;
    }

    @Override
    public boolean isClinic() {
        return _clinic;
    }

    @Override
    public void setClinic(boolean clinic) {
        _clinic = clinic;
    }

    @Override
    public Date getSubmitDate() {
        return _submitDate;
    }

    @Override
    public void setSubmitDate(Date submitDate) {
        _submitDate = submitDate;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _columnBitmask = -1L;

        _creationDate = creationDate;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            VcgAn.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public VcgAn toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (VcgAn) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        VcgAnImpl vcgAnImpl = new VcgAnImpl();

        vcgAnImpl.setVcgAnId(getVcgAnId());
        vcgAnImpl.setVcgId(getVcgId());
        vcgAnImpl.setVeteranId(getVeteranId());
        vcgAnImpl.setPrimaryId(getPrimaryId());
        vcgAnImpl.setSecondaryId(getSecondaryId());
        vcgAnImpl.setSecondaryTwoId(getSecondaryTwoId());
        vcgAnImpl.setStatus(getStatus());
        vcgAnImpl.setReceivedDate(getReceivedDate());
        vcgAnImpl.setPrimaryRelationship(getPrimaryRelationship());
        vcgAnImpl.setSecondaryRelationship(getSecondaryRelationship());
        vcgAnImpl.setSecondaryTwoRelationship(getSecondaryTwoRelationship());
        vcgAnImpl.setPrimarySignDate(getPrimarySignDate());
        vcgAnImpl.setSecondarySignDate(getSecondarySignDate());
        vcgAnImpl.setSecondaryTwoSignDate(getSecondaryTwoSignDate());
        vcgAnImpl.setVaHealthEnrolled(getVaHealthEnrolled());
        vcgAnImpl.setMediEnrolled(getMediEnrolled());
        vcgAnImpl.setLastTreatmentPlace(getLastTreatmentPlace());
        vcgAnImpl.setHospital(getHospital());
        vcgAnImpl.setClinic(getClinic());
        vcgAnImpl.setSubmitDate(getSubmitDate());
        vcgAnImpl.setCreationDate(getCreationDate());
        vcgAnImpl.setGroupId(getGroupId());

        vcgAnImpl.resetOriginalValues();

        return vcgAnImpl;
    }

    @Override
    public int compareTo(VcgAn vcgAn) {
        int value = 0;

        value = DateUtil.compareTo(getCreationDate(), vcgAn.getCreationDate());

        value = value * -1;

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof VcgAn)) {
            return false;
        }

        VcgAn vcgAn = (VcgAn) obj;

        long primaryKey = vcgAn.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        VcgAnModelImpl vcgAnModelImpl = this;

        vcgAnModelImpl._originalVcgId = vcgAnModelImpl._vcgId;

        vcgAnModelImpl._setOriginalVcgId = false;

        vcgAnModelImpl._originalVeteranId = vcgAnModelImpl._veteranId;

        vcgAnModelImpl._setOriginalVeteranId = false;

        vcgAnModelImpl._originalPrimaryId = vcgAnModelImpl._primaryId;

        vcgAnModelImpl._setOriginalPrimaryId = false;

        vcgAnModelImpl._originalSecondaryId = vcgAnModelImpl._secondaryId;

        vcgAnModelImpl._setOriginalSecondaryId = false;

        vcgAnModelImpl._originalSecondaryTwoId = vcgAnModelImpl._secondaryTwoId;

        vcgAnModelImpl._setOriginalSecondaryTwoId = false;

        vcgAnModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<VcgAn> toCacheModel() {
        VcgAnCacheModel vcgAnCacheModel = new VcgAnCacheModel();

        vcgAnCacheModel.vcgAnId = getVcgAnId();

        vcgAnCacheModel.vcgId = getVcgId();

        vcgAnCacheModel.veteranId = getVeteranId();

        vcgAnCacheModel.primaryId = getPrimaryId();

        vcgAnCacheModel.secondaryId = getSecondaryId();

        vcgAnCacheModel.secondaryTwoId = getSecondaryTwoId();

        vcgAnCacheModel.status = getStatus();

        String status = vcgAnCacheModel.status;

        if ((status != null) && (status.length() == 0)) {
            vcgAnCacheModel.status = null;
        }

        Date receivedDate = getReceivedDate();

        if (receivedDate != null) {
            vcgAnCacheModel.receivedDate = receivedDate.getTime();
        } else {
            vcgAnCacheModel.receivedDate = Long.MIN_VALUE;
        }

        vcgAnCacheModel.primaryRelationship = getPrimaryRelationship();

        String primaryRelationship = vcgAnCacheModel.primaryRelationship;

        if ((primaryRelationship != null) &&
                (primaryRelationship.length() == 0)) {
            vcgAnCacheModel.primaryRelationship = null;
        }

        vcgAnCacheModel.secondaryRelationship = getSecondaryRelationship();

        String secondaryRelationship = vcgAnCacheModel.secondaryRelationship;

        if ((secondaryRelationship != null) &&
                (secondaryRelationship.length() == 0)) {
            vcgAnCacheModel.secondaryRelationship = null;
        }

        vcgAnCacheModel.secondaryTwoRelationship = getSecondaryTwoRelationship();

        String secondaryTwoRelationship = vcgAnCacheModel.secondaryTwoRelationship;

        if ((secondaryTwoRelationship != null) &&
                (secondaryTwoRelationship.length() == 0)) {
            vcgAnCacheModel.secondaryTwoRelationship = null;
        }

        Date primarySignDate = getPrimarySignDate();

        if (primarySignDate != null) {
            vcgAnCacheModel.primarySignDate = primarySignDate.getTime();
        } else {
            vcgAnCacheModel.primarySignDate = Long.MIN_VALUE;
        }

        Date secondarySignDate = getSecondarySignDate();

        if (secondarySignDate != null) {
            vcgAnCacheModel.secondarySignDate = secondarySignDate.getTime();
        } else {
            vcgAnCacheModel.secondarySignDate = Long.MIN_VALUE;
        }

        Date secondaryTwoSignDate = getSecondaryTwoSignDate();

        if (secondaryTwoSignDate != null) {
            vcgAnCacheModel.secondaryTwoSignDate = secondaryTwoSignDate.getTime();
        } else {
            vcgAnCacheModel.secondaryTwoSignDate = Long.MIN_VALUE;
        }

        vcgAnCacheModel.vaHealthEnrolled = getVaHealthEnrolled();

        vcgAnCacheModel.mediEnrolled = getMediEnrolled();

        vcgAnCacheModel.lastTreatmentPlace = getLastTreatmentPlace();

        String lastTreatmentPlace = vcgAnCacheModel.lastTreatmentPlace;

        if ((lastTreatmentPlace != null) && (lastTreatmentPlace.length() == 0)) {
            vcgAnCacheModel.lastTreatmentPlace = null;
        }

        vcgAnCacheModel.hospital = getHospital();

        vcgAnCacheModel.clinic = getClinic();

        Date submitDate = getSubmitDate();

        if (submitDate != null) {
            vcgAnCacheModel.submitDate = submitDate.getTime();
        } else {
            vcgAnCacheModel.submitDate = Long.MIN_VALUE;
        }

        Date creationDate = getCreationDate();

        if (creationDate != null) {
            vcgAnCacheModel.creationDate = creationDate.getTime();
        } else {
            vcgAnCacheModel.creationDate = Long.MIN_VALUE;
        }

        vcgAnCacheModel.groupId = getGroupId();

        return vcgAnCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(45);

        sb.append("{vcgAnId=");
        sb.append(getVcgAnId());
        sb.append(", vcgId=");
        sb.append(getVcgId());
        sb.append(", veteranId=");
        sb.append(getVeteranId());
        sb.append(", primaryId=");
        sb.append(getPrimaryId());
        sb.append(", secondaryId=");
        sb.append(getSecondaryId());
        sb.append(", secondaryTwoId=");
        sb.append(getSecondaryTwoId());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", receivedDate=");
        sb.append(getReceivedDate());
        sb.append(", primaryRelationship=");
        sb.append(getPrimaryRelationship());
        sb.append(", secondaryRelationship=");
        sb.append(getSecondaryRelationship());
        sb.append(", secondaryTwoRelationship=");
        sb.append(getSecondaryTwoRelationship());
        sb.append(", primarySignDate=");
        sb.append(getPrimarySignDate());
        sb.append(", secondarySignDate=");
        sb.append(getSecondarySignDate());
        sb.append(", secondaryTwoSignDate=");
        sb.append(getSecondaryTwoSignDate());
        sb.append(", vaHealthEnrolled=");
        sb.append(getVaHealthEnrolled());
        sb.append(", mediEnrolled=");
        sb.append(getMediEnrolled());
        sb.append(", lastTreatmentPlace=");
        sb.append(getLastTreatmentPlace());
        sb.append(", hospital=");
        sb.append(getHospital());
        sb.append(", clinic=");
        sb.append(getClinic());
        sb.append(", submitDate=");
        sb.append(getSubmitDate());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(70);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.VcgAn");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>vcgAnId</column-name><column-value><![CDATA[");
        sb.append(getVcgAnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vcgId</column-name><column-value><![CDATA[");
        sb.append(getVcgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>veteranId</column-name><column-value><![CDATA[");
        sb.append(getVeteranId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryId</column-name><column-value><![CDATA[");
        sb.append(getPrimaryId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryId</column-name><column-value><![CDATA[");
        sb.append(getSecondaryId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoId</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>receivedDate</column-name><column-value><![CDATA[");
        sb.append(getReceivedDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryRelationship</column-name><column-value><![CDATA[");
        sb.append(getPrimaryRelationship());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryRelationship</column-name><column-value><![CDATA[");
        sb.append(getSecondaryRelationship());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoRelationship</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoRelationship());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primarySignDate</column-name><column-value><![CDATA[");
        sb.append(getPrimarySignDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondarySignDate</column-name><column-value><![CDATA[");
        sb.append(getSecondarySignDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoSignDate</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoSignDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vaHealthEnrolled</column-name><column-value><![CDATA[");
        sb.append(getVaHealthEnrolled());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>mediEnrolled</column-name><column-value><![CDATA[");
        sb.append(getMediEnrolled());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>lastTreatmentPlace</column-name><column-value><![CDATA[");
        sb.append(getLastTreatmentPlace());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>hospital</column-name><column-value><![CDATA[");
        sb.append(getHospital());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>clinic</column-name><column-value><![CDATA[");
        sb.append(getClinic());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>submitDate</column-name><column-value><![CDATA[");
        sb.append(getSubmitDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
