package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.StiRd;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing StiRd in entity cache.
 *
 * @author caret
 * @see StiRd
 * @generated
 */
public class StiRdCacheModel implements CacheModel<StiRd>, Externalizable {
    public long stiRdId;
    public long vcgAnId;
    public String cscStatus;
    public long cscStatusDate;
    public String cbopcStatus;
    public long cbopcStatusDate;
    public long creationDate;
    public long userId;
    public long groupId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(19);

        sb.append("{stiRdId=");
        sb.append(stiRdId);
        sb.append(", vcgAnId=");
        sb.append(vcgAnId);
        sb.append(", cscStatus=");
        sb.append(cscStatus);
        sb.append(", cscStatusDate=");
        sb.append(cscStatusDate);
        sb.append(", cbopcStatus=");
        sb.append(cbopcStatus);
        sb.append(", cbopcStatusDate=");
        sb.append(cbopcStatusDate);
        sb.append(", creationDate=");
        sb.append(creationDate);
        sb.append(", userId=");
        sb.append(userId);
        sb.append(", groupId=");
        sb.append(groupId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public StiRd toEntityModel() {
        StiRdImpl stiRdImpl = new StiRdImpl();

        stiRdImpl.setStiRdId(stiRdId);
        stiRdImpl.setVcgAnId(vcgAnId);

        if (cscStatus == null) {
            stiRdImpl.setCscStatus(StringPool.BLANK);
        } else {
            stiRdImpl.setCscStatus(cscStatus);
        }

        if (cscStatusDate == Long.MIN_VALUE) {
            stiRdImpl.setCscStatusDate(null);
        } else {
            stiRdImpl.setCscStatusDate(new Date(cscStatusDate));
        }

        if (cbopcStatus == null) {
            stiRdImpl.setCbopcStatus(StringPool.BLANK);
        } else {
            stiRdImpl.setCbopcStatus(cbopcStatus);
        }

        if (cbopcStatusDate == Long.MIN_VALUE) {
            stiRdImpl.setCbopcStatusDate(null);
        } else {
            stiRdImpl.setCbopcStatusDate(new Date(cbopcStatusDate));
        }

        if (creationDate == Long.MIN_VALUE) {
            stiRdImpl.setCreationDate(null);
        } else {
            stiRdImpl.setCreationDate(new Date(creationDate));
        }

        stiRdImpl.setUserId(userId);
        stiRdImpl.setGroupId(groupId);

        stiRdImpl.resetOriginalValues();

        return stiRdImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        stiRdId = objectInput.readLong();
        vcgAnId = objectInput.readLong();
        cscStatus = objectInput.readUTF();
        cscStatusDate = objectInput.readLong();
        cbopcStatus = objectInput.readUTF();
        cbopcStatusDate = objectInput.readLong();
        creationDate = objectInput.readLong();
        userId = objectInput.readLong();
        groupId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(stiRdId);
        objectOutput.writeLong(vcgAnId);

        if (cscStatus == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(cscStatus);
        }

        objectOutput.writeLong(cscStatusDate);

        if (cbopcStatus == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(cbopcStatus);
        }

        objectOutput.writeLong(cbopcStatusDate);
        objectOutput.writeLong(creationDate);
        objectOutput.writeLong(userId);
        objectOutput.writeLong(groupId);
    }
}
