package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Persn;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing Persn in entity cache.
 *
 * @author caret
 * @see Persn
 * @generated
 */
public class PersnCacheModel implements CacheModel<Persn>, Externalizable {
    public long persnId;
    public long persnUserId;
    public String lastName;
    public String firstName;
    public String middleName;
    public String prefix;
    public String suffix;
    public long birthDate;
    public long deceasedDate;
    public String gender;
    public String address;
    public String address2;
    public String city;
    public String state;
    public String country;
    public String zip;
    public String phone;
    public String phone2;
    public String email;
    public String email2;
    public String status;
    public String source;
    public String externalId;
    public String otherHealthInsurance;
    public long userId;
    public long groupId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(53);

        sb.append("{persnId=");
        sb.append(persnId);
        sb.append(", persnUserId=");
        sb.append(persnUserId);
        sb.append(", lastName=");
        sb.append(lastName);
        sb.append(", firstName=");
        sb.append(firstName);
        sb.append(", middleName=");
        sb.append(middleName);
        sb.append(", prefix=");
        sb.append(prefix);
        sb.append(", suffix=");
        sb.append(suffix);
        sb.append(", birthDate=");
        sb.append(birthDate);
        sb.append(", deceasedDate=");
        sb.append(deceasedDate);
        sb.append(", gender=");
        sb.append(gender);
        sb.append(", address=");
        sb.append(address);
        sb.append(", address2=");
        sb.append(address2);
        sb.append(", city=");
        sb.append(city);
        sb.append(", state=");
        sb.append(state);
        sb.append(", country=");
        sb.append(country);
        sb.append(", zip=");
        sb.append(zip);
        sb.append(", phone=");
        sb.append(phone);
        sb.append(", phone2=");
        sb.append(phone2);
        sb.append(", email=");
        sb.append(email);
        sb.append(", email2=");
        sb.append(email2);
        sb.append(", status=");
        sb.append(status);
        sb.append(", source=");
        sb.append(source);
        sb.append(", externalId=");
        sb.append(externalId);
        sb.append(", otherHealthInsurance=");
        sb.append(otherHealthInsurance);
        sb.append(", userId=");
        sb.append(userId);
        sb.append(", groupId=");
        sb.append(groupId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Persn toEntityModel() {
        PersnImpl persnImpl = new PersnImpl();

        persnImpl.setPersnId(persnId);
        persnImpl.setPersnUserId(persnUserId);

        if (lastName == null) {
            persnImpl.setLastName(StringPool.BLANK);
        } else {
            persnImpl.setLastName(lastName);
        }

        if (firstName == null) {
            persnImpl.setFirstName(StringPool.BLANK);
        } else {
            persnImpl.setFirstName(firstName);
        }

        if (middleName == null) {
            persnImpl.setMiddleName(StringPool.BLANK);
        } else {
            persnImpl.setMiddleName(middleName);
        }

        if (prefix == null) {
            persnImpl.setPrefix(StringPool.BLANK);
        } else {
            persnImpl.setPrefix(prefix);
        }

        if (suffix == null) {
            persnImpl.setSuffix(StringPool.BLANK);
        } else {
            persnImpl.setSuffix(suffix);
        }

        if (birthDate == Long.MIN_VALUE) {
            persnImpl.setBirthDate(null);
        } else {
            persnImpl.setBirthDate(new Date(birthDate));
        }

        if (deceasedDate == Long.MIN_VALUE) {
            persnImpl.setDeceasedDate(null);
        } else {
            persnImpl.setDeceasedDate(new Date(deceasedDate));
        }

        if (gender == null) {
            persnImpl.setGender(StringPool.BLANK);
        } else {
            persnImpl.setGender(gender);
        }

        if (address == null) {
            persnImpl.setAddress(StringPool.BLANK);
        } else {
            persnImpl.setAddress(address);
        }

        if (address2 == null) {
            persnImpl.setAddress2(StringPool.BLANK);
        } else {
            persnImpl.setAddress2(address2);
        }

        if (city == null) {
            persnImpl.setCity(StringPool.BLANK);
        } else {
            persnImpl.setCity(city);
        }

        if (state == null) {
            persnImpl.setState(StringPool.BLANK);
        } else {
            persnImpl.setState(state);
        }

        if (country == null) {
            persnImpl.setCountry(StringPool.BLANK);
        } else {
            persnImpl.setCountry(country);
        }

        if (zip == null) {
            persnImpl.setZip(StringPool.BLANK);
        } else {
            persnImpl.setZip(zip);
        }

        if (phone == null) {
            persnImpl.setPhone(StringPool.BLANK);
        } else {
            persnImpl.setPhone(phone);
        }

        if (phone2 == null) {
            persnImpl.setPhone2(StringPool.BLANK);
        } else {
            persnImpl.setPhone2(phone2);
        }

        if (email == null) {
            persnImpl.setEmail(StringPool.BLANK);
        } else {
            persnImpl.setEmail(email);
        }

        if (email2 == null) {
            persnImpl.setEmail2(StringPool.BLANK);
        } else {
            persnImpl.setEmail2(email2);
        }

        if (status == null) {
            persnImpl.setStatus(StringPool.BLANK);
        } else {
            persnImpl.setStatus(status);
        }

        if (source == null) {
            persnImpl.setSource(StringPool.BLANK);
        } else {
            persnImpl.setSource(source);
        }

        if (externalId == null) {
            persnImpl.setExternalId(StringPool.BLANK);
        } else {
            persnImpl.setExternalId(externalId);
        }

        if (otherHealthInsurance == null) {
            persnImpl.setOtherHealthInsurance(StringPool.BLANK);
        } else {
            persnImpl.setOtherHealthInsurance(otherHealthInsurance);
        }

        persnImpl.setUserId(userId);
        persnImpl.setGroupId(groupId);

        persnImpl.resetOriginalValues();

        return persnImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        persnId = objectInput.readLong();
        persnUserId = objectInput.readLong();
        lastName = objectInput.readUTF();
        firstName = objectInput.readUTF();
        middleName = objectInput.readUTF();
        prefix = objectInput.readUTF();
        suffix = objectInput.readUTF();
        birthDate = objectInput.readLong();
        deceasedDate = objectInput.readLong();
        gender = objectInput.readUTF();
        address = objectInput.readUTF();
        address2 = objectInput.readUTF();
        city = objectInput.readUTF();
        state = objectInput.readUTF();
        country = objectInput.readUTF();
        zip = objectInput.readUTF();
        phone = objectInput.readUTF();
        phone2 = objectInput.readUTF();
        email = objectInput.readUTF();
        email2 = objectInput.readUTF();
        status = objectInput.readUTF();
        source = objectInput.readUTF();
        externalId = objectInput.readUTF();
        otherHealthInsurance = objectInput.readUTF();
        userId = objectInput.readLong();
        groupId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(persnId);
        objectOutput.writeLong(persnUserId);

        if (lastName == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(lastName);
        }

        if (firstName == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(firstName);
        }

        if (middleName == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(middleName);
        }

        if (prefix == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(prefix);
        }

        if (suffix == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(suffix);
        }

        objectOutput.writeLong(birthDate);
        objectOutput.writeLong(deceasedDate);

        if (gender == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(gender);
        }

        if (address == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(address);
        }

        if (address2 == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(address2);
        }

        if (city == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(city);
        }

        if (state == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(state);
        }

        if (country == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(country);
        }

        if (zip == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(zip);
        }

        if (phone == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(phone);
        }

        if (phone2 == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(phone2);
        }

        if (email == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(email);
        }

        if (email2 == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(email2);
        }

        if (status == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(status);
        }

        if (source == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(source);
        }

        if (externalId == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(externalId);
        }

        if (otherHealthInsurance == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(otherHealthInsurance);
        }

        objectOutput.writeLong(userId);
        objectOutput.writeLong(groupId);
    }
}
