package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.PayLg;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing PayLg in entity cache.
 *
 * @author caret
 * @see PayLg
 * @generated
 */
public class PayLgCacheModel implements CacheModel<PayLg>, Externalizable {
    public long paymentLogId;
    public long stiPtId;
    public Double amount;
    public long paymentDate;
    public String status;
    public String reason;
    public long creationDate;
    public long userId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(17);

        sb.append("{paymentLogId=");
        sb.append(paymentLogId);
        sb.append(", stiPtId=");
        sb.append(stiPtId);
        sb.append(", amount=");
        sb.append(amount);
        sb.append(", paymentDate=");
        sb.append(paymentDate);
        sb.append(", status=");
        sb.append(status);
        sb.append(", reason=");
        sb.append(reason);
        sb.append(", creationDate=");
        sb.append(creationDate);
        sb.append(", userId=");
        sb.append(userId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public PayLg toEntityModel() {
        PayLgImpl payLgImpl = new PayLgImpl();

        payLgImpl.setPaymentLogId(paymentLogId);
        payLgImpl.setStiPtId(stiPtId);
        payLgImpl.setAmount(amount);

        if (paymentDate == Long.MIN_VALUE) {
            payLgImpl.setPaymentDate(null);
        } else {
            payLgImpl.setPaymentDate(new Date(paymentDate));
        }

        if (status == null) {
            payLgImpl.setStatus(StringPool.BLANK);
        } else {
            payLgImpl.setStatus(status);
        }

        if (reason == null) {
            payLgImpl.setReason(StringPool.BLANK);
        } else {
            payLgImpl.setReason(reason);
        }

        if (creationDate == Long.MIN_VALUE) {
            payLgImpl.setCreationDate(null);
        } else {
            payLgImpl.setCreationDate(new Date(creationDate));
        }

        payLgImpl.setUserId(userId);

        payLgImpl.resetOriginalValues();

        return payLgImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        paymentLogId = objectInput.readLong();
        stiPtId = objectInput.readLong();
        amount = objectInput.readDouble();
        paymentDate = objectInput.readLong();
        status = objectInput.readUTF();
        reason = objectInput.readUTF();
        creationDate = objectInput.readLong();
        userId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(paymentLogId);
        objectOutput.writeLong(stiPtId);
        objectOutput.writeDouble(amount);
        objectOutput.writeLong(paymentDate);

        if (status == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(status);
        }

        if (reason == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(reason);
        }

        objectOutput.writeLong(creationDate);
        objectOutput.writeLong(userId);
    }
}
