package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Notif;
import gov.va.caret.model.NotifModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Notif service. Represents a row in the &quot;CARET_NOTIFICATION&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.NotifModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NotifImpl}.
 * </p>
 *
 * @author caret
 * @see NotifImpl
 * @see gov.va.caret.model.Notif
 * @see gov.va.caret.model.NotifModel
 * @generated
 */
public class NotifModelImpl extends BaseModelImpl<Notif> implements NotifModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a notif model instance should use the {@link gov.va.caret.model.Notif} interface instead.
     */
    public static final String TABLE_NAME = "CARET_NOTIFICATION";
    public static final Object[][] TABLE_COLUMNS = {
            { "notifId", Types.BIGINT },
            { "ownerId", Types.BIGINT },
            { "type_", Types.VARCHAR },
            { "discontinueDate", Types.TIMESTAMP }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_NOTIFICATION (notifId LONG not null primary key,ownerId LONG,type_ VARCHAR(75) null,discontinueDate DATE null)";
    public static final String TABLE_SQL_DROP = "drop table CARET_NOTIFICATION";
    public static final String ORDER_BY_JPQL = " ORDER BY notif.notifId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_NOTIFICATION.notifId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Notif"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Notif"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = false;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Notif"));
    private static ClassLoader _classLoader = Notif.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Notif.class };
    private long _notifId;
    private long _ownerId;
    private String _type;
    private Date _discontinueDate;
    private Notif _escapedModel;

    public NotifModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _notifId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setNotifId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _notifId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Notif.class;
    }

    @Override
    public String getModelClassName() {
        return Notif.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("notifId", getNotifId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("type", getType());
        attributes.put("discontinueDate", getDiscontinueDate());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long notifId = (Long) attributes.get("notifId");

        if (notifId != null) {
            setNotifId(notifId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        Date discontinueDate = (Date) attributes.get("discontinueDate");

        if (discontinueDate != null) {
            setDiscontinueDate(discontinueDate);
        }
    }

    @Override
    public long getNotifId() {
        return _notifId;
    }

    @Override
    public void setNotifId(long notifId) {
        _notifId = notifId;
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _ownerId = ownerId;
    }

    @Override
    public String getType() {
        if (_type == null) {
            return StringPool.BLANK;
        } else {
            return _type;
        }
    }

    @Override
    public void setType(String type) {
        _type = type;
    }

    @Override
    public Date getDiscontinueDate() {
        return _discontinueDate;
    }

    @Override
    public void setDiscontinueDate(Date discontinueDate) {
        _discontinueDate = discontinueDate;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Notif.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Notif toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Notif) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        NotifImpl notifImpl = new NotifImpl();

        notifImpl.setNotifId(getNotifId());
        notifImpl.setOwnerId(getOwnerId());
        notifImpl.setType(getType());
        notifImpl.setDiscontinueDate(getDiscontinueDate());

        notifImpl.resetOriginalValues();

        return notifImpl;
    }

    @Override
    public int compareTo(Notif notif) {
        long primaryKey = notif.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Notif)) {
            return false;
        }

        Notif notif = (Notif) obj;

        long primaryKey = notif.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
    }

    @Override
    public CacheModel<Notif> toCacheModel() {
        NotifCacheModel notifCacheModel = new NotifCacheModel();

        notifCacheModel.notifId = getNotifId();

        notifCacheModel.ownerId = getOwnerId();

        notifCacheModel.type = getType();

        String type = notifCacheModel.type;

        if ((type != null) && (type.length() == 0)) {
            notifCacheModel.type = null;
        }

        Date discontinueDate = getDiscontinueDate();

        if (discontinueDate != null) {
            notifCacheModel.discontinueDate = discontinueDate.getTime();
        } else {
            notifCacheModel.discontinueDate = Long.MIN_VALUE;
        }

        return notifCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{notifId=");
        sb.append(getNotifId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", type=");
        sb.append(getType());
        sb.append(", discontinueDate=");
        sb.append(getDiscontinueDate());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Notif");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>notifId</column-name><column-value><![CDATA[");
        sb.append(getNotifId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>type</column-name><column-value><![CDATA[");
        sb.append(getType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>discontinueDate</column-name><column-value><![CDATA[");
        sb.append(getDiscontinueDate());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
