package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Facil;
import gov.va.caret.service.FacilLocalServiceUtil;

/**
 * The extended model base implementation for the Facil service. Represents a row in the &quot;CARET_FACILITY&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link FacilImpl}.
 * </p>
 *
 * @author caret
 * @see FacilImpl
 * @see gov.va.caret.model.Facil
 * @generated
 */
public abstract class FacilBaseImpl extends FacilModelImpl implements Facil {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a facil model instance should use the {@link Facil} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            FacilLocalServiceUtil.addFacil(this);
        } else {
            FacilLocalServiceUtil.updateFacil(this);
        }
    }
}
