package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Docum;
import gov.va.caret.model.DocumDocumentBlobModel;
import gov.va.caret.model.DocumModel;
import gov.va.caret.service.DocumLocalServiceUtil;

import java.io.Serializable;

import java.sql.Blob;
import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Docum service. Represents a row in the &quot;CARET_DOCUMENT&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.DocumModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DocumImpl}.
 * </p>
 *
 * @author caret
 * @see DocumImpl
 * @see gov.va.caret.model.Docum
 * @see gov.va.caret.model.DocumModel
 * @generated
 */
public class DocumModelImpl extends BaseModelImpl<Docum> implements DocumModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a docum model instance should use the {@link gov.va.caret.model.Docum} interface instead.
     */
    public static final String TABLE_NAME = "CARET_DOCUMENT";
    public static final Object[][] TABLE_COLUMNS = {
            { "documId", Types.BIGINT },
            { "document", Types.BLOB },
            { "classId", Types.BIGINT },
            { "classPk", Types.BIGINT },
            { "name", Types.VARCHAR },
            { "type_", Types.VARCHAR }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_DOCUMENT (documId LONG not null primary key,document BLOB,classId LONG,classPk LONG,name VARCHAR(75) null,type_ VARCHAR(75) null)";
    public static final String TABLE_SQL_DROP = "drop table CARET_DOCUMENT";
    public static final String ORDER_BY_JPQL = " ORDER BY docum.documId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_DOCUMENT.documId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Docum"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Docum"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.Docum"),
            true);
    public static long CLASSID_COLUMN_BITMASK = 1L;
    public static long CLASSPK_COLUMN_BITMASK = 2L;
    public static long TYPE_COLUMN_BITMASK = 4L;
    public static long DOCUMID_COLUMN_BITMASK = 8L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Docum"));
    private static ClassLoader _classLoader = Docum.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Docum.class };
    private long _documId;
    private DocumDocumentBlobModel _documentBlobModel;
    private long _classId;
    private long _originalClassId;
    private boolean _setOriginalClassId;
    private long _classPk;
    private long _originalClassPk;
    private boolean _setOriginalClassPk;
    private String _name;
    private String _type;
    private String _originalType;
    private long _columnBitmask;
    private Docum _escapedModel;

    public DocumModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _documId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setDocumId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _documId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Docum.class;
    }

    @Override
    public String getModelClassName() {
        return Docum.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("documId", getDocumId());
        attributes.put("document", getDocument());
        attributes.put("classId", getClassId());
        attributes.put("classPk", getClassPk());
        attributes.put("name", getName());
        attributes.put("type", getType());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long documId = (Long) attributes.get("documId");

        if (documId != null) {
            setDocumId(documId);
        }

        Blob document = (Blob) attributes.get("document");

        if (document != null) {
            setDocument(document);
        }

        Long classId = (Long) attributes.get("classId");

        if (classId != null) {
            setClassId(classId);
        }

        Long classPk = (Long) attributes.get("classPk");

        if (classPk != null) {
            setClassPk(classPk);
        }

        String name = (String) attributes.get("name");

        if (name != null) {
            setName(name);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }
    }

    @Override
    public long getDocumId() {
        return _documId;
    }

    @Override
    public void setDocumId(long documId) {
        _documId = documId;
    }

    @Override
    public Blob getDocument() {
        if (_documentBlobModel == null) {
            try {
                _documentBlobModel = DocumLocalServiceUtil.getDocumentBlobModel(getPrimaryKey());
            } catch (Exception e) {
            }
        }

        Blob blob = null;

        if (_documentBlobModel != null) {
            blob = _documentBlobModel.getDocumentBlob();
        }

        return blob;
    }

    @Override
    public void setDocument(Blob document) {
        if (_documentBlobModel == null) {
            _documentBlobModel = new DocumDocumentBlobModel(getPrimaryKey(),
                    document);
        } else {
            _documentBlobModel.setDocumentBlob(document);
        }
    }

    @Override
    public long getClassId() {
        return _classId;
    }

    @Override
    public void setClassId(long classId) {
        _columnBitmask |= CLASSID_COLUMN_BITMASK;

        if (!_setOriginalClassId) {
            _setOriginalClassId = true;

            _originalClassId = _classId;
        }

        _classId = classId;
    }

    public long getOriginalClassId() {
        return _originalClassId;
    }

    @Override
    public long getClassPk() {
        return _classPk;
    }

    @Override
    public void setClassPk(long classPk) {
        _columnBitmask |= CLASSPK_COLUMN_BITMASK;

        if (!_setOriginalClassPk) {
            _setOriginalClassPk = true;

            _originalClassPk = _classPk;
        }

        _classPk = classPk;
    }

    public long getOriginalClassPk() {
        return _originalClassPk;
    }

    @Override
    public String getName() {
        if (_name == null) {
            return StringPool.BLANK;
        } else {
            return _name;
        }
    }

    @Override
    public void setName(String name) {
        _name = name;
    }

    @Override
    public String getType() {
        if (_type == null) {
            return StringPool.BLANK;
        } else {
            return _type;
        }
    }

    @Override
    public void setType(String type) {
        _columnBitmask |= TYPE_COLUMN_BITMASK;

        if (_originalType == null) {
            _originalType = _type;
        }

        _type = type;
    }

    public String getOriginalType() {
        return GetterUtil.getString(_originalType);
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Docum.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Docum toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Docum) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        DocumImpl documImpl = new DocumImpl();

        documImpl.setDocumId(getDocumId());
        documImpl.setClassId(getClassId());
        documImpl.setClassPk(getClassPk());
        documImpl.setName(getName());
        documImpl.setType(getType());

        documImpl.resetOriginalValues();

        return documImpl;
    }

    @Override
    public int compareTo(Docum docum) {
        long primaryKey = docum.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Docum)) {
            return false;
        }

        Docum docum = (Docum) obj;

        long primaryKey = docum.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        DocumModelImpl documModelImpl = this;

        documModelImpl._documentBlobModel = null;

        documModelImpl._originalClassId = documModelImpl._classId;

        documModelImpl._setOriginalClassId = false;

        documModelImpl._originalClassPk = documModelImpl._classPk;

        documModelImpl._setOriginalClassPk = false;

        documModelImpl._originalType = documModelImpl._type;

        documModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<Docum> toCacheModel() {
        DocumCacheModel documCacheModel = new DocumCacheModel();

        documCacheModel.documId = getDocumId();

        documCacheModel.classId = getClassId();

        documCacheModel.classPk = getClassPk();

        documCacheModel.name = getName();

        String name = documCacheModel.name;

        if ((name != null) && (name.length() == 0)) {
            documCacheModel.name = null;
        }

        documCacheModel.type = getType();

        String type = documCacheModel.type;

        if ((type != null) && (type.length() == 0)) {
            documCacheModel.type = null;
        }

        return documCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(13);

        sb.append("{documId=");
        sb.append(getDocumId());
        sb.append(", classId=");
        sb.append(getClassId());
        sb.append(", classPk=");
        sb.append(getClassPk());
        sb.append(", name=");
        sb.append(getName());
        sb.append(", type=");
        sb.append(getType());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(22);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Docum");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>documId</column-name><column-value><![CDATA[");
        sb.append(getDocumId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classId</column-name><column-value><![CDATA[");
        sb.append(getClassId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classPk</column-name><column-value><![CDATA[");
        sb.append(getClassPk());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>name</column-name><column-value><![CDATA[");
        sb.append(getName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>type</column-name><column-value><![CDATA[");
        sb.append(getType());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
