package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Crypto;
import gov.va.caret.service.CryptoLocalServiceUtil;

/**
 * The extended model base implementation for the Crypto service. Represents a row in the &quot;CARET_CRYPTO_VALUES&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CryptoImpl}.
 * </p>
 *
 * @author caret
 * @see CryptoImpl
 * @see gov.va.caret.model.Crypto
 * @generated
 */
public abstract class CryptoBaseImpl extends CryptoModelImpl implements Crypto {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a crypto model instance should use the {@link Crypto} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            CryptoLocalServiceUtil.addCrypto(this);
        } else {
            CryptoLocalServiceUtil.updateCrypto(this);
        }
    }
}
