package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Call;
import gov.va.caret.service.CallLocalServiceUtil;

/**
 * The extended model base implementation for the Call service. Represents a row in the &quot;CARET_CALL&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CallImpl}.
 * </p>
 *
 * @author caret
 * @see CallImpl
 * @see gov.va.caret.model.Call
 * @generated
 */
public abstract class CallBaseImpl extends CallModelImpl implements Call {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a call model instance should use the {@link Call} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            CallLocalServiceUtil.addCall(this);
        } else {
            CallLocalServiceUtil.updateCall(this);
        }
    }
}
