package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.CalEt;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing CalEt in entity cache.
 *
 * @author caret
 * @see CalEt
 * @generated
 */
public class CalEtCacheModel implements CacheModel<CalEt>, Externalizable {
    public long calEtId;
    public long callId;
    public String event;
    public String comment;
    public long creationDate;
    public long userId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(13);

        sb.append("{calEtId=");
        sb.append(calEtId);
        sb.append(", callId=");
        sb.append(callId);
        sb.append(", event=");
        sb.append(event);
        sb.append(", comment=");
        sb.append(comment);
        sb.append(", creationDate=");
        sb.append(creationDate);
        sb.append(", userId=");
        sb.append(userId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public CalEt toEntityModel() {
        CalEtImpl calEtImpl = new CalEtImpl();

        calEtImpl.setCalEtId(calEtId);
        calEtImpl.setCallId(callId);

        if (event == null) {
            calEtImpl.setEvent(StringPool.BLANK);
        } else {
            calEtImpl.setEvent(event);
        }

        if (comment == null) {
            calEtImpl.setComment(StringPool.BLANK);
        } else {
            calEtImpl.setComment(comment);
        }

        if (creationDate == Long.MIN_VALUE) {
            calEtImpl.setCreationDate(null);
        } else {
            calEtImpl.setCreationDate(new Date(creationDate));
        }

        calEtImpl.setUserId(userId);

        calEtImpl.resetOriginalValues();

        return calEtImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        calEtId = objectInput.readLong();
        callId = objectInput.readLong();
        event = objectInput.readUTF();
        comment = objectInput.readUTF();
        creationDate = objectInput.readLong();
        userId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(calEtId);
        objectOutput.writeLong(callId);

        if (event == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(event);
        }

        if (comment == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(comment);
        }

        objectOutput.writeLong(creationDate);
        objectOutput.writeLong(userId);
    }
}
