/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.BgMem;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing BgMem in entity cache.
 *
 * @author caret
 * @see BgMem
 * @generated
 */
public class BgMemCacheModel implements CacheModel<BgMem>, Externalizable {
	@Override
	public String toString() {
		StringBundler sb = new StringBundler(9);

		sb.append("{bgMemId=");
		sb.append(bgMemId);
		sb.append(", ownerId=");
		sb.append(ownerId);
		sb.append(", boxGpId=");
		sb.append(boxGpId);
		sb.append(", mediumText=");
		sb.append(mediumText);
		sb.append("}");

		return sb.toString();
	}

	@Override
	public BgMem toEntityModel() {
		BgMemImpl bgMemImpl = new BgMemImpl();

		bgMemImpl.setBgMemId(bgMemId);
		bgMemImpl.setOwnerId(ownerId);
		bgMemImpl.setBoxGpId(boxGpId);

		if (mediumText == null) {
			bgMemImpl.setMediumText(StringPool.BLANK);
		}
		else {
			bgMemImpl.setMediumText(mediumText);
		}

		bgMemImpl.resetOriginalValues();

		return bgMemImpl;
	}

	@Override
	public void readExternal(ObjectInput objectInput) throws IOException {
		bgMemId = objectInput.readLong();
		ownerId = objectInput.readLong();
		boxGpId = objectInput.readLong();
		mediumText = objectInput.readUTF();
	}

	@Override
	public void writeExternal(ObjectOutput objectOutput)
		throws IOException {
		objectOutput.writeLong(bgMemId);
		objectOutput.writeLong(ownerId);
		objectOutput.writeLong(boxGpId);

		if (mediumText == null) {
			objectOutput.writeUTF(StringPool.BLANK);
		}
		else {
			objectOutput.writeUTF(mediumText);
		}
	}

	public long bgMemId;
	public long ownerId;
	public long boxGpId;
	public String mediumText;
}