/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.BgMem;
import gov.va.caret.service.BgMemLocalServiceUtil;

/**
 * The extended model base implementation for the BgMem service. Represents a row in the &quot;CARET_MEDIUM_STR_ASSOCIATION&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BgMemImpl}.
 * </p>
 *
 * @author caret
 * @see BgMemImpl
 * @see gov.va.caret.model.BgMem
 * @generated
 */
public abstract class BgMemBaseImpl extends BgMemModelImpl implements BgMem {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a bg mem model instance should use the {@link BgMem} interface instead.
	 */
	@Override
	public void persist() throws SystemException {
		if (this.isNew()) {
			BgMemLocalServiceUtil.addBgMem(this);
		}
		else {
			BgMemLocalServiceUtil.updateBgMem(this);
		}
	}
}