package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.BgLae;
import gov.va.caret.model.BgLaeModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the BgLae service. Represents a row in the &quot;CARET_BOXED_GROUP_CHAR&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.BgLaeModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BgLaeImpl}.
 * </p>
 *
 * @author caret
 * @see BgLaeImpl
 * @see gov.va.caret.model.BgLae
 * @see gov.va.caret.model.BgLaeModel
 * @generated
 */
public class BgLaeModelImpl extends BaseModelImpl<BgLae> implements BgLaeModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a bg lae model instance should use the {@link gov.va.caret.model.BgLae} interface instead.
     */
    public static final String TABLE_NAME = "CARET_BOXED_GROUP_CHAR";
    public static final Object[][] TABLE_COLUMNS = {
            { "bgLaeId", Types.BIGINT },
            { "ownerId", Types.BIGINT },
            { "boxGpId", Types.BIGINT },
            { "largeText", Types.VARCHAR }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_BOXED_GROUP_CHAR (bgLaeId LONG not null primary key,ownerId LONG,boxGpId LONG,largeText VARCHAR(75) null)";
    public static final String TABLE_SQL_DROP = "drop table CARET_BOXED_GROUP_CHAR";
    public static final String ORDER_BY_JPQL = " ORDER BY bgLae.bgLaeId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_BOXED_GROUP_CHAR.bgLaeId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.BgLae"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.BgLae"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.BgLae"),
            true);
    public static long BOXGPID_COLUMN_BITMASK = 1L;
    public static long OWNERID_COLUMN_BITMASK = 2L;
    public static long BGLAEID_COLUMN_BITMASK = 4L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.BgLae"));
    private static ClassLoader _classLoader = BgLae.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { BgLae.class };
    private long _bgLaeId;
    private long _ownerId;
    private long _originalOwnerId;
    private boolean _setOriginalOwnerId;
    private long _boxGpId;
    private long _originalBoxGpId;
    private boolean _setOriginalBoxGpId;
    private String _largeText;
    private long _columnBitmask;
    private BgLae _escapedModel;

    public BgLaeModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _bgLaeId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBgLaeId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _bgLaeId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return BgLae.class;
    }

    @Override
    public String getModelClassName() {
        return BgLae.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("bgLaeId", getBgLaeId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("boxGpId", getBoxGpId());
        attributes.put("largeText", getLargeText());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long bgLaeId = (Long) attributes.get("bgLaeId");

        if (bgLaeId != null) {
            setBgLaeId(bgLaeId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        Long boxGpId = (Long) attributes.get("boxGpId");

        if (boxGpId != null) {
            setBoxGpId(boxGpId);
        }

        String largeText = (String) attributes.get("largeText");

        if (largeText != null) {
            setLargeText(largeText);
        }
    }

    @Override
    public long getBgLaeId() {
        return _bgLaeId;
    }

    @Override
    public void setBgLaeId(long bgLaeId) {
        _bgLaeId = bgLaeId;
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _columnBitmask |= OWNERID_COLUMN_BITMASK;

        if (!_setOriginalOwnerId) {
            _setOriginalOwnerId = true;

            _originalOwnerId = _ownerId;
        }

        _ownerId = ownerId;
    }

    public long getOriginalOwnerId() {
        return _originalOwnerId;
    }

    @Override
    public long getBoxGpId() {
        return _boxGpId;
    }

    @Override
    public void setBoxGpId(long boxGpId) {
        _columnBitmask |= BOXGPID_COLUMN_BITMASK;

        if (!_setOriginalBoxGpId) {
            _setOriginalBoxGpId = true;

            _originalBoxGpId = _boxGpId;
        }

        _boxGpId = boxGpId;
    }

    public long getOriginalBoxGpId() {
        return _originalBoxGpId;
    }

    @Override
    public String getLargeText() {
        if (_largeText == null) {
            return StringPool.BLANK;
        } else {
            return _largeText;
        }
    }

    @Override
    public void setLargeText(String largeText) {
        _largeText = largeText;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            BgLae.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public BgLae toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (BgLae) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        BgLaeImpl bgLaeImpl = new BgLaeImpl();

        bgLaeImpl.setBgLaeId(getBgLaeId());
        bgLaeImpl.setOwnerId(getOwnerId());
        bgLaeImpl.setBoxGpId(getBoxGpId());
        bgLaeImpl.setLargeText(getLargeText());

        bgLaeImpl.resetOriginalValues();

        return bgLaeImpl;
    }

    @Override
    public int compareTo(BgLae bgLae) {
        long primaryKey = bgLae.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BgLae)) {
            return false;
        }

        BgLae bgLae = (BgLae) obj;

        long primaryKey = bgLae.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        BgLaeModelImpl bgLaeModelImpl = this;

        bgLaeModelImpl._originalOwnerId = bgLaeModelImpl._ownerId;

        bgLaeModelImpl._setOriginalOwnerId = false;

        bgLaeModelImpl._originalBoxGpId = bgLaeModelImpl._boxGpId;

        bgLaeModelImpl._setOriginalBoxGpId = false;

        bgLaeModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<BgLae> toCacheModel() {
        BgLaeCacheModel bgLaeCacheModel = new BgLaeCacheModel();

        bgLaeCacheModel.bgLaeId = getBgLaeId();

        bgLaeCacheModel.ownerId = getOwnerId();

        bgLaeCacheModel.boxGpId = getBoxGpId();

        bgLaeCacheModel.largeText = getLargeText();

        String largeText = bgLaeCacheModel.largeText;

        if ((largeText != null) && (largeText.length() == 0)) {
            bgLaeCacheModel.largeText = null;
        }

        return bgLaeCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{bgLaeId=");
        sb.append(getBgLaeId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", boxGpId=");
        sb.append(getBoxGpId());
        sb.append(", largeText=");
        sb.append(getLargeText());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BgLae");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>bgLaeId</column-name><column-value><![CDATA[");
        sb.append(getBgLaeId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>boxGpId</column-name><column-value><![CDATA[");
        sb.append(getBoxGpId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>largeText</column-name><column-value><![CDATA[");
        sb.append(getLargeText());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
