package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BgAsnModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the BgAsn service. Represents a row in the &quot;CARET_BOXED_GROUP_BOOL&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.BgAsnModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BgAsnImpl}.
 * </p>
 *
 * @author caret
 * @see BgAsnImpl
 * @see gov.va.caret.model.BgAsn
 * @see gov.va.caret.model.BgAsnModel
 * @generated
 */
public class BgAsnModelImpl extends BaseModelImpl<BgAsn> implements BgAsnModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a bg asn model instance should use the {@link gov.va.caret.model.BgAsn} interface instead.
     */
    public static final String TABLE_NAME = "CARET_BOXED_GROUP_BOOL";
    public static final Object[][] TABLE_COLUMNS = {
            { "bgAsnId", Types.BIGINT },
            { "ownerId", Types.BIGINT },
            { "boxGpId", Types.BIGINT },
            { "selected", Types.BOOLEAN }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_BOXED_GROUP_BOOL (bgAsnId LONG not null primary key,ownerId LONG,boxGpId LONG,selected BOOLEAN)";
    public static final String TABLE_SQL_DROP = "drop table CARET_BOXED_GROUP_BOOL";
    public static final String ORDER_BY_JPQL = " ORDER BY bgAsn.bgAsnId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_BOXED_GROUP_BOOL.bgAsnId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.BgAsn"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.BgAsn"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.BgAsn"),
            true);
    public static long BOXGPID_COLUMN_BITMASK = 1L;
    public static long OWNERID_COLUMN_BITMASK = 2L;
    public static long SELECTED_COLUMN_BITMASK = 4L;
    public static long BGASNID_COLUMN_BITMASK = 8L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.BgAsn"));
    private static ClassLoader _classLoader = BgAsn.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { BgAsn.class };
    private long _bgAsnId;
    private long _ownerId;
    private long _originalOwnerId;
    private boolean _setOriginalOwnerId;
    private long _boxGpId;
    private long _originalBoxGpId;
    private boolean _setOriginalBoxGpId;
    private boolean _selected;
    private boolean _originalSelected;
    private boolean _setOriginalSelected;
    private long _columnBitmask;
    private BgAsn _escapedModel;

    public BgAsnModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _bgAsnId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBgAsnId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _bgAsnId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return BgAsn.class;
    }

    @Override
    public String getModelClassName() {
        return BgAsn.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("bgAsnId", getBgAsnId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("boxGpId", getBoxGpId());
        attributes.put("selected", getSelected());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long bgAsnId = (Long) attributes.get("bgAsnId");

        if (bgAsnId != null) {
            setBgAsnId(bgAsnId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        Long boxGpId = (Long) attributes.get("boxGpId");

        if (boxGpId != null) {
            setBoxGpId(boxGpId);
        }

        Boolean selected = (Boolean) attributes.get("selected");

        if (selected != null) {
            setSelected(selected);
        }
    }

    @Override
    public long getBgAsnId() {
        return _bgAsnId;
    }

    @Override
    public void setBgAsnId(long bgAsnId) {
        _bgAsnId = bgAsnId;
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _columnBitmask |= OWNERID_COLUMN_BITMASK;

        if (!_setOriginalOwnerId) {
            _setOriginalOwnerId = true;

            _originalOwnerId = _ownerId;
        }

        _ownerId = ownerId;
    }

    public long getOriginalOwnerId() {
        return _originalOwnerId;
    }

    @Override
    public long getBoxGpId() {
        return _boxGpId;
    }

    @Override
    public void setBoxGpId(long boxGpId) {
        _columnBitmask |= BOXGPID_COLUMN_BITMASK;

        if (!_setOriginalBoxGpId) {
            _setOriginalBoxGpId = true;

            _originalBoxGpId = _boxGpId;
        }

        _boxGpId = boxGpId;
    }

    public long getOriginalBoxGpId() {
        return _originalBoxGpId;
    }

    @Override
    public boolean getSelected() {
        return _selected;
    }

    @Override
    public boolean isSelected() {
        return _selected;
    }

    @Override
    public void setSelected(boolean selected) {
        _columnBitmask |= SELECTED_COLUMN_BITMASK;

        if (!_setOriginalSelected) {
            _setOriginalSelected = true;

            _originalSelected = _selected;
        }

        _selected = selected;
    }

    public boolean getOriginalSelected() {
        return _originalSelected;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            BgAsn.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public BgAsn toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (BgAsn) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        BgAsnImpl bgAsnImpl = new BgAsnImpl();

        bgAsnImpl.setBgAsnId(getBgAsnId());
        bgAsnImpl.setOwnerId(getOwnerId());
        bgAsnImpl.setBoxGpId(getBoxGpId());
        bgAsnImpl.setSelected(getSelected());

        bgAsnImpl.resetOriginalValues();

        return bgAsnImpl;
    }

    @Override
    public int compareTo(BgAsn bgAsn) {
        long primaryKey = bgAsn.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BgAsn)) {
            return false;
        }

        BgAsn bgAsn = (BgAsn) obj;

        long primaryKey = bgAsn.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        BgAsnModelImpl bgAsnModelImpl = this;

        bgAsnModelImpl._originalOwnerId = bgAsnModelImpl._ownerId;

        bgAsnModelImpl._setOriginalOwnerId = false;

        bgAsnModelImpl._originalBoxGpId = bgAsnModelImpl._boxGpId;

        bgAsnModelImpl._setOriginalBoxGpId = false;

        bgAsnModelImpl._originalSelected = bgAsnModelImpl._selected;

        bgAsnModelImpl._setOriginalSelected = false;

        bgAsnModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<BgAsn> toCacheModel() {
        BgAsnCacheModel bgAsnCacheModel = new BgAsnCacheModel();

        bgAsnCacheModel.bgAsnId = getBgAsnId();

        bgAsnCacheModel.ownerId = getOwnerId();

        bgAsnCacheModel.boxGpId = getBoxGpId();

        bgAsnCacheModel.selected = getSelected();

        return bgAsnCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{bgAsnId=");
        sb.append(getBgAsnId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", boxGpId=");
        sb.append(getBoxGpId());
        sb.append(", selected=");
        sb.append(getSelected());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BgAsn");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>bgAsnId</column-name><column-value><![CDATA[");
        sb.append(getBgAsnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>boxGpId</column-name><column-value><![CDATA[");
        sb.append(getBoxGpId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>selected</column-name><column-value><![CDATA[");
        sb.append(getSelected());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
