package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.AudLg;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing AudLg in entity cache.
 *
 * @author caret
 * @see AudLg
 * @generated
 */
public class AudLgCacheModel implements CacheModel<AudLg>, Externalizable {
    public long audLgId;
    public long classPk;
    public long classId;
    public String attribute;
    public String oldValue;
    public String newValue;
    public long coverUserId;
    public long modifiedById;
    public long modifiedDate;
    public long groupId;
    public String roleName;
    public long sysDateTime;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(25);

        sb.append("{audLgId=");
        sb.append(audLgId);
        sb.append(", classPk=");
        sb.append(classPk);
        sb.append(", classId=");
        sb.append(classId);
        sb.append(", attribute=");
        sb.append(attribute);
        sb.append(", oldValue=");
        sb.append(oldValue);
        sb.append(", newValue=");
        sb.append(newValue);
        sb.append(", coverUserId=");
        sb.append(coverUserId);
        sb.append(", modifiedById=");
        sb.append(modifiedById);
        sb.append(", modifiedDate=");
        sb.append(modifiedDate);
        sb.append(", groupId=");
        sb.append(groupId);
        sb.append(", roleName=");
        sb.append(roleName);
        sb.append(", sysDateTime=");
        sb.append(sysDateTime);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public AudLg toEntityModel() {
        AudLgImpl audLgImpl = new AudLgImpl();

        audLgImpl.setAudLgId(audLgId);
        audLgImpl.setClassPk(classPk);
        audLgImpl.setClassId(classId);

        if (attribute == null) {
            audLgImpl.setAttribute(StringPool.BLANK);
        } else {
            audLgImpl.setAttribute(attribute);
        }

        if (oldValue == null) {
            audLgImpl.setOldValue(StringPool.BLANK);
        } else {
            audLgImpl.setOldValue(oldValue);
        }

        if (newValue == null) {
            audLgImpl.setNewValue(StringPool.BLANK);
        } else {
            audLgImpl.setNewValue(newValue);
        }

        audLgImpl.setCoverUserId(coverUserId);
        audLgImpl.setModifiedById(modifiedById);

        if (modifiedDate == Long.MIN_VALUE) {
            audLgImpl.setModifiedDate(null);
        } else {
            audLgImpl.setModifiedDate(new Date(modifiedDate));
        }

        audLgImpl.setGroupId(groupId);

        if (roleName == null) {
            audLgImpl.setRoleName(StringPool.BLANK);
        } else {
            audLgImpl.setRoleName(roleName);
        }

        audLgImpl.setSysDateTime(sysDateTime);

        audLgImpl.resetOriginalValues();

        return audLgImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        audLgId = objectInput.readLong();
        classPk = objectInput.readLong();
        classId = objectInput.readLong();
        attribute = objectInput.readUTF();
        oldValue = objectInput.readUTF();
        newValue = objectInput.readUTF();
        coverUserId = objectInput.readLong();
        modifiedById = objectInput.readLong();
        modifiedDate = objectInput.readLong();
        groupId = objectInput.readLong();
        roleName = objectInput.readUTF();
        sysDateTime = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(audLgId);
        objectOutput.writeLong(classPk);
        objectOutput.writeLong(classId);

        if (attribute == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(attribute);
        }

        if (oldValue == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(oldValue);
        }

        if (newValue == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(newValue);
        }

        objectOutput.writeLong(coverUserId);
        objectOutput.writeLong(modifiedById);
        objectOutput.writeLong(modifiedDate);
        objectOutput.writeLong(groupId);

        if (roleName == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(roleName);
        }

        objectOutput.writeLong(sysDateTime);
    }
}
