package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.AudLg;
import gov.va.caret.service.AudLgLocalServiceUtil;

/**
 * The extended model base implementation for the AudLg service. Represents a row in the &quot;CARET_AUDIT_LOG&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AudLgImpl}.
 * </p>
 *
 * @author caret
 * @see AudLgImpl
 * @see gov.va.caret.model.AudLg
 * @generated
 */
public abstract class AudLgBaseImpl extends AudLgModelImpl implements AudLg {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a aud lg model instance should use the {@link AudLg} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            AudLgLocalServiceUtil.addAudLg(this);
        } else {
            AudLgLocalServiceUtil.updateAudLg(this);
        }
    }
}
