package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Assmt;
import gov.va.caret.model.AssmtModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Assmt service. Represents a row in the &quot;CARET_ASSESSMENT&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.AssmtModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AssmtImpl}.
 * </p>
 *
 * @author caret
 * @see AssmtImpl
 * @see gov.va.caret.model.Assmt
 * @see gov.va.caret.model.AssmtModel
 * @generated
 */
public class AssmtModelImpl extends BaseModelImpl<Assmt> implements AssmtModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a assmt model instance should use the {@link gov.va.caret.model.Assmt} interface instead.
     */
    public static final String TABLE_NAME = "CARET_ASSESSMENT";
    public static final Object[][] TABLE_COLUMNS = {
            { "assmtId", Types.BIGINT },
            { "vcgId", Types.BIGINT },
            { "noteId", Types.BIGINT },
            { "completionDate", Types.TIMESTAMP },
            { "type_", Types.VARCHAR },
            { "scheduleDate", Types.TIMESTAMP },
            { "userId", Types.BIGINT },
            { "comment_", Types.VARCHAR },
            { "active_", Types.BOOLEAN },
            { "caregiverId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_ASSESSMENT (assmtId LONG not null primary key,vcgId LONG,noteId LONG,completionDate DATE null,type_ VARCHAR(75) null,scheduleDate DATE null,userId LONG,comment_ VARCHAR(75) null,active_ BOOLEAN,caregiverId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_ASSESSMENT";
    public static final String ORDER_BY_JPQL = " ORDER BY assmt.scheduleDate ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_ASSESSMENT.scheduleDate ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Assmt"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Assmt"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.Assmt"),
            true);
    public static long VCGID_COLUMN_BITMASK = 1L;
    public static long SCHEDULEDATE_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Assmt"));
    private static ClassLoader _classLoader = Assmt.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Assmt.class };
    private long _assmtId;
    private long _vcgId;
    private long _originalVcgId;
    private boolean _setOriginalVcgId;
    private long _noteId;
    private Date _completionDate;
    private String _type;
    private Date _scheduleDate;
    private long _userId;
    private String _userUuid;
    private String _comment;
    private boolean _active;
    private long _caregiverId;
    private long _columnBitmask;
    private Assmt _escapedModel;

    public AssmtModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _assmtId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setAssmtId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _assmtId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Assmt.class;
    }

    @Override
    public String getModelClassName() {
        return Assmt.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("assmtId", getAssmtId());
        attributes.put("vcgId", getVcgId());
        attributes.put("noteId", getNoteId());
        attributes.put("completionDate", getCompletionDate());
        attributes.put("type", getType());
        attributes.put("scheduleDate", getScheduleDate());
        attributes.put("userId", getUserId());
        attributes.put("comment", getComment());
        attributes.put("active", getActive());
        attributes.put("caregiverId", getCaregiverId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long assmtId = (Long) attributes.get("assmtId");

        if (assmtId != null) {
            setAssmtId(assmtId);
        }

        Long vcgId = (Long) attributes.get("vcgId");

        if (vcgId != null) {
            setVcgId(vcgId);
        }

        Long noteId = (Long) attributes.get("noteId");

        if (noteId != null) {
            setNoteId(noteId);
        }

        Date completionDate = (Date) attributes.get("completionDate");

        if (completionDate != null) {
            setCompletionDate(completionDate);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        Date scheduleDate = (Date) attributes.get("scheduleDate");

        if (scheduleDate != null) {
            setScheduleDate(scheduleDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        String comment = (String) attributes.get("comment");

        if (comment != null) {
            setComment(comment);
        }

        Boolean active = (Boolean) attributes.get("active");

        if (active != null) {
            setActive(active);
        }

        Long caregiverId = (Long) attributes.get("caregiverId");

        if (caregiverId != null) {
            setCaregiverId(caregiverId);
        }
    }

    @Override
    public long getAssmtId() {
        return _assmtId;
    }

    @Override
    public void setAssmtId(long assmtId) {
        _assmtId = assmtId;
    }

    @Override
    public long getVcgId() {
        return _vcgId;
    }

    @Override
    public void setVcgId(long vcgId) {
        _columnBitmask |= VCGID_COLUMN_BITMASK;

        if (!_setOriginalVcgId) {
            _setOriginalVcgId = true;

            _originalVcgId = _vcgId;
        }

        _vcgId = vcgId;
    }

    public long getOriginalVcgId() {
        return _originalVcgId;
    }

    @Override
    public long getNoteId() {
        return _noteId;
    }

    @Override
    public void setNoteId(long noteId) {
        _noteId = noteId;
    }

    @Override
    public Date getCompletionDate() {
        return _completionDate;
    }

    @Override
    public void setCompletionDate(Date completionDate) {
        _completionDate = completionDate;
    }

    @Override
    public String getType() {
        if (_type == null) {
            return StringPool.BLANK;
        } else {
            return _type;
        }
    }

    @Override
    public void setType(String type) {
        _type = type;
    }

    @Override
    public Date getScheduleDate() {
        return _scheduleDate;
    }

    @Override
    public void setScheduleDate(Date scheduleDate) {
        _columnBitmask = -1L;

        _scheduleDate = scheduleDate;
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    @Override
    public String getComment() {
        if (_comment == null) {
            return StringPool.BLANK;
        } else {
            return _comment;
        }
    }

    @Override
    public void setComment(String comment) {
        _comment = comment;
    }

    @Override
    public boolean getActive() {
        return _active;
    }

    @Override
    public boolean isActive() {
        return _active;
    }

    @Override
    public void setActive(boolean active) {
        _active = active;
    }

    @Override
    public long getCaregiverId() {
        return _caregiverId;
    }

    @Override
    public void setCaregiverId(long caregiverId) {
        _caregiverId = caregiverId;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Assmt.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Assmt toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Assmt) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        AssmtImpl assmtImpl = new AssmtImpl();

        assmtImpl.setAssmtId(getAssmtId());
        assmtImpl.setVcgId(getVcgId());
        assmtImpl.setNoteId(getNoteId());
        assmtImpl.setCompletionDate(getCompletionDate());
        assmtImpl.setType(getType());
        assmtImpl.setScheduleDate(getScheduleDate());
        assmtImpl.setUserId(getUserId());
        assmtImpl.setComment(getComment());
        assmtImpl.setActive(getActive());
        assmtImpl.setCaregiverId(getCaregiverId());

        assmtImpl.resetOriginalValues();

        return assmtImpl;
    }

    @Override
    public int compareTo(Assmt assmt) {
        int value = 0;

        value = DateUtil.compareTo(getScheduleDate(), assmt.getScheduleDate());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Assmt)) {
            return false;
        }

        Assmt assmt = (Assmt) obj;

        long primaryKey = assmt.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        AssmtModelImpl assmtModelImpl = this;

        assmtModelImpl._originalVcgId = assmtModelImpl._vcgId;

        assmtModelImpl._setOriginalVcgId = false;

        assmtModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<Assmt> toCacheModel() {
        AssmtCacheModel assmtCacheModel = new AssmtCacheModel();

        assmtCacheModel.assmtId = getAssmtId();

        assmtCacheModel.vcgId = getVcgId();

        assmtCacheModel.noteId = getNoteId();

        Date completionDate = getCompletionDate();

        if (completionDate != null) {
            assmtCacheModel.completionDate = completionDate.getTime();
        } else {
            assmtCacheModel.completionDate = Long.MIN_VALUE;
        }

        assmtCacheModel.type = getType();

        String type = assmtCacheModel.type;

        if ((type != null) && (type.length() == 0)) {
            assmtCacheModel.type = null;
        }

        Date scheduleDate = getScheduleDate();

        if (scheduleDate != null) {
            assmtCacheModel.scheduleDate = scheduleDate.getTime();
        } else {
            assmtCacheModel.scheduleDate = Long.MIN_VALUE;
        }

        assmtCacheModel.userId = getUserId();

        assmtCacheModel.comment = getComment();

        String comment = assmtCacheModel.comment;

        if ((comment != null) && (comment.length() == 0)) {
            assmtCacheModel.comment = null;
        }

        assmtCacheModel.active = getActive();

        assmtCacheModel.caregiverId = getCaregiverId();

        return assmtCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(21);

        sb.append("{assmtId=");
        sb.append(getAssmtId());
        sb.append(", vcgId=");
        sb.append(getVcgId());
        sb.append(", noteId=");
        sb.append(getNoteId());
        sb.append(", completionDate=");
        sb.append(getCompletionDate());
        sb.append(", type=");
        sb.append(getType());
        sb.append(", scheduleDate=");
        sb.append(getScheduleDate());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", comment=");
        sb.append(getComment());
        sb.append(", active=");
        sb.append(getActive());
        sb.append(", caregiverId=");
        sb.append(getCaregiverId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(34);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Assmt");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>assmtId</column-name><column-value><![CDATA[");
        sb.append(getAssmtId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vcgId</column-name><column-value><![CDATA[");
        sb.append(getVcgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>noteId</column-name><column-value><![CDATA[");
        sb.append(getNoteId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>completionDate</column-name><column-value><![CDATA[");
        sb.append(getCompletionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>type</column-name><column-value><![CDATA[");
        sb.append(getType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>scheduleDate</column-name><column-value><![CDATA[");
        sb.append(getScheduleDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>comment</column-name><column-value><![CDATA[");
        sb.append(getComment());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>active</column-name><column-value><![CDATA[");
        sb.append(getActive());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>caregiverId</column-name><column-value><![CDATA[");
        sb.append(getCaregiverId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
