package gov.va.caret.hook;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public class LandingPage extends Action {

	private static final Log _log = LogFactoryUtil.getLog( LandingPage.class );
	private static final String LANDING_SEQUENCE = "site.priority.order";

	@Override
	public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
		try {
			Group userSite = getUserSite( PortalUtil.getUser(request) );
			if ( userSite == null ){
				return;
			}
			String siteLanding = PortalUtil.getPortalProperties().get( PropsKeys.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING ) + userSite.getFriendlyURL();
			LastPath lastPath = new LastPath(StringPool.BLANK, siteLanding);
			if ( _log.isDebugEnabled() ){
				_log.debug("landing page..." + lastPath );
			}
			request.getSession().setAttribute(WebKeys.LAST_PATH, lastPath);
		} catch (PortalException e) {
			throw new ActionException(e);
		} catch (SystemException e) {
			throw new ActionException(e);
		}
	}

	private Group getUserSite(User user) throws PortalException, SystemException {

		String[] landingSequence = PortalUtil.getPortalProperties().get( LANDING_SEQUENCE ).toString().split( StringPool.COMMA );
		List<Group> userSites = user.getSiteGroups();
		for ( String siteName : landingSequence ){
			for( Group group : userSites ){
				if( siteName.equalsIgnoreCase( group.getName() ) ){
					return group;
				}
			}
		}
		_log.error("Landing page could not identify user-group");
		return null;
	}

}
