package gov.va.caret.controller.dashboard.config;

import com.liferay.portal.model.Role;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Facil;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ResultMap;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

import javax.portlet.PortletRequest;


public class TechDashboardConfig extends DashboardConfig {

	private static final long serialVersionUID = 1L;
	public final String VIEW = "/jsp/dashboard/tech.jsp";
	
	public TechDashboardConfig() {
		super();
		Collection<GenericReport> enabledSearch = new TreeSet<GenericReport>();
		for ( DashboardType type: DashboardType.values() ){
			if ( type.isHelped() ){
				try {
					DashboardConfig dashboardConfig = type.dashboardConfig.newInstance();
					for ( GenericReport report : dashboardConfig.getReports() ){
						enabledSearch.add( report );
					}
					enabledSearch.addAll( dashboardConfig.enabledSearch.getCachedReports() );
				} catch (InstantiationException e) {
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					e.printStackTrace();
				}
			}
		}
		this.reports = null;
		this.enabledSearch = new EnabledSearch( enabledSearch );
	}

	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.CREATE_APPLICATIONS,
			CAction.CaretCan.CREATE_CALLS,
			CAction.CaretCan.CREATE_CALL_TYPE,
			CAction.CaretCan.CREATE_REFERRAL,
			CAction.CaretCan.CREATE_MESSAGES
		};
	}
	
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR,
				CAction.CaretCan.IDENTITY_MATCHING
			};
	}
	
	@Override
	public String getView() {
		return VIEW;
	}
	
	
	public void setRoles(PortletRequest request, List<Role> roles) {
		Map<String,Long> roleMap = (Map<String,Long>)request.getPortletSession().getAttribute("ROLEMAP");
		if ( roleMap == null ) {
			roleMap = new TreeMap<String,Long>();
		}
		if ( roleMap.isEmpty() ){
			for ( Role role: roles ){
				roleMap.put(role.getName(), role.getRoleId() );
			}
			
			roleMap.put("veteran", 1l );
			roleMap.put("primary-general", 2l );
			roleMap.put("secondary-cg", 3l );
			roleMap.put("secondary-two-cg", 4l );
			
			request.getPortletSession().setAttribute("ROLEMAP", roleMap);
		}
	}
	
	public void setSearchContext(PortletRequest request) throws ApplicationWorkFlowException {
		
		request.setAttribute(CaretStrPool.ROLES, request.getPortletSession().getAttribute("ROLEMAP"));
		
		Map<Long,Facil> facilities = CaretParam.getFacilities(request);
		if ( facilities != null && !facilities.isEmpty() ){
			StringBuilder sb = new StringBuilder(" ( ");
			for ( Iterator<Facil> iter = facilities.values().iterator(); iter.hasNext(); ){
				sb.append(iter.next().getFacilityNumber()).append(", ");
			}
			request.setAttribute("facility", sb.substring(0, sb.length() - 2) + " )" );
		}
		
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		caret.put( CaretStrPool.VHA_SYSTEM, Toolbox.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
	}
	
}
